/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.clion.embedded.execution.rtos;

import com.intellij.clion.embedded.execution.rtos.RtosLLThread;
import com.intellij.clion.embedded.execution.rtos.RtosType;
import com.intellij.clion.embedded.execution.rtos.freertos.Task;
import com.intellij.execution.ExecutionException;
import com.intellij.openapi.util.io.FileUtil;
import com.jetbrains.cidr.CidrPathManager;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerLog;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerPathManager;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriverConfiguration;
import com.jetbrains.cidr.execution.debugger.backend.LLFrame;
import com.jetbrains.cidr.execution.debugger.backend.LLThread;
import com.jetbrains.cidr.execution.debugger.backend.gdb.GDBBundle;
import com.jetbrains.cidr.execution.debugger.backend.gdb.GDBDriver;
import com.jetbrains.cidr.execution.debugger.backend.gdb.GDBTuple;
import java.io.File;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.builtins.BuiltinSerializersKt;
import kotlinx.serialization.json.Json;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000Z\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a8\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0012\u0010\t\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u00010\n\u001a\u001a\u0010\u000b\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a:\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u0003\u001a\u00020\u00042$\u0010\u000f\u001a \u0012\u0004\u0012\u00020\u0011\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\r\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r0\u0010\u001a)\u0010\u0013\u001a\u0004\u0018\u0001H\u0014\"\u0004\b\u0000\u0010\u00142\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\u00140\u0018\u00a2\u0006\u0002\u0010\u0019\u001a\u000e\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u0016\u001a\u0016\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 \u00a8\u0006!"}, d2={"rtosDoReadStopPlaceAsync", "Ljava/util/concurrent/CompletableFuture;", "Lcom/jetbrains/cidr/execution/debugger/backend/DebuggerDriver$StopPlace;", "bridge", "Lcom/jetbrains/cidr/execution/debugger/backend/gdb/GDBDriver$Bridge;", "driver", "Lcom/jetbrains/cidr/execution/debugger/backend/gdb/GDBDriver;", "stopTuple", "Lcom/jetbrains/cidr/execution/debugger/backend/gdb/GDBTuple;", "fallbackReadStopPlace", "Lkotlin/Function0;", "rtosReadStopPlace", "getRtosThreads", "", "Lcom/jetbrains/cidr/execution/debugger/backend/LLThread;", "taskProcessor", "Lkotlin/Function2;", "", "Lcom/intellij/clion/embedded/execution/rtos/freertos/Task;", "tryDecodeJsonFromConsoleOutput", "T", "s", "", "serializer", "Lkotlinx/serialization/KSerializer;", "(Ljava/lang/String;Lkotlinx/serialization/KSerializer;)Ljava/lang/Object;", "extractQuotedString", "raw", "generateRtosImportScript", "driverConfiguration", "Lcom/jetbrains/cidr/execution/debugger/backend/DebuggerDriverConfiguration;", "rtosType", "Lcom/intellij/clion/embedded/execution/rtos/RtosType;", "intellij.clion.embedded"})
@SourceDebugExtension(value={"SMAP\nGdbRtosSupport.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GdbRtosSupport.kt\ncom/intellij/clion/embedded/execution/rtos/GdbRtosSupportKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,358:1\n1869#2,2:359\n1#3:361\n*S KotlinDebug\n*F\n+ 1 GdbRtosSupport.kt\ncom/intellij/clion/embedded/execution/rtos/GdbRtosSupportKt\n*L\n351#1:359,2\n*E\n"})
public final class GdbRtosSupportKt {
    @NotNull
    public static final CompletableFuture<DebuggerDriver.StopPlace> rtosDoReadStopPlaceAsync(@NotNull GDBDriver.Bridge bridge, @NotNull GDBDriver driver, @NotNull GDBTuple stopTuple, @NotNull Function0<? extends CompletableFuture<DebuggerDriver.StopPlace>> fallbackReadStopPlace) {
        Intrinsics.checkNotNullParameter((Object)bridge, (String)"bridge");
        Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
        Intrinsics.checkNotNullParameter((Object)stopTuple, (String)"stopTuple");
        Intrinsics.checkNotNullParameter(fallbackReadStopPlace, (String)"fallbackReadStopPlace");
        CompletionStage completionStage = ((CompletableFuture)bridge.executeAsyncCommand(() -> GdbRtosSupportKt.rtosDoReadStopPlaceAsync$lambda$0(bridge, stopTuple)).handle((arg_0, arg_1) -> GdbRtosSupportKt.rtosDoReadStopPlaceAsync$lambda$2(driver, arg_0, arg_1))).thenCompose(arg_0 -> GdbRtosSupportKt.rtosDoReadStopPlaceAsync$lambda$4(arg_0 -> GdbRtosSupportKt.rtosDoReadStopPlaceAsync$lambda$3(fallbackReadStopPlace, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"thenCompose(...)");
        return completionStage;
    }

    private static final DebuggerDriver.StopPlace rtosReadStopPlace(GDBDriver.Bridge bridge, GDBTuple stopTuple) {
        GDBTuple gDBTuple = stopTuple.getRequiredTupleOrThrow("frame", () -> GdbRtosSupportKt.rtosReadStopPlace$lambda$5(stopTuple));
        Intrinsics.checkNotNullExpressionValue((Object)gDBTuple, (String)"getRequiredTupleOrThrow(...)");
        GDBTuple frameTuple = gDBTuple;
        LLFrame lLFrame = bridge.doReadFrame(0, frameTuple);
        Intrinsics.checkNotNullExpressionValue((Object)lLFrame, (String)"doReadFrame(...)");
        LLFrame frame = lLFrame;
        bridge.sendSilentRequestAndGetOutput("p/s 1", new Object[0]);
        bridge.sendSilentRequestAndGetOutput("set print elements unlimited", new Object[0]);
        String string = bridge.sendSilentRequestAndGetOutput("p/r $rtos_curr()", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sendSilentRequestAndGetOutput(...)");
        String consoleOutput = string;
        String string2 = "set print elements %s";
        Object[] objectArray = new Object[]{256};
        String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
        bridge.sendSilentRequestAndGetOutput(string3, new Object[0]);
        Task task = GdbRtosSupportKt.tryDecodeJsonFromConsoleOutput(consoleOutput, Task.Companion.serializer());
        if (task == null) {
            return null;
        }
        Task task2 = task;
        long threadId = bridge.doEvaluateAndLoad(-1L, -1, "$_gthread", null).intValue();
        return new DebuggerDriver.StopPlace((LLThread)new RtosLLThread(threadId, task2.getId(), task2.getState(), task2.getName(), task2.getStackTop(), frame.getProgramCounter()), frame, bridge.doReadReturnValue(stopTuple, threadId, frame.getIndex()));
    }

    @NotNull
    public static final List<LLThread> getRtosThreads(@NotNull GDBDriver.Bridge bridge, @NotNull Function2<? super Long, ? super List<Task>, ? extends List<? extends LLThread>> taskProcessor) {
        Intrinsics.checkNotNullParameter((Object)bridge, (String)"bridge");
        Intrinsics.checkNotNullParameter(taskProcessor, (String)"taskProcessor");
        Object object = bridge.executeCommand((GDBDriver.Command)((GDBDriver.SuspendedCommand)() -> GdbRtosSupportKt.getRtosThreads$lambda$6(bridge, taskProcessor)));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"executeCommand(...)");
        return (List)object;
    }

    @Nullable
    public static final <T> T tryDecodeJsonFromConsoleOutput(@NotNull String s, @NotNull KSerializer<T> serializer2) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        Intrinsics.checkNotNullParameter(serializer2, (String)"serializer");
        try {
            String extractedQuote = GdbRtosSupportKt.extractQuotedString(s);
            object = Json.Default.decodeFromString((DeserializationStrategy)serializer2, extractedQuote);
        }
        catch (IllegalArgumentException e) {
            CidrDebuggerLog.LOG.info(e.getMessage());
            object = null;
        }
        return (T)object;
    }

    @NotNull
    public static final String extractQuotedString(@NotNull String raw) {
        int right;
        int left;
        block4: {
            block2: {
                block3: {
                    Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
                    if (!(!StringsKt.isBlank((CharSequence)raw))) break block2;
                    left = StringsKt.indexOf$default((CharSequence)raw, (String)"\"", (int)0, (boolean)false, (int)6, null) + 1;
                    right = StringsKt.lastIndexOf$default((CharSequence)raw, (String)"\"", (int)0, (boolean)false, (int)6, null);
                    boolean bl = 0 <= left ? left < ((CharSequence)raw).length() : false;
                    if (!bl) break block3;
                    if ((0 <= right ? right < ((CharSequence)raw).length() : false) && left < right) break block4;
                }
                throw new IllegalArgumentException("Input string doesn't contain enough quotes");
            }
            throw new IllegalArgumentException("Empty string passed");
        }
        String string = raw.substring(left, right);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        String threadsEscaped = string;
        String string2 = DebuggerDriver.unescapeString((String)threadsEscaped);
        Intrinsics.checkNotNull((Object)string2);
        return string2;
    }

    @NotNull
    public static final String generateRtosImportScript(@NotNull DebuggerDriverConfiguration driverConfiguration, @NotNull RtosType rtosType) {
        Intrinsics.checkNotNullParameter((Object)driverConfiguration, (String)"driverConfiguration");
        Intrinsics.checkNotNullParameter((Object)((Object)rtosType), (String)"rtosType");
        File rtosBinFile = CidrPathManager.getBinPath(CidrDebuggerPathManager.class, (String)"clion-embedded/bin", (String)"rtos", null).toFile();
        String string = FileUtil.toSystemIndependentName((String)rtosBinFile.getAbsolutePath());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toSystemIndependentName(...)");
        String rtosPath = string;
        String envPath = driverConfiguration.convertToEnvPath(rtosPath);
        String script = null;
        script = "import sys; sys.path.insert(0, " + DebuggerDriver.stringify((String)envPath) + "); import common; ";
        if (rtosType == RtosType.AUTO) {
            EnumSet<Enum> enumSet = EnumSet.complementOf(EnumSet.of((Enum)RtosType.AUTO));
            Intrinsics.checkNotNullExpressionValue(enumSet, (String)"complementOf(...)");
            Iterable $this$forEach$iv = enumSet;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                RtosType it = (RtosType)((Object)element$iv);
                boolean bl = false;
                script = script + "import " + it.getPyPackageName() + "; ";
            }
        } else {
            script = script + "import " + rtosType.getPyPackageName() + " ";
        }
        return script;
    }

    private static final DebuggerDriver.StopPlace rtosDoReadStopPlaceAsync$lambda$0(GDBDriver.Bridge $bridge, GDBTuple $stopTuple) {
        return GdbRtosSupportKt.rtosReadStopPlace($bridge, $stopTuple);
    }

    private static final DebuggerDriver.StopPlace rtosDoReadStopPlaceAsync$lambda$2(GDBDriver $driver, DebuggerDriver.StopPlace result2, Throwable throwable) {
        Throwable driverError;
        Object object;
        if (throwable != null) {
            CidrDebuggerLog.LOG.warn(throwable.getMessage());
        }
        try {
            boolean bl = false;
            $driver.checkErrors();
            object = Result.constructor-impl((Object)Unit.INSTANCE);
        }
        catch (Throwable throwable2) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable2));
        }
        Throwable throwable3 = driverError = Result.exceptionOrNull-impl((Object)object);
        if ((throwable3 != null ? throwable3.getCause() : null) != null) {
            Throwable throwable4 = throwable;
            if (!Intrinsics.areEqual((Object)driverError.getCause(), (Object)(throwable4 != null ? throwable4.getCause() : null))) {
                CidrDebuggerLog.LOG.warn(driverError.getMessage());
            }
        }
        return result2;
    }

    private static final CompletionStage rtosDoReadStopPlaceAsync$lambda$3(Function0 $fallbackReadStopPlace, DebuggerDriver.StopPlace it) {
        return it != null ? CompletableFuture.completedFuture(it) : (CompletableFuture)$fallbackReadStopPlace.invoke();
    }

    private static final CompletionStage rtosDoReadStopPlaceAsync$lambda$4(Function1 $tmp0, Object p0) {
        return (CompletionStage)$tmp0.invoke(p0);
    }

    private static final ExecutionException rtosReadStopPlace$lambda$5(GDBTuple $stopTuple) {
        Object[] objectArray = new Object[]{$stopTuple};
        return new ExecutionException(GDBBundle.message((String)"error.cannot.read.stop.place", (Object[])objectArray));
    }

    private static final List getRtosThreads$lambda$6(GDBDriver.Bridge $bridge, Function2 $taskProcessor) {
        $bridge.sendSilentRequestAndGetOutput("set print elements unlimited", new Object[0]);
        long threadId = $bridge.doEvaluateAndLoad(-1L, -1, "$_gthread", null).intValue();
        $bridge.sendSilentRequestAndGetOutput("p/s 1", new Object[0]);
        String string = $bridge.sendSilentRequestAndGetOutput("p/r $rtos_tasks()", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sendSilentRequestAndGetOutput(...)");
        String consoleOutput = string;
        String string2 = "set print elements %s";
        Object[] objectArray = new Object[]{256};
        String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
        $bridge.sendSilentRequestAndGetOutput(string3, new Object[0]);
        List list = (List)GdbRtosSupportKt.tryDecodeJsonFromConsoleOutput(consoleOutput, BuiltinSerializersKt.ListSerializer(Task.Companion.serializer()));
        if (list == null) {
            return CollectionsKt.emptyList();
        }
        List tasks = list;
        return (List)$taskProcessor.invoke((Object)threadId, (Object)tasks);
    }
}

