/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.clion.embedded.execution.rtos.freertos;

import com.intellij.CommonBundle;
import com.intellij.clion.embedded.EmbeddedBundle;
import com.intellij.clion.embedded.execution.rtos.GdbRtosSupportKt;
import com.intellij.clion.embedded.execution.rtos.freertos.FreeRtosConfig;
import com.intellij.clion.embedded.execution.rtos.freertos.FreeRtosDataManager;
import com.intellij.clion.embedded.execution.rtos.freertos.Heap;
import com.intellij.clion.embedded.execution.rtos.freertos.HeapDataRetriever;
import com.intellij.clion.embedded.execution.rtos.freertos.Queue;
import com.intellij.clion.embedded.execution.rtos.freertos.QueueDataRetriever;
import com.intellij.clion.embedded.execution.rtos.freertos.Task;
import com.intellij.clion.embedded.execution.rtos.freertos.TaskDataRetriever;
import com.intellij.clion.embedded.execution.rtos.freertos.Timer;
import com.intellij.clion.embedded.execution.rtos.freertos.TimerDataRetriever;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcess;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerLog;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerCommandException;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerIllegalStateException;
import java.util.List;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J \u0010-\u001a\u00020$*\u00020\u00052\u0006\u0010.\u001a\u00020/2\n\u00100\u001a\u000601j\u0002`2H\u0002J\u0014\u00103\u001a\u0002042\n\u00100\u001a\u000601j\u0002`2H\u0002J\u0012\u00105\u001a\u0002042\b\b\u0001\u00106\u001a\u00020/H\u0002J\u001c\u00107\u001a\u0002042\f\u00108\u001a\b\u0012\u0004\u0012\u00020409H\u0086@\u00a2\u0006\u0002\u0010:R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R \u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u0014\"\u0004\b\u001a\u0010\u0016R \u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u0014\"\u0004\b\u001e\u0010\u0016R \u0010\u001f\u001a\b\u0012\u0004\u0012\u00020 0\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\u0014\"\u0004\b\"\u0010\u0016R\u0011\u0010#\u001a\u00020$\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u0011\u0010'\u001a\u00020$\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010&R\u0011\u0010)\u001a\u00020*\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010,\u00a8\u0006;"}, d2={"Lcom/intellij/clion/embedded/execution/rtos/freertos/FreeRtosDataManager;", "", "debugProcess", "Lcom/jetbrains/cidr/execution/debugger/CidrDebugProcess;", "driver", "Lcom/jetbrains/cidr/execution/debugger/backend/DebuggerDriver;", "<init>", "(Lcom/jetbrains/cidr/execution/debugger/CidrDebugProcess;Lcom/jetbrains/cidr/execution/debugger/backend/DebuggerDriver;)V", "queueDataRetriever", "Lcom/intellij/clion/embedded/execution/rtos/freertos/QueueDataRetriever;", "taskDataRetriever", "Lcom/intellij/clion/embedded/execution/rtos/freertos/TaskDataRetriever;", "timerDataRetriever", "Lcom/intellij/clion/embedded/execution/rtos/freertos/TimerDataRetriever;", "heapDataRetriever", "Lcom/intellij/clion/embedded/execution/rtos/freertos/HeapDataRetriever;", "queueData", "", "Lcom/intellij/clion/embedded/execution/rtos/freertos/Queue;", "getQueueData", "()Ljava/util/List;", "setQueueData", "(Ljava/util/List;)V", "taskData", "Lcom/intellij/clion/embedded/execution/rtos/freertos/Task;", "getTaskData", "setTaskData", "timerData", "Lcom/intellij/clion/embedded/execution/rtos/freertos/Timer;", "getTimerData", "setTimerData", "heapData", "Lcom/intellij/clion/embedded/execution/rtos/freertos/Heap;", "getHeapData", "setHeapData", "queueStructSize", "", "getQueueStructSize", "()J", "tcbStructSize", "getTcbStructSize", "config", "Lcom/intellij/clion/embedded/execution/rtos/freertos/FreeRtosConfig;", "getConfig", "()Lcom/intellij/clion/embedded/execution/rtos/freertos/FreeRtosConfig;", "calculateSizeof", "typeName", "", "messageBuilder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "collectErrors", "", "showNotificationIfNeeded", "warningMessage", "updateAll", "updateListener", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.clion.embedded"})
@SourceDebugExtension(value={"SMAP\nFreeRtosDataManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FreeRtosDataManager.kt\ncom/intellij/clion/embedded/execution/rtos/freertos/FreeRtosDataManager\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,304:1\n24#2:305\n*S KotlinDebug\n*F\n+ 1 FreeRtosDataManager.kt\ncom/intellij/clion/embedded/execution/rtos/freertos/FreeRtosDataManager\n*L\n115#1:305\n*E\n"})
public final class FreeRtosDataManager {
    @NotNull
    private final CidrDebugProcess debugProcess;
    @NotNull
    private final QueueDataRetriever queueDataRetriever;
    @NotNull
    private final TaskDataRetriever taskDataRetriever;
    @NotNull
    private final TimerDataRetriever timerDataRetriever;
    @NotNull
    private final HeapDataRetriever heapDataRetriever;
    @NotNull
    private List<Queue> queueData;
    @NotNull
    private List<Task> taskData;
    @NotNull
    private List<Timer> timerData;
    @NotNull
    private List<Heap> heapData;
    private final long queueStructSize;
    private final long tcbStructSize;
    @NotNull
    private final FreeRtosConfig config;

    public FreeRtosDataManager(@NotNull CidrDebugProcess debugProcess, @NotNull DebuggerDriver driver) {
        Intrinsics.checkNotNullParameter((Object)debugProcess, (String)"debugProcess");
        Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
        this.debugProcess = debugProcess;
        this.queueDataRetriever = new QueueDataRetriever();
        this.taskDataRetriever = new TaskDataRetriever(this);
        this.timerDataRetriever = new TimerDataRetriever();
        this.heapDataRetriever = new HeapDataRetriever(this);
        this.queueData = CollectionsKt.emptyList();
        this.taskData = CollectionsKt.emptyList();
        this.timerData = CollectionsKt.emptyList();
        this.heapData = CollectionsKt.emptyList();
        StringBuilder messageBuilder = new StringBuilder();
        this.queueStructSize = this.calculateSizeof(driver, "Queue_t", messageBuilder);
        this.tcbStructSize = this.calculateSizeof(driver, "TCB_t", messageBuilder);
        String string = driver.executeInterpreterCommand(-1L, -1, "p/r $rtos_config()");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"executeInterpreterCommand(...)");
        FreeRtosConfig freeRtosConfig = GdbRtosSupportKt.tryDecodeJsonFromConsoleOutput(string, FreeRtosConfig.Companion.serializer());
        if (freeRtosConfig == null) {
            freeRtosConfig = new FreeRtosConfig(false, false, false, false, false, false, false, false, false, 511, null);
        }
        this.config = freeRtosConfig;
        this.collectErrors(messageBuilder);
        String string2 = messageBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        this.showNotificationIfNeeded(string2);
    }

    @NotNull
    public final List<Queue> getQueueData() {
        return this.queueData;
    }

    public final void setQueueData(@NotNull List<Queue> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.queueData = list;
    }

    @NotNull
    public final List<Task> getTaskData() {
        return this.taskData;
    }

    public final void setTaskData(@NotNull List<Task> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.taskData = list;
    }

    @NotNull
    public final List<Timer> getTimerData() {
        return this.timerData;
    }

    public final void setTimerData(@NotNull List<Timer> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.timerData = list;
    }

    @NotNull
    public final List<Heap> getHeapData() {
        return this.heapData;
    }

    public final void setHeapData(@NotNull List<Heap> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.heapData = list;
    }

    public final long getQueueStructSize() {
        return this.queueStructSize;
    }

    public final long getTcbStructSize() {
        return this.tcbStructSize;
    }

    @NotNull
    public final FreeRtosConfig getConfig() {
        return this.config;
    }

    private final long calculateSizeof(DebuggerDriver $this$calculateSizeof, String typeName, StringBuilder messageBuilder) {
        long l;
        String string = $this$calculateSizeof.executeInterpreterCommand(-1L, -1, "py print(gdb.parse_and_eval(\"sizeof(" + typeName + ")\"))");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"executeInterpreterCommand(...)");
        Long l2 = StringsKt.toLongOrNull((String)((Object)StringsKt.trim((CharSequence)string)).toString());
        if (l2 != null) {
            l = l2;
        } else {
            DebuggerDriver it = $this$calculateSizeof;
            boolean bl = false;
            Object[] objectArray = new Object[]{typeName};
            String string2 = EmbeddedBundle.message("freertos.integration.sizeof.failed", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
            String message = string2;
            messageBuilder.append(message).append('\n');
            CidrDebuggerLog.LOG.warn(message);
            l = 0L;
        }
        return l;
    }

    private final void collectErrors(StringBuilder messageBuilder) {
        if (!(this.config.getUseTraceFacility() && this.config.getUseTimers() && this.config.getHeapInfoAvailable() && this.config.getQueueRegistryEnabled() && this.config.getGenerateRuntimeStats() && this.config.getRecordStackHighAddress() && this.config.getUseMutexes())) {
            messageBuilder.append(EmbeddedBundle.message("freertos.integration.not.full", new Object[0]));
        }
    }

    private final void showNotificationIfNeeded(@Nls String warningMessage) {
        if (!StringsKt.isBlank((CharSequence)warningMessage)) {
            Notification noDataFoundNotification = new Notification("Embedded Development", EmbeddedBundle.message("freertos.integration.enabled", new Object[0]), warningMessage, NotificationType.WARNING);
            noDataFoundNotification.addAction((AnAction)DumbAwareAction.create((String)CommonBundle.message((String)"action.help", (Object[])new Object[0]), arg_0 -> FreeRtosDataManager.showNotificationIfNeeded$lambda$2(FreeRtosDataManager::showNotificationIfNeeded$lambda$1, arg_0)));
            Notifications.Bus.notify((Notification)noDataFoundNotification, (Project)this.debugProcess.getProject());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Nullable
    public final Object updateAll(@NotNull Function0<Unit> updateListener, @NotNull Continuation<? super Unit> $completion) {
        block28: {
            if (!($completion instanceof updateAll.1)) ** GOTO lbl-1000
            var9_3 = $completion;
            if ((var9_3.label & -2147483648) != 0) {
                var9_3.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, $completion){
                    Object L$0;
                    Object L$1;
                    /* synthetic */ Object result;
                    final /* synthetic */ FreeRtosDataManager this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return this.this$0.updateAll(null, (Continuation<? super Unit>)((Continuation)this));
                    }
                };
            }
            $result = $continuation.result;
            var10_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    if (!this.config.getQueueRegistryEnabled()) ** GOTO lbl31
                    var7_6 = this;
                    $continuation.L$0 = updateListener;
                    $continuation.L$1 = var7_6;
                    $continuation.label = 1;
                    v0 = this.queueDataRetriever.getObjectData(this.debugProcess, (Continuation<? super List<Queue>>)$continuation);
                    ** if (v0 != var10_5) goto lbl22
lbl21:
                    // 1 sources

                    return var10_5;
lbl22:
                    // 1 sources

                    ** GOTO lbl30
                }
                case 1: {
                    var7_6 = (FreeRtosDataManager)$continuation.L$1;
                    updateListener = (Function0)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl30:
                    // 2 sources

                    var7_6.queueData = (List)v0;
lbl31:
                    // 2 sources

                    var7_6 = this;
                    $continuation.L$0 = updateListener;
                    $continuation.L$1 = var7_6;
                    $continuation.label = 2;
                    v1 = this.taskDataRetriever.getObjectData(this.debugProcess, (Continuation<? super List<Task>>)$continuation);
                    ** if (v1 != var10_5) goto lbl38
lbl37:
                    // 1 sources

                    return var10_5;
lbl38:
                    // 1 sources

                    ** GOTO lbl46
                }
                case 2: {
                    var7_6 = (FreeRtosDataManager)$continuation.L$1;
                    updateListener = (Function0)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = $result;
lbl46:
                    // 2 sources

                    var7_6.taskData = (List)v1;
                    if (!this.config.getUseTimers()) ** GOTO lbl64
                    var7_6 = this;
                    $continuation.L$0 = updateListener;
                    $continuation.L$1 = var7_6;
                    $continuation.label = 3;
                    v2 = this.timerDataRetriever.getObjectData(this.debugProcess, (Continuation<? super List<Timer>>)$continuation);
                    ** if (v2 != var10_5) goto lbl55
lbl54:
                    // 1 sources

                    return var10_5;
lbl55:
                    // 1 sources

                    ** GOTO lbl63
                }
                case 3: {
                    var7_6 = (FreeRtosDataManager)$continuation.L$1;
                    updateListener = (Function0)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v2 = $result;
lbl63:
                    // 2 sources

                    var7_6.timerData = (List)v2;
lbl64:
                    // 2 sources

                    if (!this.config.getHeapInfoAvailable()) ** GOTO lbl81
                    var7_6 = this;
                    $continuation.L$0 = updateListener;
                    $continuation.L$1 = var7_6;
                    $continuation.label = 4;
                    v3 = this.heapDataRetriever.getObjectData(this.debugProcess, (Continuation<? super List<Heap>>)$continuation);
                    ** if (v3 != var10_5) goto lbl72
lbl71:
                    // 1 sources

                    return var10_5;
lbl72:
                    // 1 sources

                    ** GOTO lbl80
                }
                case 4: {
                    var7_6 = (FreeRtosDataManager)$continuation.L$1;
                    updateListener = (Function0)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v3 = $result;
lbl80:
                    // 2 sources

                    var7_6.heapData = (List)v3;
lbl81:
                    // 2 sources

                    $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)updateListener);
                    $continuation.L$1 = null;
                    $continuation.label = 5;
                    v4 = BuildersKt.withContext((CoroutineContext)CoroutinesKt.getUI((Dispatchers)Dispatchers.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>((Function0<Unit>)updateListener, null){
                        int label;
                        final /* synthetic */ Function0<Unit> $updateListener;
                        {
                            this.$updateListener = $updateListener;
                            super(2, $completion);
                        }

                        public final Object invokeSuspend(Object $result) {
                            IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)$result);
                                    this.$updateListener.invoke();
                                    return Unit.INSTANCE;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                        }

                        public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }), (Continuation)$continuation);
                    if (v4 == var10_5) {
                        return var10_5;
                    }
                    break;
                }
                case 5: {
                    updateListener = (Function0)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v4 = $result;
                    break;
                }
            }
            catch (Exception ex) {
                var4_10 = ex;
                if (!(var4_10 instanceof DebuggerCommandException) && !(var4_10 instanceof DebuggerIllegalStateException)) {
                    throw ex;
                }
                $this$thisLogger$iv = this;
                $i$f$thisLogger = false;
                v5 = Logger.getInstance(FreeRtosDataManager.class);
                Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"getInstance(...)");
                v5.warn("FreeRTOS objects updating failed: " + ex);
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)updateListener);
                $continuation.L$1 = null;
                $continuation.label = 6;
                v6 = BuildersKt.withContext((CoroutineContext)CoroutinesKt.getUI((Dispatchers)Dispatchers.INSTANCE), (Function2)((Function2)new /* invalid duplicate definition of identical inner class */), (Continuation)$continuation);
                if (v6 == var10_5) {
                    return var10_5;
                }
                break block28;
            }
            {
                case 6: {
                    updateListener = (Function0)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v6 = $result;
                    break;
                }
            }
            {
                catch (Throwable var3_8) {
                    $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)updateListener);
                    $continuation.L$1 = var3_8;
                    $continuation.label = 7;
                    v7 = BuildersKt.withContext((CoroutineContext)CoroutinesKt.getUI((Dispatchers)Dispatchers.INSTANCE), (Function2)((Function2)new /* invalid duplicate definition of identical inner class */), (Continuation)$continuation);
                    if (v7 == var10_5) {
                        return var10_5;
                    }
                    ** GOTO lbl128
                }
            }
            {
                case 7: {
                    var3_9 = (Throwable)$continuation.L$1;
                    updateListener = (Function0)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v7 = $result;
lbl128:
                    // 2 sources

                    throw var3_9;
                }
            }
        }
        return Unit.INSTANCE;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private static final Unit showNotificationIfNeeded$lambda$1(AnActionEvent it) {
        HelpManager.getInstance().invokeHelp("rtos.objectsview");
        return Unit.INSTANCE;
    }

    private static final void showNotificationIfNeeded$lambda$2(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }
}

