/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.clion.embedded.execution.ui;

import com.intellij.CommonBundle;
import com.intellij.clion.embedded.EmbeddedBundle;
import com.intellij.clion.embedded.execution.EmbeddedSettingsConfigurable;
import com.intellij.execution.impl.EditConfigurationsDialog;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.NlsContexts;
import com.jetbrains.cidr.cpp.toolchains.CPPToolchainsConfigurable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class EmbeddedMessages {
    public static final String OPEN_OCD_TITLE = "OpenOCD";

    private EmbeddedMessages() {
    }

    public static void showSuccessfulDownloadNotification(@NotNull Project project) {
        if (project == null) {
            EmbeddedMessages.$$$reportNull$$$0(0);
        }
        EmbeddedMessages.showSuccessMessage(project, OPEN_OCD_TITLE, EmbeddedBundle.message("firmware.downloaded", new Object[0]));
    }

    public static void showSuccessMessage(@Nullable Project project, @NlsContexts.NotificationTitle @NotNull String title, @NlsContexts.NotificationContent @NotNull String message) {
        if (title == null) {
            EmbeddedMessages.$$$reportNull$$$0(1);
        }
        if (message == null) {
            EmbeddedMessages.$$$reportNull$$$0(2);
        }
        EmbeddedMessages.showMessage(project, NotificationType.INFORMATION, title, message, false);
    }

    public static void showErrorMessage(@Nullable Project project, @NlsContexts.NotificationTitle @NotNull String title, @NlsContexts.NotificationContent @NotNull String message, boolean enableRunConfiguration) {
        if (title == null) {
            EmbeddedMessages.$$$reportNull$$$0(3);
        }
        if (message == null) {
            EmbeddedMessages.$$$reportNull$$$0(4);
        }
        EmbeddedMessages.showMessage(project, NotificationType.ERROR, title, message, enableRunConfiguration);
    }

    public static void showErrorMessage(@Nullable Project project, @NlsContexts.NotificationTitle @NotNull String title, @NlsContexts.NotificationContent @NotNull String message) {
        if (title == null) {
            EmbeddedMessages.$$$reportNull$$$0(5);
        }
        if (message == null) {
            EmbeddedMessages.$$$reportNull$$$0(6);
        }
        EmbeddedMessages.showMessage(project, NotificationType.ERROR, title, message, false);
    }

    public static void showErrorMessage(@Nullable Project project, @NotNull ConfigurationException e) {
        if (e == null) {
            EmbeddedMessages.$$$reportNull$$$0(7);
        }
        EmbeddedMessages.showErrorMessage(project, e.getTitle(), e.getMessage());
    }

    private static void showMessage(@Nullable Project project, @NotNull NotificationType notificationType, @NlsContexts.NotificationTitle @NotNull String title, @NlsContexts.NotificationContent @NotNull String message, boolean enableRunConfiguration) {
        if (notificationType == null) {
            EmbeddedMessages.$$$reportNull$$$0(8);
        }
        if (title == null) {
            EmbeddedMessages.$$$reportNull$$$0(9);
        }
        if (message == null) {
            EmbeddedMessages.$$$reportNull$$$0(10);
        }
        Notification notification = new Notification("Embedded Development", title, message, notificationType);
        notification.addAction((AnAction)DumbAwareAction.create((String)CommonBundle.message((String)"action.help", (Object[])new Object[0]), e -> EmbeddedMessages.openHelp()));
        if (notificationType != NotificationType.INFORMATION) {
            notification.addAction((AnAction)DumbAwareAction.create((String)EmbeddedBundle.message("show.settings.action", new Object[0]), e -> ShowSettingsUtil.getInstance().showSettingsDialog(project, EmbeddedSettingsConfigurable.class)));
            notification.addAction((AnAction)DumbAwareAction.create((String)EmbeddedBundle.message("show.toolchains.action", new Object[0]), e -> ShowSettingsUtil.getInstance().showSettingsDialog(project, CPPToolchainsConfigurable.class)));
            if (enableRunConfiguration && project != null) {
                notification.addAction((AnAction)DumbAwareAction.create((String)EmbeddedBundle.message("edit.configuration.action", new Object[0]), e -> new EditConfigurationsDialog(project).show()));
            }
        }
        Notifications.Bus.notify((Notification)notification, (Project)project);
    }

    public static void showFailedDownloadNotification(@Nullable Project project) {
        if (project == null) {
            project = ProjectManager.getInstance().getDefaultProject();
        }
        EmbeddedMessages.showErrorMessage(project, OPEN_OCD_TITLE, EmbeddedBundle.message("mcu.communication.failure.detailed", new Object[0]), true);
    }

    public static void openHelp() {
        HelpManager.getInstance().invokeHelp("Embedded_Development");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notificationType";
                break;
            }
        }
        objectArray2[1] = "com/intellij/clion/embedded/execution/ui/EmbeddedMessages";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "showSuccessfulDownloadNotification";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "showSuccessMessage";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "showErrorMessage";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "showMessage";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

