/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.clion.embedded.execution.wizard;

import com.intellij.clion.embedded.EmbeddedBundle;
import com.intellij.clion.embedded.execution.wizard.Device;
import com.intellij.clion.embedded.execution.wizard.GdbServer;
import com.intellij.clion.embedded.execution.wizard.GdbServerType;
import com.intellij.clion.embedded.execution.wizard.GdbServerWizard;
import com.intellij.clion.embedded.execution.wizard.GdbWizardDevicesTreeBuilder;
import com.intellij.clion.embedded.execution.wizard.GdbWizardOptions;
import com.intellij.clion.embedded.execution.wizard.ResetStrategy;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.ide.wizard.CommitStepException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\b\u0010\u0006\u001a\u00020\u0005H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0018\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0016\u00a8\u0006\u0014"}, d2={"Lcom/intellij/clion/embedded/execution/wizard/PyOcdServer;", "Lcom/intellij/clion/embedded/execution/wizard/GdbServer;", "<init>", "()V", "getDisplayName", "", "getDefaultServerExecutableName", "getDialogPanel", "Lcom/intellij/openapi/ui/DialogPanel;", "wizard", "Lcom/intellij/clion/embedded/execution/wizard/GdbServerWizard;", "gatherData", "", "project", "Lcom/intellij/openapi/project/Project;", "state", "Lcom/intellij/clion/embedded/execution/wizard/GdbWizardOptions;", "generateConnectionString", "port", "", "intellij.clion.embedded"})
@SourceDebugExtension(value={"SMAP\nPyOcdServer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PyOcdServer.kt\ncom/intellij/clion/embedded/execution/wizard/PyOcdServer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,59:1\n774#2:60\n865#2,2:61\n1869#2,2:63\n37#3:65\n36#3,3:66\n*S KotlinDebug\n*F\n+ 1 PyOcdServer.kt\ncom/intellij/clion/embedded/execution/wizard/PyOcdServer\n*L\n33#1:60\n33#1:61,2\n34#1:63,2\n22#1:65\n22#1:66,3\n*E\n"})
public final class PyOcdServer
extends GdbServer {
    public PyOcdServer() {
        super(GdbServerType.PYOCD);
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = EmbeddedBundle.message("pyocd.gdb.server.displayname", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @Override
    @NotNull
    public String getDefaultServerExecutableName() {
        return SystemInfo.isWindows ? "pyocd.exe" : "pyocd";
    }

    @Override
    @NotNull
    public DialogPanel getDialogPanel(@NotNull GdbServerWizard wizard) {
        Intrinsics.checkNotNullParameter((Object)((Object)wizard), (String)"wizard");
        return BuilderKt.panel(arg_0 -> PyOcdServer.getDialogPanel$lambda$1(this, wizard, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void gatherData(@NotNull Project project, @NotNull GdbWizardOptions state) {
        void $this$forEach$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)((Object)state), (String)"state");
        String executable = this.getGdbserverLocation(state);
        String[] stringArray = new String[]{executable, "list", "--targets", "--no-header"};
        ProcessOutput output = this.gatherProcessOutput(true, stringArray);
        GdbWizardDevicesTreeBuilder builder = new GdbWizardDevicesTreeBuilder();
        Regex wsRegex = new Regex("\\s\\s+");
        String string = output.getStdout();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getStdout(...)");
        Object object = new String[]{"\n"};
        object = StringsKt.split$default((CharSequence)string, (String[])object, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$filter = false;
        Iterator iterator = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            boolean bl2 = ((CharSequence)it).length() > 0;
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String line = (String)element$iv;
            boolean bl = false;
            Object[] objectArray = (Object[])line;
            int n = 4;
            List parts = wsRegex.split((CharSequence)objectArray, n);
            if (parts.size() != 4) {
                objectArray = new Object[]{line};
                throw new CommitStepException(EmbeddedBundle.message("gdb.servers.wizard.devices.parse.error", objectArray));
            }
            builder.addNode(new Device((String)parts.get(1), (String)parts.get(2), null, null, null, 28, null));
        }
        state.setDevicesTree(this.validateNonEmptyTree(builder.build()));
    }

    @Override
    @NotNull
    public String generateConnectionString(@NotNull GdbWizardOptions state, int port) {
        CharSequence charSequence;
        Intrinsics.checkNotNullParameter((Object)((Object)state), (String)"state");
        String arguments = "gdbserver -p " + port + " -t " + this.selectedDeviceKey(state);
        if (!Intrinsics.areEqual((Object)state.getFrequency(), (Object)"AUTO") && !((charSequence = (CharSequence)state.getFrequency()) == null || StringsKt.isBlank((CharSequence)charSequence))) {
            arguments = arguments + " -f " + state.getFrequency();
        }
        switch (WhenMappings.$EnumSwitchMapping$0[state.getResetStrategy().ordinal()]) {
            case 1: {
                arguments = arguments + " --connect attach";
                break;
            }
            case 2: {
                arguments = arguments + " --connect under-reset";
                break;
            }
            case 3: {
                arguments = arguments + " --connect pre-reset";
                break;
            }
            case 4: {
                arguments = arguments + " --connect halt";
            }
        }
        return arguments;
    }

    private static final Unit getDialogPanel$lambda$1$lambda$0(Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        return Unit.INSTANCE;
    }

    private static final Unit getDialogPanel$lambda$1(PyOcdServer this$0, GdbServerWizard $wizard, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        String string = EmbeddedBundle.message("label.pyocd", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        $this$panel.row(string, PyOcdServer::getDialogPanel$lambda$1$lambda$0);
        Panel.separator$default((Panel)$this$panel, null, (int)1, null);
        Object[] objectArray = new String[]{"AUTO", "400", "1000", "2000", "4000", "8000", "12000"};
        this$0.speedRow($this$panel, $wizard, "AUTO", (String[])objectArray);
        Collection $this$toTypedArray$iv = (Collection)ResetStrategy.getEntries();
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        objectArray = thisCollection$iv.toArray(new ResetStrategy[0]);
        this$0.resetStrategyRow($this$panel, $wizard, (ResetStrategy[])Arrays.copyOf(objectArray, objectArray.length));
        this$0.devicesListRows($this$panel, $wizard);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ResetStrategy.values().length];
            try {
                nArray[ResetStrategy.ATTACH.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ResetStrategy.UNDER_RESET.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ResetStrategy.PRE_RESET.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ResetStrategy.HALT.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

