/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.clion.embedded.execution.wizard;

import com.intellij.clion.embedded.EmbeddedBundle;
import com.intellij.clion.embedded.execution.wizard.GdbServer;
import com.intellij.clion.embedded.execution.wizard.GdbServerType;
import com.intellij.clion.embedded.execution.wizard.GdbServerWizard;
import com.intellij.clion.embedded.execution.wizard.GdbWizardOptions;
import com.intellij.clion.embedded.execution.wizard.ResetStrategy;
import com.intellij.clion.embedded.execution.wizard.StLinkServer;
import com.intellij.clion.embedded.execution.wizard.StToolsPaths;
import com.intellij.ide.wizard.CommitStepException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlin.text.UStringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\b\u0010\u0006\u001a\u00020\u0005H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\"\u0010\u0010\u001a\u00020\u0011*\u0004\u0018\u00010\u00112\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00140\u0013H\u0002J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\f\u001a\u00020\rH\u0016J\n\u0010\u0019\u001a\u0004\u0018\u00010\u0005H\u0016J4\u0010\u001a\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0011\u0012\u0004\u0012\u00020\u001c0\u001b2\u0014\u0010\u001d\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0011\u0012\u0004\u0012\u00020\u001c0\u001b2\u0006\u0010\u001e\u001a\u00020\u0011H\u0002J\u0010\u0010\u001f\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006 "}, d2={"Lcom/intellij/clion/embedded/execution/wizard/StLinkServer;", "Lcom/intellij/clion/embedded/execution/wizard/GdbServer;", "<init>", "()V", "getDisplayName", "", "getDefaultServerExecutableName", "getDialogPanel", "Lcom/intellij/openapi/ui/DialogPanel;", "wizard", "Lcom/intellij/clion/embedded/execution/wizard/GdbServerWizard;", "generateConnectionString", "state", "Lcom/intellij/clion/embedded/execution/wizard/GdbWizardOptions;", "port", "", "ensure", "Ljava/io/File;", "validator", "Lkotlin/Function1;", "", "gatherData", "", "project", "Lcom/intellij/openapi/project/Project;", "findDefaultLocation", "selectLatest", "Lkotlin/Pair;", "", "fileAndDate", "anotherFile", "getGdbserverExe", "intellij.clion.embedded"})
@SourceDebugExtension(value={"SMAP\nStLinkServer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StLinkServer.kt\ncom/intellij/clion/embedded/execution/wizard/StLinkServer\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,123:1\n13472#2,2:124\n1374#3:126\n1460#3,5:127\n774#3:132\n865#3,2:133\n*S KotlinDebug\n*F\n+ 1 StLinkServer.kt\ncom/intellij/clion/embedded/execution/wizard/StLinkServer\n*L\n74#1:124,2\n105#1:126\n105#1:127,5\n108#1:132\n108#1:133,2\n*E\n"})
public final class StLinkServer
extends GdbServer {
    public StLinkServer() {
        super(GdbServerType.STLINK);
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = EmbeddedBundle.message("st.link.gdb.server.displayname", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @Override
    @NotNull
    public String getDefaultServerExecutableName() {
        return SystemInfo.isWindows ? "stm32cubeide.exe" : (SystemInfo.isMac ? "STM32CubeIDE.app" : "stm32cubeide");
    }

    @Override
    @NotNull
    public DialogPanel getDialogPanel(@NotNull GdbServerWizard wizard) {
        Intrinsics.checkNotNullParameter((Object)((Object)wizard), (String)"wizard");
        return BuilderKt.panel(arg_0 -> StLinkServer.getDialogPanel$lambda$1(this, wizard, arg_0));
    }

    @Override
    @NotNull
    public String generateConnectionString(@NotNull GdbWizardOptions state, int port) {
        Intrinsics.checkNotNullParameter((Object)((Object)state), (String)"state");
        String arguments = "-p " + port + " -cp \"" + state.getStTools().getProgrammerPath() + "\"";
        String string = state.getFrequency();
        if ((string != null ? UStringsKt.toUIntOrNull((String)string) : null) != null) {
            arguments = arguments + " --frequency " + state.getFrequency();
        }
        if (state.getInterfaceType() == GdbWizardOptions.Companion.TransportInterface.SWD) {
            arguments = arguments + " --swd";
        }
        switch (WhenMappings.$EnumSwitchMapping$0[state.getResetStrategy().ordinal()]) {
            case 1: {
                arguments = arguments + " --attach";
                break;
            }
            case 2: {
                arguments = arguments + " --initialize-reset";
            }
        }
        return arguments;
    }

    private final File ensure(File $this$ensure, Function1<? super File, Boolean> validator) {
        if ($this$ensure == null || !((Boolean)validator.invoke((Object)$this$ensure)).booleanValue()) {
            throw new CommitStepException(EmbeddedBundle.message("stm32.cube.ide.wrong.executable", new Object[0]));
        }
        return $this$ensure;
    }

    @Override
    public void gatherData(@NotNull Project project, @NotNull GdbWizardOptions state) {
        File file;
        File file2;
        Path path;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)((Object)state), (String)"state");
        if (SystemInfo.isMac) {
            Path path2 = Paths.get(this.getGdbserverLocation(state) + "/Contents/Eclipse", new String[0]);
            path = path2;
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"get(...)");
        } else {
            Path path3 = Paths.get(this.getGdbserverLocation(state), new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"get(...)");
            path = path3.getParent();
        }
        Path baseFolder = path;
        File pluginsFolder2 = this.ensure(baseFolder.resolve("plugins").toFile(), (Function1<? super File, Boolean>)((Function1)gatherData.pluginsFolder.1.INSTANCE));
        Pair<File, Long> gdbServerFolderAndDate = null;
        gdbServerFolderAndDate = new Pair<File, Long>(null, (Object)-1L);
        Pair<File, Long> stProgrammerAndDate = null;
        stProgrammerAndDate = new Pair<File, Long>(null, (Object)-1L);
        File[] fileArray = pluginsFolder2.listFiles();
        if (fileArray != null) {
            File[] $this$forEach$iv = fileArray;
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int i = 0; i < n; ++i) {
                File element$iv;
                File it = element$iv = $this$forEach$iv[i];
                boolean bl = false;
                if (!it.isDirectory()) continue;
                String string = it.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                if (StringsKt.startsWith$default((String)string, (String)"com.st.stm32cube.ide.mcu.externaltools.stlink-gdb-server", (boolean)false, (int)2, null)) {
                    Intrinsics.checkNotNull((Object)it);
                    gdbServerFolderAndDate = this.selectLatest((Pair<? extends File, Long>)gdbServerFolderAndDate, it);
                    continue;
                }
                String string2 = it.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
                if (!StringsKt.startsWith$default((String)string2, (String)"com.st.stm32cube.ide.mcu.externaltools.cubeprogrammer", (boolean)false, (int)2, null)) continue;
                Intrinsics.checkNotNull((Object)it);
                stProgrammerAndDate = this.selectLatest((Pair<? extends File, Long>)stProgrammerAndDate, it);
            }
        }
        Path path4 = this.ensure((file2 = (File)gdbServerFolderAndDate.getFirst()) != null && (file = FilesKt.resolve((File)file2, (String)"tools/bin")) != null ? FilesKt.resolve((File)file, (String)(SystemInfo.isWindows ? "ST-LINK_gdbserver.exe" : "ST-LINK_gdbserver")) : null, (Function1<? super File, Boolean>)((Function1)gatherData.2.INSTANCE)).toPath();
        Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"toPath(...)");
        file2 = (File)stProgrammerAndDate.getFirst();
        Path path5 = this.ensure(file2 != null ? FilesKt.resolve((File)file2, (String)"tools/bin") : null, (Function1<? super File, Boolean>)((Function1)gatherData.3.INSTANCE)).toPath();
        Intrinsics.checkNotNullExpressionValue((Object)path5, (String)"toPath(...)");
        state.setStTools(new StToolsPaths(path4, path5));
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @Nullable
    public String findDefaultLocation() {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        void $this$flatMapTo$iv$iv;
        void $this$flatMap$iv;
        if (SystemInfo.isMac) {
            String location2 = "/Applications/STM32CubeIDE.app";
            if (!new File(location2).canExecute()) return null;
            String string = location2;
            return string;
        }
        Object[] objectArray = new File(SystemInfo.isWindows ? "C:\\ST" : "/opt/st").listFiles();
        if (objectArray == null) return null;
        List list = ArraysKt.asList((Object[])objectArray);
        if (list == null) return null;
        List list2 = CollectionsKt.sortedWith((Iterable)list, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                File p0 = (File)b;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)p0.toString());
                p0 = (File)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)p0.toString())));
            }
        });
        if (list2 == null) return null;
        Iterable iterable = list2;
        boolean $i$f$flatMap22 = false;
        void var6_8 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            File dir = (File)element$iv$iv;
            boolean bl = false;
            File subDir = new File(dir, "STM32CubeIDE");
            Object[] objectArray2 = new File[]{new File(dir, this.getDefaultServerExecutableName()), new File(subDir, this.getDefaultServerExecutableName())};
            Iterable list$iv$iv = CollectionsKt.listOf((Object[])objectArray2);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Iterable $i$f$flatMap22 = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        destination$iv$iv = $this$filter$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            File p0 = (File)element$iv$iv;
            boolean bl = false;
            if (!p0.canExecute()) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        File file = (File)CollectionsKt.getOrNull((List)((List)destination$iv$iv2), (int)0);
        if (file == null) return null;
        String string = file.toString();
        return string;
    }

    private final Pair<File, Long> selectLatest(Pair<? extends File, Long> fileAndDate, File anotherFile) {
        String name = anotherFile.getName();
        Intrinsics.checkNotNull((Object)name);
        int lastDotIndex = StringsKt.lastIndexOf$default((CharSequence)name, (char)'.', (int)0, (boolean)false, (int)6, null);
        if (lastDotIndex < 0) {
            return fileAndDate;
        }
        String string = name.substring(lastDotIndex + 1);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        Long l = StringsKt.toLongOrNull((String)string, (int)10);
        long bcdDate = l != null ? l : -1L;
        return bcdDate > ((Number)fileAndDate.getSecond()).longValue() ? new Pair((Object)anotherFile, (Object)bcdDate) : fileAndDate;
    }

    @Override
    @NotNull
    public String getGdbserverExe(@NotNull GdbWizardOptions state) {
        Intrinsics.checkNotNullParameter((Object)((Object)state), (String)"state");
        return ((Object)state.getStTools().getGdbServerApp()).toString();
    }

    private static final Unit getDialogPanel$lambda$1$lambda$0(Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        return Unit.INSTANCE;
    }

    private static final Unit getDialogPanel$lambda$1(StLinkServer this$0, GdbServerWizard $wizard, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        String string = EmbeddedBundle.message("label.stlink.gdb.server", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        $this$panel.row(string, StLinkServer::getDialogPanel$lambda$1$lambda$0);
        Panel.separator$default((Panel)$this$panel, null, (int)1, null);
        this$0.interfacesRow($this$panel, $wizard);
        Object[] objectArray = new String[]{"AUTO", "5", "25", "100", "240", "950", "1800", "4000", "8000", "24000"};
        this$0.speedRow($this$panel, $wizard, "8000", (String[])objectArray);
        objectArray = new ResetStrategy[]{ResetStrategy.DEFAULT, ResetStrategy.ATTACH, ResetStrategy.UNDER_RESET};
        this$0.resetStrategyRow($this$panel, $wizard, (ResetStrategy[])objectArray);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ResetStrategy.values().length];
            try {
                nArray[ResetStrategy.ATTACH.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ResetStrategy.UNDER_RESET.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

