/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.clion.embedded.stm32cubemx;

import com.intellij.clion.embedded.stm32cubemx.ConvertProjectAction;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
public final class CubeMXManager
implements BulkFileListener,
Disposable {
    public static final int FILE_MTIME_TOLERANCE_S = 10;
    public static final Topic<CubeStatusListener> TOPIC = Topic.create((String)"STM32CubeMX Project Updates", CubeStatusListener.class);
    private final Project myProject;
    private VirtualFile myProjectDir;
    private MessageBus myMessageBus;
    private MessageBusConnection myConnection;
    private final AtomicBoolean cmakeUpdateScheduled;
    @NotNull
    private volatile CubeStatus myStatus;
    private volatile String myTargetMCU;
    private volatile boolean myUtilityRunning;
    private final CoroutineScope myScope;

    public CubeMXManager(@NotNull Project project, @NotNull CoroutineScope cs) {
        if (project == null) {
            CubeMXManager.$$$reportNull$$$0(0);
        }
        if (cs == null) {
            CubeMXManager.$$$reportNull$$$0(1);
        }
        this.cmakeUpdateScheduled = new AtomicBoolean(false);
        this.myStatus = CubeStatus.BROKEN;
        this.myTargetMCU = null;
        this.myProject = project;
        this.myScope = cs;
    }

    public void notifyPossibleCubeMXChanges() {
        this.myMessageBus = this.myProject.getMessageBus();
        if (this.myConnection == null) {
            Object[] projectRootFiles;
            this.myProjectDir = ConvertProjectAction.getProjectDir(this.myProject);
            if (this.myProjectDir != null && (projectRootFiles = VfsUtilCore.virtualToIoFile((VirtualFile)this.myProjectDir).list()) != null && ContainerUtil.or((Object[])projectRootFiles, path -> FileUtilRt.extensionEquals((String)path, (String)"ioc"))) {
                this.myConnection = this.myMessageBus.connect((Disposable)this);
                this.myConnection.subscribe(VirtualFileManager.VFS_CHANGES, (Object)this);
                this.scheduleProjectUpdate();
            }
        }
    }

    private void scheduleProjectUpdate() {
        if (this.myProjectDir != null && !this.cmakeUpdateScheduled.getAndSet(true)) {
            ApplicationManager.getApplication().invokeLater(this::doUpdateProjectStatus);
        }
    }

    public void dispose() {
    }

    @NotNull
    public CoroutineScope getCoroutineScope() {
        CoroutineScope coroutineScope = this.myScope;
        if (coroutineScope == null) {
            CubeMXManager.$$$reportNull$$$0(2);
        }
        return coroutineScope;
    }

    @NotNull
    public CubeStatus getStatus() {
        CubeStatus cubeStatus = this.myStatus;
        if (cubeStatus == null) {
            CubeMXManager.$$$reportNull$$$0(3);
        }
        return cubeStatus;
    }

    @Nullable
    public String getTargetMCU() {
        return this.myTargetMCU;
    }

    public void after(@NotNull @NotNull List<? extends @NotNull VFileEvent> events) {
        if (events == null) {
            CubeMXManager.$$$reportNull$$$0(4);
        }
        for (VFileEvent vFileEvent : events) {
            String path = vFileEvent.getPath();
            if (!FileUtilRt.extensionEquals((String)path, (String)"ioc") && !StringUtil.endsWithIgnoreCase((String)path, (String)"/.cproject")) continue;
            this.scheduleProjectUpdate();
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doUpdateProjectStatus() {
        if (this.myProject.isDisposed()) {
            return;
        }
        try {
            VirtualFile cmakeLists;
            VirtualFile iocFile2 = CubeMXManager.findIocFile(this.myProjectDir, false);
            CubeStatus newStatus = CubeStatus.BROKEN;
            String newTargetMCU = null;
            VirtualFile cProject = null;
            if (iocFile2 != null) {
                try {
                    Properties properties = CubeMXManager.loadPropertiesFile(iocFile2).get();
                    if (!properties.isEmpty()) {
                        String targetIde = properties.getProperty("ProjectManager.TargetToolchain", "").toUpperCase(Locale.ROOT);
                        if ("SW4STM32".equals(targetIde) || "STM32CUBEIDE".equals(targetIde)) {
                            cProject = this.myProjectDir.findChild(".cproject");
                            if (cProject == null) {
                                newStatus = CubeStatus.REQUIRES_GENERATION;
                            } else if (!cProject.isDirectory()) {
                                newStatus = CubeMXManager.notNewerThan(iocFile2, cProject, 10) ? CubeStatus.OK : CubeStatus.OUTDATED;
                            }
                        } else {
                            newStatus = "CMAKE".equals(targetIde) || targetIde.startsWith("EWARM") ? CubeStatus.NOT_CONVERTIBLE : CubeStatus.WRONG_TARGET;
                        }
                        newTargetMCU = properties.getProperty("Mcu.Name");
                    }
                }
                catch (Throwable properties) {
                    // empty catch block
                }
            }
            if (!Objects.equals((Object)this.myStatus, (Object)newStatus) || !Objects.equals(this.myTargetMCU, newTargetMCU)) {
                this.myStatus = newStatus;
                this.myTargetMCU = newTargetMCU;
                ((CubeStatusListener)this.myMessageBus.syncPublisher(TOPIC)).cubeMxStatusUpdated(this);
            }
            if (!(cProject == null || this.myStatus != CubeStatus.OK && this.myStatus != CubeStatus.OUTDATED || (cmakeLists = this.myProjectDir.findChild("CMakeLists.txt")) != null && !CubeMXManager.notNewerThan(cmakeLists, cProject, 0))) {
                ConvertProjectAction.updateProject(this.myProject, true);
            }
        }
        finally {
            this.cmakeUpdateScheduled.set(false);
        }
    }

    @Nullable
    public static VirtualFile findIocFile(@NotNull VirtualFile projectDir, boolean refreshFirst) {
        if (projectDir == null) {
            CubeMXManager.$$$reportNull$$$0(5);
        }
        String iocFileName = projectDir.getName() + ".ioc";
        VirtualFile iocFile2 = refreshFirst ? VfsUtil.refreshAndFindChild((VirtualFile)projectDir, (String)iocFileName) : projectDir.findChild(iocFileName);
        if (iocFile2 != null && !iocFile2.isDirectory()) {
            return iocFile2;
        }
        return (VirtualFile)ContainerUtil.find((Object[])projectDir.getChildren(), file -> !file.isDirectory() && "ioc".equals(file.getExtension()));
    }

    public boolean isUtilityRunning() {
        return this.myUtilityRunning;
    }

    public void cubeUtilityStatus(boolean running) {
        if (running != this.myUtilityRunning) {
            this.myUtilityRunning = running;
            ((CubeStatusListener)this.myMessageBus.syncPublisher(TOPIC)).cubeMxStatusUpdated(this);
        }
    }

    private static boolean notNewerThan(VirtualFile fileA, VirtualFile fileB, int timeToleranceS) {
        return VfsUtilCore.virtualToIoFile((VirtualFile)fileA).lastModified() <= VfsUtilCore.virtualToIoFile((VirtualFile)fileB).lastModified() + (long)timeToleranceS * 1000L;
    }

    @NotNull
    public static @NotNull Future<@NotNull Properties> loadPropertiesFile(VirtualFile iocFile2) {
        Future future = ApplicationManager.getApplication().executeOnPooledThread(() -> {
            Properties properties = new Properties();
            properties.load(iocFile2.getInputStream());
            return properties;
        });
        if (future == null) {
            CubeMXManager.$$$reportNull$$$0(6);
        }
        return future;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cs";
                break;
            }
            case 2: 
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/clion/embedded/stm32cubemx/CubeMXManager";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "events";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectDir";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/clion/embedded/stm32cubemx/CubeMXManager";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getCoroutineScope";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getStatus";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "loadPropertiesFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 6: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "after";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findIocFile";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 6 -> new IllegalStateException(string);
        };
    }

    public static enum CubeStatus {
        BROKEN,
        WRONG_TARGET,
        REQUIRES_GENERATION,
        OUTDATED,
        OK,
        NOT_CONVERTIBLE;

    }

    public static interface CubeStatusListener {
        public void cubeMxStatusUpdated(@NotNull CubeMXManager var1);
    }
}

