/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.ml.tools.model.catboostOld;

import com.jetbrains.ml.tools.model.catboostOld.Feature;
import com.jetbrains.ml.tools.model.catboostOld.FeatureMapper;
import com.jetbrains.ml.tools.model.catboostOld.InconsistentMetadataException;
import com.jetbrains.ml.tools.model.catboostOld.UndefinedMapper;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001:\u0001\u001cB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0012\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0003H\u0016J\u0013\u0010\u0016\u001a\u00020\u00072\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001J\t\u0010\u001b\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001d"}, d2={"Lcom/jetbrains/ml/tools/model/catboostOld/FloatFeature;", "Lcom/jetbrains/ml/tools/model/catboostOld/Feature;", "name", "", "defaultValue", "", "allowUndefined", "", "(Ljava/lang/String;DZ)V", "getAllowUndefined", "()Z", "getDefaultValue", "()D", "getName", "()Ljava/lang/String;", "component1", "component2", "component3", "copy", "createMapper", "Lcom/jetbrains/ml/tools/model/catboostOld/FeatureMapper;", "suffix", "equals", "other", "", "hashCode", "", "toString", "FloatMapper", "ml-tools"})
public final class FloatFeature
extends Feature {
    @NotNull
    private final String name;
    private final double defaultValue;
    private final boolean allowUndefined;

    public FloatFeature(@NotNull String name, double defaultValue, boolean allowUndefined) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        super(null);
        this.name = name;
        this.defaultValue = defaultValue;
        this.allowUndefined = allowUndefined;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    public final double getDefaultValue() {
        return this.defaultValue;
    }

    public final boolean getAllowUndefined() {
        return this.allowUndefined;
    }

    @Override
    @NotNull
    public FeatureMapper createMapper(@Nullable String suffix) {
        FeatureMapper featureMapper;
        String string = suffix;
        if (Intrinsics.areEqual((Object)string, (Object)"UNDEFINED")) {
            featureMapper = UndefinedMapper.Companion.checkAndCreate(this.getName(), this.allowUndefined);
        } else if (string == null) {
            featureMapper = new FloatMapper();
        } else {
            throw new InconsistentMetadataException("Unexpected float feature suffix: " + suffix + " (feature '" + this.getName() + "')");
        }
        return featureMapper;
    }

    @NotNull
    public final String component1() {
        return this.name;
    }

    public final double component2() {
        return this.defaultValue;
    }

    public final boolean component3() {
        return this.allowUndefined;
    }

    @NotNull
    public final FloatFeature copy(@NotNull String name, double defaultValue, boolean allowUndefined) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return new FloatFeature(name, defaultValue, allowUndefined);
    }

    public static /* synthetic */ FloatFeature copy$default(FloatFeature floatFeature, String string, double d, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            string = floatFeature.name;
        }
        if ((n & 2) != 0) {
            d = floatFeature.defaultValue;
        }
        if ((n & 4) != 0) {
            bl = floatFeature.allowUndefined;
        }
        return floatFeature.copy(string, d, bl);
    }

    @NotNull
    public String toString() {
        return "FloatFeature(name=" + this.name + ", defaultValue=" + this.defaultValue + ", allowUndefined=" + this.allowUndefined + ")";
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = result * 31 + Double.hashCode(this.defaultValue);
        int n = this.allowUndefined ? 1 : 0;
        if (n != 0) {
            n = 1;
        }
        result = result * 31 + n;
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof FloatFeature)) {
            return false;
        }
        FloatFeature floatFeature = (FloatFeature)other;
        if (!Intrinsics.areEqual((Object)this.name, (Object)floatFeature.name)) {
            return false;
        }
        if (Double.compare(this.defaultValue, floatFeature.defaultValue) != 0) {
            return false;
        }
        return this.allowUndefined == floatFeature.allowUndefined;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016J\u0015\u0010\u000b\u001a\u0004\u0018\u00010\b*\u0004\u0018\u00010\nH\u0002\u00a2\u0006\u0002\u0010\fR\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\r"}, d2={"Lcom/jetbrains/ml/tools/model/catboostOld/FloatFeature$FloatMapper;", "Lcom/jetbrains/ml/tools/model/catboostOld/FeatureMapper;", "(Lcom/jetbrains/ml/tools/model/catboostOld/FloatFeature;)V", "featureName", "", "getFeatureName", "()Ljava/lang/String;", "asArrayValue", "", "value", "", "asDouble", "(Ljava/lang/Object;)Ljava/lang/Double;", "ml-tools"})
    private final class FloatMapper
    implements FeatureMapper {
        @NotNull
        private final String featureName;

        public FloatMapper() {
            this.featureName = FloatFeature.this.getName();
        }

        @Override
        @NotNull
        public String getFeatureName() {
            return this.featureName;
        }

        @Override
        public double asArrayValue(@Nullable Object value) {
            Double d = this.asDouble(value);
            return d != null ? d.doubleValue() : FloatFeature.this.getDefaultValue();
        }

        private final Double asDouble(Object $this$asDouble) {
            if ($this$asDouble instanceof Number) {
                return ((Number)$this$asDouble).doubleValue();
            }
            return StringsKt.toDoubleOrNull((String)String.valueOf($this$asDouble));
        }
    }
}

