/*
 * Decompiled with CFR 0.152.
 */
package git4idea;

import com.intellij.dvcs.branch.DvcsTaskHandler;
import com.intellij.dvcs.repo.AbstractRepositoryManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsTaskHandler;
import com.intellij.util.containers.ContainerUtil;
import git4idea.branch.GitBranchUtil;
import git4idea.branch.GitBrancher;
import git4idea.branch.GitBranchesCollection;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import git4idea.validators.GitRefNameValidator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class GitTaskHandler
extends DvcsTaskHandler<GitRepository> {
    @NotNull
    private final GitBrancher myBrancher;
    @NotNull
    private final GitRefNameValidator myNameValidator;

    GitTaskHandler(@NotNull Project project) {
        if (project == null) {
            GitTaskHandler.$$$reportNull$$$0(0);
        }
        super((AbstractRepositoryManager)GitRepositoryManager.getInstance(project), project, "branch");
        this.myBrancher = GitBrancher.getInstance(project);
        this.myNameValidator = GitRefNameValidator.getInstance();
    }

    protected void checkout(@NotNull String taskName, @NotNull List<? extends GitRepository> repos, @Nullable Runnable callInAwtLater) {
        if (taskName == null) {
            GitTaskHandler.$$$reportNull$$$0(1);
        }
        if (repos == null) {
            GitTaskHandler.$$$reportNull$$$0(2);
        }
        this.myBrancher.checkout(taskName, false, repos, callInAwtLater);
    }

    protected void checkoutAsNewBranch(@NotNull String name, @NotNull List<? extends GitRepository> repositories) {
        if (name == null) {
            GitTaskHandler.$$$reportNull$$$0(3);
        }
        if (repositories == null) {
            GitTaskHandler.$$$reportNull$$$0(4);
        }
        this.myBrancher.checkoutNewBranch(name, repositories);
    }

    protected String getActiveBranch(GitRepository repository2) {
        return repository2.getCurrentBranchName();
    }

    protected void mergeAndClose(@NotNull String branch, @NotNull List<? extends GitRepository> repositories) {
        if (branch == null) {
            GitTaskHandler.$$$reportNull$$$0(5);
        }
        if (repositories == null) {
            GitTaskHandler.$$$reportNull$$$0(6);
        }
        this.myBrancher.merge(branch, GitBrancher.DeleteOnMergeOption.DELETE, repositories);
    }

    protected boolean hasBranch(@NotNull GitRepository repository2, @NotNull VcsTaskHandler.TaskInfo info) {
        if (repository2 == null) {
            GitTaskHandler.$$$reportNull$$$0(7);
        }
        if (info == null) {
            GitTaskHandler.$$$reportNull$$$0(8);
        }
        GitBranchesCollection branches = repository2.getBranches();
        return info.isRemote() ? branches.getRemoteBranches().stream().anyMatch(branch -> info.getName().equals(branch.getName())) : branches.findLocalBranch(info.getName()) != null;
    }

    @NotNull
    protected Iterable<VcsTaskHandler.TaskInfo> getAllBranches(@NotNull GitRepository repository2) {
        if (repository2 == null) {
            GitTaskHandler.$$$reportNull$$$0(9);
        }
        GitBranchesCollection branches = repository2.getBranches();
        ArrayList<VcsTaskHandler.TaskInfo> list = new ArrayList<VcsTaskHandler.TaskInfo>(ContainerUtil.map(GitBranchUtil.sortBranchesByName(branches.getLocalBranches()), branch -> new VcsTaskHandler.TaskInfo(branch.getName(), Collections.singleton(repository2.getPresentableUrl()))));
        list.addAll(ContainerUtil.map(GitBranchUtil.sortBranchesByName(branches.getRemoteBranches()), branch -> new VcsTaskHandler.TaskInfo(branch.getName(), Collections.singleton(repository2.getPresentableUrl())){

            public boolean isRemote() {
                return true;
            }
        }));
        ArrayList<VcsTaskHandler.TaskInfo> arrayList = list;
        if (arrayList == null) {
            GitTaskHandler.$$$reportNull$$$0(10);
        }
        return arrayList;
    }

    public boolean isBranchNameValid(@NotNull String branchName) {
        if (branchName == null) {
            GitTaskHandler.$$$reportNull$$$0(11);
        }
        return this.myNameValidator.checkInput(branchName);
    }

    @NotNull
    public String cleanUpBranchName(@NotNull String suggestedName) {
        if (suggestedName == null) {
            GitTaskHandler.$$$reportNull$$$0(12);
        }
        String string = this.myNameValidator.cleanUpBranchName(suggestedName);
        if (string == null) {
            GitTaskHandler.$$$reportNull$$$0(13);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 10, 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "taskName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repos";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repositories";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "branch";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repository";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/GitTaskHandler";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "branchName";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suggestedName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/GitTaskHandler";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllBranches";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "cleanUpBranchName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "checkout";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "checkoutAsNewBranch";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "mergeAndClose";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "hasBranch";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getAllBranches";
                break;
            }
            case 10: 
            case 13: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isBranchNameValid";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "cleanUpBranchName";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 10, 13 -> new IllegalStateException(string);
        };
    }
}

