/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server;

import com.intellij.openapi.util.Pair;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangDaemonContext;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangPlannedInteraction;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangProperty;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangServer;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.RemoteWorkspaceFile;
import com.jetbrains.cidr.lang.daemon.clang.clangd.registry.ClangRemoteWorkspace;
import java.util.Collections;
import java.util.List;
import org.eclipse.lsp4j.DidSaveTextDocumentParams;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.jetbrains.annotations.NotNull;

public final class ClangSaveRequest
implements ClangPlannedInteraction {
    @NotNull
    private final ClangDaemonContext myContext;
    @NotNull
    private final String myUrl;

    public ClangSaveRequest(@NotNull ClangDaemonContext context, @NotNull String url) {
        if (context == null) {
            ClangSaveRequest.$$$reportNull$$$0(0);
        }
        if (url == null) {
            ClangSaveRequest.$$$reportNull$$$0(1);
        }
        this.myContext = context;
        this.myUrl = url;
    }

    @Override
    @NotNull
    public List<Pair<String, ClangProperty>> getWrittenProperties() {
        List<Pair<String, ClangProperty>> list = Collections.singletonList(Pair.create((Object)this.myUrl, (Object)((Object)ClangProperty.SavedFlag)));
        if (list == null) {
            ClangSaveRequest.$$$reportNull$$$0(2);
        }
        return list;
    }

    @Override
    public void send(@NotNull ClangServer server, @NotNull ClangRemoteWorkspace ws) {
        if (server == null) {
            ClangSaveRequest.$$$reportNull$$$0(3);
        }
        if (ws == null) {
            ClangSaveRequest.$$$reportNull$$$0(4);
        }
        server.clionDidSave(new DidSaveTextDocumentParams(new TextDocumentIdentifier(this.myContext.getUrlConverter().toUriFromUrl(this.myUrl))));
        this.toNextRemoteState(ws);
    }

    @Override
    public void onSkipped(@NotNull ClangRemoteWorkspace ws) {
        if (ws == null) {
            ClangSaveRequest.$$$reportNull$$$0(5);
        }
        this.toNextRemoteState(ws);
    }

    private void toNextRemoteState(@NotNull ClangRemoteWorkspace ws) {
        if (ws == null) {
            ClangSaveRequest.$$$reportNull$$$0(6);
        }
        ws.modify(this.myUrl, wf -> {
            wf.put(RemoteWorkspaceFile.IS_SAVED, true);
            if (!wf.getOrDefault(RemoteWorkspaceFile.IS_OPENED).booleanValue()) {
                wf.put(RemoteWorkspaceFile.CONTENT, null);
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/daemon/clang/clangd/lsp/server/ClangSaveRequest";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "server";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ws";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/daemon/clang/clangd/lsp/server/ClangSaveRequest";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getWrittenProperties";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "send";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "onSkipped";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "toNextRemoteState";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

