/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.radler.clangd;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.backend.workspace.WorkspaceModel;
import com.jetbrains.cidr.lang.LanguageUtils;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangdBridge;
import com.jetbrains.cidr.radler.clangd.RadClangIdeFacadeImpl;
import com.jetbrains.cidr.radler.util.RdCallUtilKt;
import com.jetbrains.rd.framework.IProtocol;
import com.jetbrains.rd.framework.impl.RdCall;
import com.jetbrains.rd.ide.model.Solution;
import com.jetbrains.rd.ide.model.TextControlId;
import com.jetbrains.rdclient.document.DocumentExKt;
import com.jetbrains.rider.model.CppFileContext;
import com.jetbrains.rider.model.RadEditorContextModel_PregeneratedKt;
import com.jetbrains.rider.projectView.SolutionHostExtensionsKt;
import com.jetbrains.rider.projectView.workspace.ProjectModelEntity;
import com.jetbrains.rider.projectView.workspace.ProjectModelEntityExtensionsKt;
import com.jetbrains.rider.projectView.workspace.WorkspaceModelExtensionsKt;
import com.jetbrains.rider.protocol.ApplicationProtocolKt;
import java.io.File;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u001c\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\u001a\u0018\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0003\u001a\u001a\u0010\u0007\u001a\u0004\u0018\u00010\u00032\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"logger", "Lcom/intellij/openapi/diagnostic/Logger;", "getRootFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "vf", "findVirtualFileFromId", "id", "", "intellij.cidr.clangd.novaBridge"})
@SourceDebugExtension(value={"SMAP\nRadRootFileUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RadRootFileUtil.kt\ncom/jetbrains/cidr/radler/clangd/RadRootFileUtilKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,71:1\n1#2:72\n14#3:73\n*S KotlinDebug\n*F\n+ 1 RadRootFileUtil.kt\ncom/jetbrains/cidr/radler/clangd/RadRootFileUtilKt\n*L\n22#1:73\n*E\n"})
public final class RadRootFileUtilKt {
    @NotNull
    private static final Logger logger;

    @Nullable
    public static final VirtualFile getRootFile(@NotNull Project project, @NotNull VirtualFile vf) {
        TextEditor textEditorRef;
        TextEditor textEditor;
        block10: {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)vf, (String)"vf");
            if (!LanguageUtils.Companion.getInstance().isSupportedFile(vf)) {
                return null;
            }
            if (ClangdBridge.isSourceFile(project, vf)) {
                return vf;
            }
            FileEditor[] fileEditorArray = FileEditorManager.getInstance((Project)project).getAllEditors(vf);
            Intrinsics.checkNotNullExpressionValue((Object)fileEditorArray, (String)"getAllEditors(...)");
            Object[] objectArray = fileEditorArray;
            int n = objectArray.length;
            for (int i = 0; i < n; ++i) {
                FileEditor it = (FileEditor)objectArray[i];
                boolean bl = false;
                textEditor = it instanceof TextEditor ? (TextEditor)it : null;
                if (textEditor == null) {
                    continue;
                }
                break block10;
            }
            textEditor = null;
        }
        if ((textEditorRef = textEditor) == null) {
            Integer sourceFileId;
            ProjectModelEntity projectModelEntity = (ProjectModelEntity)CollectionsKt.firstOrNull((List)WorkspaceModelExtensionsKt.getProjectModelEntities((WorkspaceModel)WorkspaceModel.Companion.getInstance(project), (VirtualFile)vf, (Project)project));
            Integer n = sourceFileId = projectModelEntity != null ? ProjectModelEntityExtensionsKt.getId((ProjectModelEntity)projectModelEntity, (Project)project) : null;
            if (sourceFileId == null) {
                logger.warn("Can't find project model entity for \"" + vf.getPath() + "\"");
                return vf;
            }
            int rootFileId = ((Number)RdCallUtilKt.callSomehow((RdCall)RadEditorContextModel_PregeneratedKt.getRadEditorContextModel((Solution)SolutionHostExtensionsKt.getSolution((Project)project)).getGetRootFileId(), (Object)sourceFileId, (IProtocol)ApplicationProtocolKt.getProtocol((Project)project))).intValue();
            VirtualFile virtualFile = RadRootFileUtilKt.findVirtualFileFromId(rootFileId, project);
            if (virtualFile == null) {
                virtualFile = vf;
            }
            return virtualFile;
        }
        Editor editor = textEditorRef.getEditor();
        Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"getEditor(...)");
        TextControlId textControlId = DocumentExKt.getTextControlId((Editor)editor);
        if (textControlId == null) {
            return vf;
        }
        TextControlId textControlId2 = textControlId;
        CppFileContext cppFileContext = (CppFileContext)RadEditorContextModel_PregeneratedKt.getRadEditorContextModel((Solution)SolutionHostExtensionsKt.getSolution((Project)project)).getEditorToRoot().get((Object)textControlId2);
        if (cppFileContext == null) {
            return vf;
        }
        CppFileContext rootFileId = cppFileContext;
        VirtualFile virtualFile = RadRootFileUtilKt.findVirtualFileFromId(rootFileId.getRootFileId(), project);
        if (virtualFile == null) {
            virtualFile = vf;
        }
        return virtualFile;
    }

    private static final VirtualFile findVirtualFileFromId(int id, Project project) {
        File file;
        ProjectModelEntity projectModelEntity = WorkspaceModelExtensionsKt.getProjectModelEntity((WorkspaceModel)WorkspaceModel.Companion.getInstance(project), (int)id);
        File file2 = file = projectModelEntity != null ? ProjectModelEntityExtensionsKt.getFile((ProjectModelEntity)projectModelEntity) : null;
        if (file == null) {
            logger.warn("Can't find project model entity for id - " + id);
            return null;
        }
        VirtualFile virtualFile = VfsUtil.findFileByIoFile((File)file, (boolean)true);
        if (virtualFile == null) {
            logger.warn("Virtual file for \"" + file.getPath() + "\" is not found");
            return null;
        }
        return virtualFile;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(RadClangIdeFacadeImpl.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        RadRootFileUtilKt.logger = logger;
    }
}

