/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.toolchains.docker;

import com.github.dockerjava.api.command.CreateContainerCmd;
import com.intellij.docker.DockerCloudConfiguration;
import com.intellij.docker.DockerCloudType;
import com.intellij.docker.agent.ApiTaskException;
import com.intellij.docker.agent.DockerAgentDeploymentConfig;
import com.intellij.docker.agent.cli.model.DockerRunCliParser;
import com.intellij.docker.agent.settings.DockerVolumeBinding;
import com.intellij.docker.connection.DockerConnectionConfigurator;
import com.intellij.docker.connection.DockerWslConnectionConfiguratorKt;
import com.intellij.docker.remote.DockerContainerSettings;
import com.intellij.docker.remote.DockerCredentialsHolder;
import com.intellij.docker.remote.DockerProcessUtil;
import com.intellij.docker.remote.run.common.EnvsBuilder;
import com.intellij.docker.remote.run.common.PortsBuilder;
import com.intellij.docker.remote.run.runtime.DockerAgentDeploymentConfigImpl;
import com.intellij.docker.remote.run.runtime.DockerExecProcess;
import com.intellij.docker.remoteRunRuntime.RemoteDockerRuntime;
import com.intellij.execution.CommandLineUtil;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.wsl.WSLDistribution;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.RemoteSdkException;
import com.intellij.remoteServer.ServerType;
import com.intellij.remoteServer.configuration.RemoteServer;
import com.intellij.remoteServer.configuration.RemoteServersManager;
import com.intellij.remoteServer.util.ServerRuntimeException;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.PathMapper;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.execution.ParametersListUtil;
import com.intellij.util.system.OS;
import com.jetbrains.cidr.cpp.toolchains.docker.CidrDockerBundle;
import com.jetbrains.cidr.cpp.toolchains.docker.CidrDockerOptions;
import com.jetbrains.cidr.cpp.toolchains.docker.DockerUtilKt;
import com.jetbrains.cidr.cpp.toolchains.docker.fus.CidrDockerRuntimeUsageCollector;
import com.jetbrains.cidr.cpp.toolchains.docker.host.DockerHostBase;
import com.jetbrains.cidr.system.CidrProcessBuilder;
import com.jetbrains.cidr.system.HostMachine;
import com.jetbrains.cidr.system.LocalHost;
import com.jetbrains.cidr.system.RemoteHostUtil;
import com.jetbrains.cidr.system.SystemUtil;
import com.jetbrains.cidr.toolchains.CidrToolsUtil;
import com.jetbrains.cidr.toolchains.wsl.WSLCidrUtil;
import com.sun.security.auth.module.UnixSystem;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CidrDockerUtil {
    public static final Logger LOG = Logger.getInstance((String)"#com.jetbrains.cidr.docker");
    private static final String LABEL_FLAG = "--label";
    private static final String CLION_LABEL = "clion";
    private static final String CLION_TOOLCHAIN_LABEL = "clion-toolchain=";

    public static RemoteDockerRuntime getDockerRuntime(@NotNull DockerCredentialsHolder holder) throws ExecutionException {
        if (holder == null) {
            CidrDockerUtil.$$$reportNull$$$0(0);
        }
        return CidrDockerUtil.getDockerRuntime(null, holder);
    }

    public static RemoteDockerRuntime getDockerRuntime(@Nullable Project project, @NotNull DockerCredentialsHolder holder) throws ExecutionException {
        String name;
        if (holder == null) {
            CidrDockerUtil.$$$reportNull$$$0(1);
        }
        if ((name = holder.getAccountName()) == null) {
            throw new ExecutionException(CidrDockerBundle.message("docker.message.empty.server.name", new Object[0]));
        }
        RemoteServer dockerServer = RemoteServersManager.getInstance().findByName(name, (ServerType)DockerCloudType.getInstance());
        if (dockerServer == null) {
            throw new ExecutionException(CidrDockerBundle.message("docker.message.cannot.find.server", name));
        }
        DockerCloudConfiguration dockerConfiguration = (DockerCloudConfiguration)dockerServer.getConfiguration();
        try {
            RemoteDockerRuntime runtime = RemoteDockerRuntime.create((DockerCloudConfiguration)dockerConfiguration, (Project)project);
            CidrDockerRuntimeUsageCollector.logCreated(project, runtime);
            return runtime;
        }
        catch (ServerRuntimeException e) {
            Throwable cause = e.getCause();
            throw new ExecutionException(cause != null ? cause : e);
        }
    }

    @NotNull
    public static DockerExecProcess createDockerProcess(@NotNull DockerCredentialsHolder holder, @Nullable DockerContainerSettings containerSettings, @NotNull RemoteDockerRuntime dockerRuntime, @NotNull List<DockerVolumeBinding> implicitBindVolumes, @NotNull PathMapper pathMapper, @NotNull GeneralCommandLine commandLine, @NotNull CidrProcessBuilder.Parameters parameters, @NotNull CidrDockerOptions cidrDockerOptions, @NotNull HostMachine host) throws ExecutionException {
        DockerExecProcess dockerExecProcess;
        DockerAgentDeploymentConfigImpl config;
        block15: {
            if (holder == null) {
                CidrDockerUtil.$$$reportNull$$$0(2);
            }
            if (dockerRuntime == null) {
                CidrDockerUtil.$$$reportNull$$$0(3);
            }
            if (implicitBindVolumes == null) {
                CidrDockerUtil.$$$reportNull$$$0(4);
            }
            if (pathMapper == null) {
                CidrDockerUtil.$$$reportNull$$$0(5);
            }
            if (commandLine == null) {
                CidrDockerUtil.$$$reportNull$$$0(6);
            }
            if (parameters == null) {
                CidrDockerUtil.$$$reportNull$$$0(7);
            }
            if (cidrDockerOptions == null) {
                CidrDockerUtil.$$$reportNull$$$0(8);
            }
            if (host == null) {
                CidrDockerUtil.$$$reportNull$$$0(9);
            }
            commandLine.getEnvironment().put("JETBRAINS_REMOTE_RUN", "1");
            config = CidrDockerUtil.getConfig(holder, containerSettings, dockerRuntime, implicitBindVolumes, parameters, cidrDockerOptions, host);
            String exe = FileUtil.toSystemIndependentName((String)pathMapper.convertToRemote(commandLine.getExePath()));
            List command = pathMapper.convertToRemote((Collection)commandLine.getCommandLineList(exe));
            File inputFile = commandLine.getInputFile();
            if (inputFile != null) {
                String commandStr = command.stream().map(CommandLineUtil::posixQuote).collect(Collectors.joining(" ")) + " < " + pathMapper.convertToRemote(inputFile.getPath());
                commandLine.getParametersList().clearAll();
                exe = RemoteHostUtil.remoteShell();
                commandLine.withExePath(exe).withParameters(new String[]{"-c", commandStr});
                command = commandLine.getCommandLineList(exe);
            }
            config.withCommand(ArrayUtilRt.toStringArray((Collection)command));
            commandLine.setExePath(exe);
            Path workDirectory = commandLine.getWorkingDirectory();
            if (workDirectory != null) {
                config.withWorkingDir(pathMapper.convertToRemote(workDirectory.normalize().toString()));
            }
            if (!CidrDockerUtil.isContainerOptionsEnabled()) break block15;
            boolean setupPorts = parameters.getSetupRunDebugEnv();
            DockerProcessUtil.prepareConfig((DockerAgentDeploymentConfigImpl)config, (GeneralCommandLine)commandLine, (DockerContainerSettings)containerSettings, (PortsBuilder)PortsBuilder.builder(), (boolean)false, (boolean)setupPorts);
            DockerExecProcess dockerExecProcess2 = DockerExecProcess.Factory.startProcessWithRemove((RemoteDockerRuntime)dockerRuntime, (DockerAgentDeploymentConfig)config);
            if (dockerExecProcess2 == null) {
                CidrDockerUtil.$$$reportNull$$$0(10);
            }
            return dockerExecProcess2;
        }
        try {
            dockerExecProcess = CidrDockerUtil.prepareAndStartProcessInternal(config, commandLine, dockerRuntime);
        }
        catch (ServerRuntimeException | IOException e) {
            throw new ExecutionException(e);
        }
        if (dockerExecProcess == null) {
            CidrDockerUtil.$$$reportNull$$$0(11);
        }
        return dockerExecProcess;
    }

    @NotNull
    public static DockerAgentDeploymentConfigImpl getConfig(@NotNull RemoteDockerRuntime dockerRuntime, @Nullable CidrProcessBuilder.Parameters parameters, @NotNull DockerHostBase<?> machine) {
        if (dockerRuntime == null) {
            CidrDockerUtil.$$$reportNull$$$0(12);
        }
        if (machine == null) {
            CidrDockerUtil.$$$reportNull$$$0(13);
        }
        return CidrDockerUtil.getConfig(machine.getCredentialsHolder(), machine.getContainerSettings(), dockerRuntime, machine.getBindVolumes(), parameters, machine.getCidrDockerOptions(), machine.getUnderlyingHost());
    }

    @NotNull
    private static DockerAgentDeploymentConfigImpl getConfig(@NotNull DockerCredentialsHolder holder, @Nullable DockerContainerSettings containerSettings, @NotNull RemoteDockerRuntime dockerRuntime, @NotNull List<DockerVolumeBinding> implicitBindVolumes, final @Nullable CidrProcessBuilder.Parameters parameters, @NotNull CidrDockerOptions cidrDockerOptions, @NotNull HostMachine host) {
        boolean isOptionsEnabled;
        if (holder == null) {
            CidrDockerUtil.$$$reportNull$$$0(14);
        }
        if (dockerRuntime == null) {
            CidrDockerUtil.$$$reportNull$$$0(15);
        }
        if (implicitBindVolumes == null) {
            CidrDockerUtil.$$$reportNull$$$0(16);
        }
        if (cidrDockerOptions == null) {
            CidrDockerUtil.$$$reportNull$$$0(17);
        }
        if (host == null) {
            CidrDockerUtil.$$$reportNull$$$0(18);
        }
        final String[] customRunOptions = (isOptionsEnabled = CidrDockerUtil.isContainerOptionsEnabled()) ? CidrDockerUtil.getCustomRunOptions(containerSettings, cidrDockerOptions) : null;
        final DockerVolumeBinding[] volumeBinding = DockerProcessUtil.setupVolumesBinds(null, (DockerContainerSettings)(isOptionsEnabled ? containerSettings : null)).addBoundVolumes(implicitBindVolumes).build();
        DockerAgentDeploymentConfigImpl config = new DockerAgentDeploymentConfigImpl(holder.getImageName(), null){

            public DockerVolumeBinding[] getVolumeBindings() {
                return volumeBinding;
            }

            public String @Nullable [] getCustomRunOptions() {
                return customRunOptions;
            }

            public boolean withTty() {
                return parameters != null && parameters.isPty();
            }
        };
        if (containerSettings == null || !CidrDockerUtil.optionsHaveUserSpecified(containerSettings.getRunCliOptions())) {
            CidrDockerUtil.tweakUserInConfig(dockerRuntime, parameters, config, host);
        }
        DockerAgentDeploymentConfigImpl dockerAgentDeploymentConfigImpl = config;
        if (dockerAgentDeploymentConfigImpl == null) {
            CidrDockerUtil.$$$reportNull$$$0(19);
        }
        return dockerAgentDeploymentConfigImpl;
    }

    private static void tweakUserInConfig(@NotNull RemoteDockerRuntime dockerRuntime, @Nullable CidrProcessBuilder.Parameters parameters, DockerAgentDeploymentConfigImpl config, @NotNull HostMachine host) {
        block12: {
            WSLDistribution wslDistribution;
            String wsl;
            if (dockerRuntime == null) {
                CidrDockerUtil.$$$reportNull$$$0(20);
            }
            if (host == null) {
                CidrDockerUtil.$$$reportNull$$$0(21);
            }
            DockerCloudConfiguration account = dockerRuntime.getAccount();
            if (parameters != null && parameters.isElevated() || DockerUtilKt.isRootless(host, dockerRuntime)) {
                config.withUser("root");
            } else if (host.getOS() == OS.Linux) {
                try {
                    SystemUtil.IdInfo idInfo = SystemUtil.runId((HostMachine)host);
                    config.withUser(idInfo.getUid() + ":" + idInfo.getGid());
                }
                catch (ExecutionException | SystemUtil.IllegalOutputFormatException | IllegalArgumentException e) {
                    if (host instanceof LocalHost) {
                        UnixSystem unixSystem = new UnixSystem();
                        config.withUser(unixSystem.getUid() + ":" + unixSystem.getGid());
                        break block12;
                    }
                    LOG.warn("Failed to get uid/gid for Linux user: ", e);
                }
            } else if (DockerConnectionConfigurator.isWsl((String)account.getCustomConfiguratorId()) && (wsl = DockerWslConnectionConfiguratorKt.getWSLId((DockerCloudConfiguration)account)) != null && (wslDistribution = WSLCidrUtil.getDistributionByMsId((String)wsl)) != null) {
                try {
                    int uid = Integer.parseInt(wslDistribution.executeOnWsl(CidrToolsUtil.DEFAULT_COMMAND_TIMEOUT, new String[]{"id", "-u"}).getStdout().trim());
                    int gid = Integer.parseInt(wslDistribution.executeOnWsl(CidrToolsUtil.DEFAULT_COMMAND_TIMEOUT, new String[]{"id", "-g"}).getStdout().trim());
                    config.withUser(uid + ":" + gid);
                }
                catch (ExecutionException | NumberFormatException e) {
                    LOG.warn("Failed to get uid/gid for WSL user: ", e);
                }
            }
        }
    }

    @Nullable
    public static CreateContainerCmd tryParseContainerCmd(@NotNull String options) {
        if (options == null) {
            CidrDockerUtil.$$$reportNull$$$0(22);
        }
        DockerRunCliParser parser = new DockerRunCliParser();
        try {
            return parser.parse(ParametersListUtil.parseToArray((String)options));
        }
        catch (ApiTaskException ex) {
            LOG.warn((Throwable)ex);
            return null;
        }
    }

    private static boolean optionsHaveUserSpecified(@Nullable String options) {
        if (options != null) {
            try (CreateContainerCmd cmd = CidrDockerUtil.tryParseContainerCmd(options);){
                boolean bl = cmd != null && cmd.getUser() != null;
                return bl;
            }
        }
        return false;
    }

    public static boolean isContainerOptionsEnabled() {
        return Registry.is((String)"clion.docker.enable.options", (boolean)false);
    }

    private static DockerExecProcess prepareAndStartProcessInternal(@NotNull DockerAgentDeploymentConfigImpl config, @NotNull GeneralCommandLine commandLine, @NotNull RemoteDockerRuntime dockerRuntime) throws ServerRuntimeException, RemoteSdkException, IOException {
        if (config == null) {
            CidrDockerUtil.$$$reportNull$$$0(23);
        }
        if (commandLine == null) {
            CidrDockerUtil.$$$reportNull$$$0(24);
        }
        if (dockerRuntime == null) {
            CidrDockerUtil.$$$reportNull$$$0(25);
        }
        config.withEntrypoint(ArrayUtil.EMPTY_STRING_ARRAY);
        EnvsBuilder envsBuilder = EnvsBuilder.builder().addEnvs(commandLine.getEnvironment());
        config.withEnvs(envsBuilder.withPassParentEnvironment(true).buildEnvs());
        return DockerExecProcess.Factory.startProcessWithRemove((RemoteDockerRuntime)dockerRuntime, (DockerAgentDeploymentConfig)config);
    }

    static String @Nullable [] getCustomRunOptions(@Nullable DockerContainerSettings containerSettings, @NotNull CidrDockerOptions cidrDockerOptions) {
        if (cidrDockerOptions == null) {
            CidrDockerUtil.$$$reportNull$$$0(26);
        }
        if (containerSettings == null) {
            return null;
        }
        List<String> defaultOptions = CidrDockerUtil.getDefaultOptions(cidrDockerOptions);
        String runOptions = containerSettings.getRunCliOptions();
        if (runOptions == null) {
            return ArrayUtilRt.toStringArray(defaultOptions);
        }
        List filteredOptions = ContainerUtil.filter((Collection)ParametersListUtil.parse((String)runOptions), option -> !option.equals("--rm") && !option.startsWith("--rm="));
        ArrayList<String> allOptions = new ArrayList<String>();
        allOptions.addAll(filteredOptions);
        allOptions.addAll(defaultOptions);
        return ArrayUtilRt.toStringArray(allOptions);
    }

    @NotNull
    public static Path suggestPath(@NotNull Path root, @NotNull DockerCredentialsHolder credentialsHolder) {
        if (root == null) {
            CidrDockerUtil.$$$reportNull$$$0(27);
        }
        if (credentialsHolder == null) {
            CidrDockerUtil.$$$reportNull$$$0(28);
        }
        Path result = root;
        if (!CidrDockerUtil.isValid(credentialsHolder)) {
            Path path = result;
            if (path == null) {
                CidrDockerUtil.$$$reportNull$$$0(29);
            }
            return path;
        }
        ApplicationInfo info = ApplicationInfo.getInstance();
        if (info != null) {
            result = result.resolve(PathUtil.suggestFileName((String)info.getShortVersion()));
        }
        Path path = result.resolve(PathUtil.suggestFileName((String)credentialsHolder.getAccountName())).resolve(PathUtil.suggestFileName((String)credentialsHolder.getImageName()));
        if (path == null) {
            CidrDockerUtil.$$$reportNull$$$0(30);
        }
        return path;
    }

    public static boolean isValid(@NotNull DockerCredentialsHolder credentialsHolder) {
        if (credentialsHolder == null) {
            CidrDockerUtil.$$$reportNull$$$0(31);
        }
        return StringUtil.isNotEmpty((String)credentialsHolder.getAccountName()) && StringUtil.isNotEmpty((String)credentialsHolder.getImageName());
    }

    private static List<String> getDefaultOptions(@NotNull CidrDockerOptions cidrDockerOptions) {
        if (cidrDockerOptions == null) {
            CidrDockerUtil.$$$reportNull$$$0(32);
        }
        return List.of(LABEL_FLAG, CLION_LABEL, LABEL_FLAG, CLION_TOOLCHAIN_LABEL + cidrDockerOptions.getToolchainName());
    }

    static boolean isDockerOverSSH(String configuratorId) {
        return "DockerSshConnectionConfigurator".equals(configuratorId);
    }

    public static String getWslConfiguratorId() {
        return "DockerWslConnectionConfigurator";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 10, 11, 19, 29, 30 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 3: 
            case 12: 
            case 15: 
            case 20: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dockerRuntime";
                break;
            }
            case 4: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "implicitBindVolumes";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathMapper";
                break;
            }
            case 6: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 8: 
            case 17: 
            case 26: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cidrDockerOptions";
                break;
            }
            case 9: 
            case 18: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "host";
                break;
            }
            case 10: 
            case 11: 
            case 19: 
            case 29: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/cpp/toolchains/docker/CidrDockerUtil";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "machine";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 28: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "credentialsHolder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/cpp/toolchains/docker/CidrDockerUtil";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createDockerProcess";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfig";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getDockerRuntime";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createDockerProcess";
                break;
            }
            case 10: 
            case 11: 
            case 19: 
            case 29: 
            case 30: {
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getConfig";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "tweakUserInConfig";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "tryParseContainerCmd";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "prepareAndStartProcessInternal";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getCustomRunOptions";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "suggestPath";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "isValid";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultOptions";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 10, 11, 19, 29, 30 -> new IllegalStateException(string);
        };
    }
}

