/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.toolchains.docker;

import com.intellij.docker.DockerCloudConfiguration;
import com.intellij.docker.DockerCloudType;
import com.intellij.docker.DockerIcons;
import com.intellij.docker.agent.DockerAgentImage;
import com.intellij.docker.agent.settings.DockerVolumeBindingImpl;
import com.intellij.docker.remote.DockerContainerSettings;
import com.intellij.docker.remote.DockerCredentialsHolder;
import com.intellij.docker.remoteRunRuntime.RemoteDockerRuntime;
import com.intellij.execution.ExecutionException;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.PathManagerEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.advanced.AdvancedSettings;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.remote.RemoteCredentials;
import com.intellij.remoteServer.ServerType;
import com.intellij.remoteServer.configuration.RemoteServer;
import com.intellij.remoteServer.configuration.RemoteServersManager;
import com.intellij.ssh.config.unified.SshConfig;
import com.intellij.util.ui.GridBag;
import com.intellij.util.xmlb.XmlSerializer;
import com.jetbrains.cidr.cpp.toolchains.CPPToolSet;
import com.jetbrains.cidr.cpp.toolchains.CPPToolchains;
import com.jetbrains.cidr.cpp.toolchains.HostFactory;
import com.jetbrains.cidr.cpp.toolchains.docker.CidrDockerOptions;
import com.jetbrains.cidr.cpp.toolchains.docker.CidrDockerUtil;
import com.jetbrains.cidr.cpp.toolchains.docker.DockerCredentialsComponent;
import com.jetbrains.cidr.cpp.toolchains.docker.DockerHelper;
import com.jetbrains.cidr.cpp.toolchains.docker.DockerSettingsConfigurable;
import com.jetbrains.cidr.cpp.toolchains.docker.DockerToolSet;
import com.jetbrains.cidr.cpp.toolchains.docker.DockerUtilKt;
import com.jetbrains.cidr.cpp.toolchains.docker.host.DockerHostBase;
import com.jetbrains.cidr.cpp.toolchains.docker.host.DockerHostLocal;
import com.jetbrains.cidr.cpp.toolchains.docker.host.DockerHostRemote;
import com.jetbrains.cidr.cpp.toolchains.docker.host.DockerHostService;
import com.jetbrains.cidr.cpp.toolchains.ui.ToolchainPanel;
import com.jetbrains.cidr.system.HostData;
import com.jetbrains.cidr.system.HostMachine;
import com.jetbrains.cidr.system.RemoteHost;
import com.jetbrains.cidr.system.RemoteUtil;
import com.jetbrains.cidr.toolchains.SettingsHandler;
import java.io.File;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import javax.swing.Icon;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DockerHelperImpl
implements DockerHelper {
    private static final String CIDR_CONTAINER_SETTINGS = "CIDR_DOCKER_CONTAINER_SETTINGS";
    private static final Logger LOG = Logger.getInstance(DockerHelperImpl.class);

    public HostMachine createOrGetHostMachine(@NotNull SettingsHandler handler, @Nullable File projectDir, @NotNull String toolchainName, @Nullable Project project) {
        RemoteHost remoteHost;
        if (handler == null) {
            DockerHelperImpl.$$$reportNull$$$0(0);
        }
        if (toolchainName == null) {
            DockerHelperImpl.$$$reportNull$$$0(1);
        }
        CidrDockerSettingsHandler internalHandler = DockerHelperImpl.check(handler);
        DockerCredentialsHolder credentials = internalHandler.getDockerCredentials();
        DockerContainerSettings settings = internalHandler.getContainerSettings();
        CidrDockerOptions cidrDockerOptions = new CidrDockerOptions(toolchainName);
        HostData hostData = internalHandler.getHostData();
        if (hostData != null) {
            Path cacheDirectory = RemoteUtil.suggestRemoteCacheDirectory((Path)DockerUtilKt.suggestDockerCacheDirectory(PathManager.getSystemDir(), credentials), (String)hostData.getId(), (RemoteCredentials)RemoteUtil.getCredentials((SshConfig)hostData.getSshConfig()));
            remoteHost = HostFactory.createOrGetRemoteHost((HostData)hostData, (String)toolchainName, (Project)project, (File)projectDir, (Path)cacheDirectory);
        } else {
            remoteHost = null;
        }
        if (AdvancedSettings.getBoolean((String)"clion.docker.cache.hosts")) {
            return DockerHostService.getInstance().computeIfAbsent(credentials, settings, projectDir, cidrDockerOptions, remoteHost, () -> DockerHelperImpl.createDockerHost(credentials, settings, cidrDockerOptions, remoteHost, projectDir));
        }
        return DockerHelperImpl.createDockerHost(credentials, settings, cidrDockerOptions, remoteHost, projectDir);
    }

    private static DockerHostBase<?> createDockerHost(@NotNull DockerCredentialsHolder credentials, @NotNull DockerContainerSettings settings, @NotNull CidrDockerOptions cidrDockerOptions, @Nullable RemoteHost remoteHost, @Nullable File projectDir) {
        if (credentials == null) {
            DockerHelperImpl.$$$reportNull$$$0(2);
        }
        if (settings == null) {
            DockerHelperImpl.$$$reportNull$$$0(3);
        }
        if (cidrDockerOptions == null) {
            DockerHelperImpl.$$$reportNull$$$0(4);
        }
        if (remoteHost == null) {
            return new DockerHostLocal(credentials, settings, projectDir, cidrDockerOptions);
        }
        return new DockerHostRemote(credentials, settings, projectDir, cidrDockerOptions, remoteHost);
    }

    public boolean isAvailable() {
        return Registry.is((String)"clion.docker");
    }

    public Icon getToolSetIcon() {
        return DockerIcons.Docker;
    }

    public DockerSettingsConfigurable createCredentialsEditor(@NotNull ToolchainPanel mainPanel, @NotNull GridBag bag) {
        if (mainPanel == null) {
            DockerHelperImpl.$$$reportNull$$$0(5);
        }
        if (bag == null) {
            DockerHelperImpl.$$$reportNull$$$0(6);
        }
        return new DockerCredentialsComponent(mainPanel, bag);
    }

    public CPPToolSet createDockerToolSet(@NotNull CPPToolSet.Kind kind) {
        if (kind == null) {
            DockerHelperImpl.$$$reportNull$$$0(7);
        }
        return new DockerToolSet(kind);
    }

    public SettingsHandler loadDockerSettings(@NotNull Element element) {
        if (element == null) {
            DockerHelperImpl.$$$reportNull$$$0(8);
        }
        CidrDockerSettingsHandler handler = new CidrDockerSettingsHandler();
        handler.load(element);
        return handler;
    }

    public void setupTestToolchain(CPPToolchains.Toolchain toolchain, String param) {
        String name;
        RemoteServersManager remoteServersManager = RemoteServersManager.getInstance();
        RemoteServer server = remoteServersManager.findByName(name = "DOCKER", (ServerType)DockerCloudType.getInstance());
        if (server == null) {
            server = remoteServersManager.createServer((ServerType)DockerCloudType.getInstance(), name);
            DockerCloudConfiguration configuration = (DockerCloudConfiguration)server.getConfiguration();
            configuration.setApiUrl(SystemInfoRt.isWindows ? "npipe:////./pipe/docker_engine" : "unix:///var/run/docker.sock");
            String wsl = System.getProperty("cidr.docker.use.wsl");
            if (SystemInfoRt.isWindows && wsl != null) {
                configuration.setDockerExePath("/usr/bin/docker");
                configuration.setCustomConfiguratorId("DockerWslConnectionConfigurator");
                configuration.getContributedData().put("DockerWslConnectionConfigurator.distribution", wsl);
            }
            remoteServersManager.addServer(server);
        }
        CidrDockerSettingsHandler settingsHandler = new CidrDockerSettingsHandler();
        settingsHandler.myCredentials.setImageName(param);
        settingsHandler.myCredentials.setAccountName(name);
        DockerContainerSettings settings = new DockerContainerSettings();
        settings.setRunCliOptions("--entrypoint= --rm");
        DockerVolumeBindingImpl hostTmpBinding = new DockerVolumeBindingImpl("/host_tmp", FileUtilRt.getTempDirectory(), false);
        DockerVolumeBindingImpl systemDirBinding = new DockerVolumeBindingImpl("/system_tmp", PathManagerEx.getAppSystemDir().toString(), false);
        settings.setVolumeBindings(List.of(hostTmpBinding, systemDirBinding));
        settingsHandler.myContainerSettings = settings;
        toolchain.setDockerSettingsHandler((SettingsHandler)settingsHandler);
        toolchain.setCustomCMakePath("/usr/bin/cmake");
    }

    static CidrDockerSettingsHandler check(@NotNull SettingsHandler handler) {
        if (handler == null) {
            DockerHelperImpl.$$$reportNull$$$0(9);
        }
        try {
            return (CidrDockerSettingsHandler)handler;
        }
        catch (ClassCastException e) {
            throw new IllegalStateException(e);
        }
    }

    public boolean canReadToolVersion(@NotNull SettingsHandler handler) {
        RemoteDockerRuntime runtime;
        if (handler == null) {
            DockerHelperImpl.$$$reportNull$$$0(10);
        }
        CidrDockerSettingsHandler settings = DockerHelperImpl.check(handler);
        try {
            runtime = CidrDockerUtil.getDockerRuntime(settings.myCredentials);
        }
        catch (ExecutionException e) {
            LOG.warn((Throwable)e);
            return false;
        }
        DockerAgentImage image = runtime.findImageByName(settings.myCredentials.getImageName());
        return image != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolchainName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "credentials";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cidrDockerOptions";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mainPanel";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bag";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/cidr/cpp/toolchains/docker/DockerHelperImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createOrGetHostMachine";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "createDockerHost";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "createCredentialsEditor";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "createDockerToolSet";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "loadDockerSettings";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "check";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "canReadToolVersion";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    static class CidrDockerSettingsHandler
    implements SettingsHandler {
        private final DockerCredentialsHolder myCredentials;
        private DockerContainerSettings myContainerSettings;
        @Nullable
        private HostData myHostData;

        CidrDockerSettingsHandler() {
            this.myContainerSettings = null;
            this.myHostData = null;
            this.myCredentials = new DockerCredentialsHolder();
        }

        CidrDockerSettingsHandler(@NotNull DockerCredentialsHolder credentials, @Nullable DockerContainerSettings settings, @Nullable HostData hostData) {
            if (credentials == null) {
                CidrDockerSettingsHandler.$$$reportNull$$$0(0);
            }
            this.myContainerSettings = null;
            this.myHostData = null;
            this.myCredentials = credentials;
            this.myContainerSettings = settings;
            this.myHostData = hostData;
        }

        public DockerCredentialsHolder getDockerCredentials() {
            return this.myCredentials;
        }

        public DockerContainerSettings getContainerSettings() {
            return this.myContainerSettings;
        }

        @Nullable
        HostData getHostData() {
            return this.myHostData;
        }

        public void save(@NotNull Element root) {
            if (root == null) {
                CidrDockerSettingsHandler.$$$reportNull$$$0(1);
            }
            this.myCredentials.save(root);
            if (this.myContainerSettings != null) {
                Element settingElement = new Element(DockerHelperImpl.CIDR_CONTAINER_SETTINGS);
                XmlSerializer.serializeInto((Object)this.myContainerSettings, (Element)settingElement);
                root.addContent(settingElement);
            }
            HostData.save((Element)root, (HostData)this.myHostData);
        }

        public void load(@NotNull Element root) {
            if (root == null) {
                CidrDockerSettingsHandler.$$$reportNull$$$0(2);
            }
            this.myCredentials.load(root);
            Element settingsElement = root.getChild(DockerHelperImpl.CIDR_CONTAINER_SETTINGS);
            if (settingsElement != null) {
                this.myContainerSettings = (DockerContainerSettings)XmlSerializer.deserialize((Element)settingsElement, DockerContainerSettings.class);
                DockerContainerSettings.upgradeSettings(null, (DockerContainerSettings)this.myContainerSettings, (int)2);
            }
            this.myHostData = HostData.load((Element)root);
        }

        @NotNull
        public SettingsHandler copy() {
            DockerCredentialsHolder credentials = new DockerCredentialsHolder(this.myCredentials);
            DockerContainerSettings settings = null;
            if (this.myContainerSettings != null) {
                settings = new DockerContainerSettings();
                this.myContainerSettings.copyTo(settings);
            }
            HostData hostData = null;
            if (this.myHostData != null) {
                hostData = this.myHostData.copy();
            }
            return new CidrDockerSettingsHandler(credentials, settings, hostData);
        }

        @NotNull
        public SettingsHandler copyToNewToolchain() {
            CidrDockerSettingsHandler copy = (CidrDockerSettingsHandler)this.copy();
            copy.myHostData = copy.myHostData == null ? null : new HostData(copy.myHostData.getSshConfig());
            CidrDockerSettingsHandler cidrDockerSettingsHandler = copy;
            if (cidrDockerSettingsHandler == null) {
                CidrDockerSettingsHandler.$$$reportNull$$$0(3);
            }
            return cidrDockerSettingsHandler;
        }

        public void clear() {
            HostData.deleteRemoteHost((HostData)this.myHostData);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CidrDockerSettingsHandler handler = (CidrDockerSettingsHandler)o;
            return Objects.equals(this.myCredentials, handler.myCredentials) && Objects.equals(this.myContainerSettings, handler.myContainerSettings) && Objects.equals(this.myHostData, handler.myHostData);
        }

        public int hashCode() {
            return Objects.hash(this.myCredentials, this.myContainerSettings, this.myHostData);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "credentials";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "root";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/cpp/toolchains/docker/DockerHelperImpl$CidrDockerSettingsHandler";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/cpp/toolchains/docker/DockerHelperImpl$CidrDockerSettingsHandler";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "copyToNewToolchain";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "save";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "load";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3 -> new IllegalStateException(string);
            };
        }
    }
}

