/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.toolchains.docker.host;

import com.intellij.docker.remote.DockerContainerSettings;
import com.intellij.docker.remote.DockerCredentialsHolder;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.PathMapper;
import com.jetbrains.cidr.cpp.toolchains.docker.CidrDockerOptions;
import com.jetbrains.cidr.cpp.toolchains.docker.CidrDockerUtil;
import com.jetbrains.cidr.cpp.toolchains.docker.DockerHelper;
import com.jetbrains.cidr.cpp.toolchains.docker.DockerUtilKt;
import com.jetbrains.cidr.cpp.toolchains.docker.host.DockerHostBase;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerPathManager;
import com.jetbrains.cidr.system.HostMachine;
import com.jetbrains.cidr.system.LocalHost;
import java.io.File;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0010\u0011\n\u0002\b\u0004\u0018\u0000 82\b\u0012\u0004\u0012\u00020\u00020\u0001:\u00018B+\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0010\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020)H\u0014J\b\u0010+\u001a\u00020,H\u0016J\u0018\u0010-\u001a\u00020\u000e2\u0006\u0010.\u001a\u00020\u000e2\u0006\u0010/\u001a\u00020)H\u0002J\u0018\u0010+\u001a\u00020,2\u0006\u00100\u001a\u00020\u000e2\u0006\u00101\u001a\u00020\u000eH\u0002J)\u00102\u001a\u00020\u000e2\u0006\u00103\u001a\u00020)2\u0012\u00104\u001a\n\u0012\u0006\b\u0001\u0012\u00020)05\"\u00020)H\u0016\u00a2\u0006\u0002\u00106J\b\u00107\u001a\u00020)H\u0016R\u001b\u0010\r\u001a\u00020\u000e8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u000f\u0010\u0010R\u001b\u0010\u0013\u001a\u00020\b8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0016\u0010\u0012\u001a\u0004\b\u0014\u0010\u0015R\u001b\u0010\u0017\u001a\u00020\u00188VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001b\u0010\u0012\u001a\u0004\b\u0019\u0010\u001aR\u001b\u0010\u001c\u001a\u00020\u000e8TX\u0094\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001e\u0010\u0012\u001a\u0004\b\u001d\u0010\u0010R\u001b\u0010\u001f\u001a\u00020\u000e8TX\u0094\u0084\u0002\u00a2\u0006\f\n\u0004\b!\u0010\u0012\u001a\u0004\b \u0010\u0010R\u001b\u0010\"\u001a\u00020\u000e8TX\u0094\u0084\u0002\u00a2\u0006\f\n\u0004\b$\u0010\u0012\u001a\u0004\b#\u0010\u0010R\u001b\u0010%\u001a\u00020\u000e8TX\u0094\u0084\u0002\u00a2\u0006\f\n\u0004\b'\u0010\u0012\u001a\u0004\b&\u0010\u0010\u00a8\u00069"}, d2={"Lcom/jetbrains/cidr/cpp/toolchains/docker/host/DockerHostLocal;", "Lcom/jetbrains/cidr/cpp/toolchains/docker/host/DockerHostBase;", "Lcom/jetbrains/cidr/system/LocalHost;", "credentialsHolder", "Lcom/intellij/docker/remote/DockerCredentialsHolder;", "containerSettings", "Lcom/intellij/docker/remote/DockerContainerSettings;", "projectDir", "Ljava/io/File;", "cidrDockerOptions", "Lcom/jetbrains/cidr/cpp/toolchains/docker/CidrDockerOptions;", "<init>", "(Lcom/intellij/docker/remote/DockerCredentialsHolder;Lcom/intellij/docker/remote/DockerContainerSettings;Ljava/io/File;Lcom/jetbrains/cidr/cpp/toolchains/docker/CidrDockerOptions;)V", "hostTemporaryDirectory", "Ljava/nio/file/Path;", "getHostTemporaryDirectory", "()Ljava/nio/file/Path;", "hostTemporaryDirectory$delegate", "Lkotlin/Lazy;", "cacheDirectory", "getCacheDirectory", "()Ljava/io/File;", "cacheDirectory$delegate", "totalMapper", "Lcom/intellij/util/PathMapper;", "getTotalMapper", "()Lcom/intellij/util/PathMapper;", "totalMapper$delegate", "hostStlPrettyPrintersDirectory", "getHostStlPrettyPrintersDirectory", "hostStlPrettyPrintersDirectory$delegate", "hostStlPrettyPrintersDirectoryToMount", "getHostStlPrettyPrintersDirectoryToMount", "hostStlPrettyPrintersDirectoryToMount$delegate", "hostQtPrettyPrintersDirectory", "getHostQtPrettyPrintersDirectory", "hostQtPrettyPrintersDirectory$delegate", "hostQtPrettyPrintersDirectoryToMount", "getHostQtPrettyPrintersDirectoryToMount", "hostQtPrettyPrintersDirectoryToMount$delegate", "convertToHostPath", "", "localPath", "setupPrettyPrinters", "", "getPrintersPathToMount", "printersPath", "tmpDirName", "bundledPrintersPath", "printersPathToMount", "getPath", "first", "more", "", "(Ljava/lang/String;[Ljava/lang/String;)Ljava/nio/file/Path;", "getHostId", "Companion", "intellij.clion.docker"})
public final class DockerHostLocal
extends DockerHostBase<LocalHost> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Lazy hostTemporaryDirectory$delegate;
    @NotNull
    private final Lazy cacheDirectory$delegate;
    @NotNull
    private final Lazy totalMapper$delegate;
    @NotNull
    private final Lazy hostStlPrettyPrintersDirectory$delegate;
    @NotNull
    private final Lazy hostStlPrettyPrintersDirectoryToMount$delegate;
    @NotNull
    private final Lazy hostQtPrettyPrintersDirectory$delegate;
    @NotNull
    private final Lazy hostQtPrettyPrintersDirectoryToMount$delegate;
    private static final boolean useTemporaryDirectoryForPrettyPrinters = SystemInfo.isMac;

    public DockerHostLocal(@NotNull DockerCredentialsHolder credentialsHolder, @Nullable DockerContainerSettings containerSettings, @Nullable File projectDir, @NotNull CidrDockerOptions cidrDockerOptions) {
        Intrinsics.checkNotNullParameter((Object)credentialsHolder, (String)"credentialsHolder");
        Intrinsics.checkNotNullParameter((Object)cidrDockerOptions, (String)"cidrDockerOptions");
        LocalHost localHost = LocalHost.INSTANCE;
        Intrinsics.checkNotNullExpressionValue((Object)localHost, (String)"INSTANCE");
        super(credentialsHolder, containerSettings, projectDir, cidrDockerOptions, (HostMachine)localHost);
        this.hostTemporaryDirectory$delegate = LazyKt.lazy(() -> DockerHostLocal.hostTemporaryDirectory_delegate$lambda$0(credentialsHolder));
        this.cacheDirectory$delegate = LazyKt.lazy(() -> DockerHostLocal.cacheDirectory_delegate$lambda$1(credentialsHolder));
        this.totalMapper$delegate = LazyKt.lazy(() -> DockerHostLocal.totalMapper_delegate$lambda$2(this));
        this.hostStlPrettyPrintersDirectory$delegate = LazyKt.lazy(DockerHostLocal::hostStlPrettyPrintersDirectory_delegate$lambda$3);
        this.hostStlPrettyPrintersDirectoryToMount$delegate = LazyKt.lazy(() -> DockerHostLocal.hostStlPrettyPrintersDirectoryToMount_delegate$lambda$4(this));
        this.hostQtPrettyPrintersDirectory$delegate = LazyKt.lazy(DockerHostLocal::hostQtPrettyPrintersDirectory_delegate$lambda$5);
        this.hostQtPrettyPrintersDirectoryToMount$delegate = LazyKt.lazy(() -> DockerHostLocal.hostQtPrettyPrintersDirectoryToMount_delegate$lambda$6(this));
    }

    @Override
    @NotNull
    public Path getHostTemporaryDirectory() {
        Lazy lazy = this.hostTemporaryDirectory$delegate;
        return (Path)lazy.getValue();
    }

    @Override
    @NotNull
    public File getCacheDirectory() {
        Lazy lazy = this.cacheDirectory$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
        return (File)object;
    }

    @Override
    @NotNull
    public PathMapper getTotalMapper() {
        Lazy lazy = this.totalMapper$delegate;
        return (PathMapper)lazy.getValue();
    }

    @Override
    @NotNull
    protected Path getHostStlPrettyPrintersDirectory() {
        Lazy lazy = this.hostStlPrettyPrintersDirectory$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
        return (Path)object;
    }

    @Override
    @NotNull
    protected Path getHostStlPrettyPrintersDirectoryToMount() {
        Lazy lazy = this.hostStlPrettyPrintersDirectoryToMount$delegate;
        return (Path)lazy.getValue();
    }

    @Override
    @NotNull
    protected Path getHostQtPrettyPrintersDirectory() {
        Lazy lazy = this.hostQtPrettyPrintersDirectory$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
        return (Path)object;
    }

    @Override
    @NotNull
    protected Path getHostQtPrettyPrintersDirectoryToMount() {
        Lazy lazy = this.hostQtPrettyPrintersDirectoryToMount$delegate;
        return (Path)lazy.getValue();
    }

    @Override
    @NotNull
    protected String convertToHostPath(@NotNull String localPath) {
        Intrinsics.checkNotNullParameter((Object)localPath, (String)"localPath");
        return localPath;
    }

    @Override
    public void setupPrettyPrinters() {
        this.setupPrettyPrinters(this.getHostStlPrettyPrintersDirectory(), this.getHostStlPrettyPrintersDirectoryToMount());
        this.setupPrettyPrinters(this.getHostQtPrettyPrintersDirectory(), this.getHostQtPrettyPrintersDirectoryToMount());
    }

    private final Path getPrintersPathToMount(Path printersPath, String tmpDirName) {
        Path path;
        if (useTemporaryDirectoryForPrettyPrinters) {
            Path path2 = Path.of(FileUtil.getTempDirectory(), new String[0]).resolve(".clion-pretty-printers").resolve(tmpDirName);
            Intrinsics.checkNotNull((Object)path2);
            path = path2;
        } else {
            path = printersPath;
        }
        return path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void setupPrettyPrinters(Path bundledPrintersPath, Path printersPathToMount) {
        if (Intrinsics.areEqual((Object)bundledPrintersPath, (Object)printersPathToMount)) {
            return;
        }
        DockerHelper dockerService = DockerHelper.getInstance();
        Intrinsics.checkNotNull((Object)dockerService);
        DockerHelper dockerHelper = dockerService;
        synchronized (dockerHelper) {
            boolean bl = false;
            if (Files.exists(printersPathToMount, new LinkOption[0])) {
                Files.walk(printersPathToMount, 1, new FileVisitOption[0]).forEach(arg_0 -> DockerHostLocal.setupPrettyPrinters$lambda$9$lambda$8(arg_0 -> DockerHostLocal.setupPrettyPrinters$lambda$9$lambda$7(printersPathToMount, arg_0), arg_0));
            }
            FileUtil.copyDir((File)bundledPrintersPath.toFile(), (File)printersPathToMount.toFile());
            Unit unit = Unit.INSTANCE;
        }
    }

    @NotNull
    public Path getPath(@NotNull String first, String ... more) {
        Intrinsics.checkNotNullParameter((Object)first, (String)"first");
        Intrinsics.checkNotNullParameter((Object)more, (String)"more");
        String[] others = new String[more.length];
        int n = more.length;
        for (int i = 0; i < n; ++i) {
            others[i] = this.getPathMapper().convertToLocal(more[i]);
        }
        Path path = Paths.get(this.getPathMapper().convertToLocal(first), Arrays.copyOf(others, others.length));
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        return path;
    }

    @NotNull
    public String getHostId() {
        return "Docker null " + this.getCredentialsHolder().getAccountName() + "-" + this.getCredentialsHolder().getImageName();
    }

    private static final Path hostTemporaryDirectory_delegate$lambda$0(DockerCredentialsHolder $credentialsHolder) {
        String string = Registry.Companion.is("clion.docker.use.system.tmp") ? PathManager.getTempPath() : FileUtil.getTempDirectory();
        Intrinsics.checkNotNull((Object)string);
        String tmpLocation = string;
        Path path = CidrDockerUtil.suggestPath(Path.of(tmpLocation, new String[0]).resolve("clion_docker_tmp"), $credentialsHolder);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"suggestPath(...)");
        Path path2 = path;
        FileUtil.createDirectory((File)path2.toFile());
        return path2;
    }

    private static final File cacheDirectory_delegate$lambda$1(DockerCredentialsHolder $credentialsHolder) {
        Path path = PathManager.getSystemDir();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getSystemDir(...)");
        return DockerUtilKt.suggestDockerCacheDirectory(path, $credentialsHolder).toFile();
    }

    private static final PathMapper totalMapper_delegate$lambda$2(DockerHostLocal this$0) {
        return this$0.getDockerMapper();
    }

    private static final Path hostStlPrettyPrintersDirectory_delegate$lambda$3() {
        return CidrDebuggerPathManager.getBundledGDBSTLPrettyPrinters().toPath();
    }

    private static final Path hostStlPrettyPrintersDirectoryToMount_delegate$lambda$4(DockerHostLocal this$0) {
        return this$0.getPrintersPathToMount(this$0.getHostStlPrettyPrintersDirectory(), "gdb");
    }

    private static final Path hostQtPrettyPrintersDirectory_delegate$lambda$5() {
        return CidrDebuggerPathManager.getBundledQtPrinters().toPath();
    }

    private static final Path hostQtPrettyPrintersDirectoryToMount_delegate$lambda$6(DockerHostLocal this$0) {
        return this$0.getPrintersPathToMount(this$0.getHostQtPrettyPrintersDirectory(), "qt");
    }

    private static final Unit setupPrettyPrinters$lambda$9$lambda$7(Path $printersPathToMount, Path it) {
        if (!Intrinsics.areEqual((Object)it, (Object)$printersPathToMount)) {
            FileUtil.deleteRecursively((Path)it);
        }
        return Unit.INSTANCE;
    }

    private static final void setupPrettyPrinters$lambda$9$lambda$8(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/cidr/cpp/toolchains/docker/host/DockerHostLocal$Companion;", "", "<init>", "()V", "useTemporaryDirectoryForPrettyPrinters", "", "intellij.clion.docker"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

