/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.toolchains.docker.host;

import com.intellij.docker.remote.DockerContainerSettings;
import com.intellij.docker.remote.DockerCredentialsHolder;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.remote.RemoteCredentials;
import com.intellij.util.PathMapper;
import com.intellij.util.io.PathKt;
import com.jetbrains.cidr.cpp.toolchains.docker.CidrDockerOptions;
import com.jetbrains.cidr.cpp.toolchains.docker.CidrDockerUtil;
import com.jetbrains.cidr.cpp.toolchains.docker.host.ChainedMapper;
import com.jetbrains.cidr.cpp.toolchains.docker.host.DockerHostBase;
import com.jetbrains.cidr.system.AuthenticatedHost;
import com.jetbrains.cidr.system.HostMachine;
import com.jetbrains.cidr.system.RemoteHost;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0010\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 <2\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0001<B3\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\u0002\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001fH\u0014J\u0010\u0010-\u001a\u00020\u001f2\u0006\u0010.\u001a\u00020\u001fH\u0014J\b\u0010/\u001a\u000200H\u0016J8\u00101\u001a\u00020\u00102\u000b\u00102\u001a\u00070\u001f\u00a2\u0006\u0002\b32\u001c\u00104\u001a\u000f\u0012\u000b\b\u0001\u0012\u00070\u001f\u00a2\u0006\u0002\b305\"\u00070\u001f\u00a2\u0006\u0002\b3H\u0016\u00a2\u0006\u0002\u00106J\b\u00107\u001a\u00020\u001fH\u0016R\u001b\u0010\u000f\u001a\u00020\u00108VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u0011\u0010\u0012R\u001b\u0010\u0015\u001a\u00020\t8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0018\u0010\u0014\u001a\u0004\b\u0016\u0010\u0017R\u001b\u0010\u0019\u001a\u00020\u001a8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001d\u0010\u0014\u001a\u0004\b\u001b\u0010\u001cR\u001b\u0010!\u001a\u00020\u00108TX\u0094\u0084\u0002\u00a2\u0006\f\n\u0004\b#\u0010\u0014\u001a\u0004\b\"\u0010\u0012R\u001b\u0010$\u001a\u00020\u00108TX\u0094\u0084\u0002\u00a2\u0006\f\n\u0004\b&\u0010\u0014\u001a\u0004\b%\u0010\u0012R\u001b\u0010'\u001a\u00020\u00108TX\u0094\u0084\u0002\u00a2\u0006\f\n\u0004\b)\u0010\u0014\u001a\u0004\b(\u0010\u0012R\u001b\u0010*\u001a\u00020\u00108TX\u0094\u0084\u0002\u00a2\u0006\f\n\u0004\b,\u0010\u0014\u001a\u0004\b+\u0010\u0012R\u0014\u00108\u001a\u0002098VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b:\u0010;\u00a8\u0006="}, d2={"Lcom/jetbrains/cidr/cpp/toolchains/docker/host/DockerHostRemote;", "Lcom/jetbrains/cidr/cpp/toolchains/docker/host/DockerHostBase;", "Lcom/jetbrains/cidr/system/RemoteHost;", "Lcom/jetbrains/cidr/system/AuthenticatedHost;", "credentialsHolder", "Lcom/intellij/docker/remote/DockerCredentialsHolder;", "containerSettings", "Lcom/intellij/docker/remote/DockerContainerSettings;", "projectDir", "Ljava/io/File;", "cidrDockerOptions", "Lcom/jetbrains/cidr/cpp/toolchains/docker/CidrDockerOptions;", "remoteHost", "<init>", "(Lcom/intellij/docker/remote/DockerCredentialsHolder;Lcom/intellij/docker/remote/DockerContainerSettings;Ljava/io/File;Lcom/jetbrains/cidr/cpp/toolchains/docker/CidrDockerOptions;Lcom/jetbrains/cidr/system/RemoteHost;)V", "hostTemporaryDirectory", "Ljava/nio/file/Path;", "getHostTemporaryDirectory", "()Ljava/nio/file/Path;", "hostTemporaryDirectory$delegate", "Lkotlin/Lazy;", "cacheDirectory", "getCacheDirectory", "()Ljava/io/File;", "cacheDirectory$delegate", "totalMapper", "Lcom/intellij/util/PathMapper;", "getTotalMapper", "()Lcom/intellij/util/PathMapper;", "totalMapper$delegate", "mapServerToLocal", "", "path", "hostStlPrettyPrintersDirectory", "getHostStlPrettyPrintersDirectory", "hostStlPrettyPrintersDirectory$delegate", "hostStlPrettyPrintersDirectoryToMount", "getHostStlPrettyPrintersDirectoryToMount", "hostStlPrettyPrintersDirectoryToMount$delegate", "hostQtPrettyPrintersDirectory", "getHostQtPrettyPrintersDirectory", "hostQtPrettyPrintersDirectory$delegate", "hostQtPrettyPrintersDirectoryToMount", "getHostQtPrettyPrintersDirectoryToMount", "hostQtPrettyPrintersDirectoryToMount$delegate", "convertToHostPath", "localPath", "setupPrettyPrinters", "", "getPath", "first", "Lorg/jetbrains/annotations/NonNls;", "more", "", "(Ljava/lang/String;[Ljava/lang/String;)Ljava/nio/file/Path;", "getHostId", "credentials", "Lcom/intellij/remote/RemoteCredentials;", "getCredentials", "()Lcom/intellij/remote/RemoteCredentials;", "Companion", "intellij.clion.docker"})
@SourceDebugExtension(value={"SMAP\nDockerHostRemote.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DockerHostRemote.kt\ncom/jetbrains/cidr/cpp/toolchains/docker/host/DockerHostRemote\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,87:1\n14#2:88\n*S KotlinDebug\n*F\n+ 1 DockerHostRemote.kt\ncom/jetbrains/cidr/cpp/toolchains/docker/host/DockerHostRemote\n*L\n85#1:88\n*E\n"})
public final class DockerHostRemote
extends DockerHostBase<RemoteHost>
implements AuthenticatedHost {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Lazy hostTemporaryDirectory$delegate;
    @NotNull
    private final Lazy cacheDirectory$delegate;
    @NotNull
    private final Lazy totalMapper$delegate;
    @NotNull
    private final Lazy hostStlPrettyPrintersDirectory$delegate;
    @NotNull
    private final Lazy hostStlPrettyPrintersDirectoryToMount$delegate;
    @NotNull
    private final Lazy hostQtPrettyPrintersDirectory$delegate;
    @NotNull
    private final Lazy hostQtPrettyPrintersDirectoryToMount$delegate;
    @NotNull
    private static final Logger LOG;

    public DockerHostRemote(@NotNull DockerCredentialsHolder credentialsHolder, @Nullable DockerContainerSettings containerSettings, @Nullable File projectDir, @NotNull CidrDockerOptions cidrDockerOptions, @NotNull RemoteHost remoteHost) {
        Intrinsics.checkNotNullParameter((Object)credentialsHolder, (String)"credentialsHolder");
        Intrinsics.checkNotNullParameter((Object)cidrDockerOptions, (String)"cidrDockerOptions");
        Intrinsics.checkNotNullParameter((Object)remoteHost, (String)"remoteHost");
        super(credentialsHolder, containerSettings, projectDir, cidrDockerOptions, (HostMachine)remoteHost);
        this.hostTemporaryDirectory$delegate = LazyKt.lazy(() -> DockerHostRemote.hostTemporaryDirectory_delegate$lambda$0(this, credentialsHolder));
        this.cacheDirectory$delegate = LazyKt.lazy(() -> DockerHostRemote.cacheDirectory_delegate$lambda$1(this));
        this.totalMapper$delegate = LazyKt.lazy(() -> DockerHostRemote.totalMapper_delegate$lambda$2(this));
        this.hostStlPrettyPrintersDirectory$delegate = LazyKt.lazy(() -> DockerHostRemote.hostStlPrettyPrintersDirectory_delegate$lambda$3(this));
        this.hostStlPrettyPrintersDirectoryToMount$delegate = LazyKt.lazy(() -> DockerHostRemote.hostStlPrettyPrintersDirectoryToMount_delegate$lambda$4(this));
        this.hostQtPrettyPrintersDirectory$delegate = LazyKt.lazy(() -> DockerHostRemote.hostQtPrettyPrintersDirectory_delegate$lambda$5(this));
        this.hostQtPrettyPrintersDirectoryToMount$delegate = LazyKt.lazy(() -> DockerHostRemote.hostQtPrettyPrintersDirectoryToMount_delegate$lambda$6(this));
    }

    @Override
    @NotNull
    public Path getHostTemporaryDirectory() {
        Lazy lazy = this.hostTemporaryDirectory$delegate;
        return (Path)lazy.getValue();
    }

    @Override
    @NotNull
    public File getCacheDirectory() {
        Lazy lazy = this.cacheDirectory$delegate;
        return (File)lazy.getValue();
    }

    @Override
    @NotNull
    public PathMapper getTotalMapper() {
        Lazy lazy = this.totalMapper$delegate;
        return (PathMapper)lazy.getValue();
    }

    @Override
    @NotNull
    protected String mapServerToLocal(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        String string = ((RemoteHost)this.getUnderlyingHost()).getPathMapper().convertToLocal(path);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"convertToLocal(...)");
        return string;
    }

    @Override
    @NotNull
    protected Path getHostStlPrettyPrintersDirectory() {
        Lazy lazy = this.hostStlPrettyPrintersDirectory$delegate;
        return (Path)lazy.getValue();
    }

    @Override
    @NotNull
    protected Path getHostStlPrettyPrintersDirectoryToMount() {
        Lazy lazy = this.hostStlPrettyPrintersDirectoryToMount$delegate;
        return (Path)lazy.getValue();
    }

    @Override
    @NotNull
    protected Path getHostQtPrettyPrintersDirectory() {
        Lazy lazy = this.hostQtPrettyPrintersDirectory$delegate;
        return (Path)lazy.getValue();
    }

    @Override
    @NotNull
    protected Path getHostQtPrettyPrintersDirectoryToMount() {
        Lazy lazy = this.hostQtPrettyPrintersDirectoryToMount$delegate;
        return (Path)lazy.getValue();
    }

    @Override
    @NotNull
    protected String convertToHostPath(@NotNull String localPath) {
        Intrinsics.checkNotNullParameter((Object)localPath, (String)"localPath");
        String string = ((RemoteHost)this.getUnderlyingHost()).getPathMapper().convertToRemote(localPath);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"convertToRemote(...)");
        return string;
    }

    @Override
    public void setupPrettyPrinters() {
        ((RemoteHost)this.getUnderlyingHost()).installDependencies();
    }

    @NotNull
    public Path getPath(@NotNull String first, String ... more) {
        Intrinsics.checkNotNullParameter((Object)first, (String)"first");
        Intrinsics.checkNotNullParameter((Object)more, (String)"more");
        Path path = ((RemoteHost)this.getUnderlyingHost()).getPath(first, Arrays.copyOf(more, more.length));
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getPath(...)");
        return path;
    }

    @NotNull
    public String getHostId() {
        String string = ((RemoteHost)this.getUnderlyingHost()).getHostId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getHostId(...)");
        return string;
    }

    @NotNull
    public RemoteCredentials getCredentials() {
        RemoteCredentials remoteCredentials = ((RemoteHost)this.getUnderlyingHost()).getCredentials();
        Intrinsics.checkNotNullExpressionValue((Object)remoteCredentials, (String)"<get-credentials>(...)");
        return remoteCredentials;
    }

    private static final Path hostTemporaryDirectory_delegate$lambda$0(DockerHostRemote this$0, DockerCredentialsHolder $credentialsHolder) {
        Path path = CidrDockerUtil.suggestPath(((RemoteHost)this$0.getUnderlyingHost()).getTempDirectory().resolve("tmp_docker_clion"), $credentialsHolder);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"suggestPath(...)");
        Path tmp = path;
        if (Files.notExists(tmp, new LinkOption[0])) {
            PathKt.createDirectories((Path)tmp);
        }
        return tmp;
    }

    private static final File cacheDirectory_delegate$lambda$1(DockerHostRemote this$0) {
        File file = ((RemoteHost)this$0.getUnderlyingHost()).getCacheDirectory();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getCacheDirectory(...)");
        return file;
    }

    private static final ChainedMapper totalMapper_delegate$lambda$2(DockerHostRemote this$0) {
        PathMapper pathMapper = ((RemoteHost)this$0.getUnderlyingHost()).getPathMapper();
        Intrinsics.checkNotNullExpressionValue((Object)pathMapper, (String)"getPathMapper(...)");
        return new ChainedMapper(pathMapper, this$0.getDockerMapper());
    }

    private static final Path hostStlPrettyPrintersDirectory_delegate$lambda$3(DockerHostRemote this$0) {
        return this$0.getHostStlPrettyPrintersDirectoryToMount();
    }

    private static final Path hostStlPrettyPrintersDirectoryToMount_delegate$lambda$4(DockerHostRemote this$0) {
        Path path = ((RemoteHost)this$0.getUnderlyingHost()).getRemoteGDBSTLPrettyPrinters();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getRemoteGDBSTLPrettyPrinters(...)");
        return path;
    }

    private static final Path hostQtPrettyPrintersDirectory_delegate$lambda$5(DockerHostRemote this$0) {
        return this$0.getHostQtPrettyPrintersDirectoryToMount();
    }

    private static final Path hostQtPrettyPrintersDirectoryToMount_delegate$lambda$6(DockerHostRemote this$0) {
        Path path = ((RemoteHost)this$0.getUnderlyingHost()).getRemoteQtPrettyPrinters();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getRemoteQtPrettyPrinters(...)");
        return path;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(DockerHostRemote.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/cidr/cpp/toolchains/docker/host/DockerHostRemote$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.clion.docker"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

