/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.formatter;

import com.vladsch.flexmark.ast.HtmlCommentBlock;
import com.vladsch.flexmark.ast.HtmlInlineComment;
import com.vladsch.flexmark.ast.HtmlInnerBlockComment;
import com.vladsch.flexmark.ast.ListBlock;
import com.vladsch.flexmark.ast.ListItem;
import com.vladsch.flexmark.ast.OrderedList;
import com.vladsch.flexmark.ast.Paragraph;
import com.vladsch.flexmark.ast.ParagraphContainer;
import com.vladsch.flexmark.ast.SoftLineBreak;
import com.vladsch.flexmark.formatter.Formatter;
import com.vladsch.flexmark.formatter.FormatterOptions;
import com.vladsch.flexmark.formatter.MarkdownWriter;
import com.vladsch.flexmark.formatter.NodeFormatterContext;
import com.vladsch.flexmark.parser.ListOptions;
import com.vladsch.flexmark.parser.Parser;
import com.vladsch.flexmark.util.ast.BlankLine;
import com.vladsch.flexmark.util.ast.Block;
import com.vladsch.flexmark.util.ast.BlockQuoteLike;
import com.vladsch.flexmark.util.ast.Document;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.data.DataKey;
import com.vladsch.flexmark.util.data.MutableDataHolder;
import com.vladsch.flexmark.util.data.NullableDataKey;
import com.vladsch.flexmark.util.format.MarkdownParagraph;
import com.vladsch.flexmark.util.format.TrackedOffset;
import com.vladsch.flexmark.util.format.TrackedOffsetList;
import com.vladsch.flexmark.util.format.options.BlockQuoteMarker;
import com.vladsch.flexmark.util.format.options.ListSpacing;
import com.vladsch.flexmark.util.misc.CharPredicate;
import com.vladsch.flexmark.util.misc.Pair;
import com.vladsch.flexmark.util.misc.Utils;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import com.vladsch.flexmark.util.sequence.LineAppendable;
import com.vladsch.flexmark.util.sequence.LineInfo;
import com.vladsch.flexmark.util.sequence.RepeatedSequence;
import com.vladsch.flexmark.util.sequence.builder.SequenceBuilder;
import com.vladsch.flexmark.util.sequence.mappers.SpaceMapper;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FormatterUtils {
    public static final DataKey<Integer> LIST_ITEM_NUMBER = new DataKey<Integer>("LIST_ITEM_NUMBER", 0);
    public static final DataKey<Boolean> FIRST_LIST_ITEM_CHILD = new DataKey<Boolean>("FIRST_LIST_ITEM_CHILD", false);
    public static final Function<CharSequence, Pair<Integer, Integer>> NULL_PADDING = sequence -> Pair.of(0, 0);
    public static final DataKey<Function<CharSequence, Pair<Integer, Integer>>> LIST_ALIGN_NUMERIC = new DataKey<Function<CharSequence, Pair<Integer, Integer>>>("LIST_ITEM_NUMBER", NULL_PADDING);
    public static final NullableDataKey<ListSpacing> LIST_ITEM_SPACING = new NullableDataKey("LIST_ITEM_SPACING");

    public static String getBlockLikePrefix(BlockQuoteLike node, NodeFormatterContext context, BlockQuoteMarker blockQuoteMarkers, @NotNull BasedSequence prefix) {
        Object usePrefix;
        String prefixChars = node.getOpeningMarker().toString();
        boolean compactPrefix = false;
        switch (blockQuoteMarkers) {
            case AS_IS: {
                if (node.getFirstChild() != null) {
                    usePrefix = node.getChars().baseSubSequence(node.getOpeningMarker().getStartOffset(), node.getFirstChild().getStartOffset()).toString();
                    break;
                }
                usePrefix = prefixChars;
                break;
            }
            case ADD_COMPACT: {
                usePrefix = prefixChars.trim();
                break;
            }
            case ADD_COMPACT_WITH_SPACE: {
                compactPrefix = true;
                usePrefix = prefixChars.trim() + " ";
                break;
            }
            case ADD_SPACED: {
                usePrefix = prefixChars.trim() + " ";
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + blockQuoteMarkers);
            }
        }
        CharPredicate quoteLikePrefixPredicate = context.getBlockQuoteLikePrefixPredicate();
        Object combinedPrefix = prefix.toString();
        combinedPrefix = compactPrefix && ((String)combinedPrefix).endsWith(" ") && ((String)combinedPrefix).length() >= 2 && quoteLikePrefixPredicate.test(((String)combinedPrefix).charAt(((String)combinedPrefix).length() - 2)) ? ((String)combinedPrefix).substring(0, ((String)combinedPrefix).length() - 1) + (String)usePrefix : (String)combinedPrefix + (String)usePrefix;
        return combinedPrefix;
    }

    public static CharSequence stripSoftLineBreak(CharSequence chars, CharSequence spaceChar) {
        StringBuffer sb = null;
        Matcher matcher = Pattern.compile("\\s*(?:\r\n|\r|\n)\\s*").matcher(chars);
        while (matcher.find()) {
            if (sb == null) {
                sb = new StringBuffer();
            }
            matcher.appendReplacement(sb, spaceChar.toString());
        }
        if (sb != null) {
            matcher.appendTail(sb);
            return sb;
        }
        return chars;
    }

    @NotNull
    public static String getActualAdditionalPrefix(BasedSequence contentChars, MarkdownWriter markdown) {
        int parentPrefix = markdown.getPrefix().length();
        int column = contentChars.baseColumnAtStart();
        String prefix = RepeatedSequence.repeatOf(" ", Utils.minLimit(0, column - parentPrefix)).toString();
        return prefix;
    }

    @NotNull
    public static String getAdditionalPrefix(BasedSequence fromChars, BasedSequence toChars) {
        int parentPrefix = fromChars.getStartOffset();
        int column = toChars.getStartOffset();
        String prefix = RepeatedSequence.repeatOf(" ", Utils.minLimit(0, column - parentPrefix)).toString();
        return prefix;
    }

    public static BasedSequence getSoftLineBreakSpan(Node node) {
        if (node == null) {
            return BasedSequence.NULL;
        }
        Node lastNode = node;
        for (Node nextNode = node.getNext(); nextNode != null && !(nextNode instanceof SoftLineBreak); nextNode = nextNode.getNext()) {
            lastNode = nextNode;
        }
        return Node.spanningChars(node.getChars(), lastNode.getChars());
    }

    public static void appendWhiteSpaceBetween(MarkdownWriter markdown, Node prev, Node next, boolean preserve, boolean collapse, boolean collapseToEOL) {
        if (next != null && prev != null && (preserve || collapse)) {
            FormatterUtils.appendWhiteSpaceBetween(markdown, prev.getChars(), next.getChars(), preserve, collapse, collapseToEOL);
        }
    }

    public static void appendWhiteSpaceBetween(MarkdownWriter markdown, BasedSequence prev, BasedSequence next, boolean preserve, boolean collapse, boolean collapseToEOL) {
        BasedSequence sequence;
        if (next != null && prev != null && (preserve || collapse) && prev.getEndOffset() <= next.getStartOffset() && !(sequence = prev.baseSubSequence(prev.getEndOffset(), next.getStartOffset())).isEmpty() && sequence.isBlank()) {
            if (!preserve) {
                if (collapseToEOL && sequence.indexOfAny(CharPredicate.ANY_EOL) != -1) {
                    markdown.append('\n');
                } else {
                    markdown.append(' ');
                }
            } else {
                int saved = markdown.getOptions();
                markdown.setOptions(saved & ~LineAppendable.F_TRIM_LEADING_WHITESPACE);
                markdown.append(sequence);
                markdown.setOptions(saved);
            }
        }
    }

    public static void renderList(ListBlock node, NodeFormatterContext context, MarkdownWriter markdown) {
        if (context.isTransformingText()) {
            context.renderChildren(node);
        } else {
            ArrayList<Node> itemList = new ArrayList<Node>();
            for (Node item = node.getFirstChild(); item != null; item = item.getNext()) {
                itemList.add(item);
            }
            FormatterUtils.renderList(node, context, markdown, itemList);
        }
    }

    public static void renderList(ListBlock node, NodeFormatterContext context, MarkdownWriter markdown, List<Node> itemList) {
        FormatterOptions formatterOptions = context.getFormatterOptions();
        if (formatterOptions.listAddBlankLineBefore && !node.isOrDescendantOfType(ListItem.class)) {
            markdown.blankLine();
        }
        Document document = context.getDocument();
        ListSpacing listSpacing = LIST_ITEM_SPACING.get(document);
        int listItemNumber = LIST_ITEM_NUMBER.get(document);
        int startingNumber = node instanceof OrderedList ? (formatterOptions.listRenumberItems && formatterOptions.listResetFirstItemNumber ? 1 : ((OrderedList)node).getStartNumber()) : 1;
        Function<CharSequence, Pair<Integer, Integer>> listAlignNumeric = LIST_ALIGN_NUMERIC.get(document);
        document.set(LIST_ITEM_NUMBER, Integer.valueOf(startingNumber));
        ListSpacing itemSpacing = null;
        switch (formatterOptions.listSpacing) {
            case AS_IS: {
                break;
            }
            case LOOSE: {
                itemSpacing = ListSpacing.LOOSE;
                break;
            }
            case TIGHT: {
                itemSpacing = ListSpacing.TIGHT;
                break;
            }
            case LOOSEN: {
                itemSpacing = FormatterUtils.hasLooseItems(itemList) ? ListSpacing.LOOSE : ListSpacing.TIGHT;
                break;
            }
            case TIGHTEN: {
                itemSpacing = FormatterUtils.hasLooseItems(itemList) ? ListSpacing.AS_IS : ListSpacing.TIGHT;
            }
        }
        document.remove(LIST_ALIGN_NUMERIC);
        if (!formatterOptions.listAlignNumeric.isNoChange() && node instanceof OrderedList) {
            int maxLen = Integer.MIN_VALUE;
            int minLen = Integer.MAX_VALUE;
            int i = startingNumber;
            for (Node item : itemList) {
                if (formatterOptions.listRemoveEmptyItems && (!item.hasChildren() || item.getFirstChildAnyNot(BlankLine.class) == null)) continue;
                int length = formatterOptions.listRenumberItems ? Integer.toString(i).length() + 1 : ((ListItem)item).getOpeningMarker().length();
                maxLen = Math.max(maxLen, length);
                minLen = Math.min(minLen, length);
                ++i;
            }
            if (maxLen != minLen) {
                int finalMaxLen = maxLen;
                document.set(LIST_ALIGN_NUMERIC, formatterOptions.listAlignNumeric.isLeft() ? sequence -> Pair.of(0, Math.min(4, Math.max(0, finalMaxLen - sequence.length()))) : sequence -> Pair.of(Math.min(4, Math.max(0, finalMaxLen - sequence.length())), 0));
            }
        }
        document.set(LIST_ITEM_SPACING, itemSpacing == ListSpacing.LOOSE && (listSpacing == null || listSpacing == ListSpacing.LOOSE) ? ListSpacing.LOOSE : itemSpacing);
        for (Node item : itemList) {
            if (itemSpacing == ListSpacing.LOOSE && (listSpacing == null || listSpacing == ListSpacing.LOOSE)) {
                markdown.blankLine();
            }
            context.render(item);
        }
        document.set(LIST_ITEM_SPACING, listSpacing);
        document.set(LIST_ITEM_NUMBER, Integer.valueOf(listItemNumber));
        document.set(LIST_ALIGN_NUMERIC, listAlignNumeric);
        if (!node.isOrDescendantOfType(ListItem.class)) {
            markdown.tailBlankLine();
        }
    }

    public static void renderLooseParagraph(Paragraph node, NodeFormatterContext context, MarkdownWriter markdown) {
        markdown.blankLine();
        FormatterUtils.renderLooseItemParagraph(node, context, markdown);
    }

    public static boolean isFollowedByBlankLine(@Nullable Node node) {
        while (node != null) {
            if (node.getNextAnyNot(HtmlCommentBlock.class, HtmlInnerBlockComment.class, HtmlInlineComment.class) instanceof BlankLine) {
                return true;
            }
            if (node.getNextAnyNot(BlankLine.class, HtmlCommentBlock.class, HtmlInnerBlockComment.class, HtmlInlineComment.class) != null) {
                return false;
            }
            node = node.getParent();
        }
        return false;
    }

    public static boolean isNotLastItem(@Nullable Node node) {
        while (node != null && !(node instanceof Document)) {
            if (node.getNextAnyNot(BlankLine.class, HtmlCommentBlock.class, HtmlInnerBlockComment.class, HtmlInlineComment.class) != null) {
                return true;
            }
            node = node.getParent();
        }
        return false;
    }

    public static boolean isLastOfItem(@Nullable Node node) {
        return node != null && node.getNextAnyNot(BlankLine.class, HtmlCommentBlock.class, HtmlInnerBlockComment.class, HtmlInlineComment.class) == null;
    }

    public static void renderLooseItemParagraph(Paragraph node, NodeFormatterContext context, MarkdownWriter markdown) {
        FormatterUtils.renderTextBlockParagraphLines(node, context, markdown);
        Block parent = node.getParent();
        if (parent instanceof ListItem) {
            if (context.getFormatterOptions().blankLinesInAst) {
                boolean addBlankLine;
                boolean canAddTailBlankLine = !((ParagraphContainer)((Object)parent)).isParagraphEndWrappingDisabled(node);
                ListItem listItem = (ListItem)parent;
                switch (context.getFormatterOptions().listSpacing) {
                    case LOOSEN: {
                        addBlankLine = parent.getParent() instanceof ListBlock && ((ListBlock)parent.getParent()).isLoose() && FormatterUtils.hasLooseItems(parent.getParent().getChildren()) && (FormatterUtils.isFollowedByBlankLine(node) && FormatterUtils.isNotLastItem(parent) || !listItem.isOwnTight() || listItem.isItemParagraph(node) && parent.getFirstChild() != null && parent.getFirstChild().getNext() != null);
                        break;
                    }
                    case LOOSE: {
                        addBlankLine = true;
                        break;
                    }
                    case TIGHTEN: {
                        addBlankLine = canAddTailBlankLine && (listItem.isItemParagraph(node) ? FormatterUtils.isFollowedByBlankLine(node) && FormatterUtils.isNotLastItem(node) : FormatterUtils.isNotLastItem(node));
                        break;
                    }
                    case AS_IS: {
                        addBlankLine = FormatterUtils.isFollowedByBlankLine(node) && FormatterUtils.isNotLastItem(parent);
                        break;
                    }
                    default: {
                        addBlankLine = false;
                    }
                }
                if (addBlankLine) {
                    markdown.tailBlankLine();
                }
            } else if (context.getFormatterOptions().listSpacing != ListSpacing.TIGHTEN || parent.getNext() != null) {
                markdown.tailBlankLine();
            }
        } else {
            markdown.tailBlankLine();
        }
    }

    static boolean hasLooseItems(Iterable<Node> itemList) {
        for (Node item : itemList) {
            if (!(item instanceof ListItem) || ((ListItem)item).isOwnTight() || item.getNext() == null) continue;
            return true;
        }
        return false;
    }

    public static void renderListItem(ListItem node, NodeFormatterContext context, MarkdownWriter markdown, ListOptions listOptions, BasedSequence markerSuffix, boolean addBlankLineLooseItems) {
        FormatterOptions options = context.getFormatterOptions();
        boolean savedFirstListItemChild = FIRST_LIST_ITEM_CHILD.get(context.getDocument());
        if (context.isTransformingText()) {
            String itemContentSpacer;
            String prefix;
            BasedSequence openingMarker = node.getOpeningMarker();
            String additionalPrefix = FormatterUtils.getActualAdditionalPrefix(openingMarker, markdown);
            if (node.getFirstChild() == null) {
                int count = openingMarker.length() + (listOptions.isItemContentAfterSuffix() ? markerSuffix.length() : 0) + 1;
                String itemContentPrefix = RepeatedSequence.repeatOf(' ', count).toString();
                prefix = additionalPrefix + itemContentPrefix;
                itemContentSpacer = " ";
            } else {
                BasedSequence childContent = node.getFirstChild().getChars();
                String itemContentPrefix = FormatterUtils.getAdditionalPrefix(markerSuffix.isEmpty() ? openingMarker : markerSuffix, childContent);
                prefix = additionalPrefix + itemContentPrefix;
                itemContentSpacer = FormatterUtils.getAdditionalPrefix(markerSuffix.isEmpty() ? openingMarker.getEmptySuffix() : markerSuffix.getEmptySuffix(), childContent);
            }
            ((MarkdownWriter)markdown.pushPrefix()).addPrefix(prefix, true);
            ((MarkdownWriter)markdown.append(additionalPrefix)).append(openingMarker);
            if (!markerSuffix.isEmpty()) {
                String markerSuffixIndent = FormatterUtils.getAdditionalPrefix(openingMarker.getEmptySuffix(), markerSuffix);
                ((MarkdownWriter)markdown.append(markerSuffixIndent)).append(markerSuffix);
            }
            markdown.append(itemContentSpacer);
            if (!(node.getFirstChild() instanceof Paragraph)) {
                if (node.getFirstChild() == null) {
                    if (!savedFirstListItemChild) {
                        markdown.append("\n");
                    }
                } else {
                    int posEOL = node.endOfLine(openingMarker.getEndOffset());
                    if (posEOL < node.getFirstChild().getStartOffset()) {
                        markdown.append("\n");
                    }
                }
            }
            context.renderChildren(node);
            markdown.popPrefix();
        } else {
            if (options.listRemoveEmptyItems && (!node.hasChildren() || node.getFirstChildAnyNot(BlankLine.class) == null)) {
                return;
            }
            Object useOpeningMarker = node.getOpeningMarker();
            if (node.isOrderedItem()) {
                char delimiter = useOpeningMarker.charAt(useOpeningMarker.length() - 1);
                CharSequence number = useOpeningMarker.subSequence(0, useOpeningMarker.length() - 1);
                switch (options.listNumberedMarker) {
                    case ANY: {
                        break;
                    }
                    case DOT: {
                        delimiter = '.';
                        break;
                    }
                    case PAREN: {
                        delimiter = ')';
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Missing case for ListNumberedMarker " + options.listNumberedMarker.name());
                    }
                }
                Document document = context.getDocument();
                if (options.listRenumberItems) {
                    Integer itemNumber = LIST_ITEM_NUMBER.get(document);
                    Object[] objectArray = new Object[2];
                    Integer posEOL = itemNumber;
                    Integer n = itemNumber = Integer.valueOf(itemNumber + 1);
                    objectArray[0] = posEOL;
                    objectArray[1] = Character.valueOf(delimiter);
                    useOpeningMarker = String.format(Locale.US, "%d%c", objectArray);
                    document.set(LIST_ITEM_NUMBER, itemNumber);
                } else {
                    useOpeningMarker = String.format("%s%c", number, Character.valueOf(delimiter));
                }
                Pair<Integer, Integer> padding = LIST_ALIGN_NUMERIC.get(document).apply((CharSequence)useOpeningMarker);
                if (padding.getFirst() > 0) {
                    useOpeningMarker = RepeatedSequence.ofSpaces(padding.getFirst()).toString() + useOpeningMarker.toString();
                }
                if (padding.getSecond() > 0) {
                    useOpeningMarker = useOpeningMarker.toString() + RepeatedSequence.ofSpaces(padding.getSecond()).toString();
                }
            } else if (node.canChangeMarker()) {
                switch (options.listBulletMarker) {
                    case ANY: {
                        break;
                    }
                    case DASH: {
                        useOpeningMarker = "-";
                        break;
                    }
                    case ASTERISK: {
                        useOpeningMarker = "*";
                        break;
                    }
                    case PLUS: {
                        useOpeningMarker = "+";
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Missing case for ListBulletMarker " + options.listBulletMarker.name());
                    }
                }
            }
            int itemContinuationCount = listOptions.isItemContentAfterSuffix() || options.listsItemContentAfterSuffix ? markerSuffix.length() : 0;
            int continuationCount = useOpeningMarker.length() + (listOptions.isItemContentAfterSuffix() ? markerSuffix.length() : 0) + 1;
            String additionalItemPrefix = options.itemContentIndent ? RepeatedSequence.repeatOf(' ', itemContinuationCount) : "";
            CharSequence childPrefix = options.itemContentIndent ? RepeatedSequence.repeatOf(' ', continuationCount) : RepeatedSequence.repeatOf(" ", listOptions.getItemIndent()).toString();
            BasedSequence openingMarker = node.getOpeningMarker();
            BasedSequence replacedOpenMarker = ((SequenceBuilder)((SequenceBuilder)((SequenceBuilder)openingMarker.getBuilder().append(openingMarker.getEmptyPrefix())).append((CharSequence)useOpeningMarker)).append(openingMarker.getEmptySuffix())).toSequence();
            ((MarkdownWriter)markdown.pushOptions()).preserveSpaces().append(replacedOpenMarker).append(' ').append(markerSuffix).popOptions();
            ((MarkdownWriter)markdown.pushPrefix()).addPrefix(childPrefix, true);
            Node childNode = node.getFirstChild();
            if (childNode != null && node.getFirstChildAnyNot(BlankLine.class) != null) {
                ((MarkdownWriter)markdown.pushPrefix()).addPrefix(additionalItemPrefix, true);
                FIRST_LIST_ITEM_CHILD.set(context.getDocument(), true);
                context.render(childNode);
                FIRST_LIST_ITEM_CHILD.set(context.getDocument(), false);
                markdown.popPrefix();
                while ((childNode = childNode.getNext()) != null) {
                    context.render(childNode);
                }
                if (addBlankLineLooseItems && (node.isLoose() && context.getFormatterOptions().listSpacing == ListSpacing.LOOSEN || context.getFormatterOptions().listSpacing == ListSpacing.LOOSE)) {
                    markdown.tailBlankLine();
                }
            } else if (node.isLoose()) {
                markdown.tailBlankLine();
            } else if (!savedFirstListItemChild) {
                markdown.line();
            }
            markdown.popPrefix();
        }
        FIRST_LIST_ITEM_CHILD.set(context.getDocument(), savedFirstListItemChild);
    }

    public static void renderTextBlockParagraphLines(Node node, NodeFormatterContext context, MarkdownWriter markdown) {
        if (context.isTransformingText()) {
            context.translatingSpan((context1, writer) -> context1.renderChildren(node));
            markdown.line();
        } else {
            FormatterOptions formatterOptions = context.getFormatterOptions();
            if (formatterOptions.rightMargin > 0) {
                int endOffset;
                int startOffset;
                MutableDataHolder subContextOptions = context.getOptions().toMutable().set(Formatter.KEEP_SOFT_LINE_BREAKS, Boolean.valueOf(true)).set(Formatter.KEEP_HARD_LINE_BREAKS, Boolean.valueOf(true));
                SequenceBuilder builder = context.getDocument().getChars().getBuilder();
                NodeFormatterContext subContext = (NodeFormatterContext)context.getSubContext(subContextOptions, builder.getBuilder());
                MarkdownWriter subContextMarkdown = subContext.getMarkdown();
                subContextMarkdown.removeOptions(LineAppendable.F_TRIM_TRAILING_WHITESPACE);
                subContext.renderChildren(node);
                BasedSequence nodeLessEol = (BasedSequence)node.getChars().trimEOL();
                BasedSequence trailingSpaces = (BasedSequence)node.getChars().trimmedEnd();
                if (trailingSpaces.isNotEmpty() && !subContextMarkdown.endsWithEOL()) {
                    subContextMarkdown.append(trailingSpaces);
                }
                subContextMarkdown.line();
                subContextMarkdown.appendToSilently(builder, 0, -1);
                BasedSequence paragraphChars = builder.toSequence();
                BasedSequence altParagraphChars = builder.toSequence(context.getTrackedSequence());
                boolean haveAltSequence = paragraphChars != altParagraphChars;
                TrackedOffsetList trackedOffsets = context.getTrackedOffsets();
                if (haveAltSequence) {
                    BasedSequence charsLessEol = (BasedSequence)altParagraphChars.trimEnd();
                    startOffset = charsLessEol.getStartOffset();
                    int endOffsetDelta = nodeLessEol.countTrailingWhitespace() - charsLessEol.countTrailingWhitespace();
                    endOffset = charsLessEol.getEndOffset() + endOffsetDelta + 1;
                } else {
                    startOffset = nodeLessEol.getStartOffset();
                    endOffset = nodeLessEol.getEndOffset();
                }
                TrackedOffsetList paragraphTrackedOffsets = trackedOffsets.getTrackedOffsets(startOffset, endOffset);
                MarkdownParagraph formatter = new MarkdownParagraph(paragraphChars, altParagraphChars, formatterOptions.charWidthProvider);
                formatter.setOptions(context.getOptions());
                formatter.setWidth(formatterOptions.rightMargin - markdown.getPrefix().length());
                formatter.setKeepSoftBreaks(false);
                formatter.setKeepHardBreaks(formatterOptions.keepHardLineBreaks);
                formatter.setRestoreTrackedSpaces(context.isRestoreTrackedSpaces());
                formatter.setFirstIndent(BasedSequence.NULL);
                formatter.setIndent(BasedSequence.NULL);
                formatter.setFirstWidthOffset(-markdown.column() + markdown.getAfterEolPrefixDelta());
                if (formatterOptions.applySpecialLeadInHandlers) {
                    formatter.setLeadInHandlers(Parser.SPECIAL_LEAD_IN_HANDLERS.get(context.getDocument()));
                }
                for (TrackedOffset trackedOffset : paragraphTrackedOffsets) {
                    formatter.addTrackedOffset(trackedOffset);
                }
                BasedSequence wrappedText = (BasedSequence)formatter.wrapText().toMapped(SpaceMapper.fromNonBreakSpace);
                int startLine = markdown.getLineCount();
                int firstLineOffset = markdown.column();
                ((MarkdownWriter)markdown.pushOptions()).preserveSpaces().append(wrappedText).line().popOptions();
                if (!paragraphTrackedOffsets.isEmpty()) {
                    LineInfo startLineInfo = markdown.getLineInfo(startLine);
                    for (TrackedOffset trackedOffset : paragraphTrackedOffsets) {
                        if (!trackedOffset.isResolved()) continue;
                        int offsetIndex = trackedOffset.getIndex();
                        @NotNull Pair<Integer, Integer> lineColumn = wrappedText.lineColumnAtIndex(offsetIndex);
                        int trackedLine = lineColumn.getFirst();
                        LineInfo lineInfo = markdown.getLineInfo(startLine + trackedLine);
                        int lengthOffset = startLineInfo.sumLength - startLineInfo.length;
                        int prefixDelta = lineInfo.sumPrefixLength - startLineInfo.sumPrefixLength + startLineInfo.prefixLength;
                        int delta = firstLineOffset + lengthOffset + prefixDelta;
                        trackedOffset.setIndex(offsetIndex + delta);
                    }
                }
            } else {
                context.renderChildren(node);
                markdown.line();
            }
        }
    }

    public static void renderBlockQuoteLike(BlockQuoteLike node, NodeFormatterContext context, MarkdownWriter markdown) {
        FormatterOptions formatterOptions = context.getFormatterOptions();
        String combinedPrefix = FormatterUtils.getBlockLikePrefix(node, context, formatterOptions.blockQuoteMarkers, markdown.getPrefix());
        markdown.pushPrefix();
        if (!FIRST_LIST_ITEM_CHILD.get(context.getDocument()).booleanValue()) {
            if (formatterOptions.blockQuoteBlankLines) {
                markdown.blankLine();
            }
            markdown.setPrefix(combinedPrefix, false);
        } else {
            String firstPrefix = FormatterUtils.getBlockLikePrefix(node, context, formatterOptions.blockQuoteMarkers, BasedSequence.NULL);
            ((MarkdownWriter)markdown.pushOptions()).removeOptions(LineAppendable.F_WHITESPACE_REMOVAL).append(firstPrefix).popOptions();
            markdown.setPrefix(combinedPrefix, true);
        }
        int lines = markdown.getLineCountWithPending();
        context.renderChildren((Node)((Object)node));
        markdown.popPrefix();
        if (formatterOptions.blockQuoteBlankLines && lines < markdown.getLineCountWithPending() && !FIRST_LIST_ITEM_CHILD.get(context.getDocument()).booleanValue()) {
            markdown.tailBlankLine();
        }
    }
}

