/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.clion.toolchains.debugger;

import com.intellij.clion.toolchains.debugger.ToolchainsDebuggerBundle;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.jetbrains.cidr.ArchitectureType;
import com.jetbrains.cidr.ToolVersion;
import com.jetbrains.cidr.cpp.toolchains.CLionToolchainDebuggerProvider;
import com.jetbrains.cidr.cpp.toolchains.CPPEnvironment;
import com.jetbrains.cidr.cpp.toolchains.CPPToolSet;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerPathManager;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriverConfiguration;
import com.jetbrains.cidr.execution.debugger.backend.dap.DapDriverConfiguration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\r\u0010\u0006\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0007H\u0016J\b\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J(\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u000bH\u0016\u00a8\u0006\u0017"}, d2={"Lcom/intellij/clion/toolchains/debugger/CLionLldbDapDebuggerProvider;", "Lcom/jetbrains/cidr/cpp/toolchains/CLionToolchainDebuggerProvider;", "<init>", "()V", "getId", "", "getDescription", "Lorg/jetbrains/annotations/Nls;", "getVersion", "Lcom/jetbrains/cidr/ToolVersion;", "isApplicable", "", "toolset", "Lcom/jetbrains/cidr/cpp/toolchains/CPPToolSet;", "createDriverConfiguration", "Lcom/jetbrains/cidr/execution/debugger/backend/DebuggerDriverConfiguration;", "project", "Lcom/intellij/openapi/project/Project;", "environment", "Lcom/jetbrains/cidr/cpp/toolchains/CPPEnvironment;", "isElevated", "isEmulateTerminal", "Companion", "intellij.clion.toolchains.debugger"})
public final class CLionLldbDapDebuggerProvider
implements CLionToolchainDebuggerProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String ID = "clion.lldb.dap";

    @NotNull
    public String getId() {
        return ID;
    }

    @NotNull
    public String getDescription() {
        return ToolchainsDebuggerBundle.INSTANCE.message("bundled.lldb.dap.description", new Object[0]);
    }

    @NotNull
    public ToolVersion getVersion() {
        return new ToolVersion(0, 0, 0);
    }

    public boolean isApplicable(@NotNull CPPToolSet toolset) {
        Intrinsics.checkNotNullParameter((Object)toolset, (String)"toolset");
        return Registry.Companion.is("cidr.debugger.enableLldbDap") && SystemInfo.isUnix;
    }

    @NotNull
    public DebuggerDriverConfiguration createDriverConfiguration(@NotNull Project project, @NotNull CPPEnvironment environment, boolean isElevated, boolean isEmulateTerminal) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        return (DebuggerDriverConfiguration)new DapDriverConfiguration(project){

            public GeneralCommandLine createDriverCommandLine(DebuggerDriver driver, ArchitectureType architectureType) {
                Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
                Intrinsics.checkNotNullParameter((Object)architectureType, (String)"architectureType");
                String lldbDapPath = CidrDebuggerPathManager.getLLDBBinFile((String)"bin/lldb-dap", null, (boolean)true).getPath();
                String[] stringArray = new String[]{lldbDapPath};
                return new GeneralCommandLine(stringArray);
            }

            public Map<String, Object> getDapLaunchOptions(GeneralCommandLine inferiorCmd) {
                Intrinsics.checkNotNullParameter((Object)inferiorCmd, (String)"inferiorCmd");
                Object object = new Pair[]{TuplesKt.to((Object)"type", (Object)"lldb-dap"), TuplesKt.to((Object)"request", (Object)"launch"), TuplesKt.to((Object)"cwd", (Object)String.valueOf(inferiorCmd.getWorkingDirectory())), TuplesKt.to((Object)"program", (Object)inferiorCmd.getExePath()), TuplesKt.to((Object)"args", (Object)inferiorCmd.getParametersList().getParameters())};
                Map launchOptions = MapsKt.mutableMapOf((Pair[])object);
                if (inferiorCmd.isPassParentEnvironment()) {
                    object = launchOptions;
                    String string = "env";
                    Map map = inferiorCmd.getEffectiveEnvironment();
                    Intrinsics.checkNotNullExpressionValue((Object)map, (String)"getEffectiveEnvironment(...)");
                    List<String> list = this.prepareEnv(map);
                    object.put(string, list);
                } else {
                    object = launchOptions;
                    String string = "env";
                    Map map = inferiorCmd.getEnvironment();
                    Intrinsics.checkNotNullExpressionValue((Object)map, (String)"getEnvironment(...)");
                    List<String> list = this.prepareEnv(map);
                    object.put(string, list);
                    launchOptions.put("initCommands", CollectionsKt.listOf((Object)"settings set target.inherit-env false"));
                }
                return launchOptions;
            }

            /*
             * WARNING - void declaration
             */
            private final List<String> prepareEnv(Map<String, String> env) {
                void $this$mapTo$iv$iv;
                Map<String, String> $this$map$iv = env;
                boolean $i$f$map = false;
                Map<String, String> map = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>($this$map$iv.size());
                boolean $i$f$mapTo = false;
                Iterator<Map.Entry<K, V>> iterator = $this$mapTo$iv$iv.entrySet().iterator();
                while (iterator.hasNext()) {
                    void it;
                    Map.Entry<K, V> item$iv$iv;
                    Map.Entry<K, V> entry = item$iv$iv = iterator.next();
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(it.getKey() + "=" + it.getValue());
                }
                return (List)destination$iv$iv;
            }
        };
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/clion/toolchains/debugger/CLionLldbDapDebuggerProvider$Companion;", "", "<init>", "()V", "ID", "", "intellij.clion.toolchains.debugger"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

