/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.execution.testing.ctest;

import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerEx;
import com.intellij.execution.ExecutionTargetManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.ex.AnActionListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.messages.MessageBusConnection;
import com.jetbrains.cidr.cpp.cmake.workspace.CMakeWorkspaceListener;
import com.jetbrains.cidr.cpp.execution.CMakeAppRunConfiguration;
import com.jetbrains.cidr.cpp.execution.testing.ctest.CTestUtil;
import com.jetbrains.cidr.cpp.execution.testing.ctest.CidrCTestBundle;
import com.jetbrains.cidr.cpp.execution.testing.ctest.CidrCTestCommandLineState;
import com.jetbrains.cidr.cpp.execution.testing.ctest.CidrCTestProjectState;
import com.jetbrains.cidr.cpp.execution.testing.ctest.CidrCTestProjectTestInfo;
import com.jetbrains.cidr.execution.build.CidrBuildEvent;
import com.jetbrains.cidr.execution.build.CidrBuildListener;
import com.jetbrains.cidr.execution.build.CidrBuildResult;
import com.jetbrains.cmake.CMakeListsFileType;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public final class CTestProjectTestsUpdater
implements StartupActivity.DumbAware,
ModificationTracker {
    public static final Key<RelativePoint> DEBUG_TEST_SELECTION_DLG_POINT = Key.create((String)"DEBUG_TEST_SELECTION_DLG_POINT");
    private volatile long myTestInfoVersion = 1L;

    public void runActivity(final @NotNull Project project) {
        if (project == null) {
            CTestProjectTestsUpdater.$$$reportNull$$$0(0);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        this.collectTestsInfoInBackground(project);
        MessageBusConnection connection = project.getMessageBus().connect();
        connection.subscribe(ExecutionTargetManager.TOPIC, newTarget -> this.collectTestsInfoInBackground(project));
        connection.subscribe(CMakeWorkspaceListener.TOPIC, (Object)new CMakeWorkspaceListener(){

            public void reloadingFinished(boolean canceled) {
                if (!canceled) {
                    CTestProjectTestsUpdater.this.collectTestsInfoInBackground(project);
                    CTestProjectTestsUpdater.restartCMakeListInspections(project);
                }
            }
        });
        connection.subscribe(CidrBuildListener.TOPIC, (Object)new CidrBuildListener(){

            public void afterFinished(@NotNull CidrBuildEvent buildEvent, @NotNull CidrBuildResult result) {
                if (buildEvent == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (result == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (result.getSucceeded()) {
                    CTestProjectTestsUpdater.this.collectTestsInfoInBackground(project);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "buildEvent";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "result";
                        break;
                    }
                }
                objectArray[1] = "com/jetbrains/cidr/cpp/execution/testing/ctest/CTestProjectTestsUpdater$2";
                objectArray[2] = "afterFinished";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        connection.subscribe(AnActionListener.TOPIC, (Object)new AnActionListener(){

            public void beforeActionPerformed(@NotNull AnAction action, @NotNull AnActionEvent event) {
                String actionClassName;
                if (action == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (event == null) {
                    3.$$$reportNull$$$0(1);
                }
                if ("com.intellij.execution.ExecutorRegistryImpl.ExecutorAction".equals(actionClassName = action.getClass().getCanonicalName())) {
                    DEBUG_TEST_SELECTION_DLG_POINT.set((UserDataHolder)project, null);
                } else if ("com.intellij.execution.actions.RunContextAction".equals(actionClassName)) {
                    DEBUG_TEST_SELECTION_DLG_POINT.set((UserDataHolder)project, (Object)JBPopupFactory.getInstance().guessBestPopupLocation(event.getDataContext()));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "action";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "event";
                        break;
                    }
                }
                objectArray[1] = "com/jetbrains/cidr/cpp/execution/testing/ctest/CTestProjectTestsUpdater$3";
                objectArray[2] = "beforeActionPerformed";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    public static void restartCMakeListInspections(@NotNull Project project) {
        if (project == null) {
            CTestProjectTestsUpdater.$$$reportNull$$$0(1);
        }
        DaemonCodeAnalyzerEx codeAnalyzer = DaemonCodeAnalyzerEx.getInstanceEx((Project)project);
        PsiManager psiManager = PsiManager.getInstance((Project)project);
        ((Stream)Arrays.stream(FileEditorManager.getInstance((Project)project).getAllEditors()).sequential()).map(FileEditor::getFile).filter(vFile -> vFile != null && vFile.getFileType() instanceof CMakeListsFileType).map(vFile -> (PsiFile)ReadAction.compute(() -> psiManager.findFile(vFile))).filter(Objects::nonNull).forEach(arg_0 -> ((DaemonCodeAnalyzerEx)codeAnalyzer).restart(arg_0));
    }

    public void incTestInfoVersion() {
        ++this.myTestInfoVersion;
    }

    public long getModificationCount() {
        return this.myTestInfoVersion;
    }

    private void collectTestsInfoInBackground(final @NotNull Project project) {
        if (project == null) {
            CTestProjectTestsUpdater.$$$reportNull$$$0(2);
        }
        Task.Backgroundable task = new Task.Backgroundable(project, CidrCTestBundle.message("ctest.updating.tests.info", new Object[0]), true){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    4.$$$reportNull$$$0(0);
                }
                CTestProjectTestsUpdater.doCollectTestsInfo(project, indicator);
                CTestProjectTestsUpdater.this.incTestInfoVersion();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/jetbrains/cidr/cpp/execution/testing/ctest/CTestProjectTestsUpdater$4", "run"));
            }
        };
        ProgressManager.getInstance().run((Task)task);
    }

    private static void doCollectTestsInfo(@NotNull Project project, @NotNull ProgressIndicator indicator) {
        if (project == null) {
            CTestProjectTestsUpdater.$$$reportNull$$$0(3);
        }
        if (indicator == null) {
            CTestProjectTestsUpdater.$$$reportNull$$$0(4);
        }
        try {
            CidrCTestProjectState state = (CidrCTestProjectState)project.getService(CidrCTestProjectState.class);
            CMakeAppRunConfiguration.BuildAndRunConfigurations configurations = CMakeAppRunConfiguration.getSelectedBuildAndRunConfigurations((Project)project);
            if (configurations == null) {
                CTestUtil.LOG.info("No selected configuration");
                state.setTests(null, null);
                return;
            }
            List<CidrCTestProjectTestInfo> tests = CTestUtil.getInfos(project, indicator, configurations.buildConfiguration, CidrCTestCommandLineState.getTestListParams(null, configurations.buildConfiguration));
            state.setTests(tests, configurations.buildConfiguration);
            if (tests != null && !tests.isEmpty()) {
                CTestUtil.createDefaultRunConfigurationForTests(project);
            }
        }
        catch (Exception e) {
            CTestUtil.LOG.warn(CidrCTestBundle.message("ctest.error.json.any", new Object[0]), (Throwable)e);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/cidr/cpp/execution/testing/ctest/CTestProjectTestsUpdater";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "runActivity";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "restartCMakeListInspections";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "collectTestsInfoInBackground";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "doCollectTestsInfo";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

