/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.util;

import com.intellij.database.model.DasTable;
import com.intellij.database.util.GridColumnAlias;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0010\u0011\n\u0002\b\u0018\b\u0086\b\u0018\u00002\u00020\u0001Ba\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00050\u0003\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\t\u0012\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u000b0\u0003\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\r\u00a2\u0006\u0004\b\u000f\u0010\u0010BI\b\u0016\u0012\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00050\t\u0012\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u000b0\u0003\u0012\b\b\u0002\u0010\u000e\u001a\u00020\r\u00a2\u0006\u0004\b\u000f\u0010\u0014B\u0011\b\u0016\u0012\u0006\u0010\u0015\u001a\u00020\u0005\u00a2\u0006\u0004\b\u000f\u0010\u0016J\u0011\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00050\u0019\u00a2\u0006\u0002\u0010\u001aJ\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u001c\u001a\u00020\u0004J\u0006\u0010\u001d\u001a\u00020\rJ\u000e\u0010\u001e\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u0005J\u0006\u0010\u000e\u001a\u00020\rJ\u000e\u0010\u001f\u001a\u00020\r2\u0006\u0010\u001c\u001a\u00020\u0004J\u0010\u0010 \u001a\u0004\u0018\u00010\u00072\u0006\u0010\u001c\u001a\u00020\u0004J\u0015\u0010&\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003H\u00c2\u0003J\u0015\u0010'\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00050\u0003H\u00c2\u0003J\u000f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00050\tH\u00c2\u0003J\u0015\u0010)\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u000b0\u0003H\u00c2\u0003J\t\u0010*\u001a\u00020\rH\u00c6\u0003J\t\u0010+\u001a\u00020\rH\u00c2\u0003Jo\u0010,\u001a\u00020\u00002\u0014\b\u0002\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u00032\u0014\b\u0002\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00050\u00032\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\t2\u0014\b\u0002\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u000b0\u00032\b\b\u0002\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\rH\u00c6\u0001J\u0013\u0010-\u001a\u00020\r2\b\u0010.\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010/\u001a\u00020\u0004H\u00d6\u0001J\t\u00100\u001a\u00020\u0007H\u00d6\u0001R\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u000b0\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0017R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010!\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\u0017R\u0011\u0010\"\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\u0017R\u0011\u0010#\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b$\u0010%\u00a8\u00061"}, d2={"Lcom/intellij/database/util/GridTablesModel;", "", "myColumnIndexes2Tables", "", "", "Lcom/intellij/database/model/DasTable;", "myTablesMap", "", "myTablesWithMergeAllowed", "", "columnsWithAlias", "Lcom/intellij/database/util/GridColumnAlias;", "isForSingleTable", "", "isNotEditable", "<init>", "(Ljava/util/Map;Ljava/util/Map;Ljava/util/Set;Ljava/util/Map;ZZ)V", "columnIndexes2Tables", "tablesWithMergeAllowed", "columnsWithAliases", "(Ljava/util/Map;Ljava/util/Set;Ljava/util/Map;Z)V", "table", "(Lcom/intellij/database/model/DasTable;)V", "()Z", "getDasTables", "", "()[Lcom/intellij/database/model/DasTable;", "getDasTableByColumnIndex", "columnIndex", "hasSingleTable", "isMergeAllowed", "isColumnWithAlias", "getRealColumnName", "isTablesEmpty", "isColumnsEmpty", "firstTable", "getFirstTable", "()Lcom/intellij/database/model/DasTable;", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "other", "hashCode", "toString", "intellij.database"})
@SourceDebugExtension(value={"SMAP\nGridTablesModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GridTablesModel.kt\ncom/intellij/database/util/GridTablesModel\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,71:1\n1208#2,2:72\n1236#2,4:74\n37#3:78\n36#3,3:79\n*S KotlinDebug\n*F\n+ 1 GridTablesModel.kt\ncom/intellij/database/util/GridTablesModel\n*L\n17#1:72,2\n17#1:74,4\n35#1:78\n35#1:79,3\n*E\n"})
public final class GridTablesModel {
    @NotNull
    private final Map<Integer, DasTable> myColumnIndexes2Tables;
    @NotNull
    private final Map<String, DasTable> myTablesMap;
    @NotNull
    private final Set<DasTable> myTablesWithMergeAllowed;
    @NotNull
    private final Map<Integer, GridColumnAlias> columnsWithAlias;
    private final boolean isForSingleTable;
    private final boolean isNotEditable;

    public GridTablesModel(@NotNull Map<Integer, ? extends DasTable> myColumnIndexes2Tables, @NotNull Map<String, ? extends DasTable> myTablesMap, @NotNull Set<? extends DasTable> myTablesWithMergeAllowed, @NotNull Map<Integer, GridColumnAlias> columnsWithAlias, boolean isForSingleTable, boolean isNotEditable) {
        Intrinsics.checkNotNullParameter(myColumnIndexes2Tables, (String)"myColumnIndexes2Tables");
        Intrinsics.checkNotNullParameter(myTablesMap, (String)"myTablesMap");
        Intrinsics.checkNotNullParameter(myTablesWithMergeAllowed, (String)"myTablesWithMergeAllowed");
        Intrinsics.checkNotNullParameter(columnsWithAlias, (String)"columnsWithAlias");
        this.myColumnIndexes2Tables = myColumnIndexes2Tables;
        this.myTablesMap = myTablesMap;
        this.myTablesWithMergeAllowed = myTablesWithMergeAllowed;
        this.columnsWithAlias = columnsWithAlias;
        this.isForSingleTable = isForSingleTable;
        this.isNotEditable = isNotEditable;
    }

    public final boolean isForSingleTable() {
        return this.isForSingleTable;
    }

    /*
     * WARNING - void declaration
     */
    public GridTablesModel(@NotNull Map<Integer, ? extends DasTable> columnIndexes2Tables, @NotNull Set<? extends DasTable> tablesWithMergeAllowed, @NotNull Map<Integer, GridColumnAlias> columnsWithAliases, boolean isNotEditable) {
        void $this$associateByTo$iv$iv;
        void $this$associateBy$iv;
        Intrinsics.checkNotNullParameter(columnIndexes2Tables, (String)"columnIndexes2Tables");
        Intrinsics.checkNotNullParameter(tablesWithMergeAllowed, (String)"tablesWithMergeAllowed");
        Intrinsics.checkNotNullParameter(columnsWithAliases, (String)"columnsWithAliases");
        Iterable iterable = columnIndexes2Tables.values();
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        void var9_8 = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            DasTable dasTable = (DasTable)element$iv$iv;
            Map map = destination$iv$iv;
            boolean bl = false;
            map.put(it.getName(), element$iv$iv);
        }
        Map map = MapsKt.toMap((Map)destination$iv$iv);
        this(columnIndexes2Tables, map, tablesWithMergeAllowed, columnsWithAliases, false, isNotEditable);
    }

    public /* synthetic */ GridTablesModel(Map map, Set set, Map map2, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            bl = false;
        }
        this(map, set, map2, bl);
    }

    public GridTablesModel(@NotNull DasTable table) {
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        this((Map<Integer, ? extends DasTable>)MapsKt.emptyMap(), MapsKt.mapOf((Pair)TuplesKt.to((Object)table.getName(), (Object)table)), SetsKt.setOf((Object)table), MapsKt.emptyMap(), true, false);
    }

    @NotNull
    public final DasTable[] getDasTables() {
        Collection<DasTable> $this$toTypedArray$iv = this.myTablesMap.values();
        boolean $i$f$toTypedArray = false;
        Collection<DasTable> thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new DasTable[0]);
    }

    @Nullable
    public final DasTable getDasTableByColumnIndex(int columnIndex) {
        return this.myColumnIndexes2Tables.get(columnIndex);
    }

    public final boolean hasSingleTable() {
        return this.myTablesMap.size() == 1;
    }

    public final boolean isMergeAllowed(@NotNull DasTable table) {
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        return this.myTablesWithMergeAllowed.contains(table);
    }

    public final boolean isNotEditable() {
        return this.isNotEditable;
    }

    public final boolean isColumnWithAlias(int columnIndex) {
        return this.columnsWithAlias.containsKey(columnIndex);
    }

    @Nullable
    public final String getRealColumnName(int columnIndex) {
        GridColumnAlias gridColumnAlias = this.columnsWithAlias.get(columnIndex);
        if (gridColumnAlias == null) {
            return null;
        }
        GridColumnAlias aliasItem = gridColumnAlias;
        return aliasItem.getRealName();
    }

    public final boolean isTablesEmpty() {
        return this.myTablesMap.isEmpty();
    }

    public final boolean isColumnsEmpty() {
        return this.myColumnIndexes2Tables.isEmpty();
    }

    @NotNull
    public final DasTable getFirstTable() {
        return (DasTable)CollectionsKt.first((Iterable)this.myTablesMap.values());
    }

    private final Map<Integer, DasTable> component1() {
        return this.myColumnIndexes2Tables;
    }

    private final Map<String, DasTable> component2() {
        return this.myTablesMap;
    }

    private final Set<DasTable> component3() {
        return this.myTablesWithMergeAllowed;
    }

    private final Map<Integer, GridColumnAlias> component4() {
        return this.columnsWithAlias;
    }

    public final boolean component5() {
        return this.isForSingleTable;
    }

    private final boolean component6() {
        return this.isNotEditable;
    }

    @NotNull
    public final GridTablesModel copy(@NotNull Map<Integer, ? extends DasTable> myColumnIndexes2Tables, @NotNull Map<String, ? extends DasTable> myTablesMap, @NotNull Set<? extends DasTable> myTablesWithMergeAllowed, @NotNull Map<Integer, GridColumnAlias> columnsWithAlias, boolean isForSingleTable, boolean isNotEditable) {
        Intrinsics.checkNotNullParameter(myColumnIndexes2Tables, (String)"myColumnIndexes2Tables");
        Intrinsics.checkNotNullParameter(myTablesMap, (String)"myTablesMap");
        Intrinsics.checkNotNullParameter(myTablesWithMergeAllowed, (String)"myTablesWithMergeAllowed");
        Intrinsics.checkNotNullParameter(columnsWithAlias, (String)"columnsWithAlias");
        return new GridTablesModel(myColumnIndexes2Tables, myTablesMap, myTablesWithMergeAllowed, columnsWithAlias, isForSingleTable, isNotEditable);
    }

    public static /* synthetic */ GridTablesModel copy$default(GridTablesModel gridTablesModel, Map map, Map map2, Set set, Map map3, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 1) != 0) {
            map = gridTablesModel.myColumnIndexes2Tables;
        }
        if ((n & 2) != 0) {
            map2 = gridTablesModel.myTablesMap;
        }
        if ((n & 4) != 0) {
            set = gridTablesModel.myTablesWithMergeAllowed;
        }
        if ((n & 8) != 0) {
            map3 = gridTablesModel.columnsWithAlias;
        }
        if ((n & 0x10) != 0) {
            bl = gridTablesModel.isForSingleTable;
        }
        if ((n & 0x20) != 0) {
            bl2 = gridTablesModel.isNotEditable;
        }
        return gridTablesModel.copy(map, map2, set, map3, bl, bl2);
    }

    @NotNull
    public String toString() {
        return "GridTablesModel(myColumnIndexes2Tables=" + this.myColumnIndexes2Tables + ", myTablesMap=" + this.myTablesMap + ", myTablesWithMergeAllowed=" + this.myTablesWithMergeAllowed + ", columnsWithAlias=" + this.columnsWithAlias + ", isForSingleTable=" + this.isForSingleTable + ", isNotEditable=" + this.isNotEditable + ")";
    }

    public int hashCode() {
        int result2 = ((Object)this.myColumnIndexes2Tables).hashCode();
        result2 = result2 * 31 + ((Object)this.myTablesMap).hashCode();
        result2 = result2 * 31 + ((Object)this.myTablesWithMergeAllowed).hashCode();
        result2 = result2 * 31 + ((Object)this.columnsWithAlias).hashCode();
        result2 = result2 * 31 + Boolean.hashCode(this.isForSingleTable);
        result2 = result2 * 31 + Boolean.hashCode(this.isNotEditable);
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof GridTablesModel)) {
            return false;
        }
        GridTablesModel gridTablesModel = (GridTablesModel)other;
        if (!Intrinsics.areEqual(this.myColumnIndexes2Tables, gridTablesModel.myColumnIndexes2Tables)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.myTablesMap, gridTablesModel.myTablesMap)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.myTablesWithMergeAllowed, gridTablesModel.myTablesWithMergeAllowed)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.columnsWithAlias, gridTablesModel.columnsWithAlias)) {
            return false;
        }
        if (this.isForSingleTable != gridTablesModel.isForSingleTable) {
            return false;
        }
        return this.isNotEditable == gridTablesModel.isNotEditable;
    }
}

