/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.util;

import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.ObjectPathTrie;
import com.intellij.database.util.ObjectPathTrieImpl;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class ObjectPathRefTrie<V>
implements ObjectPathTrie<V> {
    protected final ReferenceQueue<V> myQueue;
    private final ObjectPathTrieImpl<Reference<? extends V>> myTrie;

    ObjectPathRefTrie(@NotNull ObjectPathTrieImpl.MapFactory mapFactory) {
        if (mapFactory == null) {
            ObjectPathRefTrie.$$$reportNull$$$0(0);
        }
        this.myQueue = new ReferenceQueue();
        this.myTrie = new ObjectPathTrieImpl(mapFactory);
    }

    @Override
    public void clear() {
        this.myTrie.clear();
        this.processQueue();
    }

    @Override
    @NotNull
    public List<? extends V> clearAndCollectValues() {
        List res = this.myTrie.removeCascadeAndCollectValuesImpl(null).map(Reference::get).toList();
        this.processQueue();
        List list = res;
        if (list == null) {
            ObjectPathRefTrie.$$$reportNull$$$0(1);
        }
        return list;
    }

    @Override
    public V put(@NotNull ObjectPath path, V value) {
        if (path == null) {
            ObjectPathRefTrie.$$$reportNull$$$0(2);
        }
        this.processQueue();
        return this.extract(this.myTrie.put(path, this.store(path, value)));
    }

    @Override
    public V putIfAbsent(@NotNull ObjectPath path, V value) {
        if (path == null) {
            ObjectPathRefTrie.$$$reportNull$$$0(3);
        }
        this.processQueue();
        return this.extract(this.myTrie.putIfAbsent(path, this.store(path, value)));
    }

    protected abstract Reference<V> store(@NotNull ObjectPath var1, V var2);

    @Override
    public V get(@NotNull ObjectPath path) {
        if (path == null) {
            ObjectPathRefTrie.$$$reportNull$$$0(4);
        }
        return this.extract(this.myTrie.get(path));
    }

    @Override
    public V remove(@NotNull ObjectPath path) {
        if (path == null) {
            ObjectPathRefTrie.$$$reportNull$$$0(5);
        }
        this.processQueue();
        return this.extract(this.myTrie.remove(path));
    }

    @Override
    public boolean remove(@NotNull ObjectPath path, V value) {
        if (path == null) {
            ObjectPathRefTrie.$$$reportNull$$$0(6);
        }
        this.processQueue();
        return this.myTrie.remove(path, this.store(path, value));
    }

    @Override
    public boolean removeCascade(@NotNull ObjectPath path) {
        if (path == null) {
            ObjectPathRefTrie.$$$reportNull$$$0(7);
        }
        boolean res = this.myTrie.removeCascade(path);
        this.processQueue();
        return res;
    }

    @Override
    @NotNull
    public List<? extends V> removeCascadeAndCollectValues(@NotNull ObjectPath path) {
        if (path == null) {
            ObjectPathRefTrie.$$$reportNull$$$0(8);
        }
        List res = this.myTrie.removeCascadeAndCollectValuesImpl(path).map(Reference::get).toList();
        this.processQueue();
        List list = res;
        if (list == null) {
            ObjectPathRefTrie.$$$reportNull$$$0(9);
        }
        return list;
    }

    @Override
    public boolean contains(@NotNull ObjectPath path) {
        if (path == null) {
            ObjectPathRefTrie.$$$reportNull$$$0(10);
        }
        return this.myTrie.contains(path);
    }

    @Override
    @NotNull
    public Iterable<ObjectPath> getChildren(@Nullable ObjectPath path) {
        Iterable<ObjectPath> iterable = this.myTrie.getChildren(path);
        if (iterable == null) {
            ObjectPathRefTrie.$$$reportNull$$$0(11);
        }
        return iterable;
    }

    @Nullable
    private V extract(Reference<? extends V> res) {
        return res == null ? null : (V)res.get();
    }

    private void processQueue() {
        Reference<V> ref;
        while ((ref = this.myQueue.poll()) != null) {
            ObjectPath key2 = ((KeyProvider)((Object)ref)).getKey();
            this.myTrie.remove(key2, ref);
        }
    }

    static <V> ObjectPathTrie<V> createSoftValueTrie(@NotNull ObjectPathTrieImpl.MapFactory mapFactory) {
        if (mapFactory == null) {
            ObjectPathRefTrie.$$$reportNull$$$0(12);
        }
        return new ObjectPathRefTrie<V>(mapFactory){

            @Override
            protected Reference<V> store(@NotNull ObjectPath path, V value) {
                if (path == null) {
                    1.$$$reportNull$$$0(0);
                }
                return new MySoftRef(path, value, this.myQueue);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/database/util/ObjectPathRefTrie$1", "store"));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 9, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mapFactory";
                break;
            }
            case 1: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/util/ObjectPathRefTrie";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/util/ObjectPathRefTrie";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "clearAndCollectValues";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "removeCascadeAndCollectValues";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 9: 
            case 11: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "put";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "putIfAbsent";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "get";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "remove";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "removeCascade";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "removeCascadeAndCollectValues";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "contains";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createSoftValueTrie";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 9, 11 -> new IllegalStateException(string);
        };
    }

    private static interface KeyProvider {
        @NotNull
        public ObjectPath getKey();
    }

    private static class MySoftRef<V>
    extends SoftReference<V>
    implements KeyProvider {
        private final ObjectPath myKey;

        private MySoftRef(@NotNull ObjectPath key2, V referent, ReferenceQueue<? super V> q) {
            if (key2 == null) {
                MySoftRef.$$$reportNull$$$0(0);
            }
            super(referent, q);
            this.myKey = key2;
        }

        @Override
        @NotNull
        public ObjectPath getKey() {
            ObjectPath objectPath = this.myKey;
            if (objectPath == null) {
                MySoftRef.$$$reportNull$$$0(1);
            }
            return objectPath;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MySoftRef that = (MySoftRef)o;
            Object v = this.get();
            Object thatV = that.get();
            return this.myKey.equals(that.getKey()) && v != null && v.equals(thatV);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "key";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/util/ObjectPathRefTrie$MySoftRef";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/util/ObjectPathRefTrie$MySoftRef";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getKey";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

