/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.mysql;

import com.intellij.codeInsight.generation.CommenterDataHolder;
import com.intellij.codeInsight.generation.SelfManagingCommenter;
import com.intellij.codeInsight.generation.SelfManagingCommenterUtil;
import com.intellij.database.sql.common.core.psi.impl.support.SqlCommenter;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.util.text.CharArrayUtil;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MysqlCommenter
extends SqlCommenter
implements SelfManagingCommenter {
    public static final String SHARP_LINE_PREFIX = "# ";
    public static final String SHARP_LINE_PREFIX_NO_SPACE = "#";
    public static final String[] PREFIXES = new String[]{"# ", "-- ", "#"};

    @Override
    public String getLineCommentPrefix() {
        return SHARP_LINE_PREFIX;
    }

    @NotNull
    public List<String> getLineCommentPrefixes() {
        List<String> list = Arrays.asList(PREFIXES);
        if (list == null) {
            MysqlCommenter.$$$reportNull$$$0(0);
        }
        return list;
    }

    @Override
    public IElementType getLineCommentTokenType() {
        return SqlTokens.MYSQL_LINE_COMMENT;
    }

    @Nullable
    public CommenterDataHolder createLineCommentingState(int startLine, int endLine, @NotNull Document document, @NotNull PsiFile file) {
        if (document == null) {
            MysqlCommenter.$$$reportNull$$$0(1);
        }
        if (file == null) {
            MysqlCommenter.$$$reportNull$$$0(2);
        }
        return null;
    }

    @Nullable
    public CommenterDataHolder createBlockCommentingState(int selectionStart, int selectionEnd, @NotNull Document document, @NotNull PsiFile file) {
        if (document == null) {
            MysqlCommenter.$$$reportNull$$$0(3);
        }
        if (file == null) {
            MysqlCommenter.$$$reportNull$$$0(4);
        }
        return null;
    }

    public void commentLine(int line, int offset, @NotNull Document document, @NotNull CommenterDataHolder data) {
        if (document == null) {
            MysqlCommenter.$$$reportNull$$$0(5);
        }
        if (data == null) {
            MysqlCommenter.$$$reportNull$$$0(6);
        }
        document.insertString(offset, (CharSequence)SHARP_LINE_PREFIX);
    }

    public void uncommentLine(int line, int offset, @NotNull Document document, @NotNull CommenterDataHolder data) {
        if (document == null) {
            MysqlCommenter.$$$reportNull$$$0(7);
        }
        if (data == null) {
            MysqlCommenter.$$$reportNull$$$0(8);
        }
        if (offset == 0 && line > 0) {
            return;
        }
        for (String p2 : PREFIXES) {
            if (!CharArrayUtil.regionMatches((CharSequence)document.getCharsSequence(), (int)offset, (CharSequence)p2)) continue;
            document.deleteString(offset, offset + p2.length());
            break;
        }
    }

    public boolean isLineCommented(int line, int offset, @NotNull Document document, @NotNull CommenterDataHolder data) {
        if (document == null) {
            MysqlCommenter.$$$reportNull$$$0(9);
        }
        if (data == null) {
            MysqlCommenter.$$$reportNull$$$0(10);
        }
        CharSequence sequence = document.getCharsSequence();
        for (String p2 : PREFIXES) {
            if (!CharArrayUtil.regionMatches((CharSequence)sequence, (int)offset, (CharSequence)p2)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public String getCommentPrefix(int line, @NotNull Document document, @NotNull CommenterDataHolder data) {
        if (document == null) {
            MysqlCommenter.$$$reportNull$$$0(11);
        }
        if (data == null) {
            MysqlCommenter.$$$reportNull$$$0(12);
        }
        return this.getLineCommentPrefix();
    }

    @Nullable
    public TextRange getBlockCommentRange(int selectionStart, int selectionEnd, @NotNull Document document, @NotNull CommenterDataHolder data) {
        if (document == null) {
            MysqlCommenter.$$$reportNull$$$0(13);
        }
        if (data == null) {
            MysqlCommenter.$$$reportNull$$$0(14);
        }
        return SelfManagingCommenterUtil.getBlockCommentRange((int)selectionStart, (int)selectionEnd, (Document)document, (String)this.getBlockCommentPrefix(), (String)this.getBlockCommentSuffix());
    }

    @Nullable
    public String getBlockCommentPrefix(int selectionStart, @NotNull Document document, @NotNull CommenterDataHolder data) {
        if (document == null) {
            MysqlCommenter.$$$reportNull$$$0(15);
        }
        if (data == null) {
            MysqlCommenter.$$$reportNull$$$0(16);
        }
        return this.getBlockCommentPrefix();
    }

    @Nullable
    public String getBlockCommentSuffix(int selectionEnd, @NotNull Document document, @NotNull CommenterDataHolder data) {
        if (document == null) {
            MysqlCommenter.$$$reportNull$$$0(17);
        }
        if (data == null) {
            MysqlCommenter.$$$reportNull$$$0(18);
        }
        return this.getBlockCommentSuffix();
    }

    public void uncommentBlockComment(int startOffset, int endOffset, Document document, CommenterDataHolder data) {
        SelfManagingCommenterUtil.uncommentBlockComment((int)startOffset, (int)endOffset, (Document)document, (String)this.getBlockCommentPrefix(), (String)this.getBlockCommentSuffix());
    }

    @NotNull
    public TextRange insertBlockComment(int startOffset, int endOffset, Document document, CommenterDataHolder data) {
        TextRange textRange = SelfManagingCommenterUtil.insertBlockComment((int)startOffset, (int)endOffset, (Document)document, (String)this.getBlockCommentPrefix(), (String)this.getBlockCommentSuffix());
        if (textRange == null) {
            MysqlCommenter.$$$reportNull$$$0(19);
        }
        return textRange;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/dialects/mysql/MysqlCommenter";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getLineCommentPrefixes";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/dialects/mysql/MysqlCommenter";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "insertBlockComment";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createLineCommentingState";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createBlockCommentingState";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "commentLine";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "uncommentLine";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isLineCommented";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getCommentPrefix";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getBlockCommentRange";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getBlockCommentPrefix";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getBlockCommentSuffix";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18 -> new IllegalArgumentException(string);
        };
    }
}

