/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.algorithm;

import org.locationtech.jts.algorithm.ConvexHull;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineSegment;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.Polygon;

public class MinimumDiameter {
    private final Geometry inputGeom;
    private final boolean isConvex;
    private Coordinate[] convexHullPts = null;
    private LineSegment minBaseSeg = new LineSegment();
    private Coordinate minWidthPt = null;
    private int minPtIndex;
    private double minWidth = 0.0;

    public static Geometry getMinimumRectangle(Geometry geom) {
        return new MinimumDiameter(geom).getMinimumRectangle();
    }

    public static Geometry getMinimumDiameter(Geometry geom) {
        return new MinimumDiameter(geom).getDiameter();
    }

    public MinimumDiameter(Geometry inputGeom) {
        this(inputGeom, false);
    }

    public MinimumDiameter(Geometry inputGeom, boolean isConvex) {
        this.inputGeom = inputGeom;
        this.isConvex = isConvex;
    }

    public double getLength() {
        this.computeMinimumDiameter();
        return this.minWidth;
    }

    public Coordinate getWidthCoordinate() {
        this.computeMinimumDiameter();
        return this.minWidthPt;
    }

    public LineString getSupportingSegment() {
        this.computeMinimumDiameter();
        return this.inputGeom.getFactory().createLineString(new Coordinate[]{this.minBaseSeg.p0, this.minBaseSeg.p1});
    }

    public LineString getDiameter() {
        this.computeMinimumDiameter();
        if (this.minWidthPt == null) {
            return this.inputGeom.getFactory().createLineString();
        }
        Coordinate basePt = this.minBaseSeg.project(this.minWidthPt);
        return this.inputGeom.getFactory().createLineString(new Coordinate[]{basePt, this.minWidthPt});
    }

    private void computeMinimumDiameter() {
        if (this.minWidthPt != null) {
            return;
        }
        if (this.isConvex) {
            this.computeWidthConvex(this.inputGeom);
        } else {
            Geometry convexGeom = new ConvexHull(this.inputGeom).getConvexHull();
            this.computeWidthConvex(convexGeom);
        }
    }

    private void computeWidthConvex(Geometry convexGeom) {
        this.convexHullPts = convexGeom instanceof Polygon ? ((Polygon)convexGeom).getExteriorRing().getCoordinates() : convexGeom.getCoordinates();
        if (this.convexHullPts.length == 0) {
            this.minWidth = 0.0;
            this.minWidthPt = null;
            this.minBaseSeg = null;
        } else if (this.convexHullPts.length == 1) {
            this.minWidth = 0.0;
            this.minWidthPt = this.convexHullPts[0];
            this.minBaseSeg.p0 = this.convexHullPts[0];
            this.minBaseSeg.p1 = this.convexHullPts[0];
        } else if (this.convexHullPts.length == 2 || this.convexHullPts.length == 3) {
            this.minWidth = 0.0;
            this.minWidthPt = this.convexHullPts[0];
            this.minBaseSeg.p0 = this.convexHullPts[0];
            this.minBaseSeg.p1 = this.convexHullPts[1];
        } else {
            this.computeConvexRingMinDiameter(this.convexHullPts);
        }
    }

    private void computeConvexRingMinDiameter(Coordinate[] pts) {
        this.minWidth = Double.MAX_VALUE;
        int currMaxIndex = 1;
        LineSegment seg = new LineSegment();
        for (int i2 = 0; i2 < pts.length - 1; ++i2) {
            seg.p0 = pts[i2];
            seg.p1 = pts[i2 + 1];
            currMaxIndex = this.findMaxPerpDistance(pts, seg, currMaxIndex);
        }
    }

    private int findMaxPerpDistance(Coordinate[] pts, LineSegment seg, int startIndex) {
        int maxIndex;
        double maxPerpDistance;
        double nextPerpDistance = maxPerpDistance = seg.distancePerpendicular(pts[startIndex]);
        int nextIndex = maxIndex = startIndex;
        while (nextPerpDistance >= maxPerpDistance) {
            maxPerpDistance = nextPerpDistance;
            maxIndex = nextIndex;
            if ((nextIndex = MinimumDiameter.nextIndex(pts, maxIndex)) == startIndex) break;
            nextPerpDistance = seg.distancePerpendicular(pts[nextIndex]);
        }
        if (maxPerpDistance < this.minWidth) {
            this.minPtIndex = maxIndex;
            this.minWidth = maxPerpDistance;
            this.minWidthPt = pts[this.minPtIndex];
            this.minBaseSeg = new LineSegment(seg);
        }
        return maxIndex;
    }

    private static int nextIndex(Coordinate[] pts, int index) {
        if (++index >= pts.length) {
            index = 0;
        }
        return index;
    }

    public Geometry getMinimumRectangle() {
        this.computeMinimumDiameter();
        if (this.minWidth == 0.0) {
            if (this.minBaseSeg.p0.equals2D(this.minBaseSeg.p1)) {
                return this.inputGeom.getFactory().createPoint(this.minBaseSeg.p0);
            }
            return MinimumDiameter.computeMaximumLine(this.convexHullPts, this.inputGeom.getFactory());
        }
        double dx = this.minBaseSeg.p1.x - this.minBaseSeg.p0.x;
        double dy = this.minBaseSeg.p1.y - this.minBaseSeg.p0.y;
        double minPara = Double.MAX_VALUE;
        double maxPara = -1.7976931348623157E308;
        double minPerp = Double.MAX_VALUE;
        double maxPerp = -1.7976931348623157E308;
        for (int i2 = 0; i2 < this.convexHullPts.length; ++i2) {
            double perpC;
            double paraC = MinimumDiameter.computeC(dx, dy, this.convexHullPts[i2]);
            if (paraC > maxPara) {
                maxPara = paraC;
            }
            if (paraC < minPara) {
                minPara = paraC;
            }
            if ((perpC = MinimumDiameter.computeC(-dy, dx, this.convexHullPts[i2])) > maxPerp) {
                maxPerp = perpC;
            }
            if (!(perpC < minPerp)) continue;
            minPerp = perpC;
        }
        LineSegment maxPerpLine = MinimumDiameter.computeSegmentForLine(-dx, -dy, maxPerp);
        LineSegment minPerpLine = MinimumDiameter.computeSegmentForLine(-dx, -dy, minPerp);
        LineSegment maxParaLine = MinimumDiameter.computeSegmentForLine(-dy, dx, maxPara);
        LineSegment minParaLine = MinimumDiameter.computeSegmentForLine(-dy, dx, minPara);
        Coordinate p0 = maxParaLine.lineIntersection(maxPerpLine);
        Coordinate p1 = minParaLine.lineIntersection(maxPerpLine);
        Coordinate p2 = minParaLine.lineIntersection(minPerpLine);
        Coordinate p3 = maxParaLine.lineIntersection(minPerpLine);
        LinearRing shell = this.inputGeom.getFactory().createLinearRing(new Coordinate[]{p0, p1, p2, p3, p0});
        return this.inputGeom.getFactory().createPolygon(shell);
    }

    private static LineString computeMaximumLine(Coordinate[] pts, GeometryFactory factory) {
        Coordinate ptMinX = null;
        Coordinate ptMaxX = null;
        Coordinate ptMinY = null;
        Coordinate ptMaxY = null;
        for (Coordinate p2 : pts) {
            if (ptMinX == null || p2.getX() < ptMinX.getX()) {
                ptMinX = p2;
            }
            if (ptMaxX == null || p2.getX() > ptMaxX.getX()) {
                ptMaxX = p2;
            }
            if (ptMinY == null || p2.getY() < ptMinY.getY()) {
                ptMinY = p2;
            }
            if (ptMaxY != null && !(p2.getY() > ptMaxY.getY())) continue;
            ptMaxY = p2;
        }
        Coordinate p0 = ptMinX;
        Coordinate p1 = ptMaxX;
        if (p0.getX() == p1.getX()) {
            p0 = ptMinY;
            p1 = ptMaxY;
        }
        return factory.createLineString(new Coordinate[]{p0.copy(), p1.copy()});
    }

    private static double computeC(double a, double b, Coordinate p2) {
        return a * p2.y - b * p2.x;
    }

    private static LineSegment computeSegmentForLine(double a, double b, double c2) {
        Coordinate p1;
        Coordinate p0;
        if (Math.abs(b) > Math.abs(a)) {
            p0 = new Coordinate(0.0, c2 / b);
            p1 = new Coordinate(1.0, c2 / b - a / b);
        } else {
            p0 = new Coordinate(c2 / a, 0.0);
            p1 = new Coordinate(c2 / a - b / a, 1.0);
        }
        return new LineSegment(p0, p1);
    }
}

