/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.geom.prep;

import java.util.List;
import org.locationtech.jts.algorithm.PointLocator;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.prep.PreparedGeometry;
import org.locationtech.jts.geom.util.ComponentCoordinateExtracter;

class BasicPreparedGeometry
implements PreparedGeometry {
    private final Geometry baseGeom;
    private final List representativePts;

    public BasicPreparedGeometry(Geometry geom) {
        this.baseGeom = geom;
        this.representativePts = ComponentCoordinateExtracter.getCoordinates(geom);
    }

    @Override
    public Geometry getGeometry() {
        return this.baseGeom;
    }

    public List getRepresentativePoints() {
        return this.representativePts;
    }

    public boolean isAnyTargetComponentInTest(Geometry testGeom) {
        PointLocator locator = new PointLocator();
        for (Coordinate p2 : this.representativePts) {
            if (!locator.intersects(p2, testGeom)) continue;
            return true;
        }
        return false;
    }

    protected boolean envelopesIntersect(Geometry g) {
        return this.baseGeom.getEnvelopeInternal().intersects(g.getEnvelopeInternal());
    }

    protected boolean envelopeCovers(Geometry g) {
        return this.baseGeom.getEnvelopeInternal().covers(g.getEnvelopeInternal());
    }

    @Override
    public boolean contains(Geometry g) {
        return this.baseGeom.contains(g);
    }

    @Override
    public boolean containsProperly(Geometry g) {
        if (!this.baseGeom.getEnvelopeInternal().contains(g.getEnvelopeInternal())) {
            return false;
        }
        return this.baseGeom.relate(g, "T**FF*FF*");
    }

    @Override
    public boolean coveredBy(Geometry g) {
        return this.baseGeom.coveredBy(g);
    }

    @Override
    public boolean covers(Geometry g) {
        return this.baseGeom.covers(g);
    }

    @Override
    public boolean crosses(Geometry g) {
        return this.baseGeom.crosses(g);
    }

    @Override
    public boolean disjoint(Geometry g) {
        return !this.intersects(g);
    }

    @Override
    public boolean intersects(Geometry g) {
        return this.baseGeom.intersects(g);
    }

    @Override
    public boolean overlaps(Geometry g) {
        return this.baseGeom.overlaps(g);
    }

    @Override
    public boolean touches(Geometry g) {
        return this.baseGeom.touches(g);
    }

    @Override
    public boolean within(Geometry g) {
        return this.baseGeom.within(g);
    }

    public String toString() {
        return this.baseGeom.toString();
    }
}

