/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dts.documentation;

import com.intellij.dts.documentation.DtsDocumentationHtmlBuilder;
import com.intellij.dts.documentation.DtsDocumentationTarget;
import com.intellij.dts.lang.psi.DtsNode;
import com.intellij.dts.lang.psi.DtsProperty;
import com.intellij.dts.util.DtsTreeUtil;
import com.intellij.dts.zephyr.binding.DtsZephyrBinding;
import com.intellij.dts.zephyr.binding.DtsZephyrBindingProvider;
import com.intellij.dts.zephyr.binding.DtsZephyrPropertyBinding;
import com.intellij.model.Pointer;
import com.intellij.openapi.project.Project;
import com.intellij.platform.backend.documentation.DocumentationTarget;
import com.intellij.platform.backend.presentation.TargetPresentation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointersKt;
import com.intellij.psi.SmartPsiElementPointer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u0007H\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/dts/documentation/DtsPropertyDocumentationTarget;", "Lcom/intellij/dts/documentation/DtsDocumentationTarget;", "property", "Lcom/intellij/dts/lang/psi/DtsProperty;", "<init>", "(Lcom/intellij/dts/lang/psi/DtsProperty;)V", "createPointer", "Lcom/intellij/model/Pointer;", "Lcom/intellij/platform/backend/documentation/DocumentationTarget;", "computePresentation", "Lcom/intellij/platform/backend/presentation/TargetPresentation;", "buildDocumentation", "", "html", "Lcom/intellij/dts/documentation/DtsDocumentationHtmlBuilder;", "intellij.dts"})
@SourceDebugExtension(value={"SMAP\nDtsPropertyDocumentationTarget.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DtsPropertyDocumentationTarget.kt\ncom/intellij/dts/documentation/DtsPropertyDocumentationTarget\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,34:1\n1#2:35\n*E\n"})
public final class DtsPropertyDocumentationTarget
extends DtsDocumentationTarget {
    @NotNull
    private final DtsProperty property;

    public DtsPropertyDocumentationTarget(@NotNull DtsProperty property) {
        Intrinsics.checkNotNullParameter((Object)property, (String)"property");
        Project project = property.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        super(project);
        this.property = property;
    }

    @NotNull
    public Pointer<? extends DocumentationTarget> createPointer() {
        SmartPsiElementPointer propertyPtr = SmartPointersKt.createSmartPointer((PsiElement)this.property);
        return () -> DtsPropertyDocumentationTarget.createPointer$lambda$1(propertyPtr);
    }

    @NotNull
    public TargetPresentation computePresentation() {
        TargetPresentation targetPresentation = TargetPresentation.Companion.builder(this.property.getDtsName()).icon(this.property.getIcon(0)).presentation();
        Intrinsics.checkNotNullExpressionValue((Object)targetPresentation, (String)"presentation(...)");
        return targetPresentation;
    }

    @Override
    protected void buildDocumentation(@NotNull DtsDocumentationHtmlBuilder html) {
        Intrinsics.checkNotNullParameter((Object)html, (String)"html");
        this.buildPropertyName(html, this.property.getDtsName());
        DtsNode dtsNode = DtsTreeUtil.INSTANCE.parentNode(this.property);
        if (dtsNode == null) {
            return;
        }
        DtsNode parent = dtsNode;
        this.buildDeclaredIn(html, parent);
        DtsZephyrBinding dtsZephyrBinding = DtsZephyrBindingProvider.Companion.bindingFor$default(DtsZephyrBindingProvider.Companion, parent, false, 2, null);
        if (dtsZephyrBinding == null) {
            return;
        }
        DtsZephyrBinding binding = dtsZephyrBinding;
        DtsZephyrPropertyBinding dtsZephyrPropertyBinding = binding.getProperties().get(this.property.getDtsName());
        if (dtsZephyrPropertyBinding == null) {
            return;
        }
        DtsZephyrPropertyBinding propertyBinding = dtsZephyrPropertyBinding;
        this.buildPropertyBinding(html, propertyBinding);
    }

    private static final DtsPropertyDocumentationTarget createPointer$lambda$1(SmartPsiElementPointer $propertyPtr) {
        DtsPropertyDocumentationTarget dtsPropertyDocumentationTarget;
        DtsProperty dtsProperty = (DtsProperty)$propertyPtr.dereference();
        if (dtsProperty != null) {
            DtsProperty it = dtsProperty;
            boolean bl = false;
            dtsPropertyDocumentationTarget = new DtsPropertyDocumentationTarget(it);
        } else {
            dtsPropertyDocumentationTarget = null;
        }
        return dtsPropertyDocumentationTarget;
    }
}

