/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dts.lang.psi;

import com.intellij.dts.api.DtsPath;
import com.intellij.dts.lang.psi.DtsNode;
import com.intellij.dts.lang.psi.DtsProperty;
import com.intellij.dts.lang.psi.DtsRefNode;
import com.intellij.dts.lang.psi.DtsStatement;
import com.intellij.dts.lang.psi.DtsString;
import com.intellij.dts.util.DtsTreeUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u00002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\u001a\u000f\u0010\u0000\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0002*\u00020\u0003\u001a\u000f\u0010\u0000\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0002*\u00020\u0004\u001a\n\u0010\u0005\u001a\u00020\u0006*\u00020\u0003\u001a\n\u0010\u0005\u001a\u00020\u0006*\u00020\u0004\u001a\f\u0010\u0007\u001a\u0004\u0018\u00010\u0003*\u00020\b\u001a\n\u0010\t\u001a\u00020\n*\u00020\u0003\u001a\f\u0010\u000b\u001a\u0004\u0018\u00010\f*\u00020\u0003\u001a\u0010\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00010\u000e*\u00020\u0003\u00a8\u0006\u000f"}, d2={"getDtsPresentableText", "", "Lcom/intellij/openapi/util/NlsSafe;", "Lcom/intellij/dts/lang/psi/DtsNode;", "Lcom/intellij/dts/lang/psi/DtsStatement;", "getDtsAnnotationTarget", "Lcom/intellij/psi/PsiElement;", "getDtsReferenceTarget", "Lcom/intellij/dts/lang/psi/DtsNode$Ref;", "isDtsRootNode", "", "getDtsPath", "Lcom/intellij/dts/api/DtsPath;", "getDtsCompatibleStrings", "", "intellij.dts"})
@SourceDebugExtension(value={"SMAP\nDtsPsiUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DtsPsiUtil.kt\ncom/intellij/dts/lang/psi/DtsPsiUtilKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,101:1\n295#2,2:102\n808#2,11:104\n1563#2:115\n1634#2,3:116\n*S KotlinDebug\n*F\n+ 1 DtsPsiUtil.kt\ncom/intellij/dts/lang/psi/DtsPsiUtilKt\n*L\n86#1:102,2\n89#1:104,11\n89#1:115\n89#1:116,3\n*E\n"})
public final class DtsPsiUtilKt {
    @NotNull
    public static final String getDtsPresentableText(@NotNull DtsNode $this$getDtsPresentableText) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$getDtsPresentableText, (String)"<this>");
        DtsNode dtsNode = $this$getDtsPresentableText;
        if (dtsNode instanceof DtsNode.Ref) {
            String string2 = ((DtsNode.Ref)$this$getDtsPresentableText).getDtsHandle().getText();
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
        } else if (dtsNode instanceof DtsNode.Root) {
            string = "/";
        } else if (dtsNode instanceof DtsNode.Sub) {
            string = ((DtsNode.Sub)$this$getDtsPresentableText).getDtsName();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string;
    }

    @NotNull
    public static final String getDtsPresentableText(@NotNull DtsStatement $this$getDtsPresentableText) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$getDtsPresentableText, (String)"<this>");
        DtsStatement dtsStatement = $this$getDtsPresentableText;
        if (dtsStatement instanceof DtsStatement.CompilerDirective) {
            String string2 = ((DtsStatement.CompilerDirective)$this$getDtsPresentableText).getDtsDirective().getText();
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
        } else if (dtsStatement instanceof DtsStatement.Node) {
            string = DtsPsiUtilKt.getDtsPresentableText((DtsNode)$this$getDtsPresentableText);
        } else if (dtsStatement instanceof DtsStatement.Property) {
            string = ((DtsStatement.Property)$this$getDtsPresentableText).getDtsName();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string;
    }

    @NotNull
    public static final PsiElement getDtsAnnotationTarget(@NotNull DtsNode $this$getDtsAnnotationTarget) {
        PsiElement psiElement;
        Intrinsics.checkNotNullParameter((Object)$this$getDtsAnnotationTarget, (String)"<this>");
        DtsNode dtsNode = $this$getDtsAnnotationTarget;
        if (dtsNode instanceof DtsNode.Ref) {
            psiElement = ((DtsNode.Ref)$this$getDtsAnnotationTarget).getDtsHandle();
        } else if (dtsNode instanceof DtsNode.Root) {
            psiElement = ((DtsNode.Root)$this$getDtsAnnotationTarget).getDtsSlash();
        } else if (dtsNode instanceof DtsNode.Sub) {
            psiElement = ((DtsNode.Sub)$this$getDtsAnnotationTarget).getDtsNameElement();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return psiElement;
    }

    @NotNull
    public static final PsiElement getDtsAnnotationTarget(@NotNull DtsStatement $this$getDtsAnnotationTarget) {
        PsiElement psiElement;
        Intrinsics.checkNotNullParameter((Object)$this$getDtsAnnotationTarget, (String)"<this>");
        DtsStatement dtsStatement = $this$getDtsAnnotationTarget;
        if (dtsStatement instanceof DtsStatement.CompilerDirective) {
            psiElement = ((DtsStatement.CompilerDirective)$this$getDtsAnnotationTarget).getDtsDirective();
        } else if (dtsStatement instanceof DtsStatement.Node) {
            psiElement = DtsPsiUtilKt.getDtsAnnotationTarget((DtsNode)$this$getDtsAnnotationTarget);
        } else if (dtsStatement instanceof DtsStatement.Property) {
            psiElement = ((DtsStatement.Property)$this$getDtsAnnotationTarget).getDtsNameElement();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return psiElement;
    }

    @Nullable
    public static final DtsNode getDtsReferenceTarget(@NotNull DtsNode.Ref $this$getDtsReferenceTarget) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$getDtsReferenceTarget, (String)"<this>");
        PsiReference psiReference = $this$getDtsReferenceTarget.getDtsHandle().getReference();
        if (psiReference == null) {
            return null;
        }
        PsiReference reference = psiReference;
        if (reference instanceof PsiPolyVariantReference) {
            ResolveResult[] resolveResultArray = ((PsiPolyVariantReference)reference).multiResolve(false);
            Intrinsics.checkNotNullExpressionValue((Object)resolveResultArray, (String)"multiResolve(...)");
            ResolveResult resolveResult = (ResolveResult)ArraysKt.firstOrNull((Object[])resolveResultArray);
            object = resolveResult != null ? resolveResult.getElement() : null;
        } else {
            object = reference.resolve();
        }
        PsiElement target = object;
        return target instanceof DtsNode ? (DtsNode)target : null;
    }

    public static final boolean isDtsRootNode(@NotNull DtsNode $this$isDtsRootNode) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$isDtsRootNode, (String)"<this>");
        DtsNode dtsNode = $this$isDtsRootNode;
        if (dtsNode instanceof DtsNode.Ref) {
            DtsNode dtsNode2 = DtsPsiUtilKt.getDtsReferenceTarget((DtsNode.Ref)$this$isDtsRootNode);
            bl = dtsNode2 != null ? DtsPsiUtilKt.isDtsRootNode(dtsNode2) : false;
        } else if (dtsNode instanceof DtsNode.Root) {
            bl = true;
        } else if (dtsNode instanceof DtsNode.Sub) {
            bl = false;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return bl;
    }

    @Nullable
    public static final DtsPath getDtsPath(@NotNull DtsNode $this$getDtsPath) {
        Intrinsics.checkNotNullParameter((Object)$this$getDtsPath, (String)"<this>");
        List pathSegments = new ArrayList();
        DtsNode node = $this$getDtsPath;
        while (node != null) {
            DtsNode dtsNode;
            DtsNode dtsNode2 = node;
            if (dtsNode2 instanceof DtsNode.Root) {
                dtsNode = null;
            } else if (dtsNode2 instanceof DtsNode.Ref) {
                dtsNode = DtsPsiUtilKt.getDtsReferenceTarget((DtsNode.Ref)node);
                if (dtsNode == null) {
                    return null;
                }
            } else if (dtsNode2 instanceof DtsNode.Sub) {
                pathSegments.add(((DtsNode.Sub)node).getDtsName());
                dtsNode = DtsTreeUtil.INSTANCE.parentNode(node);
            } else {
                throw new NoWhenBranchMatchedException();
            }
            node = dtsNode;
        }
        return new DtsPath(true, CollectionsKt.reversed((Iterable)pathSegments));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<String> getDtsCompatibleStrings(@NotNull DtsNode $this$getDtsCompatibleStrings) {
        List string;
        Object v0;
        block7: {
            Intrinsics.checkNotNullParameter((Object)$this$getDtsCompatibleStrings, (String)"<this>");
            Iterable $this$firstOrNull$iv = $this$getDtsCompatibleStrings.getDtsProperties();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                DtsProperty it = (DtsProperty)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getDtsName(), (Object)"compatible")) continue;
                v0 = element$iv;
                break block7;
            }
            v0 = null;
        }
        DtsProperty property = v0;
        if (property != null) {
            void $this$mapTo$iv$iv;
            Iterable $this$filterIsInstanceTo$iv$iv;
            Object element$iv;
            Iterable $this$filterIsInstance$iv = property.getDtsValues();
            boolean $i$f$filterIsInstance = false;
            element$iv = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof DtsString)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterIsInstanceTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void p0;
                DtsString dtsString = (DtsString)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add((String)p0.dtsParse());
            }
            v1 = (List)destination$iv$iv;
        } else {
            v1 = string = CollectionsKt.emptyList();
        }
        if (!string.isEmpty() || !($this$getDtsCompatibleStrings instanceof DtsRefNode)) {
            return string;
        }
        DtsNode dtsNode = DtsPsiUtilKt.getDtsReferenceTarget((DtsNode.Ref)$this$getDtsCompatibleStrings);
        if (dtsNode == null) {
            return CollectionsKt.emptyList();
        }
        DtsNode target = dtsNode;
        return DtsPsiUtilKt.getDtsCompatibleStrings(target);
    }
}

