/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dts.lang.psi.mixin;

import com.intellij.dts.lang.psi.DtsProperty;
import com.intellij.dts.lang.psi.DtsString;
import com.intellij.dts.lang.resolve.DtsBindingReference;
import com.intellij.dts.util.DtsTextRangeKt;
import com.intellij.dts.util.DtsTreeUtil;
import com.intellij.dts.util.DtsUtil;
import com.intellij.extapi.psi.ASTWrapperPsiElement;
import com.intellij.lang.ASTNode;
import com.intellij.model.psi.PsiSymbolReference;
import com.intellij.openapi.util.TextRange;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u000b\u001a\u00020\fH\u0016J\u000e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0016R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0010"}, d2={"Lcom/intellij/dts/lang/psi/mixin/DtsStringMixin;", "Lcom/intellij/extapi/psi/ASTWrapperPsiElement;", "Lcom/intellij/dts/lang/psi/DtsString;", "node", "Lcom/intellij/lang/ASTNode;", "<init>", "(Lcom/intellij/lang/ASTNode;)V", "dtsValueRange", "Lcom/intellij/openapi/util/TextRange;", "getDtsValueRange", "()Lcom/intellij/openapi/util/TextRange;", "dtsParse", "", "getOwnReferences", "", "Lcom/intellij/model/psi/PsiSymbolReference;", "intellij.dts"})
public abstract class DtsStringMixin
extends ASTWrapperPsiElement
implements DtsString {
    public DtsStringMixin(@NotNull ASTNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        super(node);
    }

    @Override
    @NotNull
    public TextRange getDtsValueRange() {
        TextRange textRange = this.getTextRange();
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getTextRange(...)");
        String string = this.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        char[] cArray = new char[]{'\"'};
        return DtsTextRangeKt.trim(textRange, string, cArray);
    }

    @Override
    @NotNull
    public String dtsParse() {
        String string = this.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        char[] cArray = new char[]{'\"'};
        return StringsKt.trim((String)string, (char[])cArray);
    }

    @NotNull
    public Collection<PsiSymbolReference> getOwnReferences() {
        return DtsUtil.INSTANCE.singleResult(() -> DtsStringMixin.getOwnReferences$lambda$0(this));
    }

    private static final DtsBindingReference getOwnReferences$lambda$0(DtsStringMixin this$0) {
        DtsProperty dtsProperty = DtsTreeUtil.INSTANCE.parentProperty(this$0);
        if (dtsProperty == null) {
            return null;
        }
        DtsProperty property = dtsProperty;
        if (!Intrinsics.areEqual((Object)property.getDtsName(), (Object)"compatible")) {
            return null;
        }
        return new DtsBindingReference(this$0);
    }
}

