/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dts.lang.resolve.files;

import com.intellij.dts.lang.psi.FileInclude;
import com.intellij.dts.zephyr.DtsZephyrBoard;
import com.intellij.dts.zephyr.DtsZephyrProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\nH\u0016R\u0018\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\b\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\f"}, d2={"Lcom/intellij/dts/lang/resolve/files/DtsOverlayFile;", "Lcom/intellij/dts/lang/psi/FileInclude;", "<init>", "()V", "offset", "", "getOffset", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "resolve", "Lcom/intellij/psi/PsiFile;", "anchor", "intellij.dts"})
public final class DtsOverlayFile
implements FileInclude {
    @NotNull
    public static final DtsOverlayFile INSTANCE = new DtsOverlayFile();
    @Nullable
    private static final Integer offset;

    private DtsOverlayFile() {
    }

    @Override
    @Nullable
    public Integer getOffset() {
        return offset;
    }

    @Override
    @Nullable
    public PsiFile resolve(@NotNull PsiFile anchor) {
        Intrinsics.checkNotNullParameter((Object)anchor, (String)"anchor");
        VirtualFile context = anchor.getOriginalFile().getVirtualFile();
        if (context == null || !context.isValid()) {
            return null;
        }
        String name = context.getNameWithoutExtension() + ".dts";
        Project project = anchor.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        DtsZephyrBoard dtsZephyrBoard = DtsZephyrProvider.Companion.of(project).getBoard();
        if (dtsZephyrBoard == null) {
            return null;
        }
        DtsZephyrBoard board = dtsZephyrBoard;
        List candidates = new ArrayList();
        VfsUtilCore.processFilesRecursively((VirtualFile)board.getFile(), arg_0 -> DtsOverlayFile.resolve$lambda$1(arg_0 -> DtsOverlayFile.resolve$lambda$0(name, candidates, arg_0), arg_0));
        return (PsiFile)SequencesKt.firstOrNull((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)candidates), arg_0 -> DtsOverlayFile.resolve$lambda$2(anchor, arg_0)));
    }

    private static final boolean resolve$lambda$0(String $name, List $candidates, VirtualFile virtualFile) {
        if (Intrinsics.areEqual((Object)virtualFile.getName(), (Object)$name)) {
            Intrinsics.checkNotNull((Object)virtualFile);
            $candidates.add(virtualFile);
        }
        return true;
    }

    private static final boolean resolve$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final PsiFile resolve$lambda$2(PsiFile $anchor, VirtualFile virtualFile) {
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        return $anchor.getManager().findFile(virtualFile);
    }
}

