/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.CollectionFactory;
import com.jetbrains.cidr.lang.CLanguageKind;
import com.jetbrains.cidr.lang.CUDALanguageKind;
import com.jetbrains.cidr.lang.OCFileTypeHelper;
import com.jetbrains.cidr.lang.OCLanguageKind;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import kotlin.collections.SetsKt;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class OCFileTypeHelpers {
    private static final Logger LOG = Logger.getInstance((String)("#" + OCFileTypeHelpers.class.getPackage().getName()));
    private static final Map<@NonNls String, ExtensionDescriptor> EXTENSIONS = CollectionFactory.createSmallMemoryFootprintMap();
    private static final Set<@NonNls String> HEADER_EXTENSIONS;
    private static final Set<@NonNls String> SOURCE_EXTENSIONS;
    private static final Set<@NonNls String> MODULE_EXTENSIONS;
    private static final Set<@NonNls String> ALL_EXTENSIONS;
    private static final Set<@NonNls String> OBJ_EXTENSIONS;

    @NotNull
    public static List<OCFileTypeHelper> getHelpers() {
        List list = OCFileTypeHelper.EP_NAME.getExtensionsIfPointIsRegistered();
        if (list == null) {
            OCFileTypeHelpers.$$$reportNull$$$0(0);
        }
        return list;
    }

    @Nullable
    private static ExtensionDescriptor getDescriptor(@NotNull String extension) {
        if (extension == null) {
            OCFileTypeHelpers.$$$reportNull$$$0(1);
        }
        String lower = extension.toLowerCase(Locale.getDefault());
        ExtensionDescriptor descriptor = EXTENSIONS.get(lower);
        if (lower.equals(extension) || descriptor != null && !descriptor.myIsCaseSensitive) {
            return descriptor;
        }
        return EXTENSIONS.get(extension);
    }

    public static boolean isHeaderFile(@Nullable PsiFile file) {
        return file != null && OCFileTypeHelpers.isHeaderFile(file.getName());
    }

    public static boolean isHeaderFile(@Nullable String filename) {
        if (filename == null) {
            return false;
        }
        ExtensionDescriptor descriptor = OCFileTypeHelpers.getDescriptor(FileUtilRt.getExtension((String)filename));
        if (descriptor != null) {
            return descriptor.myIsHeader;
        }
        for (OCFileTypeHelper each : OCFileTypeHelpers.getHelpers()) {
            if (!each.isHeaderFile(filename)) continue;
            return true;
        }
        return false;
    }

    public static boolean isSourceFile(@Nullable PsiFile file) {
        return file != null && OCFileTypeHelpers.isSourceFile(file.getName());
    }

    public static boolean isSourceFile(@Nullable String filename) {
        if (filename == null) {
            return false;
        }
        ExtensionDescriptor descriptor = OCFileTypeHelpers.getDescriptor(FileUtilRt.getExtension((String)filename));
        if (descriptor != null) {
            return !descriptor.myIsHeader;
        }
        for (OCFileTypeHelper each : OCFileTypeHelpers.getHelpers()) {
            if (each.isHeaderFile(filename)) {
                return false;
            }
            if (!each.isSourceFile(filename)) continue;
            return true;
        }
        return false;
    }

    public static boolean isModuleFile(@Nullable PsiFile file) {
        return file != null && OCFileTypeHelpers.isModuleFile(file.getName());
    }

    public static boolean isModuleFile(@Nullable String filename) {
        if (filename == null) {
            return false;
        }
        ExtensionDescriptor descriptor = OCFileTypeHelpers.getDescriptor(FileUtilRt.getExtension((String)filename));
        if (descriptor != null) {
            return !descriptor.myIsHeader && descriptor.myLanguageKind.isCpp();
        }
        return false;
    }

    public static boolean isAlwaysRoot(@NotNull String filename) {
        if (filename == null) {
            OCFileTypeHelpers.$$$reportNull$$$0(2);
        }
        for (OCFileTypeHelper each : OCFileTypeHelpers.getHelpers()) {
            if (!each.isAlwaysRoot(filename)) continue;
            return true;
        }
        return false;
    }

    public static boolean isKnownFileType(@Nullable String filename) {
        if (filename == null) {
            return false;
        }
        return OCFileTypeHelpers.getDescriptor(FileUtilRt.getExtension((String)filename)) != null;
    }

    @Nullable
    public static OCLanguageKind getLanguageKind(@Nullable String filename) {
        if (filename == null) {
            return null;
        }
        ExtensionDescriptor descriptor = OCFileTypeHelpers.getDescriptor(FileUtilRt.getExtension((String)filename));
        return descriptor != null ? descriptor.myLanguageKind : null;
    }

    @Nullable
    public static OCLanguageKind getLanguageKindStrict(@Nullable String filename) {
        if (filename == null) {
            return null;
        }
        ExtensionDescriptor descriptor = OCFileTypeHelpers.getDescriptor(FileUtilRt.getExtension((String)filename));
        return descriptor != null && !descriptor.myIsAmbiguous ? descriptor.myLanguageKind : null;
    }

    public static boolean isCppFile(@Nullable String filename) {
        OCLanguageKind kind = OCFileTypeHelpers.getLanguageKind(filename);
        return kind != null && kind.isCpp();
    }

    public static boolean isCudaFile(@Nullable String filename) {
        OCLanguageKind kind = OCFileTypeHelpers.getLanguageKind(filename);
        return kind != null && kind.isCuda();
    }

    private static Set<String> collectExtensions(Predicate<? super Map.Entry<String, ExtensionDescriptor>> predicate) {
        Set extensionsSet = CollectionFactory.createCaseInsensitiveStringSet();
        return EXTENSIONS.entrySet().stream().filter(predicate).map(entry -> ((String)entry.getKey()).toLowerCase(Locale.getDefault())).collect(Collectors.toCollection(() -> extensionsSet));
    }

    public static Set<String> headerExtensions() {
        return HEADER_EXTENSIONS;
    }

    public static Set<String> moduleExtensions() {
        return MODULE_EXTENSIONS;
    }

    public static Set<String> sourceExtensions() {
        return SOURCE_EXTENSIONS;
    }

    public static Set<String> allExtensions() {
        return ALL_EXTENSIONS;
    }

    public static Set<String> objExtensions() {
        return OBJ_EXTENSIONS;
    }

    static {
        try {
            EXTENSIONS.put("c", new ExtensionDescriptor((OCLanguageKind)CLanguageKind.C, false, true));
            EXTENSIONS.put("i", new ExtensionDescriptor((OCLanguageKind)CLanguageKind.C, false));
            EXTENSIONS.put("h", new ExtensionDescriptor((OCLanguageKind)CLanguageKind.C, true, true, true, false));
            EXTENSIONS.put("inl", new ExtensionDescriptor((OCLanguageKind)CLanguageKind.C, true));
            EXTENSIONS.put("", new ExtensionDescriptor((OCLanguageKind)CLanguageKind.CPP, true));
            EXTENSIONS.put("ii", new ExtensionDescriptor((OCLanguageKind)CLanguageKind.CPP, false));
            EXTENSIONS.put("cc", new ExtensionDescriptor((OCLanguageKind)CLanguageKind.CPP, false));
            EXTENSIONS.put("cp", new ExtensionDescriptor((OCLanguageKind)CLanguageKind.CPP, false));
            EXTENSIONS.put("cxx", new ExtensionDescriptor((OCLanguageKind)CLanguageKind.CPP, false));
            EXTENSIONS.put("cpp", new ExtensionDescriptor((OCLanguageKind)CLanguageKind.CPP, false));
            EXTENSIONS.put("c++", new ExtensionDescriptor((OCLanguageKind)CLanguageKind.CPP, false));
            EXTENSIONS.put("ixx", new ExtensionDescriptor((OCLanguageKind)CLanguageKind.CPP, false, false, false, true));
            EXTENSIONS.put("mxx", new ExtensionDescriptor((OCLanguageKind)CLanguageKind.CPP, false, false, false, true));
            EXTENSIONS.put("cppm", new ExtensionDescriptor((OCLanguageKind)CLanguageKind.CPP, false, false, false, true));
            EXTENSIONS.put("ccm", new ExtensionDescriptor((OCLanguageKind)CLanguageKind.CPP, false, false, false, true));
            EXTENSIONS.put("cxxm", new ExtensionDescriptor((OCLanguageKind)CLanguageKind.CPP, false, false, false, true));
            EXTENSIONS.put("c++m", new ExtensionDescriptor((OCLanguageKind)CLanguageKind.CPP, false, false, false, true));
            EXTENSIONS.put("hh", new ExtensionDescriptor((OCLanguageKind)CLanguageKind.CPP, true));
            EXTENSIONS.put("hp", new ExtensionDescriptor((OCLanguageKind)CLanguageKind.CPP, true));
            EXTENSIONS.put("hxx", new ExtensionDescriptor((OCLanguageKind)CLanguageKind.CPP, true));
            EXTENSIONS.put("hpp", new ExtensionDescriptor((OCLanguageKind)CLanguageKind.CPP, true));
            EXTENSIONS.put("h++", new ExtensionDescriptor((OCLanguageKind)CLanguageKind.CPP, true));
            EXTENSIONS.put("tcc", new ExtensionDescriptor((OCLanguageKind)CLanguageKind.CPP, true));
            EXTENSIONS.put("tpp", new ExtensionDescriptor((OCLanguageKind)CLanguageKind.CPP, true));
            EXTENSIONS.put("icc", new ExtensionDescriptor((OCLanguageKind)CLanguageKind.CPP, true));
            EXTENSIONS.put("ipp", new ExtensionDescriptor((OCLanguageKind)CLanguageKind.CPP, true));
            EXTENSIONS.put("ino", new ExtensionDescriptor((OCLanguageKind)CLanguageKind.CPP, true));
            EXTENSIONS.put("pch", new ExtensionDescriptor((OCLanguageKind)CLanguageKind.CPP, true));
            EXTENSIONS.put("cu", new ExtensionDescriptor((OCLanguageKind)CUDALanguageKind.CUDA, false));
            EXTENSIONS.put("cuh", new ExtensionDescriptor((OCLanguageKind)CUDALanguageKind.CUDA, true));
            EXTENSIONS.put("m", new ExtensionDescriptor((OCLanguageKind)CLanguageKind.OBJ_C, false, true));
            EXTENSIONS.put("mm", new ExtensionDescriptor((OCLanguageKind)CLanguageKind.OBJ_CPP, false));
            EXTENSIONS.put("C", new ExtensionDescriptor((OCLanguageKind)CLanguageKind.CPP, false, true));
            EXTENSIONS.put("H", new ExtensionDescriptor((OCLanguageKind)CLanguageKind.CPP, true, true));
            EXTENSIONS.put("M", new ExtensionDescriptor((OCLanguageKind)CLanguageKind.OBJ_CPP, false, true));
            HEADER_EXTENSIONS = Collections.unmodifiableSet(OCFileTypeHelpers.collectExtensions(entry -> ((ExtensionDescriptor)entry.getValue()).myIsHeader));
            SOURCE_EXTENSIONS = Collections.unmodifiableSet(OCFileTypeHelpers.collectExtensions(entry -> !((ExtensionDescriptor)entry.getValue()).myIsHeader && !((ExtensionDescriptor)entry.getValue()).myIsModule));
            MODULE_EXTENSIONS = Collections.unmodifiableSet(OCFileTypeHelpers.collectExtensions(entry -> !((ExtensionDescriptor)entry.getValue()).myIsHeader && ((ExtensionDescriptor)entry.getValue()).myLanguageKind.equals(CLanguageKind.CPP) && !((ExtensionDescriptor)entry.getValue()).myIsCaseSensitive));
            ALL_EXTENSIONS = Collections.unmodifiableSet(OCFileTypeHelpers.collectExtensions(entry -> true));
            OBJ_EXTENSIONS = SetsKt.setOf((Object[])new String[]{"", "o", "obj", "so", "bin", "elf", "exe", "lib", "a", "dll", "axf", "prx", "puff", "ko", "mod", "COM", "dylib", "bundle", "acm", "ax", "cpl", "drv", "efi", "mui", "ocx", "scr", "sys", "tsp"});
        }
        catch (Throwable e) {
            try {
                LOG.error(e);
            }
            catch (Throwable e2) {
                e.addSuppressed(e2);
            }
            throw e;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/OCFileTypeHelpers";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extension";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filename";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getHelpers";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/OCFileTypeHelpers";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getDescriptor";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isAlwaysRoot";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2 -> new IllegalArgumentException(string);
        };
    }

    private static class ExtensionDescriptor {
        @NotNull
        public final OCLanguageKind myLanguageKind;
        public final boolean myIsHeader;
        public final boolean myIsCaseSensitive;
        public final boolean myIsAmbiguous;
        public final boolean myIsModule;

        ExtensionDescriptor(@NotNull OCLanguageKind languageKind, boolean isHeader, boolean isCaseSensitive, boolean isAmbiguous, boolean isModule) {
            if (languageKind == null) {
                ExtensionDescriptor.$$$reportNull$$$0(0);
            }
            this.myLanguageKind = languageKind;
            this.myIsHeader = isHeader;
            this.myIsCaseSensitive = isCaseSensitive;
            this.myIsAmbiguous = isAmbiguous;
            this.myIsModule = isModule;
        }

        ExtensionDescriptor(@NotNull OCLanguageKind languageKind, boolean isHeader, boolean isCaseSensitive) {
            if (languageKind == null) {
                ExtensionDescriptor.$$$reportNull$$$0(1);
            }
            this(languageKind, isHeader, isCaseSensitive, false, false);
        }

        ExtensionDescriptor(@NotNull OCLanguageKind languageKind, boolean isHeader) {
            if (languageKind == null) {
                ExtensionDescriptor.$$$reportNull$$$0(2);
            }
            this(languageKind, isHeader, false);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "languageKind", "com/jetbrains/cidr/lang/OCFileTypeHelpers$ExtensionDescriptor", "<init>"));
        }
    }
}

