/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.settings;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.DifferenceFilter;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.CustomCodeStyleSettings;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.PluginUtils;
import com.jetbrains.cidr.lang.OCFileType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class CidrCodeStyleSettings
extends CustomCodeStyleSettings {
    protected static final Logger LOG = Logger.getInstance(DefaultJDOMExternalizer.class);
    public static final int NEW_LINE_NEVER = 0;
    public static final int NEW_LINE_ALWAYS = 1;
    public static final int NEW_LINE_IF_LONG = 2;
    public boolean DO_NOT_ADD_BREAKS = false;
    public int INDENT_NAMESPACE_MEMBERS;
    public int INDENT_C_STRUCT_MEMBERS;
    public int INDENT_CLASS_MEMBERS;
    public int INDENT_INTERFACE_MEMBERS;
    public boolean INDENT_BLOCK_COMMENT;
    public boolean INDENT_INTERFACE_MEMBERS_EXCEPT_IVARS_BLOCK;
    public int INDENT_IMPLEMENTATION_MEMBERS;
    public int INDENT_VISIBILITY_KEYWORDS;
    public int INDENT_INSIDE_CODE_BLOCK;
    public int INDENT_PREPROCESSOR_DIRECTIVE;
    public boolean INDENT_DIRECTIVE_AS_CODE;
    public boolean KEEP_STRUCTURES_IN_ONE_LINE;
    public boolean KEEP_CASE_EXPRESSIONS_IN_ONE_LINE;
    public boolean KEEP_NESTED_NAMESPACES_IN_ONE_LINE;
    public boolean KEEP_DIRECTIVE_AT_FIRST_COLUMN;
    @CommonCodeStyleSettings.BraceStyleConstant
    public int NAMESPACE_BRACE_PLACEMENT;
    @CommonCodeStyleSettings.BraceStyleConstant
    public int METHOD_BRACE_PLACEMENT;
    @CommonCodeStyleSettings.BraceStyleConstant
    public int FUNCTION_BRACE_PLACEMENT;
    @CommonCodeStyleSettings.BraceStyleConstant
    public int BLOCK_BRACE_PLACEMENT;
    @CommonCodeStyleSettings.WrapConstant
    public int METHOD_PARAMETERS_WRAP;
    public boolean METHOD_PARAMETERS_ALIGN_MULTILINE;
    public boolean METHOD_PARAMETERS_ALIGN_BY_COLONS;
    @CommonCodeStyleSettings.WrapConstant
    public int METHOD_CALL_ARGUMENTS_WRAP;
    public boolean METHOD_CALL_ARGUMENTS_ALIGN_MULTILINE;
    public boolean METHOD_CALL_ARGUMENTS_ALIGN_BY_COLONS;
    public boolean METHOD_CALL_ARGUMENTS_SPECIAL_DICTIONARY_PAIRS_TREATMENT;
    @CommonCodeStyleSettings.WrapConstant
    public int FUNCTION_NON_TOP_AFTER_RETURN_TYPE_WRAP;
    @CommonCodeStyleSettings.WrapConstant
    public int FUNCTION_TOP_AFTER_RETURN_TYPE_WRAP;
    @CommonCodeStyleSettings.WrapConstant
    public int FUNCTION_PARAMETERS_WRAP;
    public boolean FUNCTION_PARAMETERS_ALIGN_MULTILINE;
    public boolean FUNCTION_PARAMETERS_NEW_LINE_AFTER_LPAR;
    public boolean FUNCTION_PARAMETERS_NEW_LINE_BEFORE_RPAR;
    public boolean FUNCTION_PARAMETERS_ALIGN_MULTILINE_PARS;
    public boolean FUNCTION_PARAMETERS_COMMA_ON_NEXT_LINE;
    @CommonCodeStyleSettings.WrapConstant
    public int LAMBDA_CAPTURE_LIST_WRAP;
    public boolean LAMBDA_CAPTURE_LIST_ALIGN_MULTILINE;
    public boolean LAMBDA_CAPTURE_LIST_NEW_LINE_AFTER_LBRACKET;
    public boolean LAMBDA_CAPTURE_LIST_NEW_LINE_BEFORE_RBRACKET;
    public boolean LAMBDA_CAPTURE_LIST_ALIGN_MULTILINE_BRACKET;
    public boolean LAMBDA_CAPTURE_LIST_COMMA_ON_NEXT_LINE;
    @CommonCodeStyleSettings.WrapConstant
    public int STRUCTURED_BINDING_LIST_WRAP;
    public boolean STRUCTURED_BINDING_LIST_ALIGN_MULTILINE;
    public boolean STRUCTURED_BINDING_LIST_NEW_LINE_AFTER_LBRACKET;
    public boolean STRUCTURED_BINDING_LIST_NEW_LINE_BEFORE_RBRACKET;
    public boolean STRUCTURED_BINDING_LIST_ALIGN_MULTILINE_BRACKET;
    public boolean STRUCTURED_BINDING_LIST_COMMA_ON_NEXT_LINE;
    @CommonCodeStyleSettings.WrapConstant
    public int FUNCTION_CALL_ARGUMENTS_WRAP;
    public boolean FUNCTION_CALL_ARGUMENTS_ALIGN_MULTILINE;
    public boolean FUNCTION_CALL_ARGUMENTS_NEW_LINE_AFTER_LPAR;
    public boolean FUNCTION_CALL_ARGUMENTS_NEW_LINE_BEFORE_RPAR;
    public boolean FUNCTION_CALL_ARGUMENTS_ALIGN_MULTILINE_PARS;
    public boolean FUNCTION_CALL_ARGUMENTS_COMMA_ON_NEXT_LINE;
    @CommonCodeStyleSettings.WrapConstant
    public int SHIFT_OPERATION_WRAP;
    public boolean SHIFT_OPERATION_ALIGN_MULTILINE;
    @CommonCodeStyleSettings.WrapConstant
    public int TEMPLATE_DECLARATION_STRUCT_WRAP;
    public boolean TEMPLATE_DECLARATION_STRUCT_BODY_INDENT;
    @CommonCodeStyleSettings.WrapConstant
    public int TEMPLATE_DECLARATION_FUNCTION_WRAP;
    public boolean TEMPLATE_DECLARATION_FUNCTION_BODY_INDENT;
    @CommonCodeStyleSettings.WrapConstant
    public int TEMPLATE_PARAMETERS_WRAP;
    public boolean TEMPLATE_PARAMETERS_ALIGN_MULTILINE;
    public boolean TEMPLATE_PARAMETERS_NEW_LINE_AFTER_LT;
    public boolean TEMPLATE_PARAMETERS_NEW_LINE_BEFORE_GT;
    public boolean TEMPLATE_PARAMETERS_ALIGN_MULTILINE_PARS;
    public boolean TEMPLATE_PARAMETERS_COMMA_ON_NEXT_LINE;
    @CommonCodeStyleSettings.WrapConstant
    public int TEMPLATE_CALL_ARGUMENTS_WRAP;
    public boolean TEMPLATE_CALL_ARGUMENTS_ALIGN_MULTILINE;
    public boolean TEMPLATE_CALL_ARGUMENTS_NEW_LINE_AFTER_LT;
    public boolean TEMPLATE_CALL_ARGUMENTS_NEW_LINE_BEFORE_GT;
    public boolean TEMPLATE_CALL_ARGUMENTS_ALIGN_MULTILINE_PARS;
    public boolean TEMPLATE_CALL_ARGUMENTS_COMMA_ON_NEXT_LINE;
    @CommonCodeStyleSettings.WrapConstant
    public int CLASS_CONSTRUCTOR_INIT_LIST_WRAP;
    public boolean CLASS_CONSTRUCTOR_INIT_LIST_ALIGN_MULTILINE;
    public boolean CLASS_CONSTRUCTOR_INIT_LIST_COMMA_ON_NEXT_LINE;
    @NewLineConstant
    public int CLASS_CONSTRUCTOR_INIT_LIST_NEW_LINE_BEFORE_COLON;
    @NewLineConstant
    public int CLASS_CONSTRUCTOR_INIT_LIST_NEW_LINE_AFTER_COLON;
    @CommonCodeStyleSettings.WrapConstant
    public int SUPERCLASS_LIST_WRAP;
    public boolean SUPERCLASS_LIST_ALIGN_MULTILINE;
    public boolean SUPERCLASS_LIST_COMMA_ON_NEXT_LINE;
    @NewLineConstant
    public int SUPERCLASS_LIST_BEFORE_COLON;
    @NewLineConstant
    public int SUPERCLASS_LIST_AFTER_COLON;
    public boolean SPACE_BEFORE_TEMPLATE_DECLARATION_LT;
    public boolean SPACE_WITHIN_TEMPLATE_DECLARATION_LTGT;
    public boolean SPACE_WITHIN_EMPTY_TEMPLATE_DECLARATION_LTGT;
    public boolean SPACE_BEFORE_TEMPLATE_CALL_LT;
    public boolean SPACE_WITHIN_TEMPLATE_CALL_LTGT;
    public boolean SPACE_WITHIN_EMPTY_TEMPLATE_CALL_LTGT;
    public boolean SPACE_WITHIN_TEMPLATE_DOUBLE_GT;
    @CommonCodeStyleSettings.WrapConstant
    public int WRAP_PROPERTY_DECLARATION;
    public boolean ARRAY_INITIALIZER_COMMA_ON_NEXT_LINE;
    public boolean ALIGN_DICTIONARY_PAIR_VALUES;
    public boolean ALIGN_INIT_LIST_IN_COLUMNS;
    public boolean ENUM_CONSTANTS_COMMA_ON_NEXT_LINE;
    public boolean SPACE_WITHIN_EMPTY_BRACES;
    public boolean SPACE_BEFORE_NAMESPACE_LBRACE;
    public boolean SPACE_BEFORE_EXPORT_LBRACE;
    public boolean SPACE_BEFORE_AUTORELEASE_POOL_LBRACE;
    public boolean SPACE_AFTER_STRUCTURES_RBRACE;
    public boolean SPACE_WITHIN_METHOD_RETURN_TYPE_PARENTHESES;
    public boolean SPACE_AFTER_METHOD_RETURN_TYPE_PARENTHESES;
    public boolean SPACE_WITHIN_METHOD_PARAMETER_TYPE_PARENTHESES;
    public boolean SPACE_AFTER_METHOD_PARAMETER_TYPE_PARENTHESES;
    public boolean SPACE_BEFORE_PROPERTY_ATTRIBUTES_PARENTHESES;
    public boolean SPACE_WITHIN_PROPERTY_ATTRIBUTES_PARENTHESES;
    public boolean SPACE_WITHIN_FUNCTION_DECLARATION_PARENTHESES;
    public boolean SPACE_WITHIN_EMPTY_FUNCTION_DECLARATION_PARENTHESES;
    public boolean SPACE_WITHIN_FUNCTION_CALL_PARENTHESES;
    public boolean SPACE_WITHIN_EMPTY_FUNCTION_CALL_PARENTHESES;
    public boolean SPACE_WITHIN_CATEGORY_PARENTHESES;
    public boolean SPACE_WITHIN_PROTOCOLS_BRACKETS;
    public boolean SPACE_WITHIN_SEND_MESSAGE_BRACKETS;
    public boolean SPACE_WITHIN_LAMBDA_CAPTURE_LIST_BRACKET;
    public boolean SPACE_WITHIN_EMPTY_LAMBDA_CAPTURE_LIST_BRACKET;
    public boolean SPACE_WITHIN_STRUCTURED_BINDING_LIST_BRACKET;
    public boolean SPACE_BEFORE_SUPERCLASS_COLON;
    public boolean SPACE_AFTER_SUPERCLASS_COLON;
    public boolean SPACE_BEFORE_INIT_LIST_COLON;
    public boolean SPACE_AFTER_INIT_LIST_COLON;
    public boolean SPACE_BEFORE_INIT_LIST;
    public boolean SPACE_BEFORE_CATEGORY_PARENTHESES;
    public boolean SPACE_BEFORE_PROTOCOLS_BRACKETS;
    public boolean SPACE_AFTER_VISIBILITY_SIGN_IN_METHOD_DECLARATION;
    public boolean SPACE_AFTER_COLON_IN_SELECTOR;
    public boolean SPACE_BEFORE_CHAINED_SEND_MESSAGE;
    public boolean SPACE_BEFORE_COLON_IN_FOREACH;
    public boolean SPACE_AFTER_COLON_IN_FOREACH;
    public boolean SPACE_BEFORE_POINTER_IN_DECLARATION;
    public boolean SPACE_AFTER_POINTER_IN_DECLARATION;
    public boolean SPACE_BEFORE_REFERENCE_IN_DECLARATION;
    public boolean SPACE_AFTER_REFERENCE_IN_DECLARATION;
    public boolean SPACE_AFTER_REFERENCE_IN_RVALUE;
    public boolean SPACE_AFTER_CUP_IN_BLOCKS;
    public boolean SPACE_BETWEEN_ADJACENT_BRACKETS;
    public boolean SPACE_BETWEEN_OPERATOR_AND_PUNCTUATOR;
    @Deprecated
    public boolean SPACE_AROUND_DICTIONARY_LITERAL_COLON;
    public boolean SPACE_BEFORE_DICTIONARY_LITERAL_COLON;
    public boolean SPACE_AFTER_DICTIONARY_LITERAL_COLON;
    public boolean SPACE_AROUND_PM_OPERATORS;
    public boolean DISCHARGED_SHORT_TERNARY_OPERATOR;
    public boolean IN_LINE_SHORT_TERNARY_OPERATOR;
    public int KEEP_BLANK_LINES_BEFORE_END;
    public int BLANK_LINES_AROUND_NAMESPACE;
    public int BLANK_LINES_AROUND_PROPERTIES_IN_INTERFACE;
    public int BLANK_LINES_AROUND_PROPERTIES_IN_DECLARATION;
    public boolean RETAIN_OBJECT_PARAMETERS_IN_CONSTRUCTOR;
    public RememberedOption GENERATE_INSTANCE_VARIABLES_FOR_PROPERTIES;
    public boolean REFACTOR_PROPERTIES_AND_IVARS;
    public boolean REFACTOR_COMPATIBILITY_ALIASES_AND_CLASSES;
    public boolean USE_SETTERS_IN_CONSTRUCTOR;
    public boolean GENERATE_CLASS_CONSTRUCTOR;
    public boolean CREATE_INTERFACE_FOR_CATEGORIES;
    public boolean PUT_IVARS_TO_IMPLEMENTATION;
    public boolean SEMICOLON_AFTER_METHOD_SIGNATURE;
    public ReleaseStyle RELEASE_STYLE;
    public boolean DECLARE_GENERATED_METHODS;
    public boolean DESCRIPTION_INCLUDE_MEMBER_NAMES;
    public boolean COPY_IS_DEEP;
    public boolean PROPERTY_NONATOMIC;
    public boolean INSERT_OVERRIDE;
    public boolean INSERT_VIRTUAL_WITH_OVERRIDE;
    public boolean SHOW_NON_VIRTUAL_FUNCTIONS;
    public boolean USE_MODERN_CASTS;
    public boolean ADD_BRIEF_TAG;
    public DocTagPrefix TAG_PREFIX_OF_BLOCK_COMMENT;
    public DocTagPrefix TAG_PREFIX_OF_LINE_COMMENT;
    public String IVARS_PREFIX;
    public String IVARS_SUFFIX;
    public boolean ADD_GETTER_PREFIX;
    public boolean ADD_SETTER_PREFIX;
    public boolean GENERATE_ADDITIONAL_EQ_OPERATORS;
    public boolean GENERATE_ADDITIONAL_REL_OPERATORS;
    public boolean GENERATE_OPERATORS_AS_MEMBERS;
    public boolean GENERATE_COMPARISON_OPERATORS_USE_STD_TIE;
    public boolean INTRODUCE_CONST_VARS;
    public boolean INTRODUCE_CONST_PARAMS;
    public boolean INTRODUCE_AUTO_VARS;
    public boolean INTRODUCE_STATIC_CONSTS;
    public boolean INTRODUCE_CONSTEXPR_CONSTS;
    public boolean INTRODUCE_AUTO_CONSTS;
    public boolean INTRODUCE_GLOBALS_TO_HEADER;
    public boolean INTRODUCE_GENERATE_PROPERTY;
    public boolean INTRODUCE_GENERATE_SYNTHESIZE;
    public boolean INTRODUCE_PROP_TO_PRIVATE_CATEGORY;
    public boolean INTRODUCE_USE_NS_TYPES;
    public Placement TYPE_QUALIFIERS_PLACEMENT;
    public String HEADER_GUARD_STYLE_PATTERN;

    public CidrCodeStyleSettings(CodeStyleSettings container) {
        super("Objective-C", container);
        this.INDENT_NAMESPACE_MEMBERS = this.getContainer().getIndentOptions((FileType)OCFileType.INSTANCE).INDENT_SIZE;
        this.INDENT_C_STRUCT_MEMBERS = this.getContainer().getIndentOptions((FileType)OCFileType.INSTANCE).INDENT_SIZE;
        this.INDENT_CLASS_MEMBERS = this.getContainer().getIndentOptions((FileType)OCFileType.INSTANCE).INDENT_SIZE;
        this.INDENT_INTERFACE_MEMBERS = 0;
        this.INDENT_BLOCK_COMMENT = true;
        this.INDENT_INTERFACE_MEMBERS_EXCEPT_IVARS_BLOCK = false;
        this.INDENT_IMPLEMENTATION_MEMBERS = 0;
        this.INDENT_VISIBILITY_KEYWORDS = 0;
        this.INDENT_INSIDE_CODE_BLOCK = this.getContainer().getIndentOptions((FileType)OCFileType.INSTANCE).INDENT_SIZE;
        this.INDENT_PREPROCESSOR_DIRECTIVE = 0;
        this.INDENT_DIRECTIVE_AS_CODE = false;
        this.KEEP_STRUCTURES_IN_ONE_LINE = false;
        this.KEEP_CASE_EXPRESSIONS_IN_ONE_LINE = false;
        this.KEEP_NESTED_NAMESPACES_IN_ONE_LINE = false;
        this.KEEP_DIRECTIVE_AT_FIRST_COLUMN = true;
        this.NAMESPACE_BRACE_PLACEMENT = 1;
        this.METHOD_BRACE_PLACEMENT = 1;
        this.BLOCK_BRACE_PLACEMENT = this.FUNCTION_BRACE_PLACEMENT = 1;
        this.METHOD_PARAMETERS_WRAP = 0;
        this.METHOD_PARAMETERS_ALIGN_MULTILINE = false;
        this.METHOD_PARAMETERS_ALIGN_BY_COLONS = true;
        this.METHOD_CALL_ARGUMENTS_WRAP = 0;
        this.METHOD_CALL_ARGUMENTS_ALIGN_MULTILINE = false;
        this.METHOD_CALL_ARGUMENTS_ALIGN_BY_COLONS = true;
        this.METHOD_CALL_ARGUMENTS_SPECIAL_DICTIONARY_PAIRS_TREATMENT = true;
        this.FUNCTION_NON_TOP_AFTER_RETURN_TYPE_WRAP = 0;
        this.FUNCTION_TOP_AFTER_RETURN_TYPE_WRAP = 0;
        this.FUNCTION_PARAMETERS_WRAP = 0;
        this.FUNCTION_PARAMETERS_ALIGN_MULTILINE = false;
        this.FUNCTION_PARAMETERS_NEW_LINE_AFTER_LPAR = false;
        this.FUNCTION_PARAMETERS_NEW_LINE_BEFORE_RPAR = false;
        this.FUNCTION_PARAMETERS_ALIGN_MULTILINE_PARS = false;
        this.FUNCTION_PARAMETERS_COMMA_ON_NEXT_LINE = false;
        this.LAMBDA_CAPTURE_LIST_WRAP = 0;
        this.LAMBDA_CAPTURE_LIST_ALIGN_MULTILINE = false;
        this.LAMBDA_CAPTURE_LIST_NEW_LINE_AFTER_LBRACKET = false;
        this.LAMBDA_CAPTURE_LIST_NEW_LINE_BEFORE_RBRACKET = false;
        this.LAMBDA_CAPTURE_LIST_ALIGN_MULTILINE_BRACKET = false;
        this.LAMBDA_CAPTURE_LIST_COMMA_ON_NEXT_LINE = false;
        this.STRUCTURED_BINDING_LIST_WRAP = 0;
        this.STRUCTURED_BINDING_LIST_ALIGN_MULTILINE = false;
        this.STRUCTURED_BINDING_LIST_NEW_LINE_AFTER_LBRACKET = false;
        this.STRUCTURED_BINDING_LIST_NEW_LINE_BEFORE_RBRACKET = false;
        this.STRUCTURED_BINDING_LIST_ALIGN_MULTILINE_BRACKET = false;
        this.STRUCTURED_BINDING_LIST_COMMA_ON_NEXT_LINE = false;
        this.FUNCTION_CALL_ARGUMENTS_WRAP = 0;
        this.FUNCTION_CALL_ARGUMENTS_ALIGN_MULTILINE = false;
        this.FUNCTION_CALL_ARGUMENTS_NEW_LINE_AFTER_LPAR = false;
        this.FUNCTION_CALL_ARGUMENTS_NEW_LINE_BEFORE_RPAR = false;
        this.FUNCTION_CALL_ARGUMENTS_ALIGN_MULTILINE_PARS = false;
        this.FUNCTION_CALL_ARGUMENTS_COMMA_ON_NEXT_LINE = false;
        this.SHIFT_OPERATION_WRAP = 1;
        this.SHIFT_OPERATION_ALIGN_MULTILINE = true;
        this.TEMPLATE_DECLARATION_STRUCT_WRAP = 2;
        this.TEMPLATE_DECLARATION_STRUCT_BODY_INDENT = false;
        this.TEMPLATE_DECLARATION_FUNCTION_WRAP = 2;
        this.TEMPLATE_DECLARATION_FUNCTION_BODY_INDENT = false;
        this.TEMPLATE_PARAMETERS_WRAP = this.FUNCTION_PARAMETERS_WRAP;
        this.TEMPLATE_PARAMETERS_ALIGN_MULTILINE = this.FUNCTION_PARAMETERS_ALIGN_MULTILINE;
        this.TEMPLATE_PARAMETERS_NEW_LINE_AFTER_LT = this.FUNCTION_PARAMETERS_NEW_LINE_AFTER_LPAR;
        this.TEMPLATE_PARAMETERS_NEW_LINE_BEFORE_GT = this.FUNCTION_PARAMETERS_NEW_LINE_BEFORE_RPAR;
        this.TEMPLATE_PARAMETERS_ALIGN_MULTILINE_PARS = this.FUNCTION_PARAMETERS_ALIGN_MULTILINE_PARS;
        this.TEMPLATE_PARAMETERS_COMMA_ON_NEXT_LINE = this.FUNCTION_PARAMETERS_COMMA_ON_NEXT_LINE;
        this.TEMPLATE_CALL_ARGUMENTS_WRAP = this.FUNCTION_CALL_ARGUMENTS_WRAP;
        this.TEMPLATE_CALL_ARGUMENTS_ALIGN_MULTILINE = this.FUNCTION_CALL_ARGUMENTS_ALIGN_MULTILINE;
        this.TEMPLATE_CALL_ARGUMENTS_NEW_LINE_AFTER_LT = this.FUNCTION_CALL_ARGUMENTS_NEW_LINE_AFTER_LPAR;
        this.TEMPLATE_CALL_ARGUMENTS_NEW_LINE_BEFORE_GT = this.FUNCTION_CALL_ARGUMENTS_NEW_LINE_BEFORE_RPAR;
        this.TEMPLATE_CALL_ARGUMENTS_ALIGN_MULTILINE_PARS = this.FUNCTION_CALL_ARGUMENTS_ALIGN_MULTILINE_PARS;
        this.TEMPLATE_CALL_ARGUMENTS_COMMA_ON_NEXT_LINE = this.FUNCTION_CALL_ARGUMENTS_COMMA_ON_NEXT_LINE;
        this.CLASS_CONSTRUCTOR_INIT_LIST_WRAP = 5;
        this.CLASS_CONSTRUCTOR_INIT_LIST_ALIGN_MULTILINE = true;
        this.CLASS_CONSTRUCTOR_INIT_LIST_COMMA_ON_NEXT_LINE = false;
        this.CLASS_CONSTRUCTOR_INIT_LIST_NEW_LINE_BEFORE_COLON = 2;
        this.CLASS_CONSTRUCTOR_INIT_LIST_NEW_LINE_AFTER_COLON = 0;
        this.SUPERCLASS_LIST_WRAP = 5;
        this.SUPERCLASS_LIST_ALIGN_MULTILINE = true;
        this.SUPERCLASS_LIST_COMMA_ON_NEXT_LINE = false;
        this.SUPERCLASS_LIST_BEFORE_COLON = 2;
        this.SUPERCLASS_LIST_AFTER_COLON = 0;
        this.SPACE_BEFORE_TEMPLATE_DECLARATION_LT = false;
        this.SPACE_WITHIN_TEMPLATE_DECLARATION_LTGT = false;
        this.SPACE_WITHIN_EMPTY_TEMPLATE_DECLARATION_LTGT = false;
        this.SPACE_BEFORE_TEMPLATE_CALL_LT = false;
        this.SPACE_WITHIN_TEMPLATE_CALL_LTGT = false;
        this.SPACE_WITHIN_EMPTY_TEMPLATE_CALL_LTGT = false;
        this.SPACE_WITHIN_TEMPLATE_DOUBLE_GT = true;
        this.WRAP_PROPERTY_DECLARATION = 0;
        this.ARRAY_INITIALIZER_COMMA_ON_NEXT_LINE = false;
        this.ALIGN_DICTIONARY_PAIR_VALUES = false;
        this.ALIGN_INIT_LIST_IN_COLUMNS = false;
        this.ENUM_CONSTANTS_COMMA_ON_NEXT_LINE = false;
        this.SPACE_WITHIN_EMPTY_BRACES = false;
        this.SPACE_BEFORE_NAMESPACE_LBRACE = true;
        this.SPACE_BEFORE_EXPORT_LBRACE = true;
        this.SPACE_BEFORE_AUTORELEASE_POOL_LBRACE = true;
        this.SPACE_AFTER_STRUCTURES_RBRACE = true;
        this.SPACE_WITHIN_METHOD_RETURN_TYPE_PARENTHESES = false;
        this.SPACE_AFTER_METHOD_RETURN_TYPE_PARENTHESES = false;
        this.SPACE_WITHIN_METHOD_PARAMETER_TYPE_PARENTHESES = false;
        this.SPACE_AFTER_METHOD_PARAMETER_TYPE_PARENTHESES = false;
        this.SPACE_BEFORE_PROPERTY_ATTRIBUTES_PARENTHESES = false;
        this.SPACE_WITHIN_PROPERTY_ATTRIBUTES_PARENTHESES = false;
        this.SPACE_WITHIN_FUNCTION_DECLARATION_PARENTHESES = false;
        this.SPACE_WITHIN_EMPTY_FUNCTION_DECLARATION_PARENTHESES = false;
        this.SPACE_WITHIN_FUNCTION_CALL_PARENTHESES = false;
        this.SPACE_WITHIN_EMPTY_FUNCTION_CALL_PARENTHESES = false;
        this.SPACE_WITHIN_CATEGORY_PARENTHESES = false;
        this.SPACE_WITHIN_PROTOCOLS_BRACKETS = false;
        this.SPACE_WITHIN_SEND_MESSAGE_BRACKETS = false;
        this.SPACE_WITHIN_LAMBDA_CAPTURE_LIST_BRACKET = false;
        this.SPACE_WITHIN_EMPTY_LAMBDA_CAPTURE_LIST_BRACKET = false;
        this.SPACE_WITHIN_STRUCTURED_BINDING_LIST_BRACKET = false;
        this.SPACE_BEFORE_SUPERCLASS_COLON = true;
        this.SPACE_AFTER_SUPERCLASS_COLON = true;
        this.SPACE_BEFORE_INIT_LIST_COLON = true;
        this.SPACE_AFTER_INIT_LIST_COLON = true;
        this.SPACE_BEFORE_INIT_LIST = false;
        this.SPACE_BEFORE_CATEGORY_PARENTHESES = true;
        this.SPACE_BEFORE_PROTOCOLS_BRACKETS = true;
        this.SPACE_AFTER_VISIBILITY_SIGN_IN_METHOD_DECLARATION = true;
        this.SPACE_AFTER_COLON_IN_SELECTOR = false;
        this.SPACE_BEFORE_CHAINED_SEND_MESSAGE = true;
        this.SPACE_BEFORE_COLON_IN_FOREACH = false;
        this.SPACE_AFTER_COLON_IN_FOREACH = true;
        this.SPACE_BEFORE_POINTER_IN_DECLARATION = true;
        this.SPACE_AFTER_POINTER_IN_DECLARATION = false;
        this.SPACE_BEFORE_REFERENCE_IN_DECLARATION = true;
        this.SPACE_AFTER_REFERENCE_IN_DECLARATION = false;
        this.SPACE_AFTER_REFERENCE_IN_RVALUE = false;
        this.SPACE_AFTER_CUP_IN_BLOCKS = false;
        this.SPACE_BETWEEN_ADJACENT_BRACKETS = true;
        this.SPACE_BETWEEN_OPERATOR_AND_PUNCTUATOR = false;
        this.SPACE_AROUND_DICTIONARY_LITERAL_COLON = true;
        this.SPACE_BEFORE_DICTIONARY_LITERAL_COLON = false;
        this.SPACE_AFTER_DICTIONARY_LITERAL_COLON = true;
        this.SPACE_AROUND_PM_OPERATORS = false;
        this.DISCHARGED_SHORT_TERNARY_OPERATOR = false;
        this.IN_LINE_SHORT_TERNARY_OPERATOR = true;
        this.KEEP_BLANK_LINES_BEFORE_END = 2;
        this.BLANK_LINES_AROUND_NAMESPACE = 0;
        this.BLANK_LINES_AROUND_PROPERTIES_IN_INTERFACE = 0;
        this.BLANK_LINES_AROUND_PROPERTIES_IN_DECLARATION = 0;
        this.RETAIN_OBJECT_PARAMETERS_IN_CONSTRUCTOR = true;
        this.GENERATE_INSTANCE_VARIABLES_FOR_PROPERTIES = RememberedOption.ASK;
        this.REFACTOR_PROPERTIES_AND_IVARS = true;
        this.REFACTOR_COMPATIBILITY_ALIASES_AND_CLASSES = true;
        this.USE_SETTERS_IN_CONSTRUCTOR = true;
        this.GENERATE_CLASS_CONSTRUCTOR = true;
        this.CREATE_INTERFACE_FOR_CATEGORIES = true;
        this.PUT_IVARS_TO_IMPLEMENTATION = true;
        this.SEMICOLON_AFTER_METHOD_SIGNATURE = false;
        this.RELEASE_STYLE = ReleaseStyle.IVAR;
        this.DECLARE_GENERATED_METHODS = true;
        this.DESCRIPTION_INCLUDE_MEMBER_NAMES = true;
        this.COPY_IS_DEEP = false;
        this.PROPERTY_NONATOMIC = true;
        this.INSERT_OVERRIDE = true;
        this.INSERT_VIRTUAL_WITH_OVERRIDE = false;
        this.SHOW_NON_VIRTUAL_FUNCTIONS = false;
        this.USE_MODERN_CASTS = true;
        this.ADD_BRIEF_TAG = false;
        this.TAG_PREFIX_OF_BLOCK_COMMENT = DocTagPrefix.AT;
        this.TAG_PREFIX_OF_LINE_COMMENT = PluginUtils.hasAppCode() ? DocTagPrefix.AT : DocTagPrefix.BACK_SLASH;
        this.IVARS_PREFIX = "_";
        this.IVARS_SUFFIX = "";
        this.ADD_GETTER_PREFIX = true;
        this.ADD_SETTER_PREFIX = true;
        this.GENERATE_ADDITIONAL_EQ_OPERATORS = true;
        this.GENERATE_ADDITIONAL_REL_OPERATORS = true;
        this.GENERATE_OPERATORS_AS_MEMBERS = true;
        this.GENERATE_COMPARISON_OPERATORS_USE_STD_TIE = false;
        this.INTRODUCE_CONST_VARS = false;
        this.INTRODUCE_CONST_PARAMS = false;
        this.INTRODUCE_AUTO_VARS = false;
        this.INTRODUCE_STATIC_CONSTS = true;
        this.INTRODUCE_CONSTEXPR_CONSTS = false;
        this.INTRODUCE_AUTO_CONSTS = false;
        this.INTRODUCE_GLOBALS_TO_HEADER = true;
        this.INTRODUCE_GENERATE_PROPERTY = false;
        this.INTRODUCE_GENERATE_SYNTHESIZE = true;
        this.INTRODUCE_PROP_TO_PRIVATE_CATEGORY = false;
        this.INTRODUCE_USE_NS_TYPES = false;
        this.TYPE_QUALIFIERS_PLACEMENT = Placement.BEFORE;
        this.HEADER_GUARD_STYLE_PATTERN = "${PROJECT_NAME}_${FILE_NAME}_${EXT}";
        CidrCodeStyleSettings.configureCustomSettings(this);
    }

    @NotNull
    public List<String> getKnownTagNames() {
        List list = ContainerUtil.concat((List)super.getKnownTagNames(), Collections.singletonList(this.getExtensionTagName()));
        if (list == null) {
            CidrCodeStyleSettings.$$$reportNull$$$0(0);
        }
        return list;
    }

    @NonNls
    @NotNull
    protected String getExtensionTagName() {
        String string = this.getTagName() + "-extensions";
        if (string == null) {
            CidrCodeStyleSettings.$$$reportNull$$$0(1);
        }
        return string;
    }

    public void readExternal(Element parentElement) throws InvalidDataException {
        super.readExternal(parentElement);
        this.readFromExtensionNode(parentElement.getChild(this.getExtensionTagName()));
    }

    public void readFromExtensionNode(Element parentNode) {
        if (parentNode != null) {
            this.readLegacyEnumOptions(parentNode);
        }
    }

    public void readLegacyEnumOptions(Element parentNode) {
        for (Element e : parentNode.getChildren("option")) {
            String fieldName = e.getAttributeValue("name");
            String value = e.getAttributeValue("value");
            try {
                Field field = ((Object)((Object)this)).getClass().getField(fieldName);
                if (!field.getType().isEnum() || value == null) continue;
                field.set((Object)this, Enum.valueOf(field.getType(), value));
            }
            catch (IllegalAccessException ex) {
                throw new InvalidDataException((Throwable)ex);
            }
            catch (NoSuchFieldException ex) {
                LOG.debug((Throwable)ex);
            }
        }
    }

    public void writeExternal(Element parentElement, @NotNull CustomCodeStyleSettings parentSettings) throws WriteExternalException {
        if (parentSettings == null) {
            CidrCodeStyleSettings.$$$reportNull$$$0(2);
        }
        super.writeExternal(parentElement, parentSettings);
        Element extensionNode = new Element(this.getExtensionTagName());
        this.writeToExtensionNode(extensionNode, parentSettings);
        if (extensionNode.hasAttributes() || !extensionNode.getChildren().isEmpty()) {
            parentElement.addContent(extensionNode);
        }
    }

    public void writeToExtensionNode(@NotNull Element extensionNode, @NotNull CustomCodeStyleSettings parentSettings) {
        if (extensionNode == null) {
            CidrCodeStyleSettings.$$$reportNull$$$0(3);
        }
        if (parentSettings == null) {
            CidrCodeStyleSettings.$$$reportNull$$$0(4);
        }
        this.writeLegacyEnumSettings(extensionNode, (DifferenceFilter<CustomCodeStyleSettings>)new DifferenceFilter((Object)this, (Object)parentSettings));
    }

    public void writeLegacyEnumSettings(Element parentElement, DifferenceFilter<CustomCodeStyleSettings> filter) {
        for (Field field : ((Object)((Object)this)).getClass().getFields()) {
            Element element;
            if (!field.getType().isEnum() || !filter.isAccept(field)) continue;
            try {
                element = CidrCodeStyleSettings.writeEnumField(field.getName(), (Enum)field.get((Object)this));
            }
            catch (IllegalAccessException e) {
                continue;
            }
            parentElement.addContent(element);
        }
    }

    protected void importLegacySettings(@NotNull CodeStyleSettings rootSettings) {
        if (rootSettings == null) {
            CidrCodeStyleSettings.$$$reportNull$$$0(5);
        }
        if (!this.SPACE_AROUND_DICTIONARY_LITERAL_COLON) {
            this.SPACE_AROUND_DICTIONARY_LITERAL_COLON = true;
            this.SPACE_BEFORE_DICTIONARY_LITERAL_COLON = false;
            this.SPACE_AFTER_DICTIONARY_LITERAL_COLON = false;
        }
    }

    protected static Element writeEnumField(@NonNls String name, Enum<?> value) {
        Element element = new Element("option");
        element.setAttribute("name", name);
        element.setAttribute("value", value.name());
        return element;
    }

    public static void configureDefaultSettings(@NotNull CommonCodeStyleSettings settings) {
        if (settings == null) {
            CidrCodeStyleSettings.$$$reportNull$$$0(6);
        }
        if (!ApplicationManager.getApplication().isUnitTestMode() && !PluginUtils.hasAppCode()) {
            settings.ALIGN_MULTILINE_BINARY_OPERATION = true;
            settings.ALIGN_MULTILINE_ASSIGNMENT = true;
            settings.ALIGN_MULTILINE_TERNARY_OPERATION = true;
            settings.ALIGN_MULTILINE_ARRAY_INITIALIZER_EXPRESSION = true;
            settings.SPACE_WITHIN_BRACES = true;
            settings.BINARY_OPERATION_WRAP = 1;
            settings.TERNARY_OPERATION_WRAP = 1;
            settings.TERNARY_OPERATION_SIGNS_ON_NEXT_LINE = true;
            settings.KEEP_SIMPLE_BLOCKS_IN_ONE_LINE = true;
            settings.KEEP_SIMPLE_METHODS_IN_ONE_LINE = true;
            settings.ARRAY_INITIALIZER_WRAP = 1;
            settings.ENUM_CONSTANTS_WRAP = 5;
        }
    }

    public static void configureCustomSettings(@NotNull CidrCodeStyleSettings ocSettings) {
        if (ocSettings == null) {
            CidrCodeStyleSettings.$$$reportNull$$$0(7);
        }
        if (!ApplicationManager.getApplication().isUnitTestMode() && !PluginUtils.hasAppCode()) {
            ocSettings.FUNCTION_PARAMETERS_WRAP = 1;
            ocSettings.FUNCTION_NON_TOP_AFTER_RETURN_TYPE_WRAP = 1;
            ocSettings.FUNCTION_TOP_AFTER_RETURN_TYPE_WRAP = 1;
            ocSettings.FUNCTION_PARAMETERS_ALIGN_MULTILINE = true;
            ocSettings.FUNCTION_CALL_ARGUMENTS_WRAP = 1;
            ocSettings.FUNCTION_CALL_ARGUMENTS_ALIGN_MULTILINE = true;
            ocSettings.CLASS_CONSTRUCTOR_INIT_LIST_WRAP = 1;
            ocSettings.ALIGN_INIT_LIST_IN_COLUMNS = true;
            ocSettings.SPACE_BETWEEN_ADJACENT_BRACKETS = false;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 4, 5, 6, 7 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/settings/CidrCodeStyleSettings";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentSettings";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensionNode";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootSettings";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ocSettings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getKnownTagNames";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtensionTagName";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/settings/CidrCodeStyleSettings";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "writeExternal";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "writeToExtensionNode";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "importLegacySettings";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "configureDefaultSettings";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "configureCustomSettings";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 4, 5, 6, 7 -> new IllegalArgumentException(string);
        };
    }

    public static enum RememberedOption {
        YES,
        NO,
        ASK;

    }

    public static enum ReleaseStyle {
        IVAR,
        IVAR_2,
        PROPERTY;

    }

    public static enum DocTagPrefix {
        AT,
        BACK_SLASH;

    }

    public static enum Placement {
        BEFORE,
        AFTER;

    }

    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface NewLineConstant {
    }
}

