/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.settings;

import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CustomCodeStyleSettings;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.PluginUtils;
import com.jetbrains.cidr.lang.settings.FileExtensionPair;
import com.jetbrains.cidr.lang.settings.NamingConventionStyle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0007H\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J\u001a\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0001H\u0016J\u0012\u0010\u0012\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016J\u001e\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u00102\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u0007H\u0002J\u0010\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u0010H\u0002R\u0018\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00078\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/jetbrains/cidr/lang/settings/OCFileExtensionsSettings;", "Lcom/intellij/psi/codeStyle/CustomCodeStyleSettings;", "container", "Lcom/intellij/psi/codeStyle/CodeStyleSettings;", "<init>", "(Lcom/intellij/psi/codeStyle/CodeStyleSettings;)V", "FILE_EXTENSION_PAIRS_ORDERED", "", "Lcom/jetbrains/cidr/lang/settings/FileExtensionPair;", "getKnownTagNames", "", "clone", "", "writeExternal", "", "parentElement", "Lorg/jdom/Element;", "parentSettings", "readExternal", "writeExtensions", "element", "list", "Lcom/intellij/openapi/util/JDOMExternalizable;", "readExtensions", "parentNode", "Companion", "intellij.cidr.lang.base"})
public final class OCFileExtensionsSettings
extends CustomCodeStyleSettings {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @JvmField
    @NotNull
    public List<? extends FileExtensionPair> FILE_EXTENSION_PAIRS_ORDERED;
    private static final List<FileExtensionPair> ourDefaultFileExtensions = Collections.unmodifiableList((List)new ArrayList<FileExtensionPair>(){
        {
            if (PluginUtils.hasAppCode()) {
                this.add(new FileExtensionPair("mm", "h", NamingConventionStyle.NONE));
            }
            this.add(new FileExtensionPair("cpp", "h", NamingConventionStyle.NONE));
            this.add(new FileExtensionPair("c", "h", NamingConventionStyle.NONE));
            if (PluginUtils.hasCLion()) {
                this.add(new FileExtensionPair("cu", "cuh", NamingConventionStyle.NONE));
                this.add(new FileExtensionPair("ixx", "", NamingConventionStyle.NONE));
                this.add(new FileExtensionPair("mxx", "", NamingConventionStyle.NONE));
                this.add(new FileExtensionPair("cppm", "", NamingConventionStyle.NONE));
                this.add(new FileExtensionPair("ccm", "", NamingConventionStyle.NONE));
                this.add(new FileExtensionPair("cxxm", "", NamingConventionStyle.NONE));
                this.add(new FileExtensionPair("c++m", "", NamingConventionStyle.NONE));
            }
        }
    });

    public OCFileExtensionsSettings(@NotNull CodeStyleSettings container) {
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        super(OCFileExtensionsSettings.class.getSimpleName(), container);
        List<FileExtensionPair> list = ourDefaultFileExtensions;
        Intrinsics.checkNotNullExpressionValue(list, (String)"ourDefaultFileExtensions");
        this.FILE_EXTENSION_PAIRS_ORDERED = list;
    }

    @NotNull
    public List<String> getKnownTagNames() {
        Object[] objectArray = new String[]{"Objective-C-extensions", "files"};
        List list = ContainerUtil.concat((List)super.getKnownTagNames(), (List)CollectionsKt.listOf((Object[])objectArray));
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"concat(...)");
        return list;
    }

    @NotNull
    public Object clone() {
        Object object = super.clone();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.jetbrains.cidr.lang.settings.OCFileExtensionsSettings");
        OCFileExtensionsSettings clone = (OCFileExtensionsSettings)((Object)object);
        List<? extends FileExtensionPair> list = Collections.unmodifiableList(this.FILE_EXTENSION_PAIRS_ORDERED);
        Intrinsics.checkNotNullExpressionValue(list, (String)"unmodifiableList(...)");
        clone.FILE_EXTENSION_PAIRS_ORDERED = list;
        return clone;
    }

    public void writeExternal(@Nullable Element parentElement, @NotNull CustomCodeStyleSettings parentSettings) {
        block2: {
            Element childElement;
            block1: {
                Intrinsics.checkNotNullParameter((Object)parentSettings, (String)"parentSettings");
                super.writeExternal(parentElement, parentSettings);
                childElement = new Element("files");
                this.writeExtensions(childElement, this.FILE_EXTENSION_PAIRS_ORDERED);
                if (childElement.hasAttributes()) break block1;
                List list = childElement.getChildren();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getChildren(...)");
                if (!(!((Collection)list).isEmpty())) break block2;
            }
            Element element = parentElement;
            if (element != null) {
                element.addContent(childElement);
            }
        }
    }

    public void readExternal(@Nullable Element parentElement) {
        Element oldNode;
        Element newNode;
        super.readExternal(parentElement);
        List<FileExtensionPair> list = ourDefaultFileExtensions;
        Intrinsics.checkNotNullExpressionValue(list, (String)"ourDefaultFileExtensions");
        this.FILE_EXTENSION_PAIRS_ORDERED = list;
        Element element = parentElement;
        Object object = newNode = element != null ? element.getChild("files") : null;
        if (newNode != null) {
            this.readExtensions(newNode);
            return;
        }
        Element element2 = parentElement;
        Object object2 = oldNode = element2 != null ? element2.getChild("Objective-C-extensions") : null;
        if (oldNode != null) {
            this.readExtensions(oldNode);
        }
    }

    private final void writeExtensions(Element element, List<? extends JDOMExternalizable> list) throws WriteExternalException {
        if (Intrinsics.areEqual(list, ourDefaultFileExtensions)) {
            return;
        }
        Element childElement = new Element("extensions");
        for (JDOMExternalizable jDOMExternalizable : list) {
            jDOMExternalizable.writeExternal(childElement);
        }
        List list2 = childElement.getContent();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getContent(...)");
        if (!((Collection)list2).isEmpty()) {
            element.addContent(childElement);
        }
    }

    private final void readExtensions(Element parentNode) {
        Element childElement = parentNode.getChild("extensions");
        if (childElement == null) {
            return;
        }
        List<FileExtensionPair> list = FileExtensionPair.readFileExtensionPairs(childElement);
        Intrinsics.checkNotNullExpressionValue(list, (String)"readFileExtensionPairs(...)");
        List<FileExtensionPair> list2 = list;
        if (!((Collection)list2).isEmpty()) {
            List<FileExtensionPair> list3 = Collections.unmodifiableList(list2);
            Intrinsics.checkNotNullExpressionValue(list3, (String)"unmodifiableList(...)");
            this.FILE_EXTENSION_PAIRS_ORDERED = list3;
        }
    }

    public static final List<FileExtensionPair> getOurDefaultFileExtensions() {
        return Companion.getOurDefaultFileExtensions();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R@\u0010\u0004\u001a&\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u0006 \u0007*\u0012\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u0006\u0018\u00010\b0\u00058\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\t\u0010\u0003\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lcom/jetbrains/cidr/lang/settings/OCFileExtensionsSettings$Companion;", "", "<init>", "()V", "ourDefaultFileExtensions", "", "Lcom/jetbrains/cidr/lang/settings/FileExtensionPair;", "kotlin.jvm.PlatformType", "", "getOurDefaultFileExtensions$annotations", "getOurDefaultFileExtensions", "()Ljava/util/List;", "intellij.cidr.lang.base"})
    public static final class Companion {
        private Companion() {
        }

        public final List<FileExtensionPair> getOurDefaultFileExtensions() {
            return ourDefaultFileExtensions;
        }

        @JvmStatic
        public static /* synthetic */ void getOurDefaultFileExtensions$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

