/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.makefile.execution.build.runners;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.task.ModuleBuildTask;
import com.intellij.task.ModuleFilesBuildTask;
import com.intellij.task.ProjectModelBuildTask;
import com.intellij.task.ProjectTask;
import com.jetbrains.cidr.cpp.makefile.MakefileLog;
import com.jetbrains.cidr.cpp.makefile.MakefileUtil;
import com.jetbrains.cidr.cpp.makefile.MakefileWorkspace;
import com.jetbrains.cidr.cpp.makefile.execution.build.MakefileBuildConfiguration;
import com.jetbrains.cidr.cpp.makefile.execution.build.runners.CleanTaskRunner;
import com.jetbrains.cidr.cpp.makefile.execution.build.runners.MkCompileTaskRunner;
import com.jetbrains.cidr.cpp.makefile.execution.build.runners.ModuleBuildRunner;
import com.jetbrains.cidr.cpp.makefile.execution.build.runners.ProjectModelBuildTaskRunner;
import com.jetbrains.cidr.cpp.makefile.io.MkPathUtils;
import com.jetbrains.cidr.execution.build.runners.CidrProjectTaskRunner;
import com.jetbrains.cidr.execution.build.runners.CidrTaskRunner;
import com.jetbrains.cidr.execution.build.tasks.CidrCleanTask;
import com.jetbrains.cidr.lang.OCFileTypeHelpers;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\rH\u0016J\u001a\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lcom/jetbrains/cidr/cpp/makefile/execution/build/runners/MakefileProjectTaskRunner;", "Lcom/jetbrains/cidr/execution/build/runners/CidrProjectTaskRunner;", "<init>", "()V", "buildSystemId", "", "getBuildSystemId", "()Ljava/lang/String;", "canRun", "", "project", "Lcom/intellij/openapi/project/Project;", "projectTask", "Lcom/intellij/task/ProjectTask;", "task", "runnerForTask", "Lcom/jetbrains/cidr/execution/build/runners/CidrTaskRunner;", "intellij.clion.makefile"})
@SourceDebugExtension(value={"SMAP\nMakefileProjectTaskRunner.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MakefileProjectTaskRunner.kt\ncom/jetbrains/cidr/cpp/makefile/execution/build/runners/MakefileProjectTaskRunner\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,443:1\n12637#2,2:444\n12637#2,2:446\n*S KotlinDebug\n*F\n+ 1 MakefileProjectTaskRunner.kt\ncom/jetbrains/cidr/cpp/makefile/execution/build/runners/MakefileProjectTaskRunner\n*L\n75#1:444,2\n76#1:446,2\n*E\n"})
public final class MakefileProjectTaskRunner
extends CidrProjectTaskRunner {
    @NotNull
    private final String buildSystemId;

    public MakefileProjectTaskRunner() {
        String string = MakefileUtil.ID.getId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getId(...)");
        this.buildSystemId = string;
    }

    @NotNull
    public String getBuildSystemId() {
        return this.buildSystemId;
    }

    public boolean canRun(@NotNull Project project, @NotNull ProjectTask projectTask) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)projectTask, (String)"projectTask");
        MakefileWorkspace workspace = MakefileWorkspace.Companion.getInstance(project);
        return workspace.isInitialized() && this.canRun(projectTask) && (projectTask instanceof ModuleBuildTask ? Intrinsics.areEqual((Object)((ModuleBuildTask)projectTask).getModule(), (Object)workspace.getModule()) : true);
    }

    public boolean canRun(@NotNull ProjectTask task) {
        boolean bl;
        block9: {
            ProjectTask projectTask;
            block11: {
                block13: {
                    block12: {
                        boolean bl2;
                        block7: {
                            boolean bl3;
                            VirtualFile it;
                            boolean $i$f$any;
                            Object[] $this$any$iv;
                            block6: {
                                block10: {
                                    block8: {
                                        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
                                        projectTask = task;
                                        if (!(projectTask instanceof ProjectModelBuildTask)) break block8;
                                        bl = ((ProjectModelBuildTask)task).getBuildableElement() instanceof MakefileBuildConfiguration;
                                        break block9;
                                    }
                                    if (!(projectTask instanceof CidrCleanTask)) break block10;
                                    bl = ((CidrCleanTask)task).getBuildConfiguration() instanceof MakefileBuildConfiguration;
                                    break block9;
                                }
                                if (!(projectTask instanceof ModuleFilesBuildTask)) break block11;
                                VirtualFile[] virtualFileArray = ((ModuleFilesBuildTask)task).getFiles();
                                Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getFiles(...)");
                                if (((Object[])virtualFileArray).length == 0) break block12;
                                VirtualFile[] virtualFileArray2 = ((ModuleFilesBuildTask)task).getFiles();
                                Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray2, (String)"getFiles(...)");
                                $this$any$iv = virtualFileArray2;
                                $i$f$any = false;
                                for (Object element$iv : $this$any$iv) {
                                    it = (VirtualFile)element$iv;
                                    boolean bl4 = false;
                                    if (!(it.isDirectory() || !OCFileTypeHelpers.isSourceFile((String)it.getName()) && !OCFileTypeHelpers.isHeaderFile((String)it.getName()))) continue;
                                    bl3 = true;
                                    break block6;
                                }
                                bl3 = false;
                            }
                            if (bl3) break block12;
                            VirtualFile[] virtualFileArray = ((ModuleFilesBuildTask)task).getFiles();
                            Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getFiles(...)");
                            $this$any$iv = virtualFileArray;
                            $i$f$any = false;
                            for (Object element$iv : $this$any$iv) {
                                it = (VirtualFile)element$iv;
                                boolean bl5 = false;
                                Intrinsics.checkNotNull((Object)it);
                                if (!(MkPathUtils.isMakefile(it) || MkPathUtils.isMakefilePrototype(it))) continue;
                                bl2 = true;
                                break block7;
                            }
                            bl2 = false;
                        }
                        if (!bl2) break block13;
                    }
                    return false;
                }
                Project project = ((ModuleFilesBuildTask)task).getModule().getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                MakefileWorkspace workspace = MakefileWorkspace.Companion.getInstance(project);
                return workspace.isInitialized() && Intrinsics.areEqual((Object)((ModuleFilesBuildTask)task).getModule(), (Object)workspace.getModule());
            }
            if (projectTask instanceof ModuleBuildTask) {
                Project project = ((ModuleBuildTask)task).getModule().getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                MakefileWorkspace workspace = MakefileWorkspace.Companion.getInstance(project);
                return workspace.isInitialized() && Intrinsics.areEqual((Object)((ModuleBuildTask)task).getModule(), (Object)workspace.getModule());
            }
            bl = false;
        }
        return bl;
    }

    @Nullable
    public CidrTaskRunner runnerForTask(@NotNull ProjectTask task, @NotNull Project project) {
        CidrTaskRunner cidrTaskRunner;
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        ProjectTask projectTask = task;
        if (projectTask instanceof ProjectModelBuildTask) {
            cidrTaskRunner = new ProjectModelBuildTaskRunner();
        } else if (projectTask instanceof CidrCleanTask) {
            cidrTaskRunner = new CleanTaskRunner(project);
        } else if (projectTask instanceof ModuleFilesBuildTask) {
            cidrTaskRunner = (CidrTaskRunner)new MkCompileTaskRunner();
        } else if (projectTask instanceof ModuleBuildTask) {
            cidrTaskRunner = new ModuleBuildRunner(project);
        } else {
            MakefileLog.LOG.error("Unexpected project task type: " + task.getPresentableName());
            cidrTaskRunner = null;
        }
        return cidrTaskRunner;
    }
}

