/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.toolchains.wsl;

import com.intellij.execution.wsl.WSLDistribution;
import com.intellij.execution.wsl.WSLUtil;
import com.intellij.execution.wsl.WslDistributionManager;
import com.intellij.openapi.application.Experiments;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.WindowsRegistryUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.EDT;
import com.jetbrains.cidr.CidrUtilsExecutionBundle;
import java.io.File;
import java.lang.invoke.CallSite;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class WSLCidrUtil {
    @NotNull
    public static List<WSLDistribution> getAvailableDistributions() {
        List<WSLDistribution> distributions = WSLCidrUtil.getInstalledDistributions();
        ArrayList<WSLDistributionWithRootInternal> result = new ArrayList<WSLDistributionWithRootInternal>(distributions.size());
        for (WSLDistribution distribution : distributions) {
            result.add(WSLCidrUtil.patchDistribution(distribution));
        }
        List<WSLDistribution> list = Collections.unmodifiableList(result);
        if (list == null) {
            WSLCidrUtil.$$$reportNull$$$0(0);
        }
        return list;
    }

    @NotNull
    private static WSLDistributionWithRootInternal patchDistribution(@NotNull WSLDistribution distribution) {
        if (distribution == null) {
            WSLCidrUtil.$$$reportNull$$$0(1);
        }
        return new WSLDistributionWithRootInternal(distribution){

            @Override
            @NotNull
            public String getWindowsPath(@NotNull String wslPath) {
                if (wslPath == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (this.myWslRootInHost != null && FileUtil.isAncestor((String)this.myWslRootInHost, (String)wslPath, (boolean)true)) {
                    String string = wslPath;
                    if (string == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return string;
                }
                String string = super.getWindowsPath(wslPath);
                if (string == null) {
                    1.$$$reportNull$$$0(2);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1, 2 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "wslPath";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/cidr/toolchains/wsl/WSLCidrUtil$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/cidr/toolchains/wsl/WSLCidrUtil$1";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getWindowsPath";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getWindowsPath";
                        break;
                    }
                    case 1: 
                    case 2: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1, 2 -> new IllegalStateException(string);
                };
            }
        };
    }

    public static boolean hasAvailableDistributions() {
        return !WSLCidrUtil.getInstalledDistributions().isEmpty();
    }

    @NotNull
    private static List<WSLDistribution> getInstalledDistributions() {
        if (EDT.isCurrentThreadEdt()) {
            List list = (List)ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> WslDistributionManager.getInstance().getInstalledDistributions(), CidrUtilsExecutionBundle.message("dialog.title.fetching.wsl.distributions", new Object[0]), false, null);
            if (list == null) {
                WSLCidrUtil.$$$reportNull$$$0(2);
            }
            return list;
        }
        List list = WslDistributionManager.getInstance().getInstalledDistributions();
        if (list == null) {
            WSLCidrUtil.$$$reportNull$$$0(3);
        }
        return list;
    }

    @Nullable
    public static WSLDistribution getDistributionByExecutionPath(@NotNull String exePath) {
        if (exePath == null) {
            WSLCidrUtil.$$$reportNull$$$0(4);
        }
        if (exePath.isEmpty()) {
            return null;
        }
        WSLDistribution result = (WSLDistribution)ContainerUtil.find((Iterable)WSLUtil.getAvailableDistributions(), d -> {
            Path path = d.getExecutablePath();
            return path != null && exePath.equals(path.toString());
        });
        return result == null ? null : WSLCidrUtil.patchDistribution(result);
    }

    @Nullable
    public static WSLDistribution getDistributionByMsId(@NotNull String name) {
        if (name == null) {
            WSLCidrUtil.$$$reportNull$$$0(5);
        }
        if (name.isEmpty()) {
            return null;
        }
        return (WSLDistribution)ContainerUtil.find(WSLCidrUtil.getAvailableDistributions(), d -> name.equals(d.getMsId()));
    }

    public static boolean delete(@NotNull Path path) {
        if (path == null) {
            WSLCidrUtil.$$$reportNull$$$0(6);
        }
        return path.toFile().delete();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 4, 5, 6 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/toolchains/wsl/WSLCidrUtil";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "distribution";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exePath";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getAvailableDistributions";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/toolchains/wsl/WSLCidrUtil";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstalledDistributions";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "patchDistribution";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getDistributionByExecutionPath";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getDistributionByMsId";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "delete";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 4, 5, 6 -> new IllegalArgumentException(string);
        };
    }

    public static class WSLDistributionWithRootInternal
    extends WSLDistribution {
        private static final NotNullLazyValue<Map<String, String>> DISTRIBUTION_TO_ROOTFS = NotNullLazyValue.atomicLazy(() -> {
            HashMap<String, CallSite> result = new HashMap<String, CallSite>();
            String lxss = "HKEY_CURRENT_USER\\Software\\Microsoft\\Windows\\CurrentVersion\\Lxss";
            List distributions = WindowsRegistryUtil.readRegistryBranch((String)"HKEY_CURRENT_USER\\Software\\Microsoft\\Windows\\CurrentVersion\\Lxss");
            WSLUtil.LOG.debug("Processing Lxss registry: " + distributions.size());
            for (String distribution : distributions) {
                String name = WindowsRegistryUtil.readRegistryValue((String)("HKEY_CURRENT_USER\\Software\\Microsoft\\Windows\\CurrentVersion\\Lxss\\" + distribution), (String)"DistributionName");
                String path = WindowsRegistryUtil.readRegistryValue((String)("HKEY_CURRENT_USER\\Software\\Microsoft\\Windows\\CurrentVersion\\Lxss\\" + distribution), (String)"BasePath");
                WSLUtil.LOG.debug(name + ": " + path);
                if (path == null) continue;
                result.put(name, (CallSite)((Object)(path + "\\rootfs")));
            }
            return Collections.unmodifiableMap(result);
        });
        @Nullable
        protected final String myWslRootInHost;

        private WSLDistributionWithRootInternal(@NotNull WSLDistribution wslDistribution) {
            Path uncRoot;
            boolean checkP9root;
            if (wslDistribution == null) {
                WSLDistributionWithRootInternal.$$$reportNull$$$0(0);
            }
            super(wslDistribution);
            String wslRootInHost = (String)((Map)DISTRIBUTION_TO_ROOTFS.getValue()).get(wslDistribution.getMsId());
            boolean isDirectory = wslRootInHost != null && new File(wslRootInHost).isDirectory();
            boolean bl = checkP9root = Experiments.getInstance().isFeatureEnabled("wsl.prefer.p9.support") || !isDirectory;
            if (Experiments.getInstance().isFeatureEnabled("wsl.p9.support") && checkP9root && Files.exists(uncRoot = this.getUNCRootPath(), new LinkOption[0])) {
                wslRootInHost = StringUtil.trimEnd((String)uncRoot.toString(), (String)"\\");
            }
            if (!FileUtil.exists((String)wslRootInHost)) {
                WSLUtil.LOG.warn("WSL rootfs doesn't exist: " + wslRootInHost);
                wslRootInHost = null;
            }
            this.myWslRootInHost = wslRootInHost;
        }

        @Nullable
        public String getWslPath(@NotNull Path windowsPath) {
            if (windowsPath == null) {
                WSLDistributionWithRootInternal.$$$reportNull$$$0(1);
            }
            String canonicalPath = FileUtil.toCanonicalPath((String)windowsPath.toString());
            if (this.myWslRootInHost != null && FileUtil.isAncestor((String)this.myWslRootInHost, (String)canonicalPath, (boolean)true)) {
                return FileUtil.toSystemIndependentName((String)canonicalPath.substring(this.myWslRootInHost.length()));
            }
            return super.getWslPath(Path.of(canonicalPath, new String[0]));
        }

        @NotNull
        public String getWindowsPath(@NotNull String wslPath) {
            String windowsPath;
            if (wslPath == null) {
                WSLDistributionWithRootInternal.$$$reportNull$$$0(2);
            }
            if ((windowsPath = WSLUtil.getWindowsPath((String)wslPath, (String)this.getMntRoot())) != null) {
                String string = windowsPath;
                if (string == null) {
                    WSLDistributionWithRootInternal.$$$reportNull$$$0(3);
                }
                return string;
            }
            if (this.myWslRootInHost != null) {
                String string = FileUtil.toSystemDependentName((String)(this.myWslRootInHost + FileUtil.toCanonicalPath((String)wslPath)));
                if (string == null) {
                    WSLDistributionWithRootInternal.$$$reportNull$$$0(4);
                }
                return string;
            }
            String string = super.getWindowsPath(wslPath);
            if (string == null) {
                WSLDistributionWithRootInternal.$$$reportNull$$$0(5);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 4, 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "wslDistribution";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "windowsPath";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "wslPath";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/toolchains/wsl/WSLCidrUtil$WSLDistributionWithRootInternal";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/toolchains/wsl/WSLCidrUtil$WSLDistributionWithRootInternal";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getWindowsPath";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getWslPath";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getWindowsPath";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3, 4, 5 -> new IllegalStateException(string);
            };
        }
    }
}

