/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.cmake.actions.generate.handlers;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.lang.LanguageCodeInsightActionHandler;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.jetbrains.cidr.cpp.CLionCMakeBundle;
import com.jetbrains.cidr.cpp.cmake.actions.CMakeActionsUtilKt;
import com.jetbrains.cidr.cpp.cmake.actions.generate.CMakeGenerateUtilKt;
import com.jetbrains.cidr.cpp.cmake.actions.generate.DefaultTargetDialog;
import com.jetbrains.cidr.cpp.cmake.actions.generate.TargetDialog;
import com.jetbrains.cmake.CMakeListsFileType;
import com.jetbrains.cmake.completion.contributors.providers.CMakeStandardCommands;
import com.jetbrains.cmake.psi.CMakeArgument;
import com.jetbrains.cmake.psi.CMakeBlockCommandCall;
import com.jetbrains.cmake.psi.CMakeBodyBlock;
import com.jetbrains.cmake.psi.CMakeBreakCommandCall;
import com.jetbrains.cmake.psi.CMakeCommand;
import com.jetbrains.cmake.psi.CMakeCommandArgumentsMixin;
import com.jetbrains.cmake.psi.CMakeCommandMixin;
import com.jetbrains.cmake.psi.CMakeContinueCommandCall;
import com.jetbrains.cmake.psi.CMakeElementFactory;
import com.jetbrains.cmake.psi.CMakeElseCommandCall;
import com.jetbrains.cmake.psi.CMakeElseIfCommandCall;
import com.jetbrains.cmake.psi.CMakeEndBlockCommandCall;
import com.jetbrains.cmake.psi.CMakeEndForeachCommandCall;
import com.jetbrains.cmake.psi.CMakeEndFunctionCommandCall;
import com.jetbrains.cmake.psi.CMakeEndIfCommandCall;
import com.jetbrains.cmake.psi.CMakeEndMacroCommandCall;
import com.jetbrains.cmake.psi.CMakeEndWhileCommandCall;
import com.jetbrains.cmake.psi.CMakeFile;
import com.jetbrains.cmake.psi.CMakeForeachCommandCall;
import com.jetbrains.cmake.psi.CMakeFunctionCommandCall;
import com.jetbrains.cmake.psi.CMakeIfCommand;
import com.jetbrains.cmake.psi.CMakeIfCommandCall;
import com.jetbrains.cmake.psi.CMakeLoopCommand;
import com.jetbrains.cmake.psi.CMakeMacroCommandCall;
import com.jetbrains.cmake.psi.CMakeRoutine;
import com.jetbrains.cmake.psi.CMakeWhileCommandCall;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\r\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H&J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0018\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0011H\u0002J\u0018\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0011H\u0002J&\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u00112\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u000b0\u001dH\u0002J\u0018\u0010\u001e\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020 J\u0018\u0010\"\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\u001d2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J,\u0010#\u001a\u00020$2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\t2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u000b0\u001dJ!\u0010%\u001a\u00020$2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010&\u001a\u00020\u000bH\u0096\u0002J\b\u0010'\u001a\u00020\u0007H\u0016\u00a8\u0006("}, d2={"Lcom/jetbrains/cidr/cpp/cmake/actions/generate/handlers/CMakeGenerateTargetHandler;", "Lcom/intellij/lang/LanguageCodeInsightActionHandler;", "<init>", "()V", "getCommand", "Lcom/jetbrains/cmake/completion/contributors/providers/CMakeStandardCommands;", "isValidFor", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "createTargetDialog", "Lcom/jetbrains/cidr/cpp/cmake/actions/generate/TargetDialog;", "project", "Lcom/intellij/openapi/project/Project;", "findInsertPosition", "", "offset", "element", "Lcom/intellij/psi/PsiElement;", "shouldInsertNewLineBefore", "sequence", "", "at", "shouldInsertNewLineAfter", "createInsertedNode", "", "sources", "", "getRelativePath", "baseFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "otherFile", "selectSources", "createTarget", "", "invoke", "psiFile", "startInWriteAction", "intellij.clion.cmake"})
@SourceDebugExtension(value={"SMAP\nCMakeGenerateTargetHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CMakeGenerateTargetHandler.kt\ncom/jetbrains/cidr/cpp/cmake/actions/generate/handlers/CMakeGenerateTargetHandler\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 psiTreeUtil.kt\ncom/intellij/psi/util/PsiTreeUtilKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,185:1\n1310#2,2:186\n1310#2,2:188\n66#3,2:190\n66#3,2:196\n1563#4:192\n1634#4,3:193\n*S KotlinDebug\n*F\n+ 1 CMakeGenerateTargetHandler.kt\ncom/jetbrains/cidr/cpp/cmake/actions/generate/handlers/CMakeGenerateTargetHandler\n*L\n58#1:186,2\n71#1:188,2\n74#1:190,2\n156#1:196,2\n110#1:192\n110#1:193,3\n*E\n"})
public abstract class CMakeGenerateTargetHandler
implements LanguageCodeInsightActionHandler {
    @NotNull
    public abstract CMakeStandardCommands getCommand();

    public boolean isValidFor(@NotNull Editor editor, @NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return file.isValid() && Intrinsics.areEqual((Object)file.getFileType(), (Object)CMakeListsFileType.INSTANCE);
    }

    private final TargetDialog createTargetDialog(Project project) {
        String string = CLionCMakeBundle.message("cmake.generate.target.editor.title", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return new DefaultTargetDialog(project, string);
    }

    private final int findInsertPosition(Editor editor, PsiFile file) {
        int n;
        int offset = editor.getCaretModel().getCurrentCaret().getOffset();
        if (offset == PsiTreeUtilKt.getEndOffset((PsiElement)((PsiElement)file))) {
            return PsiTreeUtilKt.getEndOffset((PsiElement)((PsiElement)file));
        }
        PsiElement psiElement = file.findElementAt(editor.getCaretModel().getCurrentCaret().getOffset());
        if (psiElement == null) {
            return -1;
        }
        PsiElement currentElement = psiElement;
        if (currentElement instanceof PsiErrorElement) {
            return -1;
        }
        PsiElement psiElement2 = new PsiElement[]{Reflection.getOrCreateKotlinClass(CMakeCommand.class), Reflection.getOrCreateKotlinClass(CMakeRoutine.class), Reflection.getOrCreateKotlinClass(PsiComment.class), Reflection.getOrCreateKotlinClass(CMakeBodyBlock.class), Reflection.getOrCreateKotlinClass(CMakeFile.class)};
        PsiElement commandOrCommentOrBodyBlock = PsiTreeUtilKt.parentOfTypes((PsiElement)currentElement, (KClass[])psiElement2, (boolean)true);
        if ((psiElement2 = commandOrCommentOrBodyBlock) instanceof CMakeFunctionCommandCall || psiElement2 instanceof CMakeMacroCommandCall || psiElement2 instanceof CMakeBlockCommandCall || psiElement2 instanceof CMakeWhileCommandCall || psiElement2 instanceof CMakeForeachCommandCall || psiElement2 instanceof CMakeIfCommandCall) {
            if (offset == PsiTreeUtilKt.getStartOffset((PsiElement)commandOrCommentOrBodyBlock)) {
                n = offset;
            } else {
                Object object;
                block21: {
                    PsiElement[] psiElementArray = ((CMakeCommandMixin)commandOrCommentOrBodyBlock).getParent().getChildren();
                    Intrinsics.checkNotNullExpressionValue((Object)psiElementArray, (String)"getChildren(...)");
                    Object[] $this$firstOrNull$iv = psiElementArray;
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        PsiElement it = (PsiElement)element$iv;
                        boolean bl = false;
                        if (!(it instanceof CMakeBodyBlock)) continue;
                        object = element$iv;
                        break block21;
                    }
                    object = null;
                }
                PsiElement psiElement3 = (PsiElement)object;
                n = psiElement3 != null ? PsiTreeUtilKt.getStartOffset((PsiElement)psiElement3) : -1;
            }
        } else if (psiElement2 instanceof CMakeContinueCommandCall || psiElement2 instanceof CMakeBreakCommandCall) {
            PsiElement psiElement4 = ((CMakeCommandMixin)commandOrCommentOrBodyBlock).getParent();
            Intrinsics.checkNotNullExpressionValue((Object)psiElement4, (String)"getParent(...)");
            n = this.findInsertPosition(offset, psiElement4);
        } else if (psiElement2 instanceof CMakeEndFunctionCommandCall || psiElement2 instanceof CMakeEndMacroCommandCall || psiElement2 instanceof CMakeEndBlockCommandCall || psiElement2 instanceof CMakeEndWhileCommandCall || psiElement2 instanceof CMakeEndForeachCommandCall || psiElement2 instanceof CMakeEndIfCommandCall) {
            PsiElement psiElement5 = ((CMakeCommandMixin)commandOrCommentOrBodyBlock).getParent();
            Intrinsics.checkNotNullExpressionValue((Object)psiElement5, (String)"getParent(...)");
            n = this.findInsertPosition(offset, psiElement5);
        } else if (psiElement2 instanceof CMakeElseIfCommandCall || psiElement2 instanceof CMakeElseCommandCall) {
            PsiElement psiElement6 = ((CMakeCommandMixin)commandOrCommentOrBodyBlock).getParent();
            Intrinsics.checkNotNullExpressionValue((Object)psiElement6, (String)"getParent(...)");
            n = this.findInsertPosition(offset, psiElement6);
        } else if (psiElement2 instanceof CMakeLoopCommand || psiElement2 instanceof CMakeRoutine || psiElement2 instanceof CMakeIfCommand) {
            if (offset == PsiTreeUtilKt.getStartOffset((PsiElement)commandOrCommentOrBodyBlock)) {
                n = offset;
            } else {
                Object object;
                block22: {
                    PsiElement[] psiElementArray = commandOrCommentOrBodyBlock.getChildren();
                    Intrinsics.checkNotNullExpressionValue((Object)psiElementArray, (String)"getChildren(...)");
                    Object[] $this$firstOrNull$iv = psiElementArray;
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        PsiElement it = (PsiElement)element$iv;
                        boolean bl = false;
                        if (!(it instanceof CMakeBodyBlock)) continue;
                        object = element$iv;
                        break block22;
                    }
                    object = null;
                }
                PsiElement psiElement7 = (PsiElement)object;
                n = psiElement7 != null ? PsiTreeUtilKt.getStartOffset((PsiElement)psiElement7) : -1;
            }
        } else if (psiElement2 instanceof PsiComment) {
            CMakeCommandArgumentsMixin argList;
            PsiElement $this$parentOfType_u24default$iv = commandOrCommentOrBodyBlock;
            boolean withSelf$iv = false;
            boolean $i$f$parentOfType = false;
            CMakeCommandArgumentsMixin cMakeCommandArgumentsMixin = argList = (CMakeCommandArgumentsMixin)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType_u24default$iv, CMakeCommandArgumentsMixin.class, (boolean)true);
            n = cMakeCommandArgumentsMixin != null ? PsiTreeUtilKt.getEndOffset((PsiElement)cMakeCommandArgumentsMixin) : PsiTreeUtilKt.getEndOffset((PsiElement)commandOrCommentOrBodyBlock);
        } else {
            n = psiElement2 instanceof CMakeCommand ? this.findInsertPosition(offset, commandOrCommentOrBodyBlock) : (psiElement2 instanceof CMakeBodyBlock ? PsiTreeUtilKt.getStartOffset((PsiElement)currentElement) : (psiElement2 instanceof CMakeFile ? PsiTreeUtilKt.getStartOffset((PsiElement)currentElement) : -1));
        }
        return n;
    }

    private final int findInsertPosition(int offset, PsiElement element) {
        return offset == PsiTreeUtilKt.getStartOffset((PsiElement)element) ? PsiTreeUtilKt.getStartOffset((PsiElement)element) : PsiTreeUtilKt.getEndOffset((PsiElement)element);
    }

    private final boolean shouldInsertNewLineBefore(CharSequence sequence, int at) {
        if (at == 0) {
            return false;
        }
        int prevNonSpace = StringUtil.skipWhitespaceBackward((CharSequence)sequence, (int)at) - 1;
        return !(0 <= prevNonSpace ? prevNonSpace < sequence.length() : false) || !StringUtil.isLineBreak((char)sequence.charAt(prevNonSpace));
    }

    private final boolean shouldInsertNewLineAfter(CharSequence sequence, int at) {
        if (at == sequence.length()) {
            return false;
        }
        int nextNonSpace = StringUtil.skipWhitespaceForward((CharSequence)sequence, (int)at);
        return nextNonSpace >= sequence.length() || !StringUtil.isLineBreak((char)sequence.charAt(nextNonSpace));
    }

    /*
     * WARNING - void declaration
     */
    private final String createInsertedNode(PsiFile file, int at, List<? extends PsiFile> sources) {
        Collection<String> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        StringBuilder stringBuilder;
        String sequence = file.getText();
        StringBuilder $this$createInsertedNode_u24lambda_u243 = stringBuilder = new StringBuilder();
        boolean bl = false;
        Intrinsics.checkNotNull((Object)sequence);
        if (this.shouldInsertNewLineBefore(sequence, at)) {
            $this$createInsertedNode_u24lambda_u243.append("\n");
        }
        Project project = file.getProject();
        String string = this.getCommand().getCommandName();
        Project project2 = file.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        Iterable iterable = sources;
        Collection collection2 = CollectionsKt.listOf((Object)CMakeActionsUtilKt.generateCMakeTargetName(project2));
        String string2 = string;
        Project project3 = project;
        StringBuilder stringBuilder2 = $this$createInsertedNode_u24lambda_u243;
        boolean $i$f$map = false;
        void var14_14 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            PsiFile psiFile = (PsiFile)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl2 = false;
            VirtualFile virtualFile = file.getVirtualFile();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getVirtualFile(...)");
            VirtualFile virtualFile2 = it.getVirtualFile();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"getVirtualFile(...)");
            collection.add(this.getRelativePath(virtualFile, virtualFile2));
        }
        collection = (List)destination$iv$iv;
        String string3 = CMakeElementFactory.createCommand(project3, string2, CollectionsKt.plus((Collection)collection2, (Iterable)collection)).getText();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getText(...)");
        stringBuilder2.append(((Object)StringsKt.trim((CharSequence)string3)).toString());
        if (this.shouldInsertNewLineAfter(sequence, at)) {
            $this$createInsertedNode_u24lambda_u243.append("\n");
        }
        return stringBuilder.toString();
    }

    @Nullable
    public final String getRelativePath(@NotNull VirtualFile baseFile, @NotNull VirtualFile otherFile) {
        Intrinsics.checkNotNullParameter((Object)baseFile, (String)"baseFile");
        Intrinsics.checkNotNullParameter((Object)otherFile, (String)"otherFile");
        VirtualFile baseDir = baseFile.isDirectory() ? baseFile : baseFile.getParent();
        String string = FileUtil.getRelativePath((File)new File(baseDir.getPath()), (File)new File(otherFile.getPath()));
        if (string == null) {
            String string2 = otherFile.getPath();
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPath(...)");
        }
        String relativePath = string;
        return FileUtil.toCanonicalPath((String)relativePath);
    }

    private final List<PsiFile> selectSources(Project project) {
        TargetDialog dialog = this.createTargetDialog(project);
        if (dialog.showAndGet()) {
            return dialog.getSelectedSources();
        }
        return null;
    }

    public final void createTarget(@NotNull Project project, @NotNull PsiFile file, @NotNull Editor editor, @NotNull List<? extends PsiFile> sources) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter(sources, (String)"sources");
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        CommandProcessor.getInstance().executeCommand(project, () -> CMakeGenerateTargetHandler.createTarget$lambda$6(file, this, editor, sources, project), CLionCMakeBundle.message("cmake.generate.target.command.title", new Object[0]), null);
    }

    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile psiFile) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        List<PsiFile> sources = this.selectSources(project);
        if (sources != null) {
            this.createTarget(project, psiFile, editor, sources);
        }
    }

    public boolean startInWriteAction() {
        return false;
    }

    private static final Pair createTarget$lambda$6$lambda$4(CMakeGenerateTargetHandler this$0, Editor $editor, PsiFile $file, List $sources) {
        int insertPosition = this$0.findInsertPosition($editor, $file);
        return insertPosition == -1 ? new Pair((Object)"", (Object)insertPosition) : new Pair((Object)this$0.createInsertedNode($file, insertPosition, $sources), (Object)insertPosition);
    }

    private static final void createTarget$lambda$6$lambda$5(Project $project, PsiFile $file, Pair $result, Editor $editor, int $newCaretPosition) {
        Document doc = PsiDocumentManager.getInstance((Project)$project).getDocument($file);
        if (doc != null) {
            CMakeCommandMixin cMakeCommandMixin;
            doc.insertString(((Number)$result.getSecond()).intValue(), (CharSequence)$result.getFirst());
            PsiDocumentManager.getInstance((Project)$project).commitDocument(doc);
            $editor.getCaretModel().moveToOffset($newCaretPosition);
            PsiElement psiElement = $file.findElementAt($newCaretPosition);
            if (psiElement != null) {
                PsiElement $this$parentOfType_u24default$iv = psiElement;
                boolean withSelf$iv = false;
                boolean $i$f$parentOfType = false;
                cMakeCommandMixin = (CMakeCommand)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType_u24default$iv, CMakeCommand.class, (boolean)true);
            } else {
                cMakeCommandMixin = null;
            }
            Intrinsics.checkNotNull(cMakeCommandMixin);
            CMakeCommandMixin cmd = cMakeCommandMixin;
            List<CMakeArgument> list2 = cmd.getCMakeArgumentList();
            Intrinsics.checkNotNull(list2);
            CMakeGenerateUtilKt.selectElement(list2.get(0));
            if (!InjectedLanguageManager.getInstance((Project)$project).isInjectedFragment($file)) {
                PostprocessReformattingAspect.getInstance((Project)$project).assertDocumentChangeIsAllowed($file.getViewProvider());
                CodeStyleManager.getInstance((Project)$project).reformatRange((PsiElement)$file, ((Number)$result.getSecond()).intValue(), ((Number)$result.getSecond()).intValue() + ((String)$result.getFirst()).length());
            }
        }
    }

    private static final void createTarget$lambda$6(PsiFile $file, CMakeGenerateTargetHandler this$0, Editor $editor, List $sources, Project $project) {
        Pair result2 = (Pair)ReadAction.compute(() -> CMakeGenerateTargetHandler.createTarget$lambda$6$lambda$4(this$0, $editor, $file, $sources));
        if (((Number)result2.getSecond()).intValue() != -1) {
            int newCaretPosition = ((Number)result2.getSecond()).intValue() + StringsKt.indexOf$default((CharSequence)((CharSequence)result2.getFirst()), (char)'(', (int)0, (boolean)false, (int)6, null) + 1;
            PsiElement[] psiElementArray = new PsiElement[]{$file};
            if (FileModificationService.getInstance().preparePsiElementsForWrite(psiElementArray)) {
                WriteAction.run(() -> CMakeGenerateTargetHandler.createTarget$lambda$6$lambda$5($project, $file, result2, $editor, newCaretPosition));
            }
        }
    }
}

