/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.cmake.model;

import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.util.containers.CollectionFactory;
import com.jetbrains.cidr.cpp.cmake.CMakeException;
import com.jetbrains.cidr.cpp.cmake.model.CMakeStringSettingsFileParser;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CMakeFlagsFile {
    @NlsSafe
    public static final String AD_HOC_TARGET_FLAGS = "_AD_HOC_TARGET_FLAGS_";
    private final Map<String, String> myVariables;

    public CMakeFlagsFile(@NotNull String text) {
        if (text == null) {
            CMakeFlagsFile.$$$reportNull$$$0(0);
        }
        this.myVariables = Collections.unmodifiableMap(new Parser().parseUnique(text));
    }

    public CMakeFlagsFile(@NotNull File file, @NotNull String encoding) throws CMakeException {
        if (file == null) {
            CMakeFlagsFile.$$$reportNull$$$0(1);
        }
        if (encoding == null) {
            CMakeFlagsFile.$$$reportNull$$$0(2);
        }
        this.myVariables = Collections.unmodifiableMap(new Parser().parseUnique(file, encoding));
    }

    @NotNull
    public Collection<String> getVariables() {
        Collection<String> collection = this.myVariables.values();
        if (collection == null) {
            CMakeFlagsFile.$$$reportNull$$$0(3);
        }
        return collection;
    }

    @Nullable
    public String getVariable(@NlsSafe @NotNull String key) {
        if (key == null) {
            CMakeFlagsFile.$$$reportNull$$$0(4);
        }
        return this.myVariables.get(key);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "encoding";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/cpp/cmake/model/CMakeFlagsFile";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/cpp/cmake/model/CMakeFlagsFile";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariables";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getVariable";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }

    private static class Parser
    extends CMakeStringSettingsFileParser {
        @NonNls
        private static final String[] STRIP_PREFIXES = new String[]{"# Custom flags: ", "# Custom defines: ", "# PCH options: "};
        private static final Pattern COMPILER_PATTERN = Pattern.compile("# compile (\\w+) with (.*)", 32);
        private static final Pattern CMAKE_2_8_11_TARGET_FLAGS_PATTERN = Pattern.compile("# TARGET_FLAGS = (.*)", 32);

        private Parser() {
        }

        @Override
        @NotNull
        protected <V> Map<String, V> createMap() {
            Map map = CollectionFactory.createFilePathLinkedMap();
            if (map == null) {
                Parser.$$$reportNull$$$0(0);
            }
            return map;
        }

        @Override
        @NotNull
        protected Pair<String, String> parseVariable(@NotNull String beforeEqual, @NotNull String afterEqual) {
            if (beforeEqual == null) {
                Parser.$$$reportNull$$$0(1);
            }
            if (afterEqual == null) {
                Parser.$$$reportNull$$$0(2);
            }
            Pair pair = Pair.create((Object)beforeEqual.trim(), (Object)afterEqual.trim());
            if (pair == null) {
                Parser.$$$reportNull$$$0(3);
            }
            return pair;
        }

        @Override
        @NotNull
        protected String convertLineAndKeepEOLs(@NotNull String lineWithEOLs) {
            if (lineWithEOLs == null) {
                Parser.$$$reportNull$$$0(4);
            }
            for (String prefix : STRIP_PREFIXES) {
                if (!lineWithEOLs.startsWith(prefix)) continue;
                String string = lineWithEOLs.substring(prefix.length());
                if (string == null) {
                    Parser.$$$reportNull$$$0(5);
                }
                return string;
            }
            Matcher m = COMPILER_PATTERN.matcher(lineWithEOLs);
            if (m.matches()) {
                String string = m.group(1) + "_COMPILER=" + m.group(2);
                if (string == null) {
                    Parser.$$$reportNull$$$0(6);
                }
                return string;
            }
            m = CMAKE_2_8_11_TARGET_FLAGS_PATTERN.matcher(lineWithEOLs);
            if (m.matches()) {
                String string = "_AD_HOC_TARGET_FLAGS_=" + m.group(1);
                if (string == null) {
                    Parser.$$$reportNull$$$0(7);
                }
                return string;
            }
            String string = lineWithEOLs;
            if (string == null) {
                Parser.$$$reportNull$$$0(8);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 4 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/cpp/cmake/model/CMakeFlagsFile$Parser";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "beforeEqual";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "afterEqual";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "lineWithEOLs";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createMap";
                    break;
                }
                case 1: 
                case 2: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/cpp/cmake/model/CMakeFlagsFile$Parser";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "parseVariable";
                    break;
                }
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "convertLineAndKeepEOLs";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "parseVariable";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "convertLineAndKeepEOLs";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 4 -> new IllegalArgumentException(string);
            };
        }
    }
}

