/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.cmake.model;

import com.jetbrains.cidr.cpp.CPPLog;
import com.jetbrains.cidr.cpp.cmake.model.CMakeModelConfigurationData;
import com.jetbrains.cidr.cpp.cmake.model.CMakeTarget;
import com.jetbrains.cidr.lang.OCLanguageKind;
import java.io.File;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \"2\u00020\u0001:\u0001\"B[\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\r0\f\u0012\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\t\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u000e\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fJ\r\u0010 \u001a\u00070\u0003\u00a2\u0006\u0002\b!H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0015R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u001d\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0018\u00a8\u0006#"}, d2={"Lcom/jetbrains/cidr/cpp/cmake/model/CMakeModel;", "Ljava/io/Serializable;", "projectName", "", "cMakeDependencyFiles", "", "Ljava/io/File;", "headerAndResourceFiles", "targets", "", "Lcom/jetbrains/cidr/cpp/cmake/model/CMakeTarget;", "fileExtensions", "", "Lcom/jetbrains/cidr/lang/OCLanguageKind;", "configurationData", "Lcom/jetbrains/cidr/cpp/cmake/model/CMakeModelConfigurationData;", "<init>", "(Ljava/lang/String;Ljava/util/Set;Ljava/util/Set;Ljava/util/List;Ljava/util/Map;Ljava/util/List;)V", "getProjectName", "()Ljava/lang/String;", "getCMakeDependencyFiles", "()Ljava/util/Set;", "getHeaderAndResourceFiles", "getTargets", "()Ljava/util/List;", "getFileExtensions", "()Ljava/util/Map;", "getConfigurationData", "save", "", "out", "Ljava/io/ObjectOutputStream;", "toString", "Lorg/jetbrains/annotations/NonNls;", "Companion", "intellij.clion.cmake"})
public final class CMakeModel
implements Serializable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String projectName;
    @NotNull
    private final Set<File> cMakeDependencyFiles;
    @NotNull
    private final Set<File> headerAndResourceFiles;
    @NotNull
    private final List<CMakeTarget> targets;
    @NotNull
    private final Map<String, OCLanguageKind> fileExtensions;
    @NotNull
    private final List<CMakeModelConfigurationData> configurationData;
    @NotNull
    public static final String BUILD_TYPE_DEFAULT = "Default";
    @NotNull
    public static final String DEBUG = "Debug";
    @NotNull
    public static final String RELEASE = "Release";
    @NotNull
    public static final String REL_WITH_DEB_INFO = "RelWithDebInfo";
    @NotNull
    public static final String MIN_SIZE_REL = "MinSizeRel";
    @JvmField
    @NotNull
    public static final List<String> DEFAULT_BUILD_TYPES;
    public static final int SERIALIZATION_VERSION = 141;

    public CMakeModel(@NotNull String projectName, @NotNull Set<? extends File> cMakeDependencyFiles, @NotNull Set<? extends File> headerAndResourceFiles, @NotNull List<? extends CMakeTarget> targets, @NotNull Map<String, ? extends OCLanguageKind> fileExtensions, @NotNull List<CMakeModelConfigurationData> configurationData) {
        Intrinsics.checkNotNullParameter((Object)projectName, (String)"projectName");
        Intrinsics.checkNotNullParameter(cMakeDependencyFiles, (String)"cMakeDependencyFiles");
        Intrinsics.checkNotNullParameter(headerAndResourceFiles, (String)"headerAndResourceFiles");
        Intrinsics.checkNotNullParameter(targets, (String)"targets");
        Intrinsics.checkNotNullParameter(fileExtensions, (String)"fileExtensions");
        Intrinsics.checkNotNullParameter(configurationData, (String)"configurationData");
        this.projectName = projectName;
        Set<? extends File> set = Collections.unmodifiableSet(cMakeDependencyFiles);
        Intrinsics.checkNotNullExpressionValue(set, (String)"unmodifiableSet(...)");
        this.cMakeDependencyFiles = set;
        Set<? extends File> set2 = Collections.unmodifiableSet(headerAndResourceFiles);
        Intrinsics.checkNotNullExpressionValue(set2, (String)"unmodifiableSet(...)");
        this.headerAndResourceFiles = set2;
        List<? extends CMakeTarget> list2 = Collections.unmodifiableList(targets);
        Intrinsics.checkNotNullExpressionValue(list2, (String)"unmodifiableList(...)");
        this.targets = list2;
        Map<String, ? extends OCLanguageKind> map = Collections.unmodifiableMap(fileExtensions);
        Intrinsics.checkNotNullExpressionValue(map, (String)"unmodifiableMap(...)");
        this.fileExtensions = map;
        List<CMakeModelConfigurationData> list3 = Collections.unmodifiableList(configurationData);
        Intrinsics.checkNotNullExpressionValue(list3, (String)"unmodifiableList(...)");
        this.configurationData = list3;
    }

    @NotNull
    public final String getProjectName() {
        return this.projectName;
    }

    @NotNull
    public final Set<File> getCMakeDependencyFiles() {
        return this.cMakeDependencyFiles;
    }

    @NotNull
    public final Set<File> getHeaderAndResourceFiles() {
        return this.headerAndResourceFiles;
    }

    @NotNull
    public final List<CMakeTarget> getTargets() {
        return this.targets;
    }

    @NotNull
    public final Map<String, OCLanguageKind> getFileExtensions() {
        return this.fileExtensions;
    }

    @NotNull
    public final List<CMakeModelConfigurationData> getConfigurationData() {
        return this.configurationData;
    }

    public final void save(@NotNull ObjectOutputStream out) {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        out.writeInt(141);
        out.writeObject(this);
    }

    @NotNull
    public String toString() {
        return this.projectName + " [" + this.targets.size() + " targets]";
    }

    @JvmStatic
    @Nullable
    public static final CMakeModel load(@NotNull ObjectInputStream out) {
        return Companion.load(out);
    }

    static {
        Object[] objectArray = new String[]{BUILD_TYPE_DEFAULT, DEBUG, RELEASE, REL_WITH_DEB_INFO, MIN_SIZE_REL};
        DEFAULT_BUILD_TYPES = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0007R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0007\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u0013\u0010\b\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u0013\u0010\t\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u0013\u0010\n\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u000b\u001a\r\u0012\t\u0012\u00070\u0005\u00a2\u0006\u0002\b\u00060\f8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/cidr/cpp/cmake/model/CMakeModel$Companion;", "", "<init>", "()V", "BUILD_TYPE_DEFAULT", "", "Lcom/intellij/openapi/util/NlsSafe;", "DEBUG", "RELEASE", "REL_WITH_DEB_INFO", "MIN_SIZE_REL", "DEFAULT_BUILD_TYPES", "", "SERIALIZATION_VERSION", "", "load", "Lcom/jetbrains/cidr/cpp/cmake/model/CMakeModel;", "out", "Ljava/io/ObjectInputStream;", "intellij.clion.cmake"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @Nullable
        public final CMakeModel load(@NotNull ObjectInputStream out) {
            Intrinsics.checkNotNullParameter((Object)out, (String)"out");
            try {
                if (out.readInt() != 141) {
                    return null;
                }
                Object object = out.readObject();
                return object instanceof CMakeModel ? (CMakeModel)object : null;
            }
            catch (ClassNotFoundException e) {
                CPPLog.LOG.info("Failed to load CMakeModel", (Throwable)e);
                return null;
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

