/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.cmake.projectWizard.generators;

import com.intellij.facet.ui.ValidationResult;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.fileTemplates.FileTemplateUtil;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.ide.util.PsiNavigationSupport;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.Version;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.GeneratorPeerImpl;
import com.intellij.platform.ProjectGeneratorPeer;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiManager;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.cpp.CLionCMakeBundle;
import com.jetbrains.cidr.cpp.CPPBundle;
import com.jetbrains.cidr.cpp.CPPLog;
import com.jetbrains.cidr.cpp.cmake.projectWizard.CLionProjectWizardUtils;
import com.jetbrains.cidr.cpp.cmake.projectWizard.generators.CLionProjectGenerator;
import com.jetbrains.cidr.cpp.cmake.projectWizard.generators.settings.CMakeProjectSettings;
import com.jetbrains.cidr.cpp.cmake.projectWizard.generators.settings.ui.CMakeSettingsPanel;
import com.jetbrains.cidr.cpp.cmake.templates.CommonCMakeTemplateConstants;
import com.jetbrains.cidr.cpp.cmake.workspace.CMakeWorkspace;
import com.jetbrains.cidr.fus.CidrWorkspaceUsageCounterCollector;
import com.jetbrains.cidr.project.CidrProjectWizardUtil;
import icons.CMakeIcons;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CMakeProjectGenerator
extends CLionProjectGenerator<CMakeProjectSettings> {
    private static final Logger LOG = Logger.getInstance(CMakeProjectGenerator.class);
    @NlsSafe
    public static final String SHARED_LIB_TYPE = "shared";
    @NlsSafe
    public static final String STATIC_LIB_TYPE = "static";
    public static final boolean TIPS_ENABLED_DEFAULT = !PluginManagerCore.isDisabled((PluginId)PluginId.getId((String)"training"));
    private static final CMakeProjectSettings C_MAKE_DEFAULT_PROJECT_SETTINGS = new CMakeProjectSettings(){

        @Override
        @NotNull
        public String getEnabledProjectLanguages() {
            return "";
        }

        @Override
        @NotNull
        public String getLanguageVersion() {
            return "";
        }

        @Override
        @NotNull
        @NonNls
        public String getLanguageVersionLineForCMake() {
            return "";
        }
    };
    @Nullable
    protected String myLanguageVersion;
    @Nullable
    private String myLibraryType = "static";
    @NonNls
    protected static final String areTipsEnabled = "onboarding.tips.enabled";

    @Nullable
    public Icon getLogo() {
        return CMakeIcons.CMake;
    }

    @NotNull
    public ValidationResult validate(@NotNull String baseDirPath) {
        if (baseDirPath == null) {
            CMakeProjectGenerator.$$$reportNull$$$0(0);
        }
        if (StringUtil.isEmptyOrSpaces((String)baseDirPath)) {
            return new ValidationResult(CLionCMakeBundle.message("cmake.project.generator.enter.project.location", new Object[0]));
        }
        File dir = new File(baseDirPath);
        if (!dir.isAbsolute()) {
            return new ValidationResult(CLionCMakeBundle.message("cmake.project.generator.project.location.path.should.be.absolute", new Object[0]));
        }
        if (dir.exists() && !dir.canWrite()) {
            return new ValidationResult(CLionCMakeBundle.message("cmake.project.generator.directory.is.not.writable", baseDirPath));
        }
        ValidationResult validationResult = ValidationResult.OK;
        if (validationResult == null) {
            CMakeProjectGenerator.$$$reportNull$$$0(1);
        }
        return validationResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateProject(@NotNull Project project, @NotNull VirtualFile baseDir, @NotNull CMakeProjectSettings settings, @NotNull Module module) {
        if (project == null) {
            CMakeProjectGenerator.$$$reportNull$$$0(2);
        }
        if (baseDir == null) {
            CMakeProjectGenerator.$$$reportNull$$$0(3);
        }
        if (settings == null) {
            CMakeProjectGenerator.$$$reportNull$$$0(4);
        }
        if (module == null) {
            CMakeProjectGenerator.$$$reportNull$$$0(5);
        }
        super.generateProject(project, baseDir, (Object)settings, module);
        CidrProjectWizardUtil.NEW_PROJECT_GENERATION_IN_PROGRESS.set((UserDataHolder)project, (Object)true);
        try {
            CreatedFilesHolder createdFiles;
            CidrWorkspaceUsageCounterCollector.logProjectCreated((String)"CMake", (Project)project);
            try {
                createdFiles = this.createProject(project, baseDir);
            }
            catch (IOException e) {
                this.handleErrorDuringGeneration(project, e);
                CidrProjectWizardUtil.NEW_PROJECT_GENERATION_IN_PROGRESS.set((UserDataHolder)project, null);
                return;
            }
            CLionProjectWizardUtils.reformatProjectFiles(project, createdFiles.cMakeFile, createdFiles.sourceFiles.toArray(VirtualFile.EMPTY_ARRAY));
            CMakeWorkspace.getInstance(project).linkCMakeProjectAsync(VfsUtilCore.virtualToIoFile((VirtualFile)baseDir));
            if (!ApplicationManager.getApplication().isHeadlessEnvironment()) {
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (createdFiles.cMakeFile != null) {
                        PsiNavigationSupport.getInstance().createNavigatable(project, createdFiles.cMakeFile, -1).navigate(false);
                    }
                    createdFiles.sourceFiles.forEach(vf -> PsiNavigationSupport.getInstance().createNavigatable(project, vf, -1).navigate(true));
                }, ModalityState.nonModal());
            }
        }
        finally {
            CidrProjectWizardUtil.NEW_PROJECT_GENERATION_IN_PROGRESS.set((UserDataHolder)project, null);
        }
    }

    protected void handleErrorDuringGeneration(@NotNull Project project, Exception e) {
        if (project == null) {
            CMakeProjectGenerator.$$$reportNull$$$0(6);
        }
        Messages.showErrorDialog((Project)project, (String)CLionCMakeBundle.message("cmake.cannot.create.new.project", e.getMessage()), (String)CPPBundle.message((String)"action.CPP.CreateNewCLionProject.text", (Object[])new Object[0]));
        CPPLog.LOG.info((Throwable)e);
    }

    @NotNull
    public ProjectGeneratorPeer<CMakeProjectSettings> createPeer() {
        CMakeProjectSettings cMakeProjectSettings;
        JComponent panel2 = this.getSettingsPanel();
        if (panel2 == null) {
            panel2 = new JPanel();
        }
        if ((cMakeProjectSettings = this.getCMakeProjectSettings()) == null) {
            cMakeProjectSettings = C_MAKE_DEFAULT_PROJECT_SETTINGS;
        }
        return new GeneratorPeerImpl((Object)cMakeProjectSettings, panel2);
    }

    @Nullable
    public CMakeProjectSettings getCMakeProjectSettings() {
        CMakeProjectSettings settings = this.createProjectSettings();
        if (settings != null) {
            if (this.myLanguageVersion != null) {
                settings.setLanguageVersion(this.myLanguageVersion);
            }
            if (this.myLibraryType != null) {
                settings.setLibraryType(this.myLibraryType);
            }
            settings.setTips(this.getAreTipsEnabled());
        }
        return settings;
    }

    public boolean addLibrarySettingsPanel() {
        return false;
    }

    public boolean addOnboardingTipsCheckbox() {
        return false;
    }

    public void setLanguageVersion(@NotNull String languageVersion) {
        if (languageVersion == null) {
            CMakeProjectGenerator.$$$reportNull$$$0(7);
        }
        this.myLanguageVersion = languageVersion;
    }

    public void setLibraryType(@Nullable String libraryType) {
        this.myLibraryType = libraryType;
    }

    public void setAreTipsEnabled(boolean value) {
        PropertiesComponent.getInstance().setValue(areTipsEnabled, value, TIPS_ENABLED_DEFAULT);
    }

    public String[] getLanguageVersions() {
        return null;
    }

    @Nullable
    public JComponent getSettingsPanel() {
        CMakeSettingsPanel panel2 = this.createSettingsPanel();
        if (panel2 != null) {
            panel2.initFields(this.myLanguageVersion, this.myLibraryType);
        }
        return panel2;
    }

    protected CMakeSettingsPanel createSettingsPanel() {
        return new CMakeSettingsPanel(this);
    }

    @Nullable
    public CMakeProjectSettings createProjectSettings() {
        return null;
    }

    private CreatedFilesHolder createProject(@NotNull Project project, VirtualFile projectDir) throws IOException {
        if (project == null) {
            CMakeProjectGenerator.$$$reportNull$$$0(8);
        }
        String sanitizedName = FileUtil.sanitizeFileName((String)project.getName());
        VirtualFile cMakeFile = this.createCMakeFile(project, sanitizedName, projectDir);
        List sourceFiles = ContainerUtil.filter((Object[])this.createSourceFiles(project, sanitizedName, projectDir), file -> file != null);
        return new CreatedFilesHolder(cMakeFile, sourceFiles);
    }

    @Nullable
    protected VirtualFile createCMakeFile(@NotNull Project project, @NotNull String name, @NotNull VirtualFile dir) throws IOException {
        if (project == null) {
            CMakeProjectGenerator.$$$reportNull$$$0(9);
        }
        if (name == null) {
            CMakeProjectGenerator.$$$reportNull$$$0(10);
        }
        if (dir == null) {
            CMakeProjectGenerator.$$$reportNull$$$0(11);
        }
        return this.createProjectFileWithContent(dir, "CMakeLists.txt", this.getCMakeFileContent(project, name));
    }

    static Properties getDefaultProjectProperties(@NotNull Project project) {
        PsiDirectory psiDir;
        if (project == null) {
            CMakeProjectGenerator.$$$reportNull$$$0(12);
        }
        FileTemplateManager templateManager = FileTemplateManager.getInstance((Project)project);
        Properties props = templateManager.getDefaultProperties();
        VirtualFile projectDir = ProjectUtil.guessProjectDir((Project)project);
        if (projectDir != null && (psiDir = PsiManager.getInstance((Project)project).findDirectory(projectDir)) != null) {
            FileTemplateUtil.fillDefaultProperties((Properties)props, (PsiDirectory)psiDir);
        }
        return props;
    }

    @NotNull
    @NonNls
    protected final String getCMakeFileContent(final @NotNull Project project, final @NotNull String projectName) {
        String string;
        FileTemplateManager templateManager;
        FileTemplate template;
        if (project == null) {
            CMakeProjectGenerator.$$$reportNull$$$0(13);
        }
        if (projectName == null) {
            CMakeProjectGenerator.$$$reportNull$$$0(14);
        }
        if ((template = this.getProjectTemplate(templateManager = FileTemplateManager.getInstance((Project)project))) == null) {
            String string2 = this.getCMakeFileContent(projectName);
            if (string2 == null) {
                CMakeProjectGenerator.$$$reportNull$$$0(15);
            }
            return string2;
        }
        final Version cmakeVersion = CLionProjectWizardUtils.getCMakeVersionForDefaultToolchain();
        HashMap<String, Object> attributes = new HashMap<String, Object>(){
            {
                FileTemplateUtil.putAll((Map)this, (Properties)CMakeProjectGenerator.getDefaultProjectProperties(project));
                this.put(CommonCMakeTemplateConstants.PROJECT_NAME, projectName);
                this.put(CommonCMakeTemplateConstants.WINDOWS, SystemInfo.isWindows);
                this.put(CommonCMakeTemplateConstants.CMAKE_MAJOR_VERSION, cmakeVersion != null ? cmakeVersion.major : 3);
                this.put(CommonCMakeTemplateConstants.CMAKE_MINOR_VERSION, cmakeVersion != null ? cmakeVersion.minor : 0);
                CMakeProjectSettings settings = CMakeProjectGenerator.this.getCMakeProjectSettings();
                if (settings != null) {
                    this.put(CommonCMakeTemplateConstants.CMAKE_LANGUAGE_VERSION, settings.getLanguageVersion());
                }
                this.putAll(CMakeProjectGenerator.this.getAdditionalProperties());
            }
        };
        try {
            string = template.getText((Map)attributes);
        }
        catch (IOException ex) {
            LOG.warn("Failed to generate template text", (Throwable)ex);
            return "message(FATAL_ERROR \"CLion can't generate CMakeLists.txt, you can check log files or fill it with content by your own.\")";
        }
        if (string == null) {
            CMakeProjectGenerator.$$$reportNull$$$0(16);
        }
        return string;
    }

    @Nullable
    protected FileTemplate getProjectTemplate(@NotNull FileTemplateManager manager) {
        if (manager == null) {
            CMakeProjectGenerator.$$$reportNull$$$0(17);
        }
        return null;
    }

    @NotNull
    protected Map<String, Object> getAdditionalProperties() {
        return new HashMap<String, Object>();
    }

    @NotNull
    @NonNls
    protected String getCMakeFileContent(@NotNull String projectName) {
        if (projectName == null) {
            CMakeProjectGenerator.$$$reportNull$$$0(18);
        }
        return "";
    }

    protected VirtualFile @NotNull [] createSourceFiles(@NotNull Project project, @NotNull String name, @NotNull VirtualFile dir) throws IOException {
        if (project == null) {
            CMakeProjectGenerator.$$$reportNull$$$0(19);
        }
        if (name == null) {
            CMakeProjectGenerator.$$$reportNull$$$0(20);
        }
        if (dir == null) {
            CMakeProjectGenerator.$$$reportNull$$$0(21);
        }
        VirtualFile[] virtualFileArray = this.createSourceFiles(name, dir);
        if (virtualFileArray == null) {
            CMakeProjectGenerator.$$$reportNull$$$0(22);
        }
        return virtualFileArray;
    }

    protected VirtualFile @NotNull [] createSourceFiles(@NotNull String name, @NotNull VirtualFile dir) throws IOException {
        if (name == null) {
            CMakeProjectGenerator.$$$reportNull$$$0(23);
        }
        if (dir == null) {
            CMakeProjectGenerator.$$$reportNull$$$0(24);
        }
        throw new UnsupportedOperationException();
    }

    @Nullable
    @NlsSafe
    public String getLanguageVersion() {
        return this.myLanguageVersion;
    }

    @Nullable
    @NlsSafe
    public String getLibraryType() {
        return this.myLibraryType;
    }

    @NotNull
    public Boolean getAreTipsEnabled() {
        Boolean bl = PropertiesComponent.getInstance().getBoolean(areTipsEnabled, TIPS_ENABLED_DEFAULT);
        if (bl == null) {
            CMakeProjectGenerator.$$$reportNull$$$0(25);
        }
        return bl;
    }

    @Nullable
    protected VirtualFile createProjectFileWithContent(final @NotNull VirtualFile projectDir, final String fileName, final @NonNls String fileContent) throws IOException {
        if (projectDir == null) {
            CMakeProjectGenerator.$$$reportNull$$$0(26);
        }
        return (VirtualFile)WriteAction.compute((ThrowableComputable)new ThrowableComputable<VirtualFile, IOException>(){

            public VirtualFile compute() throws IOException {
                VirtualFile file = projectDir.findChild(fileName);
                if (file != null) {
                    return null;
                }
                file = projectDir.createChildData((Object)this, fileName);
                file.setBinaryContent(fileContent.getBytes(StandardCharsets.UTF_8));
                return file;
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 15, 16, 22, 25 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseDirPath";
                break;
            }
            case 1: 
            case 15: 
            case 16: 
            case 22: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/cpp/cmake/projectWizard/generators/CMakeProjectGenerator";
                break;
            }
            case 2: 
            case 6: 
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseDir";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageVersion";
                break;
            }
            case 10: 
            case 20: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 11: 
            case 21: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 14: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectName";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectDir";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/cpp/cmake/projectWizard/generators/CMakeProjectGenerator";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "validate";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getCMakeFileContent";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "createSourceFiles";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getAreTipsEnabled";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "validate";
                break;
            }
            case 1: 
            case 15: 
            case 16: 
            case 22: 
            case 25: {
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "generateProject";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "handleErrorDuringGeneration";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setLanguageVersion";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createProject";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createCMakeFile";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultProjectProperties";
                break;
            }
            case 13: 
            case 14: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getCMakeFileContent";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getProjectTemplate";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "createSourceFiles";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "createProjectFileWithContent";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 15, 16, 22, 25 -> new IllegalStateException(string);
        };
    }

    private static final class CreatedFilesHolder {
        @Nullable
        private final VirtualFile cMakeFile;
        @NotNull
        private final List<VirtualFile> sourceFiles;

        private CreatedFilesHolder(@Nullable VirtualFile file, @NotNull List<VirtualFile> files) {
            if (files == null) {
                CreatedFilesHolder.$$$reportNull$$$0(0);
            }
            this.cMakeFile = file;
            this.sourceFiles = files;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/jetbrains/cidr/cpp/cmake/projectWizard/generators/CMakeProjectGenerator$CreatedFilesHolder", "<init>"));
        }
    }
}

