/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.cmake.workspace;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.jetbrains.cidr.cpp.cmake.model.CMakeConfiguration;
import com.jetbrains.cidr.cpp.cmake.model.CMakeConfigurationSettings;
import com.jetbrains.cidr.cpp.cmake.workspace.CMakeCompilerEnvironmentContributor;
import com.jetbrains.cidr.cpp.cmake.workspace.CMakeProfileInfo;
import com.jetbrains.cidr.cpp.toolchains.CPPEnvironment;
import com.jetbrains.cidr.cpp.toolchains.CPPToolSet;
import com.jetbrains.cidr.cpp.toolchains.MSVC;
import com.jetbrains.cidr.cpp.toolchains.msvc.MSVCArchAndVersion;
import com.jetbrains.cidr.cpp.toolchains.msvc.MSVCCompilerToVersionCacheService;
import com.jetbrains.cidr.lang.CLanguageKind;
import com.jetbrains.cidr.lang.OCLanguageKind;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lcom/jetbrains/cidr/cpp/cmake/workspace/CMakeMSVCCompilerEnvironmentContributor;", "Lcom/jetbrains/cidr/cpp/cmake/workspace/CMakeCompilerEnvironmentContributor;", "<init>", "()V", "contribute", "Lcom/jetbrains/cidr/cpp/toolchains/CPPEnvironment;", "project", "Lcom/intellij/openapi/project/Project;", "cMakeProfileInfo", "Lcom/jetbrains/cidr/cpp/cmake/workspace/CMakeProfileInfo;", "environment", "cmakeConfig", "Lcom/jetbrains/cidr/cpp/cmake/model/CMakeConfiguration;", "intellij.clion.cmake"})
public final class CMakeMSVCCompilerEnvironmentContributor
implements CMakeCompilerEnvironmentContributor {
    @Override
    @NotNull
    public CPPEnvironment contribute(@NotNull Project project, @NotNull CMakeProfileInfo cMakeProfileInfo, @NotNull CPPEnvironment environment, @NotNull CMakeConfiguration cmakeConfig) {
        File compiler;
        CMakeConfigurationSettings settings;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)cMakeProfileInfo, (String)"cMakeProfileInfo");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        Intrinsics.checkNotNullParameter((Object)cmakeConfig, (String)"cmakeConfig");
        if (!environment.isMSVC() || !Registry.Companion.is("clion.msvc.detect.toolset.from.compiler")) {
            return environment;
        }
        CPPEnvironment cPPEnvironment = environment.clone();
        Intrinsics.checkNotNullExpressionValue((Object)cPPEnvironment, (String)"clone(...)");
        CPPEnvironment clonedEnvironment = cPPEnvironment;
        CPPToolSet cPPToolSet = clonedEnvironment.getToolSet();
        Intrinsics.checkNotNull((Object)cPPToolSet, (String)"null cannot be cast to non-null type com.jetbrains.cidr.cpp.toolchains.MSVC");
        MSVC msvc = (MSVC)cPPToolSet;
        MSVCCompilerToVersionCacheService service = (MSVCCompilerToVersionCacheService)ApplicationManager.getApplication().getService(MSVCCompilerToVersionCacheService.class);
        if (cmakeConfig.getSupportedLanguages().contains(CLanguageKind.CPP) && (settings = cmakeConfig.getSettings((OCLanguageKind)CLanguageKind.CPP)) != null && (compiler = settings.getCompilerExecutable()) != null) {
            String string = compiler.getAbsolutePath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAbsolutePath(...)");
            MSVCArchAndVersion version = service.getCompilerVersion(string);
            msvc.setToolsVersion(version);
        }
        return clonedEnvironment;
    }
}

