/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.cmake.workspace;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.limits.FileSizeLimit;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.cidr.cpp.cmake.presets.ParseKt;
import com.jetbrains.cmake.CMakeListsFileType;
import com.jetbrains.cmake.psi.CMakeArgument;
import com.jetbrains.cmake.psi.CMakeCommandArguments;
import com.jetbrains.cmake.psi.CMakeCommandName;
import com.jetbrains.cmake.psi.CMakeElementFactory;
import com.jetbrains.cmake.psi.CMakeFile;
import com.jetbrains.cmake.psi.CMakeLiteral;
import com.jetbrains.cmake.psi.CMakeTokenTypes;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.zip.CRC32;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileStamp {
    private static final Logger LOG = Logger.getInstance(FileStamp.class);
    public static final int UNKNOWN = -1;
    public final long timestamp;
    public final long size;
    public final long contentCrc;

    public FileStamp(long timestamp, long size, long contentCrc) {
        this.timestamp = timestamp;
        this.size = size;
        this.contentCrc = contentCrc;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FileStamp stamp = (FileStamp)o;
        if (this.timestamp != stamp.timestamp) {
            return false;
        }
        if (this.size != stamp.size) {
            return false;
        }
        return this.contentCrc == stamp.contentCrc;
    }

    public int hashCode() {
        int result2 = Long.hashCode(this.timestamp);
        result2 = 31 * result2 + Long.hashCode(this.size);
        result2 = 31 * result2 + Long.hashCode(this.contentCrc);
        return result2;
    }

    @NonNls
    public String toString() {
        return "Stamp{timestamp=" + this.timestamp + ", size=" + this.size + ", contentCrc=" + this.contentCrc + "}";
    }

    @Nullable
    public static PsiFile createOrGetCMakeFile(@NotNull Project project, @NotNull VirtualFile file) {
        Document cachedDoc;
        if (project == null) {
            FileStamp.$$$reportNull$$$0(0);
        }
        if (file == null) {
            FileStamp.$$$reportNull$$$0(1);
        }
        if ((cachedDoc = FileDocumentManager.getInstance().getCachedDocument(file)) != null && cachedDoc.getModificationStamp() == file.getModificationStamp()) {
            return FileStamp.createOrGetCMakeFile(project, cachedDoc);
        }
        try {
            return CMakeElementFactory.createFile(project, VfsUtilCore.loadText((VirtualFile)file));
        }
        catch (IOException ignore) {
            return null;
        }
    }

    @Nullable
    public static PsiFile getPsiFile(@NotNull Project project, @NotNull Document document) {
        PsiDocumentManager manager;
        if (project == null) {
            FileStamp.$$$reportNull$$$0(2);
        }
        if (document == null) {
            FileStamp.$$$reportNull$$$0(3);
        }
        return (manager = PsiDocumentManager.getInstance((Project)project)).isCommitted(document) ? manager.getCachedPsiFile(document) : null;
    }

    @NotNull
    public static PsiFile createOrGetCMakeFile(@NotNull Project project, @NotNull Document document) {
        PsiFile cachedPsi;
        if (project == null) {
            FileStamp.$$$reportNull$$$0(4);
        }
        if (document == null) {
            FileStamp.$$$reportNull$$$0(5);
        }
        if ((cachedPsi = FileStamp.getPsiFile(project, document)) != null) {
            PsiFile psiFile = cachedPsi;
            if (psiFile == null) {
                FileStamp.$$$reportNull$$$0(6);
            }
            return psiFile;
        }
        CMakeFile cMakeFile = CMakeElementFactory.createFile(project, document.getText());
        if (cMakeFile == null) {
            FileStamp.$$$reportNull$$$0(7);
        }
        return cMakeFile;
    }

    @NotNull
    public static FileStamp calcFileStamp(@NotNull Project project, @NotNull File file, @NotNull FileStampFunction fileFunction) {
        PsiFile cmakeFile;
        if (project == null) {
            FileStamp.$$$reportNull$$$0(8);
        }
        if (file == null) {
            FileStamp.$$$reportNull$$$0(9);
        }
        if (fileFunction == null) {
            FileStamp.$$$reportNull$$$0(10);
        }
        long fileLastModified = file.lastModified();
        long fileLength = file.length();
        FileStamp alreadyCalculated = fileFunction.getAlreadyCalculatedStamp();
        if (alreadyCalculated != null && fileLastModified == alreadyCalculated.timestamp && fileLength == alreadyCalculated.size) {
            FileStamp fileStamp = alreadyCalculated;
            if (fileStamp == null) {
                FileStamp.$$$reportNull$$$0(11);
            }
            return fileStamp;
        }
        long crc = -1L;
        String name = file.getName();
        if ((fileLength <= (long)FileSizeLimit.getIntellisenseLimit((String)FileUtilRt.getExtension((String)name)) && CMakeListsFileType.isCMakeFileByName(name) || ParseKt.isPresetFile(file)) && (cmakeFile = fileFunction.getCMakeFile(project)) != null) {
            crc = FileStamp.calcFileHashCode(cmakeFile);
        }
        return new FileStamp(fileLastModified, fileLength, crc);
    }

    public static long calcFileHashCode(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            FileStamp.$$$reportNull$$$0(12);
        }
        CRC32 crc32 = new CRC32();
        boolean hadEOL = false;
        PsiElement element = PsiTreeUtil.firstChild((PsiElement)psiFile);
        while (element != null) {
            boolean significantLeaf;
            PsiElement parent = element.getParent();
            boolean bl = significantLeaf = element instanceof LeafPsiElement && !(element instanceof PsiComment) && !(element instanceof PsiWhiteSpace) && !"\"".equals(element.getText()) && (!";".equals(element.getText()) || !(parent instanceof CMakeCommandArguments));
            if (significantLeaf) {
                boolean isEOL = ((TreeElement)element).getElementType().equals(CMakeTokenTypes.EOL);
                if (!isEOL) {
                    if (hadEOL) {
                        crc32.update(10);
                        hadEOL = false;
                    }
                    crc32.update(-1);
                    String text = element.getText();
                    if (parent instanceof CMakeCommandName) {
                        text = StringUtil.toLowerCase((String)text);
                        crc32.update(-2);
                    } else if (parent instanceof CMakeArgument) {
                        text = ((CMakeArgument)parent).getValue();
                        crc32.update(-3);
                    } else if (parent instanceof CMakeLiteral) {
                        text = ((CMakeLiteral)parent).getArgument().getValue();
                        crc32.update(-4);
                    }
                    crc32.update(text.getBytes(StandardCharsets.UTF_8));
                }
                hadEOL = hadEOL || isEOL && !(parent instanceof CMakeFile);
            }
            element = PsiTreeUtil.nextLeaf((PsiElement)element);
        }
        return crc32.getValue();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 7, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 6: 
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/cpp/cmake/workspace/FileStamp";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileFunction";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/cpp/cmake/workspace/FileStamp";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createOrGetCMakeFile";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "calcFileStamp";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createOrGetCMakeFile";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getPsiFile";
                break;
            }
            case 6: 
            case 7: 
            case 11: {
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "calcFileStamp";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "calcFileHashCode";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 7, 11 -> new IllegalStateException(string);
        };
    }

    public static interface FileStampFunction {
        @Nullable
        public FileStamp getAlreadyCalculatedStamp();

        @Nullable
        public PsiFile getCMakeFile(@NotNull Project var1);
    }
}

