/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.testing.doctest;

import com.intellij.execution.Location;
import com.intellij.execution.testframework.sm.runner.SMTestLocator;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.DocumentUtil;
import com.jetbrains.cidr.execution.testing.CidrMetaParam;
import com.jetbrains.cidr.execution.testing.CidrTestLanguageSupport;
import com.jetbrains.cidr.execution.testing.CidrTestLocation;
import com.jetbrains.cidr.execution.testing.CidrTestScopeElement;
import com.jetbrains.cidr.execution.testing.CidrTestScopeElementImpl;
import com.jetbrains.cidr.execution.testing.doctest.CidrDoctestTestElements;
import com.jetbrains.cidr.execution.testing.doctest.CidrDoctestTestLinker;
import com.jetbrains.cidr.execution.testing.doctest.DoctestTestLanguageSupport;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public final class CidrDoctestTestLocationProvider
implements SMTestLocator,
DumbAware {
    @NonNls
    public static final String PROTOCOL = "doctest";
    @NonNls
    public static final String PROTOCOL_PREFIX = "doctest://";
    public static final CidrDoctestTestLocationProvider INSTANCE = new CidrDoctestTestLocationProvider();

    @NotNull
    static List<Location> getLocationsSync(@NotNull @NonNls String locationPath, @Nullable @NonNls String metainfo, @NotNull Project project, @NotNull GlobalSearchScope scope) {
        if (locationPath == null) {
            CidrDoctestTestLocationProvider.$$$reportNull$$$0(0);
        }
        if (project == null) {
            CidrDoctestTestLocationProvider.$$$reportNull$$$0(1);
        }
        if (scope == null) {
            CidrDoctestTestLocationProvider.$$$reportNull$$$0(2);
        }
        CidrDoctestTestLinker linker = CidrDoctestTestLinker.create(locationPath);
        String configurationName = linker.getConfigurationName();
        CidrTestLanguageSupport tls = DoctestTestLanguageSupport.getInstance();
        CidrTestScopeElement scopeElement = null;
        if (tls.usesTestIndexForNavigation()) {
            int psPos;
            Object pathToFind = linker.getFindPath();
            int from = ((String)pathToFind).length();
            while ((scopeElement = tls.getTopTestScopeElement((String)pathToFind, configurationName, metainfo, project, scope, CidrDoctestTestElements.getGenerator())) == null && (psPos = ((String)pathToFind).lastIndexOf("<", from)) >= 0) {
                from = psPos - 1;
                pathToFind = ((String)pathToFind).substring(0, psPos) + "<*]";
            }
            if (scopeElement != null && !locationPath.equals(CidrDoctestTestLinker.getLocationWrapperIfNeed(scopeElement.getTestPath()))) {
                CidrTestScopeElement finalScopeElement = scopeElement;
                scopeElement = CidrTestScopeElementImpl.createTestScopeElementForVirtualTestPath((String)linker.getPatternForCommandLine(), (String)configurationName, () -> {
                    String value;
                    if (metainfo != null && (value = (String)CidrMetaParam.parse((String)metainfo).get("line")) != null) {
                        PsiElement el;
                        Document document;
                        PsiFile file;
                        int lineNumber = -1;
                        try {
                            lineNumber = Integer.parseInt(value) - 1;
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                        if (lineNumber >= 0 && (file = finalScopeElement.getElement().getContainingFile()) != null && (document = PsiDocumentManager.getInstance((Project)project).getDocument(file)) != null && lineNumber < document.getLineCount() && (el = file.findElementAt(DocumentUtil.getFirstNonSpaceCharOffset((Document)document, (int)lineNumber))) != null && finalScopeElement.equals(tls.findTestObject(el))) {
                            return el;
                        }
                    }
                    return finalScopeElement.getElement();
                }, CidrDoctestTestElements.getGenerator());
            }
        }
        if (scopeElement == null) {
            scopeElement = DoctestTestLanguageSupport.ourLanguageFreeService.getTopTestScopeElement(linker.getPatternForCommandLine(), configurationName, metainfo, project, scope, CidrDoctestTestElements.getGenerator());
        }
        List<Object> list = scopeElement == null ? Collections.emptyList() : Collections.singletonList(new CidrTestLocation(project, scopeElement, PROTOCOL_PREFIX));
        if (list == null) {
            CidrDoctestTestLocationProvider.$$$reportNull$$$0(3);
        }
        return list;
    }

    @NotNull
    public @Unmodifiable List<Location> getLocation(@NonNls @NotNull String protocol, @NonNls @NotNull String path, @NonNls @NotNull Project project, @NotNull GlobalSearchScope scope) {
        if (protocol == null) {
            CidrDoctestTestLocationProvider.$$$reportNull$$$0(4);
        }
        if (path == null) {
            CidrDoctestTestLocationProvider.$$$reportNull$$$0(5);
        }
        if (project == null) {
            CidrDoctestTestLocationProvider.$$$reportNull$$$0(6);
        }
        if (scope == null) {
            CidrDoctestTestLocationProvider.$$$reportNull$$$0(7);
        }
        List<Location> list = this.getLocation(protocol, path, null, project, scope);
        if (list == null) {
            CidrDoctestTestLocationProvider.$$$reportNull$$$0(8);
        }
        return list;
    }

    @NotNull
    public @Unmodifiable List<Location> getLocation(@NonNls @NotNull String protocol, @NonNls @NotNull String locationPath, @NonNls @Nullable String metainfo, @NotNull Project project, @NotNull GlobalSearchScope scope) {
        if (protocol == null) {
            CidrDoctestTestLocationProvider.$$$reportNull$$$0(9);
        }
        if (locationPath == null) {
            CidrDoctestTestLocationProvider.$$$reportNull$$$0(10);
        }
        if (project == null) {
            CidrDoctestTestLocationProvider.$$$reportNull$$$0(11);
        }
        if (scope == null) {
            CidrDoctestTestLocationProvider.$$$reportNull$$$0(12);
        }
        if (!PROTOCOL.equals(protocol)) {
            List<Location> list = Collections.emptyList();
            if (list == null) {
                CidrDoctestTestLocationProvider.$$$reportNull$$$0(13);
            }
            return list;
        }
        if (locationPath.startsWith("CIDRRerun?")) {
            String _metainfo = locationPath.substring("CIDRRerun?".length());
            CidrTestScopeElement scopeElement = DoctestTestLanguageSupport.ourLanguageFreeService.createTestScopeElementsSync("", null, _metainfo, project, scope, CidrDoctestTestElements.getGenerator());
            List<Object> list = scopeElement == null ? Collections.emptyList() : Collections.singletonList(new CidrTestLocation(project, scopeElement, PROTOCOL_PREFIX, _metainfo));
            if (list == null) {
                CidrDoctestTestLocationProvider.$$$reportNull$$$0(14);
            }
            return list;
        }
        List list = DoctestTestLanguageSupport.getInstance().getLocationSafe(project, () -> CidrDoctestTestLocationProvider.getLocationsSync(locationPath, metainfo, project, scope));
        if (list == null) {
            CidrDoctestTestLocationProvider.$$$reportNull$$$0(15);
        }
        return list;
    }

    @NotNull
    public ModificationTracker getLocationCacheModificationTracker(@NotNull Project project) {
        if (project == null) {
            CidrDoctestTestLocationProvider.$$$reportNull$$$0(16);
        }
        ModificationTracker modificationTracker = DoctestTestLanguageSupport.getInstance().getLocationCacheModificationTracker(project);
        if (modificationTracker == null) {
            CidrDoctestTestLocationProvider.$$$reportNull$$$0(17);
        }
        return modificationTracker;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 8, 13, 14, 15, 17 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "locationPath";
                break;
            }
            case 1: 
            case 6: 
            case 11: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 7: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 3: 
            case 8: 
            case 13: 
            case 14: 
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/execution/testing/doctest/CidrDoctestTestLocationProvider";
                break;
            }
            case 4: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "protocol";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/execution/testing/doctest/CidrDoctestTestLocationProvider";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocationsSync";
                break;
            }
            case 8: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocation";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocationCacheModificationTracker";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getLocationsSync";
                break;
            }
            case 3: 
            case 8: 
            case 13: 
            case 14: 
            case 15: 
            case 17: {
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getLocation";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getLocationCacheModificationTracker";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 8, 13, 14, 15, 17 -> new IllegalStateException(string);
        };
    }
}

