/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.coverage.gcov;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtil;
import com.jetbrains.cidr.execution.coverage.CidrCoverageBundle;
import com.jetbrains.cidr.execution.coverage.CidrCoverageComposer;
import com.jetbrains.cidr.execution.coverage.CidrCoverageDataFileProvider;
import com.jetbrains.cidr.execution.coverage.CidrCoverageLogKt;
import com.jetbrains.cidr.execution.coverage.CidrCoverageUtil;
import com.jetbrains.cidr.execution.coverage.gcov.GCovCoverageToolProvider;
import com.jetbrains.cidr.execution.coverage.gcov.GCovUtils;
import com.jetbrains.cidr.lang.toolchains.CidrToolEnvironment;
import com.jetbrains.cidr.system.HostMachine;
import java.io.File;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J0\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J0\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\b\u001a\u00020\tH\u0002J \u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u00142\u0006\u0010\b\u001a\u00020\tH\u0002J8\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0012\u0010\u001e\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\u001f"}, d2={"Lcom/jetbrains/cidr/execution/coverage/gcov/GCovCoverageComposer;", "Lcom/jetbrains/cidr/execution/coverage/CidrCoverageComposer;", "<init>", "()V", "beforeProcessExecution", "", "configuration", "Lcom/intellij/execution/configurations/RunConfiguration;", "environment", "Lcom/jetbrains/cidr/lang/toolchains/CidrToolEnvironment;", "cmdLine", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "context", "Lcom/intellij/openapi/util/UserDataHolder;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "afterProcessTerminated", "event", "Lcom/intellij/execution/process/ProcessEvent;", "getOrCreateOutputCoverageDirectory", "Ljava/nio/file/Path;", "rootDirectory", "moveGcovFilesToOutputDirWithUniquePrefix", "targetDirectory", "processGcdaFile", "inputFile", "", "workingDirectory", "toolsProvider", "Lcom/jetbrains/cidr/execution/coverage/gcov/GCovCoverageToolProvider;", "getCoverageRootDirectory", "intellij.cidr.coverage"})
@SourceDebugExtension(value={"SMAP\nGCovCoverageComposer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GCovCoverageComposer.kt\ncom/jetbrains/cidr/execution/coverage/gcov/GCovCoverageComposer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,131:1\n1491#2:132\n1516#2,3:133\n1519#2,3:143\n1869#2,2:148\n382#3,7:136\n216#4,2:146\n*S KotlinDebug\n*F\n+ 1 GCovCoverageComposer.kt\ncom/jetbrains/cidr/execution/coverage/gcov/GCovCoverageComposer\n*L\n53#1:132\n53#1:133,3\n53#1:143,3\n84#1:148,2\n53#1:136,7\n58#1:146,2\n*E\n"})
public final class GCovCoverageComposer
extends CidrCoverageComposer {
    public GCovCoverageComposer() {
        super("gcov");
    }

    @Override
    public void beforeProcessExecution(@NotNull RunConfiguration configuration, @NotNull CidrToolEnvironment environment, @NotNull GeneralCommandLine cmdLine, @NotNull UserDataHolder context, @NotNull ProgressIndicator indicator) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        Intrinsics.checkNotNullParameter((Object)cmdLine, (String)"cmdLine");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void afterProcessTerminated(@NotNull RunConfiguration configuration, @NotNull CidrToolEnvironment environment, @NotNull ProcessEvent event, @NotNull UserDataHolder context, @NotNull ProgressIndicator indicator) {
        void $this$groupByTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        String rootDirectory = this.getCoverageRootDirectory(configuration);
        if (rootDirectory == null) {
            CidrCoverageLogKt.getCidrCoverageLog().debug("gcov coverage root directory is null or not found");
            return;
        }
        Path path = environment.getHostMachine().getPath(rootDirectory, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getPath(...)");
        Path rootDirectoryPath = path;
        HostMachine hostMachine = environment.getHostMachine();
        Intrinsics.checkNotNullExpressionValue((Object)hostMachine, (String)"getHostMachine(...)");
        List<Path> gcdaFiles = GCovUtils.Companion.getGCDAFiles(hostMachine, rootDirectoryPath, true);
        GCovCoverageToolProvider gCovCoverageToolProvider = GCovCoverageToolProvider.Companion.getInstance(configuration);
        if (gCovCoverageToolProvider == null) {
            throw new ExecutionException(CidrCoverageBundle.message("gcov.tools.missing", new Object[0]));
        }
        GCovCoverageToolProvider toolsProvider = gCovCoverageToolProvider;
        Iterable $this$groupBy$iv = gcdaFiles;
        boolean $i$f$groupBy = false;
        Iterable iterable = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo22 = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            Path it = (Path)element$iv$iv;
            boolean bl = false;
            String key$iv$iv = new File(((Object)it).toString()).getName();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Map gcdaFilesGroupedByFileName = destination$iv$iv;
        List gcdaFilesToParallelProcess = new ArrayList();
        List gcdaFilesToSequentialProcess = new ArrayList();
        Map $this$forEach$iv = gcdaFilesGroupedByFileName;
        boolean $i$f$forEach22 = false;
        Iterator $i$f$groupByTo22 = $this$forEach$iv.entrySet().iterator();
        while ($i$f$groupByTo22.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry = element$iv = $i$f$groupByTo22.next();
            boolean bl = false;
            boolean bl3 = ((List)entry.getValue()).size() == 1 ? gcdaFilesToParallelProcess.add(((List)entry.getValue()).get(0)) : gcdaFilesToSequentialProcess.addAll((Collection)entry.getValue());
        }
        CidrCoverageLogKt.getCidrCoverageLog().info("Number of .gcov files for parallel processing: " + gcdaFilesToParallelProcess.size());
        CidrCoverageLogKt.getCidrCoverageLog().info("Number of .gcov files for sequential processing: " + gcdaFilesToSequentialProcess.size());
        gcdaFilesToParallelProcess.parallelStream().forEach(arg_0 -> GCovCoverageComposer.afterProcessTerminated$lambda$3(arg_0 -> GCovCoverageComposer.afterProcessTerminated$lambda$2(this, rootDirectory, indicator, configuration, environment, toolsProvider, arg_0), arg_0));
        indicator.checkCanceled();
        Path outputDirectoryPath = this.getOrCreateOutputCoverageDirectory(rootDirectoryPath, environment);
        HostMachine hostMachine2 = environment.getHostMachine();
        Intrinsics.checkNotNullExpressionValue((Object)hostMachine2, (String)"getHostMachine(...)");
        String[] $i$f$forEach22 = new String[]{".gcov"};
        CidrCoverageUtil.Companion.moveFilesWithExtensionInBatchMode(hostMachine2, rootDirectoryPath, outputDirectoryPath, false, $i$f$forEach22);
        Iterable $this$forEach$iv2 = gcdaFilesToSequentialProcess;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv2) {
            Path it = (Path)element$iv;
            boolean bl = false;
            this.processGcdaFile(((Object)it).toString(), rootDirectory, indicator, configuration, environment, toolsProvider);
            this.moveGcovFilesToOutputDirWithUniquePrefix(rootDirectoryPath, outputDirectoryPath, environment);
        }
    }

    private final Path getOrCreateOutputCoverageDirectory(Path rootDirectory, CidrToolEnvironment environment) {
        String[] stringArray = new String[]{((Object)rootDirectory).toString(), "coverage"};
        String string = FileUtil.join((String[])stringArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"join(...)");
        String outputDirectory = string;
        Path path = environment.getHostMachine().getPath(outputDirectory, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getPath(...)");
        Path outputDirectoryPath = path;
        if (!Files.exists(outputDirectoryPath, new LinkOption[0])) {
            Files.createDirectory(outputDirectoryPath, new FileAttribute[0]);
        }
        return outputDirectoryPath;
    }

    private final void moveGcovFilesToOutputDirWithUniquePrefix(Path rootDirectory, Path targetDirectory, CidrToolEnvironment environment) {
        Files.list(rootDirectory).filter(arg_0 -> GCovCoverageComposer.moveGcovFilesToOutputDirWithUniquePrefix$lambda$6(GCovCoverageComposer::moveGcovFilesToOutputDirWithUniquePrefix$lambda$5, arg_0)).forEach(arg_0 -> GCovCoverageComposer.moveGcovFilesToOutputDirWithUniquePrefix$lambda$8(arg_0 -> GCovCoverageComposer.moveGcovFilesToOutputDirWithUniquePrefix$lambda$7(environment, targetDirectory, arg_0), arg_0));
    }

    private final void processGcdaFile(String inputFile, String workingDirectory, ProgressIndicator indicator, RunConfiguration configuration, CidrToolEnvironment environment, GCovCoverageToolProvider toolsProvider) {
        String string = environment.toEnvPath(inputFile);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toEnvPath(...)");
        GeneralCommandLine gcov = toolsProvider.createCommandLine(string, workingDirectory, configuration, environment);
        if (gcov == null) {
            Object[] objectArray = new Object[]{toolsProvider.getToolName(configuration)};
            throw new ExecutionException(CidrCoverageBundle.message("coverage.tool.not.found", objectArray));
        }
        ProcessOutput processOutput = null;
        try {
            processOutput = environment.getHostMachine().runProcess(gcov, indicator, -1);
        }
        catch (ExecutionException exception) {
            Object[] objectArray = new Object[]{exception.getMessage()};
            throw new ExecutionException(CidrCoverageBundle.message("gcov.tools.failed", objectArray));
        }
        String string2 = processOutput.getStderr();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getStderr(...)");
        if (((CharSequence)string2).length() > 0) {
            CidrCoverageLogKt.getCidrCoverageLog().warn(toolsProvider.getToolName(configuration) + " finished with stderr: " + processOutput.getStderr());
        }
        if (processOutput.getExitCode() != 0) {
            Object[] objectArray = new Object[]{processOutput.getStderr()};
            throw new ExecutionException(CidrCoverageBundle.message("gcov.tools.failed", objectArray));
        }
    }

    private final String getCoverageRootDirectory(RunConfiguration configuration) {
        CidrCoverageDataFileProvider cidrCoverageDataFileProvider = CidrCoverageDataFileProvider.Companion.getInstance(configuration, this.getCoverageRunnerId());
        return cidrCoverageDataFileProvider != null ? cidrCoverageDataFileProvider.getLocalCoverageDataPath(configuration) : null;
    }

    private static final Unit afterProcessTerminated$lambda$2(GCovCoverageComposer this$0, String $rootDirectory, ProgressIndicator $indicator, RunConfiguration $configuration, CidrToolEnvironment $environment, GCovCoverageToolProvider $toolsProvider, Path it) {
        this$0.processGcdaFile(((Object)it).toString(), $rootDirectory, $indicator, $configuration, $environment, $toolsProvider);
        return Unit.INSTANCE;
    }

    private static final void afterProcessTerminated$lambda$3(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final boolean moveGcovFilesToOutputDirWithUniquePrefix$lambda$5(Path it) {
        return StringsKt.endsWith$default((String)((Object)it).toString(), (String)".gcov", (boolean)false, (int)2, null);
    }

    private static final boolean moveGcovFilesToOutputDirWithUniquePrefix$lambda$6(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Unit moveGcovFilesToOutputDirWithUniquePrefix$lambda$7(CidrToolEnvironment $environment, Path $targetDirectory, Path it) {
        String fileName = new File(((Object)it).toString()).getName();
        String newFileName = UUID.randomUUID() + "#" + fileName;
        Object[] objectArray = new String[]{newFileName};
        Path path = $environment.getHostMachine().getPath(((Object)$targetDirectory).toString(), (String[])objectArray);
        objectArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
        Files.move(it, path, (CopyOption[])objectArray);
        return Unit.INSTANCE;
    }

    private static final void moveGcovFilesToOutputDirWithUniquePrefix$lambda$8(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }
}

