/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.coverage.llvm;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.intellij.coverage.CoverageLoadErrorReporter;
import com.intellij.coverage.DummyCoverageLoadErrorReporter;
import com.intellij.openapi.util.Version;
import com.jetbrains.cidr.execution.coverage.CidrCoverageLogKt;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\n\b\u0086\b\u0018\u0000 \u001f2\u00020\u0001:\b\u0019\u001a\u001b\u001c\u001d\u001e\u001f B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u00c6\u0003J-\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u001c\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006!"}, d2={"Lcom/jetbrains/cidr/execution/coverage/llvm/LLVMCoverageModel;", "", "type", "", "version", "mappings", "", "Lcom/jetbrains/cidr/execution/coverage/llvm/LLVMCoverageModel$CoverageMapping;", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/List;)V", "getType", "()Ljava/lang/String;", "getVersion", "getMappings", "()Ljava/util/List;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "CoverageMapping", "FileMapping", "Summary", "LineMapping", "BranchMapping", "Segment", "Companion", "InvalidModelException", "intellij.cidr.coverage"})
public final class LLVMCoverageModel {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String type;
    @NotNull
    private final String version;
    @SerializedName(value="data")
    @NotNull
    private final List<CoverageMapping> mappings;

    public LLVMCoverageModel(@NotNull String type, @NotNull String version, @NotNull List<CoverageMapping> mappings) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        Intrinsics.checkNotNullParameter(mappings, (String)"mappings");
        this.type = type;
        this.version = version;
        this.mappings = mappings;
    }

    @NotNull
    public final String getType() {
        return this.type;
    }

    @NotNull
    public final String getVersion() {
        return this.version;
    }

    @NotNull
    public final List<CoverageMapping> getMappings() {
        return this.mappings;
    }

    @NotNull
    public final String component1() {
        return this.type;
    }

    @NotNull
    public final String component2() {
        return this.version;
    }

    @NotNull
    public final List<CoverageMapping> component3() {
        return this.mappings;
    }

    @NotNull
    public final LLVMCoverageModel copy(@NotNull String type, @NotNull String version, @NotNull List<CoverageMapping> mappings) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        Intrinsics.checkNotNullParameter(mappings, (String)"mappings");
        return new LLVMCoverageModel(type, version, mappings);
    }

    public static /* synthetic */ LLVMCoverageModel copy$default(LLVMCoverageModel lLVMCoverageModel, String string, String string2, List list, int n, Object object) {
        if ((n & 1) != 0) {
            string = lLVMCoverageModel.type;
        }
        if ((n & 2) != 0) {
            string2 = lLVMCoverageModel.version;
        }
        if ((n & 4) != 0) {
            list = lLVMCoverageModel.mappings;
        }
        return lLVMCoverageModel.copy(string, string2, list);
    }

    @NotNull
    public String toString() {
        return "LLVMCoverageModel(type=" + this.type + ", version=" + this.version + ", mappings=" + this.mappings + ")";
    }

    public int hashCode() {
        int result = this.type.hashCode();
        result = result * 31 + this.version.hashCode();
        result = result * 31 + ((Object)this.mappings).hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof LLVMCoverageModel)) {
            return false;
        }
        LLVMCoverageModel lLVMCoverageModel = (LLVMCoverageModel)other;
        if (!Intrinsics.areEqual((Object)this.type, (Object)lLVMCoverageModel.type)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.version, (Object)lLVMCoverageModel.version)) {
            return false;
        }
        return Intrinsics.areEqual(this.mappings, lLVMCoverageModel.mappings);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0007H\u00c6\u0003J1\u0010\u0014\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0016\u0010\u0005\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001b"}, d2={"Lcom/jetbrains/cidr/execution/coverage/llvm/LLVMCoverageModel$BranchMapping;", "", "count", "", "covered", "notCovered", "percent", "", "<init>", "(IIID)V", "getCount", "()I", "getCovered", "getNotCovered", "getPercent", "()D", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "toString", "", "intellij.cidr.coverage"})
    public static final class BranchMapping {
        private final int count;
        private final int covered;
        @SerializedName(value="notcovered")
        private final int notCovered;
        private final double percent;

        public BranchMapping(int count, int covered, int notCovered, double percent) {
            this.count = count;
            this.covered = covered;
            this.notCovered = notCovered;
            this.percent = percent;
        }

        public final int getCount() {
            return this.count;
        }

        public final int getCovered() {
            return this.covered;
        }

        public final int getNotCovered() {
            return this.notCovered;
        }

        public final double getPercent() {
            return this.percent;
        }

        public final int component1() {
            return this.count;
        }

        public final int component2() {
            return this.covered;
        }

        public final int component3() {
            return this.notCovered;
        }

        public final double component4() {
            return this.percent;
        }

        @NotNull
        public final BranchMapping copy(int count, int covered, int notCovered, double percent) {
            return new BranchMapping(count, covered, notCovered, percent);
        }

        public static /* synthetic */ BranchMapping copy$default(BranchMapping branchMapping, int n, int n2, int n3, double d, int n4, Object object) {
            if ((n4 & 1) != 0) {
                n = branchMapping.count;
            }
            if ((n4 & 2) != 0) {
                n2 = branchMapping.covered;
            }
            if ((n4 & 4) != 0) {
                n3 = branchMapping.notCovered;
            }
            if ((n4 & 8) != 0) {
                d = branchMapping.percent;
            }
            return branchMapping.copy(n, n2, n3, d);
        }

        @NotNull
        public String toString() {
            return "BranchMapping(count=" + this.count + ", covered=" + this.covered + ", notCovered=" + this.notCovered + ", percent=" + this.percent + ")";
        }

        public int hashCode() {
            int result = Integer.hashCode(this.count);
            result = result * 31 + Integer.hashCode(this.covered);
            result = result * 31 + Integer.hashCode(this.notCovered);
            result = result * 31 + Double.hashCode(this.percent);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof BranchMapping)) {
                return false;
            }
            BranchMapping branchMapping = (BranchMapping)other;
            if (this.count != branchMapping.count) {
                return false;
            }
            if (this.covered != branchMapping.covered) {
                return false;
            }
            if (this.notCovered != branchMapping.notCovered) {
                return false;
            }
            return Double.compare(this.percent, branchMapping.percent) == 0;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"Lcom/jetbrains/cidr/execution/coverage/llvm/LLVMCoverageModel$Companion;", "", "<init>", "()V", "fromFile", "Lcom/jetbrains/cidr/execution/coverage/llvm/LLVMCoverageModel;", "inputPath", "Ljava/nio/file/Path;", "reporter", "Lcom/intellij/coverage/CoverageLoadErrorReporter;", "intellij.cidr.coverage"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final LLVMCoverageModel fromFile(@NotNull Path inputPath, @NotNull CoverageLoadErrorReporter reporter) {
            LLVMCoverageModel lLVMCoverageModel;
            Intrinsics.checkNotNullParameter((Object)inputPath, (String)"inputPath");
            Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
            InputStream inputStream = Files.newInputStream(inputPath, new OpenOption[0]);
            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"newInputStream(...)");
            InputStream inputStream2 = inputStream;
            Charset charset = Charsets.UTF_8;
            InputStreamReader rawDataReader = new InputStreamReader(inputStream2, charset);
            Gson gson = new GsonBuilder().create();
            try {
                lLVMCoverageModel = (LLVMCoverageModel)gson.fromJson((Reader)rawDataReader, LLVMCoverageModel.class);
            }
            catch (JsonParseException e) {
                throw new InvalidModelException("Malformed model", (Exception)((Object)e));
            }
            LLVMCoverageModel model = lLVMCoverageModel;
            if (model == null) {
                throw new InvalidModelException("Model is null");
            }
            if (!Intrinsics.areEqual((Object)model.getType(), (Object)"llvm.coverage.json.export")) {
                throw new InvalidModelException("Invalid type: " + model.getType());
            }
            Version version = Version.parseVersion((String)model.getVersion());
            if (!(version != null ? version.major == 2 : false)) {
                String message = "Possibly incompatible llvm-cov output version: " + model.getVersion();
                CidrCoverageLogKt.getCidrCoverageLog().warn(message);
                CoverageLoadErrorReporter.reportWarning$default((CoverageLoadErrorReporter)reporter, (String)message, null, (int)2, null);
            }
            return model;
        }

        public static /* synthetic */ LLVMCoverageModel fromFile$default(Companion companion, Path path, CoverageLoadErrorReporter coverageLoadErrorReporter, int n, Object object) {
            if ((n & 2) != 0) {
                coverageLoadErrorReporter = (CoverageLoadErrorReporter)new DummyCoverageLoadErrorReporter();
            }
            return companion.fromFile(path, coverageLoadErrorReporter);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u0019\u0010\n\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0001J\u0013\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R\u001c\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0012"}, d2={"Lcom/jetbrains/cidr/execution/coverage/llvm/LLVMCoverageModel$CoverageMapping;", "", "fileMappings", "", "Lcom/jetbrains/cidr/execution/coverage/llvm/LLVMCoverageModel$FileMapping;", "<init>", "(Ljava/util/List;)V", "getFileMappings", "()Ljava/util/List;", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.cidr.coverage"})
    public static final class CoverageMapping {
        @SerializedName(value="files")
        @NotNull
        private final List<FileMapping> fileMappings;

        public CoverageMapping(@NotNull List<FileMapping> fileMappings) {
            Intrinsics.checkNotNullParameter(fileMappings, (String)"fileMappings");
            this.fileMappings = fileMappings;
        }

        @NotNull
        public final List<FileMapping> getFileMappings() {
            return this.fileMappings;
        }

        @NotNull
        public final List<FileMapping> component1() {
            return this.fileMappings;
        }

        @NotNull
        public final CoverageMapping copy(@NotNull List<FileMapping> fileMappings) {
            Intrinsics.checkNotNullParameter(fileMappings, (String)"fileMappings");
            return new CoverageMapping(fileMappings);
        }

        public static /* synthetic */ CoverageMapping copy$default(CoverageMapping coverageMapping, List list, int n, Object object) {
            if ((n & 1) != 0) {
                list = coverageMapping.fileMappings;
            }
            return coverageMapping.copy(list);
        }

        @NotNull
        public String toString() {
            return "CoverageMapping(fileMappings=" + this.fileMappings + ")";
        }

        public int hashCode() {
            return ((Object)this.fileMappings).hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CoverageMapping)) {
                return false;
            }
            CoverageMapping coverageMapping = (CoverageMapping)other;
            return Intrinsics.areEqual(this.fileMappings, coverageMapping.fileMappings);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0004\b\t\u0010\nJ\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J\u000b\u0010\u0013\u001a\u0004\u0018\u00010\bH\u00c6\u0003J/\u0010\u0014\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\bH\u00c6\u0001J\u0013\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001J\t\u0010\u001a\u001a\u00020\u0003H\u00d6\u0001R\u0016\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0013\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001b"}, d2={"Lcom/jetbrains/cidr/execution/coverage/llvm/LLVMCoverageModel$FileMapping;", "", "name", "", "segments", "", "Lcom/jetbrains/cidr/execution/coverage/llvm/LLVMCoverageModel$Segment;", "summary", "Lcom/jetbrains/cidr/execution/coverage/llvm/LLVMCoverageModel$Summary;", "<init>", "(Ljava/lang/String;Ljava/util/List;Lcom/jetbrains/cidr/execution/coverage/llvm/LLVMCoverageModel$Summary;)V", "getName", "()Ljava/lang/String;", "getSegments", "()Ljava/util/List;", "getSummary", "()Lcom/jetbrains/cidr/execution/coverage/llvm/LLVMCoverageModel$Summary;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.cidr.coverage"})
    public static final class FileMapping {
        @SerializedName(value="filename")
        @NotNull
        private final String name;
        @NotNull
        private final List<Segment> segments;
        @Nullable
        private final Summary summary;

        public FileMapping(@NotNull String name, @NotNull List<Segment> segments, @Nullable Summary summary) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter(segments, (String)"segments");
            this.name = name;
            this.segments = segments;
            this.summary = summary;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @NotNull
        public final List<Segment> getSegments() {
            return this.segments;
        }

        @Nullable
        public final Summary getSummary() {
            return this.summary;
        }

        @NotNull
        public final String component1() {
            return this.name;
        }

        @NotNull
        public final List<Segment> component2() {
            return this.segments;
        }

        @Nullable
        public final Summary component3() {
            return this.summary;
        }

        @NotNull
        public final FileMapping copy(@NotNull String name, @NotNull List<Segment> segments, @Nullable Summary summary) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter(segments, (String)"segments");
            return new FileMapping(name, segments, summary);
        }

        public static /* synthetic */ FileMapping copy$default(FileMapping fileMapping, String string, List list, Summary summary, int n, Object object) {
            if ((n & 1) != 0) {
                string = fileMapping.name;
            }
            if ((n & 2) != 0) {
                list = fileMapping.segments;
            }
            if ((n & 4) != 0) {
                summary = fileMapping.summary;
            }
            return fileMapping.copy(string, list, summary);
        }

        @NotNull
        public String toString() {
            return "FileMapping(name=" + this.name + ", segments=" + this.segments + ", summary=" + this.summary + ")";
        }

        public int hashCode() {
            int result = this.name.hashCode();
            result = result * 31 + ((Object)this.segments).hashCode();
            result = result * 31 + (this.summary == null ? 0 : this.summary.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof FileMapping)) {
                return false;
            }
            FileMapping fileMapping = (FileMapping)other;
            if (!Intrinsics.areEqual((Object)this.name, (Object)fileMapping.name)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.segments, fileMapping.segments)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.summary, (Object)fileMapping.summary);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u00002\u00060\u0001j\u0002`\u0002B\u0011\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006B\u001d\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\n\u0010\u0007\u001a\u00060\u0001j\u0002`\u0002\u00a2\u0006\u0004\b\u0005\u0010\b\u00a8\u0006\t"}, d2={"Lcom/jetbrains/cidr/execution/coverage/llvm/LLVMCoverageModel$InvalidModelException;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "message", "", "<init>", "(Ljava/lang/String;)V", "cause", "(Ljava/lang/String;Ljava/lang/Exception;)V", "intellij.cidr.coverage"})
    public static final class InvalidModelException
    extends Exception {
        public InvalidModelException(@NotNull String message) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            super(message);
        }

        public InvalidModelException(@NotNull String message, @NotNull Exception cause) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            Intrinsics.checkNotNullParameter((Object)cause, (String)"cause");
            super(message, cause);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/cidr/execution/coverage/llvm/LLVMCoverageModel$LineMapping;", "", "count", "", "covered", "<init>", "(II)V", "getCount", "()I", "getCovered", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "", "intellij.cidr.coverage"})
    public static final class LineMapping {
        private final int count;
        private final int covered;

        public LineMapping(int count, int covered) {
            this.count = count;
            this.covered = covered;
        }

        public final int getCount() {
            return this.count;
        }

        public final int getCovered() {
            return this.covered;
        }

        public final int component1() {
            return this.count;
        }

        public final int component2() {
            return this.covered;
        }

        @NotNull
        public final LineMapping copy(int count, int covered) {
            return new LineMapping(count, covered);
        }

        public static /* synthetic */ LineMapping copy$default(LineMapping lineMapping, int n, int n2, int n3, Object object) {
            if ((n3 & 1) != 0) {
                n = lineMapping.count;
            }
            if ((n3 & 2) != 0) {
                n2 = lineMapping.covered;
            }
            return lineMapping.copy(n, n2);
        }

        @NotNull
        public String toString() {
            return "LineMapping(count=" + this.count + ", covered=" + this.covered + ")";
        }

        public int hashCode() {
            int result = Integer.hashCode(this.count);
            result = result * 31 + Integer.hashCode(this.covered);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof LineMapping)) {
                return false;
            }
            LineMapping lineMapping = (LineMapping)other;
            if (this.count != lineMapping.count) {
                return false;
            }
            return this.covered == lineMapping.covered;
        }
    }

    @JsonAdapter(value=Adapter.class)
    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0014\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0087\b\u0018\u00002\u00020\u0001:\u0001\u001eB/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\n\u0010\u000bJ\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\bH\u00c6\u0003J\t\u0010\u0017\u001a\u00020\bH\u00c6\u0003J;\u0010\u0018\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\bH\u00c6\u0001J\u0013\u0010\u0019\u001a\u00020\b2\b\u0010\u001a\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001b\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\t\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0012\u00a8\u0006\u001f"}, d2={"Lcom/jetbrains/cidr/execution/coverage/llvm/LLVMCoverageModel$Segment;", "", "beginLine", "", "beginColumn", "count", "", "hasCount", "", "isRegionEntry", "<init>", "(IIJZZ)V", "getBeginLine", "()I", "getBeginColumn", "getCount", "()J", "getHasCount", "()Z", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "other", "hashCode", "toString", "", "Adapter", "intellij.cidr.coverage"})
    public static final class Segment {
        private final int beginLine;
        private final int beginColumn;
        private final long count;
        private final boolean hasCount;
        private final boolean isRegionEntry;

        public Segment(int beginLine, int beginColumn, long count, boolean hasCount, boolean isRegionEntry) {
            this.beginLine = beginLine;
            this.beginColumn = beginColumn;
            this.count = count;
            this.hasCount = hasCount;
            this.isRegionEntry = isRegionEntry;
        }

        public final int getBeginLine() {
            return this.beginLine;
        }

        public final int getBeginColumn() {
            return this.beginColumn;
        }

        public final long getCount() {
            return this.count;
        }

        public final boolean getHasCount() {
            return this.hasCount;
        }

        public final boolean isRegionEntry() {
            return this.isRegionEntry;
        }

        public final int component1() {
            return this.beginLine;
        }

        public final int component2() {
            return this.beginColumn;
        }

        public final long component3() {
            return this.count;
        }

        public final boolean component4() {
            return this.hasCount;
        }

        public final boolean component5() {
            return this.isRegionEntry;
        }

        @NotNull
        public final Segment copy(int beginLine, int beginColumn, long count, boolean hasCount, boolean isRegionEntry) {
            return new Segment(beginLine, beginColumn, count, hasCount, isRegionEntry);
        }

        public static /* synthetic */ Segment copy$default(Segment segment, int n, int n2, long l, boolean bl, boolean bl2, int n3, Object object) {
            if ((n3 & 1) != 0) {
                n = segment.beginLine;
            }
            if ((n3 & 2) != 0) {
                n2 = segment.beginColumn;
            }
            if ((n3 & 4) != 0) {
                l = segment.count;
            }
            if ((n3 & 8) != 0) {
                bl = segment.hasCount;
            }
            if ((n3 & 0x10) != 0) {
                bl2 = segment.isRegionEntry;
            }
            return segment.copy(n, n2, l, bl, bl2);
        }

        @NotNull
        public String toString() {
            return "Segment(beginLine=" + this.beginLine + ", beginColumn=" + this.beginColumn + ", count=" + this.count + ", hasCount=" + this.hasCount + ", isRegionEntry=" + this.isRegionEntry + ")";
        }

        public int hashCode() {
            int result = Integer.hashCode(this.beginLine);
            result = result * 31 + Integer.hashCode(this.beginColumn);
            result = result * 31 + Long.hashCode(this.count);
            result = result * 31 + Boolean.hashCode(this.hasCount);
            result = result * 31 + Boolean.hashCode(this.isRegionEntry);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Segment)) {
                return false;
            }
            Segment segment = (Segment)other;
            if (this.beginLine != segment.beginLine) {
                return false;
            }
            if (this.beginColumn != segment.beginColumn) {
                return false;
            }
            if (this.count != segment.count) {
                return false;
            }
            if (this.hasCount != segment.hasCount) {
                return false;
            }
            return this.isRegionEntry == segment.isRegionEntry;
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J \u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u0018\u0010\f\u001a\u00020\r*\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/cidr/execution/coverage/llvm/LLVMCoverageModel$Segment$Adapter;", "Lcom/google/gson/JsonDeserializer;", "Lcom/jetbrains/cidr/execution/coverage/llvm/LLVMCoverageModel$Segment;", "<init>", "()V", "deserialize", "json", "Lcom/google/gson/JsonElement;", "typeOfT", "Ljava/lang/reflect/Type;", "context", "Lcom/google/gson/JsonDeserializationContext;", "isTrue", "", "(Lcom/google/gson/JsonElement;)Z", "intellij.cidr.coverage"})
        public static final class Adapter
        implements JsonDeserializer<Segment> {
            @NotNull
            public Segment deserialize(@NotNull JsonElement json, @NotNull Type typeOfT, @NotNull JsonDeserializationContext context) {
                Segment segment;
                Intrinsics.checkNotNullParameter((Object)json, (String)"json");
                Intrinsics.checkNotNullParameter((Object)typeOfT, (String)"typeOfT");
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                JsonArray array = json.getAsJsonArray();
                try {
                    int n = array.get(0).getAsInt();
                    int n2 = array.get(1).getAsInt();
                    long l = array.get(2).getAsLong();
                    JsonElement jsonElement = array.get(3);
                    Intrinsics.checkNotNullExpressionValue((Object)jsonElement, (String)"get(...)");
                    boolean bl = this.isTrue(jsonElement);
                    JsonElement jsonElement2 = array.get(4);
                    Intrinsics.checkNotNullExpressionValue((Object)jsonElement2, (String)"get(...)");
                    segment = new Segment(n, n2, l, bl, this.isTrue(jsonElement2));
                }
                catch (Exception e) {
                    throw new InvalidModelException("Invalid segment data: " + json, e);
                }
                return segment;
            }

            private final boolean isTrue(JsonElement $this$isTrue) {
                return Intrinsics.areEqual((Object)$this$isTrue, (Object)new JsonPrimitive((Number)1)) || Intrinsics.areEqual((Object)$this$isTrue, (Object)new JsonPrimitive(Boolean.valueOf(true)));
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001b\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000b\u0010\f\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\r\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J!\u0010\u000e\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lcom/jetbrains/cidr/execution/coverage/llvm/LLVMCoverageModel$Summary;", "", "lines", "Lcom/jetbrains/cidr/execution/coverage/llvm/LLVMCoverageModel$LineMapping;", "branches", "Lcom/jetbrains/cidr/execution/coverage/llvm/LLVMCoverageModel$BranchMapping;", "<init>", "(Lcom/jetbrains/cidr/execution/coverage/llvm/LLVMCoverageModel$LineMapping;Lcom/jetbrains/cidr/execution/coverage/llvm/LLVMCoverageModel$BranchMapping;)V", "getLines", "()Lcom/jetbrains/cidr/execution/coverage/llvm/LLVMCoverageModel$LineMapping;", "getBranches", "()Lcom/jetbrains/cidr/execution/coverage/llvm/LLVMCoverageModel$BranchMapping;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.cidr.coverage"})
    public static final class Summary {
        @Nullable
        private final LineMapping lines;
        @Nullable
        private final BranchMapping branches;

        public Summary(@Nullable LineMapping lines, @Nullable BranchMapping branches) {
            this.lines = lines;
            this.branches = branches;
        }

        @Nullable
        public final LineMapping getLines() {
            return this.lines;
        }

        @Nullable
        public final BranchMapping getBranches() {
            return this.branches;
        }

        @Nullable
        public final LineMapping component1() {
            return this.lines;
        }

        @Nullable
        public final BranchMapping component2() {
            return this.branches;
        }

        @NotNull
        public final Summary copy(@Nullable LineMapping lines, @Nullable BranchMapping branches) {
            return new Summary(lines, branches);
        }

        public static /* synthetic */ Summary copy$default(Summary summary, LineMapping lineMapping, BranchMapping branchMapping, int n, Object object) {
            if ((n & 1) != 0) {
                lineMapping = summary.lines;
            }
            if ((n & 2) != 0) {
                branchMapping = summary.branches;
            }
            return summary.copy(lineMapping, branchMapping);
        }

        @NotNull
        public String toString() {
            return "Summary(lines=" + this.lines + ", branches=" + this.branches + ")";
        }

        public int hashCode() {
            int result = this.lines == null ? 0 : this.lines.hashCode();
            result = result * 31 + (this.branches == null ? 0 : this.branches.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Summary)) {
                return false;
            }
            Summary summary = (Summary)other;
            if (!Intrinsics.areEqual((Object)this.lines, (Object)summary.lines)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.branches, (Object)summary.branches);
        }
    }
}

