/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.radler.projectmodel;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.cidr.radler.projectmodel.ExtractedPreprocessorInfo;
import com.jetbrains.cidr.radler.projectmodel.ParsedDefine;
import com.jetbrains.cidr.radler.projectmodel.PreprocessorFeatures;
import com.jetbrains.cidr.radler.projectmodel.RadDefinesParserKt;
import com.jetbrains.rider.model.RadLockFreeType;
import com.jetbrains.rider.model.RadSizeTUnderlyingType;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007J\u0016\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0002J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\bH\u0002J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\bH\u0002J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\bH\u0002J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\bH\u0002J\u0010\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\bH\u0002\u00a8\u0006\u001b"}, d2={"Lcom/jetbrains/cidr/radler/projectmodel/RadDefinesParser;", "", "<init>", "()V", "extractMacroDefinitions", "Lcom/jetbrains/cidr/radler/projectmodel/ExtractedPreprocessorInfo;", "preprocessorDefines", "", "", "extractMacroFeatures", "Lcom/jetbrains/cidr/radler/projectmodel/PreprocessorFeatures;", "predefinedMacros", "parseLockFreeTypeMacro", "Lcom/jetbrains/rider/model/RadLockFreeType;", "current", "macro", "parseSizeTypeMacro", "Lcom/jetbrains/rider/model/RadSizeTUnderlyingType;", "macroDef", "parseDefine", "Lcom/jetbrains/cidr/radler/projectmodel/ParsedDefine;", "line", "shouldSendMacroToBackend", "", "name", "content", "isCIDRProvidedFileNameMacro", "intellij.rider.plugins.clion.radler"})
@SourceDebugExtension(value={"SMAP\nRadDefinesParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RadDefinesParser.kt\ncom/jetbrains/cidr/radler/projectmodel/RadDefinesParser\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,186:1\n68#2,4:187\n1788#3,4:191\n*S KotlinDebug\n*F\n+ 1 RadDefinesParser.kt\ncom/jetbrains/cidr/radler/projectmodel/RadDefinesParser\n*L\n59#1:187,4\n115#1:191,4\n*E\n"})
public final class RadDefinesParser {
    @NotNull
    public static final RadDefinesParser INSTANCE = new RadDefinesParser();

    private RadDefinesParser() {
    }

    @NotNull
    public final ExtractedPreprocessorInfo extractMacroDefinitions(@NotNull List<String> preprocessorDefines) {
        Intrinsics.checkNotNullParameter(preprocessorDefines, (String)"preprocessorDefines");
        List macrosToExtract = CollectionsKt.minus((Iterable)preprocessorDefines, (Iterable)RadDefinesParserKt.access$getCompilerMacrosToIgnore$p());
        HashMap nameToContent = new HashMap();
        for (String line : macrosToExtract) {
            if (StringsKt.startsWith$default((String)line, (String)"#define", (boolean)false, (int)2, null)) {
                String content;
                ParsedDefine parsedDefine;
                String name;
                if (this.parseDefine(line) == null || !this.shouldSendMacroToBackend(name = parsedDefine.component1(), content = parsedDefine.component2())) continue;
                ((Map)nameToContent).put(name, content);
                continue;
            }
            if (StringsKt.startsWith$default((String)line, (String)"#undef", (boolean)false, (int)2, null)) {
                String undefMacroName = ((Object)StringsKt.trim((CharSequence)StringsKt.removePrefix((String)line, (CharSequence)"#undef"))).toString();
                if (((CharSequence)undefMacroName).length() == 0) {
                    RadDefinesParserKt.access$getLogger$p().info("could not parse #undef line: " + line);
                    continue;
                }
                nameToContent.remove(undefMacroName);
                continue;
            }
            Logger $this$trace$iv = RadDefinesParserKt.access$getLogger$p();
            boolean $i$f$trace = false;
            if (!$this$trace$iv.isTraceEnabled()) continue;
            Logger logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("unrecognized line in preprocessor defines: " + line);
        }
        Collection collection = nameToContent.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        List predefinedMacros = CollectionsKt.sorted((Iterable)collection);
        PreprocessorFeatures preprocessorFeatures = this.extractMacroFeatures(predefinedMacros);
        return new ExtractedPreprocessorInfo(predefinedMacros, preprocessorFeatures);
    }

    private final PreprocessorFeatures extractMacroFeatures(List<String> predefinedMacros) {
        PreprocessorFeatures preprocessorFeatures = new PreprocessorFeatures(false, false, false, false, null, null, 63, null);
        for (String macro : predefinedMacros) {
            if (StringsKt.startsWith$default((String)macro, (String)"__GNUC__", (boolean)false, (int)2, null)) {
                preprocessorFeatures.setHasGnuC(true);
                continue;
            }
            if (Intrinsics.areEqual((Object)macro, (Object)"__STRICT_ANSI__=1")) {
                preprocessorFeatures.setHasStrictAnsi(true);
                continue;
            }
            if (Intrinsics.areEqual((Object)macro, (Object)"_WIN32=1") || Intrinsics.areEqual((Object)macro, (Object)"_WIN64=1")) {
                preprocessorFeatures.setHasWinMacro(true);
                continue;
            }
            if (Intrinsics.areEqual((Object)macro, (Object)"__MINGW32__=1") || Intrinsics.areEqual((Object)macro, (Object)"__MINGW64__=1")) {
                preprocessorFeatures.setHasMingwMacro(true);
                continue;
            }
            if (StringsKt.startsWith$default((String)macro, (String)"__SIZE_TYPE__", (boolean)false, (int)2, null)) {
                String definition = StringsKt.substringAfter$default((String)macro, (char)'=', null, (int)2, null);
                preprocessorFeatures.setSizeTUnderlyingType(this.parseSizeTypeMacro(definition));
                continue;
            }
            if (!StringsKt.startsWith$default((String)macro, (String)"__CLANG_ATOMIC_", (boolean)false, (int)2, null) && !StringsKt.startsWith$default((String)macro, (String)"__GCC_ATOMIC_", (boolean)false, (int)2, null)) continue;
            preprocessorFeatures.setLockFreeType(this.parseLockFreeTypeMacro(preprocessorFeatures.getLockFreeType(), macro));
        }
        return preprocessorFeatures;
    }

    private final RadLockFreeType parseLockFreeTypeMacro(RadLockFreeType current, String macro) {
        String strippedPrefix;
        if (current == RadLockFreeType.LongLong) {
            return current;
        }
        return switch (strippedPrefix = StringsKt.removePrefix((String)StringsKt.removePrefix((String)macro, (CharSequence)"__CLANG_"), (CharSequence)"__GCC_")) {
            case "ATOMIC_LLONG_LOCK_FREE=2" -> RadLockFreeType.LongLong;
            case "ATOMIC_LONG_LOCK_FREE=2" -> RadLockFreeType.Long;
            case "ATOMIC_INT_LOCK_FREE=2" -> RadLockFreeType.Int;
            case "ATOMIC_SHORT_LOCK_FREE=2" -> RadLockFreeType.Short;
            case "ATOMIC_CHAR_LOCK_FREE=2" -> RadLockFreeType.Char;
            default -> current;
        };
    }

    private final RadSizeTUnderlyingType parseSizeTypeMacro(String macroDef) {
        int n;
        char[] cArray = new char[]{' '};
        Iterable $this$count$iv = StringsKt.split$default((CharSequence)macroDef, (char[])cArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                String it = (String)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it, (Object)"long") || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = count$iv;
        }
        return switch (n) {
            case 0 -> RadSizeTUnderlyingType.UNSIGNED;
            case 1 -> RadSizeTUnderlyingType.UNSIGNED_LONG;
            case 2 -> RadSizeTUnderlyingType.UNSIGNED_LONGLONG;
            default -> {
                RadDefinesParserKt.access$getLogger$p().warn("Invalid __SIZE_TYPE__ definition: " + macroDef + ".");
                yield RadSizeTUnderlyingType.UNSIGNED_LONGLONG;
            }
        };
    }

    private final ParsedDefine parseDefine(String line) {
        boolean bl = StringsKt.startsWith$default((String)line, (String)"#define", (boolean)false, (int)2, null);
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        int nameStart = StringUtil.skipWhitespaceForward((CharSequence)line, (int)7);
        int nameEnd = StringsKt.indexOfAny$default((CharSequence)line, (char[])RadDefinesParserKt.access$getMacroEndNameChars$p(), (int)nameStart, (boolean)false, (int)4, null);
        if (nameEnd == -1) {
            nameEnd = line.length();
        }
        if (nameEnd == nameStart) {
            RadDefinesParserKt.access$getLogger$p().info("could not parse #define: empty name. line was: " + line);
            return null;
        }
        int lhsEnd = nameEnd;
        int maybeParamStart = StringUtil.skipWhitespaceForward((CharSequence)line, (int)nameEnd);
        boolean bl2 = 0 <= maybeParamStart ? maybeParamStart < ((CharSequence)line).length() : false;
        if (bl2 && line.charAt(maybeParamStart) == '(') {
            int maybeParamEnd = StringsKt.indexOf$default((CharSequence)line, (char)')', (int)maybeParamStart, (boolean)false, (int)4, null);
            if (maybeParamEnd == -1) {
                RadDefinesParserKt.access$getLogger$p().info("could not parse #define: parameters were not closed. line was: " + line);
                return null;
            }
            lhsEnd = maybeParamEnd + 1;
        }
        String string = line.substring(nameStart, nameEnd);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        String name = string;
        CharSequence key = StringsKt.trim((CharSequence)line.subSequence(nameStart, lhsEnd));
        CharSequence definition = StringsKt.trim((CharSequence)line.subSequence(lhsEnd, line.length()));
        String content = key + "=" + definition;
        return new ParsedDefine(name, content);
    }

    private final boolean shouldSendMacroToBackend(String name, String content) {
        if (StringsKt.startsWith$default((String)name, (String)"__CIDR_clang", (boolean)false, (int)2, null) || this.isCIDRProvidedFileNameMacro(content)) {
            return false;
        }
        return !RadDefinesParserKt.access$getMacrosWithBackendSupport$p().contains(name);
    }

    private final boolean isCIDRProvidedFileNameMacro(String content) {
        return Intrinsics.areEqual((Object)content, (Object)"__FILE_NAME__=\"_file_name_short_\"");
    }
}

