/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.radler.projectmodel;

import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.impl.ProjectImpl;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.NioPathUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.CollectionFactory;
import com.jetbrains.cidr.lang.CLanguageKind;
import com.jetbrains.cidr.lang.CUDALanguageKind;
import com.jetbrains.cidr.lang.LanguageUtils;
import com.jetbrains.cidr.lang.OCFileTypeHelpers;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.OCLanguageStandard;
import com.jetbrains.cidr.lang.search.scopes.OCExplicitSourcesSearchScope;
import com.jetbrains.cidr.lang.toolchains.CidrCompilerSwitches;
import com.jetbrains.cidr.lang.workspace.OCCompilerSettings;
import com.jetbrains.cidr.lang.workspace.OCLanguageKindCalculatorBase;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import com.jetbrains.cidr.lang.workspace.OCResolveConfigurations;
import com.jetbrains.cidr.lang.workspace.OCWorkspace;
import com.jetbrains.cidr.lang.workspace.compiler.AppleClangCompilerKind;
import com.jetbrains.cidr.lang.workspace.compiler.ClangClCompilerKind;
import com.jetbrains.cidr.lang.workspace.compiler.ClangCompilerKind;
import com.jetbrains.cidr.lang.workspace.compiler.CompilerSettingsKey;
import com.jetbrains.cidr.lang.workspace.compiler.GCCCompilerKind;
import com.jetbrains.cidr.lang.workspace.compiler.MSVCCompilerKind;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerFeatures;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerKind;
import com.jetbrains.cidr.lang.workspace.headerRoots.HeadersSearchPath;
import com.jetbrains.cidr.lang.workspace.moduleRoots.ModuleSearchPath;
import com.jetbrains.cidr.radler.projectmodel.ExtractedPreprocessorInfo;
import com.jetbrains.cidr.radler.projectmodel.PreprocessorFeatures;
import com.jetbrains.cidr.radler.projectmodel.RadCompilerFeaturesProvider;
import com.jetbrains.cidr.radler.projectmodel.RadProjectSnapshot;
import com.jetbrains.cidr.radler.projectmodel.RadProjectSnapshotBuilder;
import com.jetbrains.cidr.radler.projectmodel.RadProjectSnapshotBuilderKt;
import com.jetbrains.rider.model.RadCompilerKind;
import com.jetbrains.rider.model.RadCoroutineMode;
import com.jetbrains.rider.model.RadGnuNullUnderlyingType;
import com.jetbrains.rider.model.RadLanguageDialect;
import com.jetbrains.rider.model.RadLanguageKind;
import com.jetbrains.rider.model.RadLanguageStandard;
import com.jetbrains.rider.model.RadLockFreeType;
import com.jetbrains.rider.model.RadModuleSearchPath;
import com.jetbrains.rider.model.RadSizeTUnderlyingType;
import com.jetbrains.rider.model.RadSourceFileSettings;
import com.jetbrains.rider.model.RadTargetArchitecture;
import com.jetbrains.rider.model.RadToolsetSettings;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.Duration;
import kotlin.time.TimeSource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00c0\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 L2\u00020\u0001:\u0002KLB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\u0016\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0014\u0010\u0016\u001a\u0004\u0018\u00010\u00072\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0002J.\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u001d\u001a\u00020\u001e2\n\b\u0002\u0010\u001f\u001a\u0004\u0018\u00010\u0007H\u0002J6\u0010 \u001a\u0004\u0018\u00010\u00072\u0006\u0010!\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u001d\u001a\u00020\u001e2\n\b\u0002\u0010\u001f\u001a\u0004\u0018\u00010\u0007H\u0002J$\u0010\"\u001a\u0004\u0018\u00010\u00072\u0006\u0010#\u001a\u00020\u00182\u0006\u0010$\u001a\u00020%2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0002J\u0012\u0010&\u001a\u0004\u0018\u00010'2\u0006\u0010(\u001a\u00020%H\u0002J\u001a\u0010)\u001a\u0004\u0018\u00010\u00072\u0006\u0010(\u001a\u00020%2\u0006\u0010*\u001a\u00020+H\u0007J\u0012\u0010,\u001a\u00020-2\b\u0010,\u001a\u0004\u0018\u00010.H\u0002J\u0016\u0010/\u001a\u00020\u000e2\f\u00100\u001a\b\u0012\u0004\u0012\u00020\r0\tH\u0002J\u0016\u00101\u001a\u0002022\f\u00103\u001a\b\u0012\u0004\u0012\u00020\n04H\u0002J\u0012\u00105\u001a\u00020\u001e2\b\u0010,\u001a\u0004\u0018\u00010.H\u0002J(\u00106\u001a\u00020\u001e2\b\u0010,\u001a\u0004\u0018\u00010.2\u0006\u00107\u001a\u0002082\f\u00109\u001a\b\u0012\u0004\u0012\u00020\n04H\u0002J(\u0010:\u001a\u00020;2\u0006\u0010<\u001a\u0002082\u0006\u0010=\u001a\u0002022\u0006\u0010>\u001a\u00020?2\u0006\u0010@\u001a\u00020AH\u0002J\"\u0010B\u001a\u00020C2\b\u0010D\u001a\u0004\u0018\u00010C2\u0006\u0010>\u001a\u00020?2\u0006\u0010E\u001a\u00020\u001eH\u0002J\u0018\u0010F\u001a\u00020C2\u0006\u0010>\u001a\u00020?2\u0006\u0010E\u001a\u00020\u001eH\u0002J\u0012\u0010G\u001a\u0004\u0018\u00010H2\u0006\u0010I\u001a\u00020JH\u0002R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\b\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t\u0012\u0004\u0012\u00020\u000b0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\f\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\t\u0012\u0004\u0012\u00020\u000e0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006M"}, d2={"Lcom/jetbrains/cidr/radler/projectmodel/RadProjectSnapshotBuilder;", "", "<init>", "()V", "toolsetSettingsCache", "Ljava/util/concurrent/ConcurrentMap;", "Lcom/jetbrains/cidr/lang/workspace/compiler/CompilerSettingsKey;", "Lcom/jetbrains/rider/model/RadToolsetSettings;", "definesCache", "", "", "Lcom/jetbrains/cidr/radler/projectmodel/ExtractedPreprocessorInfo;", "dependenciesPathsCache", "Lcom/jetbrains/cidr/lang/workspace/headerRoots/HeadersSearchPath;", "Lcom/jetbrains/cidr/radler/projectmodel/RadProjectSnapshotBuilder$DependenciesPaths;", "getProjectSnapshot", "Lcom/jetbrains/cidr/radler/projectmodel/RadProjectSnapshot;", "project", "Lcom/intellij/openapi/project/Project;", "version", "", "getProjectContentRoots", "getFallbackToolsetSettings", "fallbackConfig", "Lcom/jetbrains/cidr/lang/workspace/OCResolveConfiguration;", "getSourceSettings", "Lcom/jetbrains/rider/model/RadSourceFileSettings;", "source", "Lcom/intellij/openapi/vfs/VirtualFile;", "tryGuess", "", "globalToolset", "getSourceToolset", "configuration", "getToolsetSettingsForLanguageKind", "config", "languageKind", "Lcom/jetbrains/cidr/lang/OCLanguageKind;", "convertLanguage", "Lcom/jetbrains/rider/model/RadLanguageKind;", "language", "convertSettings", "input", "Lcom/jetbrains/cidr/lang/workspace/OCCompilerSettings;", "compilerKind", "Lcom/jetbrains/rider/model/RadCompilerKind;", "Lcom/jetbrains/cidr/lang/workspace/compiler/OCCompilerKind;", "extractDependenciesPaths", "inputHeadersSearchPaths", "extractCoroutineMode", "Lcom/jetbrains/rider/model/RadCoroutineMode;", "compilerFlags", "", "hasClangExtensions", "hasMSVCExtensions", "preprocessorFeatures", "Lcom/jetbrains/cidr/radler/projectmodel/PreprocessorFeatures;", "flags", "extractLanguageDialect", "Lcom/jetbrains/rider/model/RadLanguageDialect;", "ppFeatures", "coroutineMode", "targetArchitecture", "Lcom/jetbrains/rider/model/RadTargetArchitecture;", "provider", "Lcom/jetbrains/cidr/radler/projectmodel/RadCompilerFeaturesProvider;", "getUnderlyingSizeType", "Lcom/jetbrains/rider/model/RadSizeTUnderlyingType;", "sizeType", "msExtensions", "getUnderlyingSizeTypeFromArch", "languageStandard", "Lcom/jetbrains/rider/model/RadLanguageStandard;", "standard", "Lcom/jetbrains/cidr/lang/OCLanguageStandard;", "DependenciesPaths", "Companion", "intellij.rider.plugins.clion.radler"})
@SourceDebugExtension(value={"SMAP\nRadProjectSnapshotBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RadProjectSnapshotBuilder.kt\ncom/jetbrains/cidr/radler/projectmodel/RadProjectSnapshotBuilder\n+ 2 measureTime.kt\nkotlin/time/MeasureTimeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,608:1\n24#2:609\n63#2,3:610\n3829#3:613\n4344#3,2:614\n1563#4:616\n1634#4,3:617\n1563#4:620\n1634#4,3:621\n1563#4:624\n1634#4,3:625\n14#5:628\n*S KotlinDebug\n*F\n+ 1 RadProjectSnapshotBuilder.kt\ncom/jetbrains/cidr/radler/projectmodel/RadProjectSnapshotBuilder\n*L\n84#1:609\n84#1:610,3\n121#1:613\n121#1:614,2\n122#1:616\n122#1:617,3\n240#1:620\n240#1:621,3\n284#1:624\n284#1:625,3\n518#1:628\n*E\n"})
public final class RadProjectSnapshotBuilder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ConcurrentMap<CompilerSettingsKey, RadToolsetSettings> toolsetSettingsCache;
    @NotNull
    private final ConcurrentMap<List<String>, ExtractedPreprocessorInfo> definesCache;
    @NotNull
    private final ConcurrentMap<List<HeadersSearchPath>, DependenciesPaths> dependenciesPathsCache;
    @NotNull
    private static final Logger logger;

    public RadProjectSnapshotBuilder() {
        ConcurrentMap concurrentMap = CollectionFactory.createConcurrentWeakValueMap();
        Intrinsics.checkNotNullExpressionValue((Object)concurrentMap, (String)"createConcurrentWeakValueMap(...)");
        this.toolsetSettingsCache = concurrentMap;
        ConcurrentMap concurrentMap2 = CollectionFactory.createConcurrentWeakValueMap();
        Intrinsics.checkNotNullExpressionValue((Object)concurrentMap2, (String)"createConcurrentWeakValueMap(...)");
        this.definesCache = concurrentMap2;
        ConcurrentMap concurrentMap3 = CollectionFactory.createConcurrentWeakValueMap();
        Intrinsics.checkNotNullExpressionValue((Object)concurrentMap3, (String)"createConcurrentWeakValueMap(...)");
        this.dependenciesPathsCache = concurrentMap3;
    }

    @NotNull
    public final RadProjectSnapshot getProjectSnapshot(@NotNull Project project, long version) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        List list = OCWorkspace.getInstance((Project)project).getConfigurations();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getConfigurations(...)");
        List configurations = list;
        Set sourceFiles = RadProjectSnapshotBuilder.Companion.getProjectSourceFiles(configurations);
        HashMap<VirtualFile, RadSourceFileSettings> sources = new HashMap<VirtualFile, RadSourceFileSettings>();
        for (VirtualFile sourceFile : sourceFiles) {
            Object object;
            Map map = sources;
            if (RadProjectSnapshotBuilder.getSourceSettings$default(this, sourceFile, project, false, null, 8, null) == null) continue;
            map.put(sourceFile, object);
        }
        LanguageUtils languageUtils = LanguageUtils.Companion.getInstance();
        OCResolveConfiguration fallbackConfig = (OCResolveConfiguration)OCResolveConfigurations.findPreselectedOrSuitableConfiguration((Project)project, (Collection)((Collection)configurations)).first;
        RadToolsetSettings fallback = this.getFallbackToolsetSettings(fallbackConfig);
        for (VirtualFile file : (Collection)ActionsKt.runReadAction((Function0)((Function0)new Function0<Collection<VirtualFile>>(project){
            final /* synthetic */ Project $project;
            {
                this.$project = $project;
                super(0);
            }

            public final Collection<VirtualFile> invoke() {
                return OCExplicitSourcesSearchScope.getExplicitlySpecifiedProjectSourceFiles((Project)this.$project);
            }
        }))) {
            RadSourceFileSettings sourceSettings;
            if (sources.containsKey(file)) continue;
            Intrinsics.checkNotNull((Object)file);
            if (!languageUtils.isSupportedFile(file) || (sourceSettings = this.getSourceSettings(file, project, true, fallback)) == null) continue;
            sources.put(file, sourceSettings);
        }
        HashMap<VirtualFile, RadSourceFileSettings> weakSources = new HashMap<VirtualFile, RadSourceFileSettings>();
        if (RadProjectSnapshotBuilderKt.isDeepProjectScanEnabled()) {
            Ref.IntRef totalFiles = new Ref.IntRef();
            boolean $i$f$measureTime = false;
            TimeSource.Monotonic $this$measureTime$iv$iv = TimeSource.Monotonic.INSTANCE;
            boolean $i$f$measureTime2 = false;
            long mark$iv$iv = $this$measureTime$iv$iv.markNow-z9LOYto();
            boolean bl = false;
            ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
            Intrinsics.checkNotNullExpressionValue((Object)projectFileIndex, (String)"getFileIndex(...)");
            ProjectFileIndex fileIndex = projectFileIndex;
            fileIndex.iterateContent(arg_0 -> RadProjectSnapshotBuilder.getProjectSnapshot$lambda$1$lambda$0(sources, languageUtils, this, project, fallback, weakSources, totalFiles, arg_0));
            long contentIterationTime = TimeSource.Monotonic.ValueTimeMark.elapsedNow-UwyO8pc((long)mark$iv$iv);
            logger.info("Content iteration took " + Duration.toString-impl((long)contentIterationTime) + " (added " + weakSources.size() + " new files of " + totalFiles.element + " total files in content)");
        }
        Object object = ProjectImpl.PROJECT_PATH.get((UserDataHolder)project);
        Intrinsics.checkNotNull((Object)object);
        Path path = ((Path)object).toAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toAbsolutePath(...)");
        String basePath = NioPathUtil.toCanonicalPath((Path)path);
        List<String> sourceRoots = this.getProjectContentRoots(project);
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            logger.info("Frontend prepared " + sources.size() + " sources for project " + project.getName() + " (weak: " + weakSources.size() + ")");
        }
        String string = project.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return new RadProjectSnapshot(sources, weakSources, fallback, string, basePath, sourceRoots, version);
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> getProjectContentRoots(Project project) {
        void $this$mapTo$iv$iv;
        Iterable $this$filterTo$iv$iv;
        VirtualFile[] virtualFileArray = ProjectRootManager.getInstance((Project)project).getContentRoots();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getContentRoots(...)");
        Object[] $this$filter$iv = virtualFileArray;
        boolean $i$f$filter = false;
        Object[] objectArray = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (VirtualFile element$iv$iv : $this$filterTo$iv$iv) {
            VirtualFile it = element$iv$iv;
            boolean bl = false;
            if (!it.isDirectory()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            VirtualFile element$iv$iv;
            element$iv$iv = (VirtualFile)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getPath());
        }
        return (List)destination$iv$iv;
    }

    private final RadToolsetSettings getFallbackToolsetSettings(OCResolveConfiguration fallbackConfig) {
        RadToolsetSettings radToolsetSettings;
        block3: {
            if (fallbackConfig == null) {
                return null;
            }
            for (OCLanguageKind kind : new OCLanguageKind[]{CLanguageKind.CPP, CLanguageKind.C, CUDALanguageKind.CUDA}) {
                boolean bl = false;
                radToolsetSettings = this.getToolsetSettingsForLanguageKind(fallbackConfig, kind, null);
                if (radToolsetSettings == null) {
                    continue;
                }
                break block3;
            }
            radToolsetSettings = null;
        }
        return radToolsetSettings;
    }

    private final RadSourceFileSettings getSourceSettings(VirtualFile source, Project project, boolean tryGuess, RadToolsetSettings globalToolset) {
        OCResolveConfiguration oCResolveConfiguration = OCResolveConfigurations.getPreselectedConfiguration((VirtualFile)source, (Project)project);
        if (oCResolveConfiguration == null) {
            return null;
        }
        OCResolveConfiguration configuration = oCResolveConfiguration;
        RadToolsetSettings radToolsetSettings = this.getSourceToolset(configuration, source, project, tryGuess, globalToolset);
        if (radToolsetSettings == null) {
            return null;
        }
        RadToolsetSettings toolsetSettings = radToolsetSettings;
        String string = configuration.getDisplayName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getDisplayName(...)");
        return new RadSourceFileSettings(toolsetSettings, string);
    }

    static /* synthetic */ RadSourceFileSettings getSourceSettings$default(RadProjectSnapshotBuilder radProjectSnapshotBuilder, VirtualFile virtualFile, Project project, boolean bl, RadToolsetSettings radToolsetSettings, int n, Object object) {
        if ((n & 8) != 0) {
            radToolsetSettings = null;
        }
        return radProjectSnapshotBuilder.getSourceSettings(virtualFile, project, bl, radToolsetSettings);
    }

    private final RadToolsetSettings getSourceToolset(OCResolveConfiguration configuration, VirtualFile source, Project project, boolean tryGuess, RadToolsetSettings globalToolset) {
        RadToolsetSettings toolsetSettings;
        OCLanguageKind languageKind = configuration.getDeclaredLanguageKind(source);
        if (languageKind == null) {
            if (tryGuess) {
                if (OCFileTypeHelpers.isHeaderFile((String)source.getName())) {
                    return globalToolset;
                }
                OCLanguageKind oCLanguageKind = OCLanguageKindCalculatorBase.tryFileTypeAndExtension((Project)project, (VirtualFile)source);
                if (oCLanguageKind == null) {
                    Set set = configuration.getEnabledLanguageKinds();
                    Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getEnabledLanguageKinds(...)");
                    oCLanguageKind = (OCLanguageKind)CollectionsKt.singleOrNull((Iterable)set);
                }
                if ((languageKind = oCLanguageKind) == null) {
                    logger.warn("Could not guess language kind for " + source + ", falling back to global toolset");
                    return globalToolset;
                }
            } else {
                logger.warn("Could not determine language kind for " + source);
                return null;
            }
        }
        if ((toolsetSettings = this.getToolsetSettingsForLanguageKind(configuration, languageKind, source)) == null) {
            logger.warn("Could not convert compiler settings to R++ format for " + source);
            return null;
        }
        return toolsetSettings;
    }

    static /* synthetic */ RadToolsetSettings getSourceToolset$default(RadProjectSnapshotBuilder radProjectSnapshotBuilder, OCResolveConfiguration oCResolveConfiguration, VirtualFile virtualFile, Project project, boolean bl, RadToolsetSettings radToolsetSettings, int n, Object object) {
        if ((n & 0x10) != 0) {
            radToolsetSettings = null;
        }
        return radProjectSnapshotBuilder.getSourceToolset(oCResolveConfiguration, virtualFile, project, bl, radToolsetSettings);
    }

    private final RadToolsetSettings getToolsetSettingsForLanguageKind(OCResolveConfiguration config, OCLanguageKind languageKind, VirtualFile source) {
        OCCompilerSettings oCCompilerSettings = config.getCompilerSettings(languageKind, source);
        Intrinsics.checkNotNullExpressionValue((Object)oCCompilerSettings, (String)"getCompilerSettings(...)");
        OCCompilerSettings compilerSettings = oCCompilerSettings;
        CompilerSettingsKey cachingKey = compilerSettings.getCachingKey();
        return cachingKey != null ? this.toolsetSettingsCache.computeIfAbsent(compilerSettings.getCachingKey(), arg_0 -> RadProjectSnapshotBuilder.getToolsetSettingsForLanguageKind$lambda$5((Function1)new Function1<CompilerSettingsKey, RadToolsetSettings>(this, languageKind, compilerSettings){
            final /* synthetic */ RadProjectSnapshotBuilder this$0;
            final /* synthetic */ OCLanguageKind $languageKind;
            final /* synthetic */ OCCompilerSettings $compilerSettings;
            {
                this.this$0 = $receiver;
                this.$languageKind = $languageKind;
                this.$compilerSettings = $compilerSettings;
                super(1);
            }

            public final RadToolsetSettings invoke(CompilerSettingsKey compilerSettingsKey) {
                return this.this$0.convertSettings(this.$languageKind, this.$compilerSettings);
            }
        }, arg_0)) : this.convertSettings(languageKind, compilerSettings);
    }

    private final RadLanguageKind convertLanguage(OCLanguageKind language) {
        RadLanguageKind radLanguageKind;
        OCLanguageKind oCLanguageKind = language;
        if (oCLanguageKind == CLanguageKind.C) {
            radLanguageKind = RadLanguageKind.C;
        } else if (oCLanguageKind == CLanguageKind.CPP) {
            radLanguageKind = RadLanguageKind.Cpp;
        } else if (oCLanguageKind == CUDALanguageKind.CUDA) {
            radLanguageKind = RadLanguageKind.CUDA;
        } else if (oCLanguageKind == CLanguageKind.OBJ_C) {
            logger.warn("Unsupported language: " + language + ", falling back to C");
            radLanguageKind = RadLanguageKind.C;
        } else if (oCLanguageKind == CLanguageKind.OBJ_CPP) {
            logger.warn("Unsupported language: " + language + ", falling back to Cpp");
            radLanguageKind = RadLanguageKind.Cpp;
        } else {
            radLanguageKind = null;
        }
        return radLanguageKind;
    }

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting
    @Nullable
    public final RadToolsetSettings convertSettings(@NotNull OCLanguageKind language, @NotNull OCCompilerSettings input) {
        void $this$mapTo$iv$iv;
        CidrCompilerSwitches cidrCompilerSwitches;
        OCCompilerKind compilerKind;
        RadTargetArchitecture radTargetArchitecture;
        Short sizeOfSizeT;
        Object it;
        Collection collection;
        Object item$iv$iv2;
        void $this$mapTo$iv$iv2;
        OCLanguageStandard languageStandard;
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        ProgressManager.checkCanceled();
        RadLanguageKind languageKind = this.convertLanguage(language);
        if (languageKind == null) {
            logger.warn("Unsupported language " + language);
            return null;
        }
        Object object = input.getCompilerFeatures().get(OCCompilerFeatures.LANGUAGE_STANDARD);
        OCLanguageStandard oCLanguageStandard = languageStandard = object instanceof OCLanguageStandard ? (OCLanguageStandard)object : null;
        if (languageStandard == null) {
            logger.info("No language standard found (language: " + language + ")");
            return null;
        }
        object = this.dependenciesPathsCache.computeIfAbsent(input.getHeadersSearchPaths(), arg_0 -> RadProjectSnapshotBuilder.convertSettings$lambda$6((Function1)new Function1<List<? extends HeadersSearchPath>, DependenciesPaths>(this){
            final /* synthetic */ RadProjectSnapshotBuilder this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final DependenciesPaths invoke(List<HeadersSearchPath> it) {
                Intrinsics.checkNotNull(it);
                return RadProjectSnapshotBuilder.access$extractDependenciesPaths(this.this$0, it);
            }
        }, arg_0));
        List<String> includePaths = ((DependenciesPaths)object).component1();
        List<String> frameworkPaths = ((DependenciesPaths)object).component2();
        List list = input.getImplicitIncludes();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getImplicitIncludes(...)");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
            VirtualFile virtualFile = (VirtualFile)item$iv$iv2;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(FileUtil.toSystemDependentName((String)it.getPath()));
        }
        List implicitIncludes = (List)destination$iv$iv;
        Short s = sizeOfSizeT = (Short)input.getCompilerFeatures().get(OCCompilerFeatures.TypeSize.POINTER);
        boolean bl = s != null ? s == 4 : false;
        if (bl) {
            radTargetArchitecture = RadTargetArchitecture.X86;
        } else {
            Short s2 = sizeOfSizeT;
            boolean bl2 = s2 != null ? s2 == 8 : false;
            if (bl2) {
                radTargetArchitecture = RadTargetArchitecture.AMD64;
            } else {
                logger.warn("R# can only handle size_t of size 4 or 8, CLion requests " + sizeOfSizeT + ". Assuming 4 instead.");
                radTargetArchitecture = RadTargetArchitecture.X86;
            }
        }
        RadTargetArchitecture targetArchitecture = radTargetArchitecture;
        ExtractedPreprocessorInfo extractedPreprocessorInfo = this.definesCache.computeIfAbsent(input.getPreprocessorDefines(), arg_0 -> RadProjectSnapshotBuilder.convertSettings$lambda$8(convertSettings.2.INSTANCE, arg_0));
        List<String> predefinedMacros = extractedPreprocessorInfo.component1();
        PreprocessorFeatures preprocessorFeatures = extractedPreprocessorInfo.component2();
        item$iv$iv2 = input.getCompilerFeatures().get(OCCompilerFeatures.HostCompilerKind.HOST_COMPILER_KIND);
        OCCompilerKind oCCompilerKind = item$iv$iv2 instanceof OCCompilerKind ? (OCCompilerKind)item$iv$iv2 : null;
        if (oCCompilerKind == null) {
            oCCompilerKind = compilerKind = input.getCompilerKind();
        }
        if ((cidrCompilerSwitches = (it = input.getCompilerFeatures().get(OCCompilerFeatures.HostCompilerFlags.HOST_COMPILER_FLAGS)) instanceof CidrCompilerSwitches ? (CidrCompilerSwitches)it : null) == null) {
            cidrCompilerSwitches = input.getCompilerSwitches();
        }
        CidrCompilerSwitches compilerSwitches = cidrCompilerSwitches;
        boolean gnuCompatible = compilerKind instanceof ClangClCompilerKind || preprocessorFeatures.getHasGnuC();
        boolean gnuExtensions = gnuCompatible && !preprocessorFeatures.getHasStrictAnsi();
        boolean clangExtensions = this.hasClangExtensions(compilerKind);
        CidrCompilerSwitches cidrCompilerSwitches2 = compilerSwitches;
        List list2 = cidrCompilerSwitches2 != null ? cidrCompilerSwitches2.getList(CidrCompilerSwitches.Format.RAW) : null;
        if (list2 == null) {
            list2 = CollectionsKt.emptyList();
        }
        Set compilerFlags = CollectionsKt.toSet((Iterable)list2);
        boolean msvcExtensions = this.hasMSVCExtensions(compilerKind, preprocessorFeatures, compilerFlags);
        RadCoroutineMode coroutineMode = this.extractCoroutineMode(compilerFlags);
        Map map = input.getCompilerFeatures();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"getCompilerFeatures(...)");
        RadCompilerFeaturesProvider provider = new RadCompilerFeaturesProvider(map, compilerFlags, msvcExtensions, gnuExtensions, gnuCompatible, clangExtensions, languageStandard);
        RadLanguageDialect languageDialect = this.extractLanguageDialect(preprocessorFeatures, coroutineMode, targetArchitecture, provider);
        List list3 = input.getModuleSearchPaths();
        Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"getModuleSearchPaths(...)");
        Iterable $this$map$iv2 = list3;
        boolean $i$f$map2 = false;
        Iterable iterable2 = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv3 : $this$mapTo$iv$iv) {
            void it2;
            ModuleSearchPath moduleSearchPath = (ModuleSearchPath)item$iv$iv3;
            collection = destination$iv$iv2;
            boolean bl3 = false;
            String string = FileUtil.toSystemDependentName((String)((Object)it2.getModulePath()).toString());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toSystemDependentName(...)");
            collection.add(new RadModuleSearchPath(string));
        }
        List moduleSearchPaths = (List)destination$iv$iv2;
        RadLanguageStandard radLanguageStandard = this.languageStandard(languageStandard);
        RadCompilerKind radCompilerKind = this.compilerKind(compilerKind);
        return new RadToolsetSettings(languageKind, radCompilerKind, includePaths, frameworkPaths, targetArchitecture, coroutineMode, implicitIncludes, radLanguageStandard, predefinedMacros, languageDialect, moduleSearchPaths);
    }

    private final RadCompilerKind compilerKind(OCCompilerKind compilerKind) {
        OCCompilerKind oCCompilerKind = compilerKind;
        return Intrinsics.areEqual((Object)oCCompilerKind, (Object)GCCCompilerKind.INSTANCE) ? RadCompilerKind.GCC : (Intrinsics.areEqual((Object)oCCompilerKind, (Object)ClangCompilerKind.INSTANCE) ? RadCompilerKind.Clang : (Intrinsics.areEqual((Object)oCCompilerKind, (Object)AppleClangCompilerKind.INSTANCE) ? RadCompilerKind.Clang : (Intrinsics.areEqual((Object)oCCompilerKind, (Object)ClangClCompilerKind.INSTANCE) ? RadCompilerKind.ClangCl : (Intrinsics.areEqual((Object)oCCompilerKind, (Object)MSVCCompilerKind.INSTANCE) ? RadCompilerKind.MSVC : RadCompilerKind.Unknown))));
    }

    private final DependenciesPaths extractDependenciesPaths(List<HeadersSearchPath> inputHeadersSearchPaths) {
        ArrayList includePaths = new ArrayList(inputHeadersSearchPaths.size());
        ArrayList<String> frameworkPaths = new ArrayList<String>(inputHeadersSearchPaths.size());
        ArrayList<String> builtinIncludePaths = new ArrayList<String>(inputHeadersSearchPaths.size());
        for (HeadersSearchPath searchPath : inputHeadersSearchPaths) {
            if (searchPath.isRecursive()) {
                logger.warn("Skipping a framework or recursive include path " + searchPath.getPath());
                continue;
            }
            if (searchPath.isFrameworksSearchPath()) {
                frameworkPaths.add(FileUtil.toSystemDependentName((String)searchPath.getPath()));
                continue;
            }
            ArrayList<String> targetList = searchPath.isBuiltInHeaders() ? builtinIncludePaths : includePaths;
            targetList.add(FileUtil.toSystemDependentName((String)searchPath.getPath()));
        }
        includePaths.addAll(builtinIncludePaths);
        return new DependenciesPaths(includePaths, (List<String>)frameworkPaths);
    }

    private final RadCoroutineMode extractCoroutineMode(Set<String> compilerFlags) {
        return compilerFlags.contains("-fcoroutines-ts") || compilerFlags.contains("-fcoroutines") || compilerFlags.contains("/await") ? RadCoroutineMode.Experimental : (compilerFlags.contains("/await:strict") ? RadCoroutineMode.Strict : RadCoroutineMode.Default);
    }

    private final boolean hasClangExtensions(OCCompilerKind compilerKind) {
        return compilerKind instanceof ClangClCompilerKind || compilerKind instanceof ClangCompilerKind || compilerKind instanceof AppleClangCompilerKind;
    }

    private final boolean hasMSVCExtensions(OCCompilerKind compilerKind, PreprocessorFeatures preprocessorFeatures, Set<String> flags) {
        if (compilerKind instanceof MSVCCompilerKind || compilerKind instanceof ClangClCompilerKind) {
            return true;
        }
        if (!(compilerKind instanceof ClangCompilerKind)) {
            return false;
        }
        if (flags.contains("-fms-extensions")) {
            return true;
        }
        return preprocessorFeatures.getHasWinMacro() && !preprocessorFeatures.getHasMingwMacro();
    }

    private final RadLanguageDialect extractLanguageDialect(PreprocessorFeatures ppFeatures, RadCoroutineMode coroutineMode, RadTargetArchitecture targetArchitecture, RadCompilerFeaturesProvider provider) {
        boolean msExtensions = provider.areMSExtensionsEnabled();
        boolean gnuExtensions = provider.areGNUExtensionsEnabled();
        boolean gnuCompatible = provider.isGNUCompatible();
        boolean clangExtensions = provider.areClangExtensionsEnabled();
        RadSizeTUnderlyingType underlyingSizeType = this.getUnderlyingSizeType(ppFeatures.getSizeTUnderlyingType(), targetArchitecture, msExtensions);
        RadGnuNullUnderlyingType underlyingNullType = switch (WhenMappings.$EnumSwitchMapping$0[targetArchitecture.ordinal()]) {
            case 1 -> RadGnuNullUnderlyingType.INT;
            case 2 -> RadGnuNullUnderlyingType.LONG;
            default -> throw new NoWhenBranchMatchedException();
        };
        boolean hasCoroutines = provider.flag(OCCompilerFeatures.Feature.CXX_COROUTINES) || coroutineMode != RadCoroutineMode.Default;
        long supportedTypeTraits = provider.packSupportedTypeTraits();
        boolean bl = provider.flag(OCCompilerFeatures.Feature.HAS_BUILTIN);
        boolean bl2 = provider.flag(OCCompilerFeatures.Feature.HAS_FEATURE);
        boolean bl3 = provider.flag(OCCompilerFeatures.Feature.HAS_EXTENSION);
        boolean bl4 = provider.flag(OCCompilerFeatures.Feature.HAS_HAS_INCLUDE_NEXT);
        boolean bl5 = provider.flag(OCCompilerFeatures.Feature.GCC_AUTO_TYPE);
        boolean bl6 = provider.flag(OCCompilerFeatures.Feature.MS_TRADITIONAL_PREPROCESSOR);
        boolean bl7 = provider.flag(OCCompilerFeatures.Feature.C_VARIABLE_DECLARATION_RULES_ARE_C89_COMPATIBLE);
        boolean bl8 = provider.flag(OCCompilerFeatures.Feature.C_NULLPTR);
        boolean bl9 = provider.flag(OCCompilerFeatures.Feature.C_AUTO_TYPE);
        boolean bl10 = provider.flag(OCCompilerFeatures.Feature.C_CONSTEXPR);
        boolean bl11 = provider.flag(OCCompilerFeatures.Feature.BUILTIN_SOURCE_LOCATION);
        boolean bl12 = provider.flag(OCCompilerFeatures.Feature.BUILTIN_BIT_CAST);
        short s = provider.typeSize(OCCompilerFeatures.TypeSize.LONG);
        short s2 = provider.typeSize(OCCompilerFeatures.TypeSize.WCHAR_T);
        RadLockFreeType radLockFreeType = ppFeatures.getLockFreeType();
        boolean bl13 = provider.flag(OCCompilerFeatures.Feature.CXX_TYPE_INFO_IN_GLOBAL_NAMESPACE);
        boolean bl14 = provider.flag(OCCompilerFeatures.Feature.CXX_MS_ALLOW_BINDING_RVALUE_TO_LVALUE_REFERENCE);
        boolean bl15 = provider.flag(OCCompilerFeatures.Feature.CXX_MS_PREFER_COPY_CTOR_OVER_USER_DEFINED);
        boolean bl16 = provider.flag(OCCompilerFeatures.Feature.CXX_ALTERNATIVE_OPERATORS);
        boolean bl17 = provider.flag(OCCompilerFeatures.Feature.CXX_BUILTIN_WCHAR);
        boolean bl18 = provider.flag(OCCompilerFeatures.Feature.CXX_EXCEPTIONS);
        boolean bl19 = provider.flag(OCCompilerFeatures.Feature.CXX_BUILTIN_CHAR16);
        boolean bl20 = provider.flag(OCCompilerFeatures.Feature.CXX_BUILTIN_CHAR32);
        boolean bl21 = provider.flag(OCCompilerFeatures.Feature.CXX_AUTO_TYPE);
        boolean bl22 = provider.flag(OCCompilerFeatures.Feature.CXX_NOEXCEPT);
        boolean bl23 = provider.flag(OCCompilerFeatures.Feature.CXX_EXPLICIT_CONVERSION_OPERATORS);
        boolean bl24 = provider.flag(OCCompilerFeatures.Feature.CXX_DELEGATING_CONSTRUCTORS);
        boolean bl25 = provider.flag(OCCompilerFeatures.Feature.CXX_DEFAULTED_AND_DELETED_FUNCTIONS);
        boolean bl26 = provider.flag(OCCompilerFeatures.Feature.CXX_OVERRIDE_CONTROL);
        boolean bl27 = provider.flag(OCCompilerFeatures.Feature.CXX_GENERALIZED_INITIALIZERS);
        boolean bl28 = provider.flag(OCCompilerFeatures.Feature.CXX_NULLPTR);
        boolean bl29 = provider.flag(OCCompilerFeatures.Feature.CXX_NONSTATIC_MEMBER_INIT);
        boolean bl30 = provider.flag(OCCompilerFeatures.Feature.CXX_LAMBDAS);
        boolean bl31 = provider.flag(OCCompilerFeatures.Feature.CXX_RAW_STRING_LITERALS);
        boolean bl32 = provider.flag(OCCompilerFeatures.Feature.CXX_USER_LITERALS);
        boolean bl33 = provider.flag(OCCompilerFeatures.Feature.CXX_ATTRIBUTES);
        boolean bl34 = provider.flag(OCCompilerFeatures.Feature.CXX_CONSTEXPR);
        boolean bl35 = provider.flag(OCCompilerFeatures.Feature.CXX_CONSTEXPR_VOID);
        boolean bl36 = provider.flag(OCCompilerFeatures.Feature.CXX_RELAXED_CONSTEXPR);
        boolean bl37 = provider.flag(OCCompilerFeatures.Feature.CXX_HAS_IMPLICIT_CONST_ON_CONSTEXPR_MEMBER);
        boolean bl38 = provider.flag(OCCompilerFeatures.Feature.CXX_BINARY_LITERALS);
        boolean bl39 = provider.flag(OCCompilerFeatures.Feature.CXX_RETURN_TYPE_DEDUCTION);
        boolean bl40 = provider.flag(OCCompilerFeatures.Feature.CXX_GENERIC_LAMBDAS);
        boolean bl41 = provider.flag(OCCompilerFeatures.Feature.CXX_STRING_BUILTINS);
        boolean bl42 = provider.flag(OCCompilerFeatures.Feature.CXX_STRUCTURED_BINDINGS);
        boolean bl43 = provider.flag(OCCompilerFeatures.Feature.CXX_CTAD);
        boolean bl44 = provider.flag(OCCompilerFeatures.Feature.CXX_GUARANTEED_COPY_ELISION);
        boolean bl45 = provider.flag(OCCompilerFeatures.Feature.CXX_AGGREGATES_WITH_BASE_CLASSES);
        boolean bl46 = provider.flag(OCCompilerFeatures.Feature.CXX_INLINE_VARIABLES);
        boolean bl47 = provider.flag(OCCompilerFeatures.Feature.CXX_CONSTEXPR_IF);
        boolean bl48 = provider.flag(OCCompilerFeatures.Feature.CXX_IF_INITIALIZERS);
        boolean bl49 = provider.flag(OCCompilerFeatures.Feature.CXX_NESTED_NAMESPACES);
        boolean bl50 = provider.flag(OCCompilerFeatures.Feature.CXX_HAS_AUTO_WITH_LIST_INIT_FIX);
        boolean bl51 = provider.flag(OCCompilerFeatures.Feature.CXX_BUILTIN_IS_CONSTANT_EVALUATED);
        boolean bl52 = provider.flag(OCCompilerFeatures.Feature.CXX_OBJECT_TEMPLATE_PARAMETERS);
        boolean bl53 = provider.flag(OCCompilerFeatures.Feature.CXX_CONSTEVAL);
        boolean bl54 = provider.flag(OCCompilerFeatures.Feature.CXX_CONSTINIT);
        boolean bl55 = provider.flag(OCCompilerFeatures.Feature.CXX_USING_ENUM);
        boolean bl56 = provider.flag(OCCompilerFeatures.Feature.CXX_DEFAULT_CONSTRUCTIBLE_AND_ASSIGNABLE_STATELESS_LAMBDAS);
        boolean bl57 = provider.flag(OCCompilerFeatures.Feature.CXX_THREE_WAY_COMPARISON);
        boolean bl58 = provider.flag(OCCompilerFeatures.Feature.CXX_CTAD_FOR_AGGREGATES_AND_TYPE_ALIASES);
        boolean bl59 = provider.flag(OCCompilerFeatures.Feature.CXX_PROHIBIT_AGGREGATES_WITH_USER_DECLARED_CONSTRUCTORS);
        boolean bl60 = provider.flag(OCCompilerFeatures.Feature.CXX_AGGREGATE_PAREN_INIT);
        boolean bl61 = provider.flag(OCCompilerFeatures.Feature.CXX_RANGE_FOR_INITIALIZERS);
        boolean bl62 = provider.flag(OCCompilerFeatures.Feature.CXX_BUILTIN_CHAR8);
        boolean bl63 = provider.flag(OCCompilerFeatures.Feature.CXX_CONCEPTS);
        boolean bl64 = provider.flag(OCCompilerFeatures.Feature.CXX_CPP_20_STRUCTURED_BINDINGS);
        boolean bl65 = provider.flag(OCCompilerFeatures.Feature.CXX_CPP_20_TEMPLATE_FUNCTIONS_DISAMBIGUATION);
        boolean bl66 = provider.flag(OCCompilerFeatures.Feature.CXX_EXPLICIT_THIS_PARAMETER);
        boolean bl67 = provider.flag(OCCompilerFeatures.Feature.EXPERIMENTAL_LIBRARY);
        boolean bl68 = provider.shouldCheckNarrowing();
        return new RadLanguageDialect(bl, bl2, bl3, bl4, msExtensions, gnuExtensions, gnuCompatible, bl5, clangExtensions, bl6, bl7, bl8, bl9, bl10, bl12, bl11, underlyingSizeType, s, s2, underlyingNullType, radLockFreeType, bl13, bl14, bl15, bl16, bl17, bl18, bl19, bl20, bl21, bl22, bl23, bl24, bl25, bl26, bl27, bl28, bl29, bl30, bl31, bl32, bl33, bl34, bl35, bl36, bl37, bl38, bl39, bl40, bl41, bl42, bl43, bl44, bl45, bl46, bl47, bl48, bl49, bl50, bl51, bl52, bl53, bl54, bl55, bl56, bl57, bl58, bl59, bl60, bl61, bl62, hasCoroutines, bl63, bl64, bl65, bl66, supportedTypeTraits, bl67, bl68);
    }

    private final RadSizeTUnderlyingType getUnderlyingSizeType(RadSizeTUnderlyingType sizeType, RadTargetArchitecture targetArchitecture, boolean msExtensions) {
        RadSizeTUnderlyingType radSizeTUnderlyingType = sizeType;
        if (radSizeTUnderlyingType == null) {
            radSizeTUnderlyingType = this.getUnderlyingSizeTypeFromArch(targetArchitecture, msExtensions);
        }
        return radSizeTUnderlyingType;
    }

    private final RadSizeTUnderlyingType getUnderlyingSizeTypeFromArch(RadTargetArchitecture targetArchitecture, boolean msExtensions) {
        return switch (WhenMappings.$EnumSwitchMapping$0[targetArchitecture.ordinal()]) {
            case 1 -> RadSizeTUnderlyingType.UNSIGNED;
            case 2 -> {
                if (msExtensions) {
                    yield RadSizeTUnderlyingType.UNSIGNED_LONGLONG;
                }
                yield RadSizeTUnderlyingType.UNSIGNED_LONG;
            }
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private final RadLanguageStandard languageStandard(OCLanguageStandard standard) {
        return switch (WhenMappings.$EnumSwitchMapping$1[standard.ordinal()]) {
            case 1 -> RadLanguageStandard.Cpp98;
            case 2 -> RadLanguageStandard.Cpp11;
            case 3 -> RadLanguageStandard.Cpp14;
            case 4 -> RadLanguageStandard.Cpp17;
            case 5 -> RadLanguageStandard.Cpp20;
            case 6 -> RadLanguageStandard.Cpp23;
            case 7 -> RadLanguageStandard.C89;
            case 8 -> RadLanguageStandard.C99;
            case 9 -> RadLanguageStandard.C11;
            case 10 -> RadLanguageStandard.C17;
            case 11 -> RadLanguageStandard.C23;
            case 12 -> RadLanguageStandard.Cpp26;
            default -> null;
        };
    }

    private static final boolean getProjectSnapshot$lambda$1$lambda$0(HashMap $sources, LanguageUtils $languageUtils, RadProjectSnapshotBuilder this$0, Project $project, RadToolsetSettings $fallback, HashMap $weakSources, Ref.IntRef $totalFiles, VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (!file.isDirectory()) {
            RadSourceFileSettings sourceSettings;
            if (!$sources.containsKey(file) && $languageUtils.isSupportedFile(file) && (sourceSettings = this$0.getSourceSettings(file, $project, true, $fallback)) != null) {
                $weakSources.put(file, sourceSettings);
            }
            int n = $totalFiles.element;
            $totalFiles.element = n + 1;
        }
        return true;
    }

    private static final RadToolsetSettings getToolsetSettingsForLanguageKind$lambda$5(Function1 $tmp0, Object p0) {
        return (RadToolsetSettings)$tmp0.invoke(p0);
    }

    private static final DependenciesPaths convertSettings$lambda$6(Function1 $tmp0, Object p0) {
        return (DependenciesPaths)$tmp0.invoke(p0);
    }

    private static final ExtractedPreprocessorInfo convertSettings$lambda$8(Function1 $tmp0, Object p0) {
        return (ExtractedPreprocessorInfo)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ DependenciesPaths access$extractDependenciesPaths(RadProjectSnapshotBuilder $this, List inputHeadersSearchPaths) {
        return $this.extractDependenciesPaths(inputHeadersSearchPaths);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(RadProjectSnapshotBuilder.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        RadProjectSnapshotBuilder.logger = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\nJ\u001c\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/cidr/radler/projectmodel/RadProjectSnapshotBuilder$Companion;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "getProjectSourceFiles", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "configurations", "", "Lcom/jetbrains/cidr/lang/workspace/OCResolveConfiguration;", "intellij.rider.plugins.clion.radler"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Set<VirtualFile> getProjectSourceFiles(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            List list = OCWorkspace.getInstance((Project)project).getConfigurations();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getConfigurations(...)");
            List configurations = list;
            return this.getProjectSourceFiles(configurations);
        }

        private final Set<VirtualFile> getProjectSourceFiles(List<? extends OCResolveConfiguration> configurations) {
            HashSet sourceFiles = new HashSet();
            for (OCResolveConfiguration oCResolveConfiguration : configurations) {
                sourceFiles.addAll(oCResolveConfiguration.getSources());
            }
            return sourceFiles;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B#\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u000f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J)\u0010\r\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0004H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\t\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/cidr/radler/projectmodel/RadProjectSnapshotBuilder$DependenciesPaths;", "", "includePaths", "", "", "frameworkPaths", "<init>", "(Ljava/util/List;Ljava/util/List;)V", "getIncludePaths", "()Ljava/util/List;", "getFrameworkPaths", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.rider.plugins.clion.radler"})
    public static final class DependenciesPaths {
        @NotNull
        private final List<String> includePaths;
        @NotNull
        private final List<String> frameworkPaths;

        public DependenciesPaths(@NotNull List<String> includePaths, @NotNull List<String> frameworkPaths) {
            Intrinsics.checkNotNullParameter(includePaths, (String)"includePaths");
            Intrinsics.checkNotNullParameter(frameworkPaths, (String)"frameworkPaths");
            this.includePaths = includePaths;
            this.frameworkPaths = frameworkPaths;
        }

        @NotNull
        public final List<String> getIncludePaths() {
            return this.includePaths;
        }

        @NotNull
        public final List<String> getFrameworkPaths() {
            return this.frameworkPaths;
        }

        @NotNull
        public final List<String> component1() {
            return this.includePaths;
        }

        @NotNull
        public final List<String> component2() {
            return this.frameworkPaths;
        }

        @NotNull
        public final DependenciesPaths copy(@NotNull List<String> includePaths, @NotNull List<String> frameworkPaths) {
            Intrinsics.checkNotNullParameter(includePaths, (String)"includePaths");
            Intrinsics.checkNotNullParameter(frameworkPaths, (String)"frameworkPaths");
            return new DependenciesPaths(includePaths, frameworkPaths);
        }

        public static /* synthetic */ DependenciesPaths copy$default(DependenciesPaths dependenciesPaths, List list, List list2, int n, Object object) {
            if ((n & 1) != 0) {
                list = dependenciesPaths.includePaths;
            }
            if ((n & 2) != 0) {
                list2 = dependenciesPaths.frameworkPaths;
            }
            return dependenciesPaths.copy(list, list2);
        }

        @NotNull
        public String toString() {
            return "DependenciesPaths(includePaths=" + this.includePaths + ", frameworkPaths=" + this.frameworkPaths + ")";
        }

        public int hashCode() {
            int result2 = ((Object)this.includePaths).hashCode();
            result2 = result2 * 31 + ((Object)this.frameworkPaths).hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof DependenciesPaths)) {
                return false;
            }
            DependenciesPaths dependenciesPaths = (DependenciesPaths)other;
            if (!Intrinsics.areEqual(this.includePaths, dependenciesPaths.includePaths)) {
                return false;
            }
            return Intrinsics.areEqual(this.frameworkPaths, dependenciesPaths.frameworkPaths);
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[RadTargetArchitecture.values().length];
            try {
                nArray[RadTargetArchitecture.X86.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RadTargetArchitecture.AMD64.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[OCLanguageStandard.values().length];
            try {
                nArray[OCLanguageStandard.CPP98.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OCLanguageStandard.CPP11.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OCLanguageStandard.CPP14.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OCLanguageStandard.CPP17.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OCLanguageStandard.CPP20.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OCLanguageStandard.CPP23.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OCLanguageStandard.C89.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OCLanguageStandard.C99.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OCLanguageStandard.C11.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OCLanguageStandard.C17.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OCLanguageStandard.C23.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OCLanguageStandard.CPP26.ordinal()] = 12;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

