/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider;

import com.intellij.execution.configurations.PathEnvironmentVariableUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.NioPathUtil;
import com.intellij.util.text.StringKt;
import com.jetbrains.rider.NetCoreUtil;
import com.jetbrains.rider.RiderEnvironment;
import com.jetbrains.rider.infrastructure.DotNetSdkCmd;
import java.io.File;
import java.nio.file.Path;
import kotlin.Deprecated;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u001aB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u0005H\u0002J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0006\u001a\u00020\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\tR\u001b\u0010\f\u001a\u00020\r8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\u000b\u001a\u0004\b\f\u0010\u000eR\u0017\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00050\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001b"}, d2={"Lcom/jetbrains/rider/NetCoreRuntime;", "", "<init>", "()V", "BACKEND_RUNTIME_PATH_PROPERTY", "", "usedRuntime", "Lcom/jetbrains/rider/NetCoreRuntime$UsedRuntime;", "getUsedRuntime", "()Lcom/jetbrains/rider/NetCoreRuntime$UsedRuntime;", "usedRuntime$delegate", "Lkotlin/Lazy;", "isUsingBundledRuntimeForBackend", "", "()Z", "isUsingBundledRuntimeForBackend$delegate", "cliPath", "Lkotlin/Lazy;", "getCliPath", "()Lkotlin/Lazy;", "getBundledDotnetCoreRuntime", "platform", "getRealIdOfBootstrappedProcess", "", "process", "Ljava/lang/Process;", "UsedRuntime", "intellij.rider.rdclient.dotnet"})
@SourceDebugExtension(value={"SMAP\nRiderEnvironment.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RiderEnvironment.kt\ncom/jetbrains/rider/NetCoreRuntime\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,896:1\n24#2:897\n*S KotlinDebug\n*F\n+ 1 RiderEnvironment.kt\ncom/jetbrains/rider/NetCoreRuntime\n*L\n702#1:897\n*E\n"})
public final class NetCoreRuntime {
    @NotNull
    public static final NetCoreRuntime INSTANCE = new NetCoreRuntime();
    @NotNull
    public static final String BACKEND_RUNTIME_PATH_PROPERTY = "rider.backend.dotnet.runtime.path";
    @NotNull
    private static final Lazy usedRuntime$delegate = LazyKt.lazy(NetCoreRuntime::usedRuntime_delegate$lambda$0);
    @NotNull
    private static final Lazy isUsingBundledRuntimeForBackend$delegate = LazyKt.lazy(NetCoreRuntime::isUsingBundledRuntimeForBackend_delegate$lambda$1);
    @NotNull
    private static final Lazy<String> cliPath = LazyKt.lazy(NetCoreRuntime::cliPath$lambda$2);

    private NetCoreRuntime() {
    }

    private final UsedRuntime getUsedRuntime() {
        Lazy lazy = usedRuntime$delegate;
        return (UsedRuntime)lazy.getValue();
    }

    public final boolean isUsingBundledRuntimeForBackend() {
        Lazy lazy = isUsingBundledRuntimeForBackend$delegate;
        return (Boolean)lazy.getValue();
    }

    @NotNull
    public final Lazy<String> getCliPath() {
        return cliPath;
    }

    private final UsedRuntime getBundledDotnetCoreRuntime(String platform) {
        Path explicitRuntime;
        NetCoreRuntime $this$thisLogger$iv = this;
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(NetCoreRuntime.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        Logger logger2 = logger;
        String string = System.getProperty(BACKEND_RUNTIME_PATH_PROPERTY);
        Path path = string != null && (string = StringKt.nullize$default((String)string, (boolean)false, (int)1, null)) != null ? NioPathUtil.toNioPathOrNull((String)string) : (explicitRuntime = null);
        if (explicitRuntime != null) {
            logger2.info("Loading runtime explicitly passed via rider.backend.dotnet.runtime.path: \"" + explicitRuntime + "\".");
            return new UsedRuntime(DotNetSdkCmd.getExecutable$default(explicitRuntime, null, 2, null), false);
        }
        String relativePath = platform + "/dotnet/" + (SystemInfo.isWindows ? "dotnet.exe" : "dotnet");
        File result2 = RiderEnvironment.getBundledFileOrNull$default(RiderEnvironment.INSTANCE, relativePath, false, null, 6, null);
        if (result2 != null) {
            Path path2 = result2.getCanonicalFile().toPath();
            logger2.info("Loading bundled runtime from path \"" + path2 + "\".");
            Intrinsics.checkNotNull((Object)path2);
            return new UsedRuntime(path2, true);
        }
        File bundledRuntimeScript = RiderEnvironment.getBundledFileOrNull$default(RiderEnvironment.INSTANCE, "dotnet-sdk.cmd", false, null, 6, null);
        if (bundledRuntimeScript != null) {
            Path path3 = bundledRuntimeScript.getCanonicalFile().toPath();
            logger2.info("Loading bundled runtime bootstrap script from path \"" + path3 + "\".");
            Intrinsics.checkNotNull((Object)path3);
            return new UsedRuntime(DotNetSdkCmd.getExecutable$default(path3, null, 2, null), false);
        }
        logger2.info("Bundled .NET runtime was not found, and system property rider.backend.dotnet.runtime.path is not defined. Executing fallback logic.");
        File runtimeFromPath = PathEnvironmentVariableUtil.findExecutableInPathOnAnyOS((String)"dotnet");
        if (runtimeFromPath != null) {
            Path path4 = runtimeFromPath.getCanonicalFile().toPath();
            logger2.info("Loading runtime found in the PATH environment variable: \"" + path4 + "\".");
            Intrinsics.checkNotNull((Object)path4);
            return new UsedRuntime(path4, false);
        }
        throw new IllegalStateException("Cannot find .NET runtime to run Rider backend. Please make sure the Rider installation is not damaged, or pass the full path to the \"dotnet\" executable via rider.backend.dotnet.runtime.path system property.".toString());
    }

    @Deprecated(message="Use pid() directly", replaceWith=@ReplaceWith(expression="process.pid()", imports={}))
    public final long getRealIdOfBootstrappedProcess(@NotNull Process process) {
        Intrinsics.checkNotNullParameter((Object)process, (String)"process");
        return process.pid();
    }

    private static final UsedRuntime usedRuntime_delegate$lambda$0() {
        return INSTANCE.getBundledDotnetCoreRuntime(NetCoreUtil.INSTANCE.getPlatformId());
    }

    private static final boolean isUsingBundledRuntimeForBackend_delegate$lambda$1() {
        return INSTANCE.getUsedRuntime().isBundled();
    }

    private static final String cliPath$lambda$2() {
        return ((Object)INSTANCE.getUsedRuntime().getExecutable().toAbsolutePath()).toString();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/rider/NetCoreRuntime$UsedRuntime;", "", "executable", "Ljava/nio/file/Path;", "isBundled", "", "<init>", "(Ljava/nio/file/Path;Z)V", "getExecutable", "()Ljava/nio/file/Path;", "()Z", "intellij.rider.rdclient.dotnet"})
    private static final class UsedRuntime {
        @NotNull
        private final Path executable;
        private final boolean isBundled;

        public UsedRuntime(@NotNull Path executable, boolean isBundled) {
            Intrinsics.checkNotNullParameter((Object)executable, (String)"executable");
            this.executable = executable;
            this.isBundled = isBundled;
        }

        @NotNull
        public final Path getExecutable() {
            return this.executable;
        }

        public final boolean isBundled() {
            return this.isBundled;
        }
    }
}

