/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.completion;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeWithMe.ClientId;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageExtension;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.patterns.ElementPattern;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilCore;
import com.jetbrains.rdclient.RiderOnly;
import com.jetbrains.rider.completion.ICompletionHelper;
import com.jetbrains.rider.completion.PreemptiveCompletionSuppressor;
import com.jetbrains.rider.completion.ProtocolCompletionContributor;
import com.jetbrains.rider.completion.patchEngine.RiderPatchEngineCompletionContributor;
import com.jetbrains.rider.editors.PlatformTextControlUtilsKt;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@RiderOnly
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0017\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J.\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\rH\u0016J.\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\rH\u0016J\u001c\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\b\b\u0002\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0017H\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/jetbrains/rider/completion/ClientCompletionSupport;", "", "<init>", "()V", "HELPERS", "Lcom/intellij/lang/LanguageExtension;", "Lcom/jetbrains/rider/completion/ICompletionHelper;", "getIdentifierStart", "Lcom/intellij/patterns/ElementPattern;", "", "element", "Lcom/intellij/psi/PsiElement;", "offset", "", "document", "Lcom/intellij/openapi/editor/Document;", "completionOffset", "getIdentifierPart", "backendCompletionEnabled", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "preemptiveCompletionEnabled", "backendCompletionEnabledInFile", "Companion", "intellij.rider.rdclient.dotnet"})
@SourceDebugExtension(value={"SMAP\nClientCompletionSupport.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClientCompletionSupport.kt\ncom/jetbrains/rider/completion/ClientCompletionSupport\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,87:1\n1761#2,3:88\n1761#2,3:91\n1761#2,3:94\n*S KotlinDebug\n*F\n+ 1 ClientCompletionSupport.kt\ncom/jetbrains/rider/completion/ClientCompletionSupport\n*L\n61#1:88,3\n66#1:91,3\n79#1:94,3\n*E\n"})
public class ClientCompletionSupport {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final LanguageExtension<ICompletionHelper> HELPERS = new LanguageExtension("com.intellij.frontend.completion.helper");

    @NotNull
    public ElementPattern<Character> getIdentifierStart(@NotNull PsiElement element, int offset, @NotNull Document document, int completionOffset) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        for (ICompletionHelper helper : this.HELPERS.allForLanguageOrAny(element.getLanguage())) {
            ElementPattern<Character> pattern = helper.getIdentifierStart(offset, document, element, completionOffset);
            if (pattern == null) continue;
            return pattern;
        }
        throw new IllegalStateException("no suitable completion helper was found!".toString());
    }

    @NotNull
    public ElementPattern<Character> getIdentifierPart(@NotNull PsiElement element, int offset, @NotNull Document document, int completionOffset) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        for (ICompletionHelper helper : this.HELPERS.allForLanguageOrAny(element.getLanguage())) {
            ElementPattern<Character> pattern = helper.getIdentifierPart(offset, document, element, completionOffset);
            if (pattern == null) continue;
            return pattern;
        }
        throw new IllegalStateException("no suitable completion helper was found!".toString());
    }

    public boolean backendCompletionEnabled(@Nullable Editor editor, int offset) {
        if (editor == null) {
            return false;
        }
        Project project = editor.getProject();
        if (project == null) {
            return false;
        }
        Project project2 = project;
        Document document = editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        Document document2 = document;
        PsiFile psiFile2 = PsiDocumentManager.getInstance((Project)project2).getPsiFile(document2);
        if (psiFile2 == null) {
            return false;
        }
        PsiFile psiFile3 = psiFile2;
        return this.backendCompletionEnabled(psiFile3, offset);
    }

    public static /* synthetic */ boolean backendCompletionEnabled$default(ClientCompletionSupport clientCompletionSupport, Editor editor, int n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: backendCompletionEnabled");
        }
        if ((n2 & 2) != 0) {
            Editor editor2 = editor;
            n = editor2 != null ? PlatformTextControlUtilsKt.getStartOffset(editor2) : 0;
        }
        return clientCompletionSupport.backendCompletionEnabled(editor, n);
    }

    public boolean backendCompletionEnabled(@NotNull PsiFile file, int offset) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Language language = PsiUtilCore.getLanguageAtOffset((PsiFile)file, (int)offset);
            Intrinsics.checkNotNullExpressionValue((Object)language, (String)"getLanguageAtOffset(...)");
            Language language2 = language;
            List list = CompletionContributor.forLanguage((Language)language2);
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"forLanguage(...)");
            Iterable $this$any$iv = list;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    CompletionContributor it = (CompletionContributor)element$iv;
                    boolean bl2 = false;
                    if (!(it instanceof ProtocolCompletionContributor && ((ProtocolCompletionContributor)it).isAvailable(file, offset))) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean preemptiveCompletionEnabled(@NotNull PsiFile file, int offset) {
        CompletionContributor it;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Language language = PsiUtilCore.getLanguageAtOffset((PsiFile)file, (int)offset);
        Intrinsics.checkNotNullExpressionValue((Object)language, (String)"getLanguageAtOffset(...)");
        Language language2 = language;
        List list = CompletionContributor.forLanguage((Language)language2);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"forLanguage(...)");
        Iterable $this$any$iv = list;
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator = $this$any$iv.iterator();
        do {
            if (!iterator.hasNext()) return false;
            Object element$iv = iterator.next();
            it = (CompletionContributor)element$iv;
            boolean bl = false;
        } while (!(it instanceof ProtocolCompletionContributor && ((ProtocolCompletionContributor)it).isAvailable(file, offset) && ((ProtocolCompletionContributor)it).isPreemptive()));
        boolean bl = true;
        if (!bl) return false;
        Project project = file.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        if (PreemptiveCompletionSuppressor.Companion.shouldSuppressPreemptiveCompletion(project)) return false;
        return true;
    }

    public boolean backendCompletionEnabledInFile(@NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Set set = file.getViewProvider().getLanguages();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getLanguages(...)");
        Set languages = set;
        for (Language language : languages) {
            boolean bl;
            block4: {
                List contributors;
                Intrinsics.checkNotNullExpressionValue((Object)CompletionContributor.forLanguage((Language)language), (String)"forLanguage(...)");
                Iterable $this$any$iv = contributors;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        CompletionContributor it = (CompletionContributor)element$iv;
                        boolean bl2 = false;
                        if (!(it instanceof ProtocolCompletionContributor && ((ProtocolCompletionContributor)it).isAvailable(file, 0) || it instanceof RiderPatchEngineCompletionContributor && ((RiderPatchEngineCompletionContributor)it).isAvailable(file, 0))) continue;
                        bl = true;
                        break block4;
                    }
                    bl = false;
                }
            }
            if (!bl) continue;
            return true;
        }
        return false;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/rider/completion/ClientCompletionSupport$Companion;", "", "<init>", "()V", "getInstance", "Lcom/jetbrains/rider/completion/ClientCompletionSupport;", "intellij.rider.rdclient.dotnet"})
    @SourceDebugExtension(value={"SMAP\nClientCompletionSupport.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClientCompletionSupport.kt\ncom/jetbrains/rider/completion/ClientCompletionSupport$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,87:1\n40#2,3:88\n*S KotlinDebug\n*F\n+ 1 ClientCompletionSupport.kt\ncom/jetbrains/rider/completion/ClientCompletionSupport$Companion\n*L\n20#1:88,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ClientCompletionSupport getInstance() {
            boolean $i$f$service = false;
            Class<ClientCompletionSupport> serviceClass$iv = ClientCompletionSupport.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            return (ClientCompletionSupport)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

