/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.completion;

import com.intellij.codeInsight.lookup.Lookup;
import com.intellij.codeInsight.lookup.LookupListener;
import com.intellij.codeInsight.lookup.LookupManagerListener;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.codeInsight.lookup.impl.PrefixChangeListener;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.rd.LifetimeDisposableExKt;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.TextRange;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.RLifetimeKt;
import com.jetbrains.rdclient.daemon.util.HighlightersUtilKt;
import com.jetbrains.rdclient.patches.PatchEngineRegistryKt;
import com.jetbrains.rdclient.services.IdeBackend;
import com.jetbrains.rdclient.util.idea.DocumentUtilKt;
import com.jetbrains.rdclient.util.idea.EditorUtilKt;
import com.jetbrains.rider.completion.AutoPopupBackendSupportPolicy;
import com.jetbrains.rider.completion.FrontendCompletionHost;
import com.jetbrains.rider.completion.FrontendCompletionHostKt;
import com.jetbrains.rider.completion.QuickDocLookupListener;
import com.jetbrains.rider.editorActions.ITypingSessions;
import com.jetbrains.rider.editorActions.TypingSessions;
import com.jetbrains.rider.services.RiderDefaultBackend;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001c\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u000bH\u0016J\u0018\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/rider/completion/FrontendLookupListener;", "Lcom/intellij/codeInsight/lookup/LookupManagerListener;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "activeLookupChanged", "", "oldLookup", "Lcom/intellij/codeInsight/lookup/Lookup;", "newLookup", "handleBackendLookupShown", "lookup", "Lcom/intellij/codeInsight/lookup/impl/LookupImpl;", "backend", "Lcom/jetbrains/rdclient/services/IdeBackend;", "Companion", "intellij.rider.rdclient.dotnet"})
@SourceDebugExtension(value={"SMAP\nFrontendLookupListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrontendLookupListener.kt\ncom/jetbrains/rider/completion/FrontendLookupListener\n+ 2 Logger.kt\ncom/jetbrains/rd/platform/util/LoggerKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,111:1\n13#2:112\n14#3:113\n*S KotlinDebug\n*F\n+ 1 FrontendLookupListener.kt\ncom/jetbrains/rider/completion/FrontendLookupListener\n*L\n29#1:112\n29#1:113\n*E\n"})
public abstract class FrontendLookupListener
implements LookupManagerListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private static final Logger logger;

    public FrontendLookupListener(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public void activeLookupChanged(@Nullable Lookup oldLookup, @Nullable Lookup newLookup) {
        LookupImpl lookupImpl = (LookupImpl)newLookup;
        if (lookupImpl == null) {
            return;
        }
        LookupImpl lookup = lookupImpl;
        if (this.project.isDefault()) {
            return;
        }
        Editor editor = lookup.getEditor();
        Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"getEditor(...)");
        Editor editor2 = editor;
        IdeBackend backend = IdeBackend.Companion.getInstance(this.project);
        if (backend.isCompletionEnabled(editor2)) {
            this.handleBackendLookupShown(lookup, backend);
        }
    }

    protected void handleBackendLookupShown(@NotNull LookupImpl lookup, @NotNull IdeBackend backend) {
        Intrinsics.checkNotNullParameter((Object)lookup, (String)"lookup");
        Intrinsics.checkNotNullParameter((Object)backend, (String)"backend");
        logger.trace("handle backend lookup shown...");
        Editor editor = lookup.getEditor();
        Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"getEditor(...)");
        Editor editor2 = editor;
        Document document = editor2.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        Document document2 = document;
        Lifetime lifetime = LifetimeDisposableExKt.defineNestedLifetime((Disposable)((Disposable)lookup)).getLifetime();
        if (RLifetimeKt.isAlive((Lifetime)lifetime)) {
            document2.addDocumentListener(new DocumentListener(lifetime, editor2){
                final /* synthetic */ Lifetime $lifetime;
                final /* synthetic */ Editor $editor;
                {
                    this.$lifetime = $lifetime;
                    this.$editor = $editor;
                }

                public void documentChanged(DocumentEvent event) {
                    Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                    if (!RLifetimeKt.isAlive((Lifetime)this.$lifetime)) {
                        return;
                    }
                    if (event.getDocument().isInBulkUpdate()) {
                        FrontendLookupListener.Companion.getLogger().trace("Skip vanishing highlighters during bulk update. Event : " + event);
                        return;
                    }
                    TextRange textRange = TextRange.from((int)event.getOffset(), (int)event.getNewLength());
                    Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"from(...)");
                    TextRange range = textRange;
                    HighlightersUtilKt.vanishHighlighters((Lifetime)this.$lifetime, (TextRange)range, (Editor)this.$editor);
                }

                public void beforeDocumentChange(DocumentEvent event) {
                    Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                }
            }, LifetimeDisposableExKt.createNestedDisposable$default((Lifetime)lifetime, null, (int)1, null));
            lookup.addLookupListener((LookupListener)new QuickDocLookupListener(lifetime, lookup));
        }
        RiderDefaultBackend cfr_ignored_0 = (RiderDefaultBackend)backend;
        if (PatchEngineRegistryKt.isTypingSessionEnabled() && ((RiderDefaultBackend)backend).getTypedHandler(editor2, editor2.getCaretModel().getOffset()) != null && TypingSessions.Companion.isEnabled(this.project)) {
            ITypingSessions typingSessions = TypingSessions.Companion.getInstance(this.project);
            if (EditorUtilKt.hasMultipleEditPoints((Editor)editor2)) {
                if (typingSessions.hasActiveSession()) {
                    logger.error("There are multiple edit points, but typing session doesn't support this mode.");
                    typingSessions.forceCloseActiveSession("multiple edit points is not supported");
                }
            } else {
                lookup.addPrefixChangeListener(new PrefixChangeListener(typingSessions, editor2, this, lookup){
                    private Disposable tracker;
                    final /* synthetic */ ITypingSessions $typingSessions;
                    final /* synthetic */ Editor $editor;
                    final /* synthetic */ FrontendLookupListener this$0;
                    final /* synthetic */ LookupImpl $lookup;
                    {
                        this.$typingSessions = $typingSessions;
                        this.$editor = $editor;
                        this.this$0 = $receiver;
                        this.$lookup = $lookup;
                    }

                    public void beforeAppend(char c) {
                        this.tracker = this.$typingSessions.typeCharCookie(c, this.$editor, this.this$0.getProject());
                        Disposable disposable = (Disposable)this.$lookup;
                        Disposable disposable2 = this.tracker;
                        Intrinsics.checkNotNull((Object)disposable2);
                        Disposer.register((Disposable)disposable, (Disposable)disposable2);
                    }

                    public void afterAppend(char c) {
                        Disposable t = this.tracker;
                        this.tracker = null;
                        Disposable disposable = t;
                        Intrinsics.checkNotNull((Object)disposable);
                        Disposer.dispose((Disposable)disposable);
                    }
                }, (Disposable)lookup);
            }
        }
        Language language = DocumentUtilKt.getLanguage((Editor)editor2);
        if (language == null) {
            return;
        }
        Language language2 = language;
        boolean autopopupTrustsBackend = ((RiderDefaultBackend)backend).getAutoPopupBackendSupportPolicy(language2) == AutoPopupBackendSupportPolicy.TRUST_BACKEND;
        FrontendCompletionHost completionHost = FrontendCompletionHost.Companion.getInstance(this.project);
        if (FrontendCompletionHostKt.getCompletionStateData(editor2).getHasSession()) {
            completionHost.onCurrentSessionTerminated(editor2, (Function0<Unit>)((Function0)() -> FrontendLookupListener.handleBackendLookupShown$lambda$0(editor2, lookup, autopopupTrustsBackend)));
        }
    }

    private static final Unit handleBackendLookupShown$lambda$0(Editor $editor, LookupImpl $lookup, boolean $autopopupTrustsBackend) {
        if (!EditorUtilKt.hasMultipleEditPoints((Editor)$editor) && $lookup.getItems().isEmpty() && $autopopupTrustsBackend) {
            logger.trace("hiding lookup due to session termination");
            $lookup.hideLookup(false);
        }
        return Unit.INSTANCE;
    }

    static {
        boolean $i$f$getLogger = false;
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(FrontendLookupListener.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        FrontendLookupListener.logger = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rider/completion/FrontendLookupListener$Companion;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "getLogger", "()Lcom/intellij/openapi/diagnostic/Logger;", "intellij.rider.rdclient.dotnet"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLogger() {
            return logger;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

