/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.completion.patchEngine;

import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.completion.CompletionPhase;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.impl.CompletionServiceImpl;
import com.intellij.codeInsight.lookup.Lookup;
import com.intellij.codeInsight.lookup.LookupEvent;
import com.intellij.codeInsight.lookup.LookupEx;
import com.intellij.codeInsight.lookup.LookupListener;
import com.intellij.codeInsight.lookup.LookupManagerListener;
import com.intellij.codeInsight.lookup.impl.LookupManagerImpl;
import com.intellij.lang.Language;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.Topic;
import com.jetbrains.ide.model.uiautomation.ComponentId;
import com.jetbrains.rd.ide.editor.EditorSynchronizer;
import com.jetbrains.rd.ide.model.CompletionMode;
import com.jetbrains.rd.ide.model.CompletionPopupRequestData;
import com.jetbrains.rd.ide.model.EditorComponentId;
import com.jetbrains.rd.ide.model.RdAbstractEditorVersion;
import com.jetbrains.rd.ide.model.RdProjectId;
import com.jetbrains.rd.ide.model.TextControlId;
import com.jetbrains.rd.platform.ProjectUtilKt;
import com.jetbrains.rd.platform.util.ListenersKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.LifetimeDefinition;
import com.jetbrains.rdclient.document.DocumentExKt;
import com.jetbrains.rdclient.editors.FrontendTextControlHostKt;
import com.jetbrains.rdclient.util.idea.DocumentUtilKt;
import com.jetbrains.rider.completion.FrontendAutoPopupHost;
import com.jetbrains.rider.completion.patchEngine.RiderPatchEngineAutoPopupHost;
import com.jetbrains.rider.completion.patchEngine.RiderPatchEngineAutoPopupStatisticsHolder;
import com.jetbrains.rider.editors.statistic.RiderCompletionStatisticCollector;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J \u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u00a8\u0006\u0012"}, d2={"Lcom/jetbrains/rider/completion/patchEngine/RiderPatchEngineAutoPopupHost;", "Lcom/jetbrains/rdclient/completion/FrontendAutoPopupHost;", "<init>", "()V", "autoPopupRequested", "", "componentId", "Lcom/jetbrains/ide/model/uiautomation/ComponentId;", "data", "Lcom/jetbrains/rd/ide/model/CompletionPopupRequestData;", "registerStatisticsListener", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "statisticLifetimeDefinition", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "Companion", "intellij.rider.rdclient.dotnet"})
@SourceDebugExtension(value={"SMAP\nRiderPatchEngineAutoPopupHost.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RiderPatchEngineAutoPopupHost.kt\ncom/jetbrains/rider/completion/patchEngine/RiderPatchEngineAutoPopupHost\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,137:1\n68#2,4:138\n68#2,4:142\n68#2,4:146\n14#2:150\n*S KotlinDebug\n*F\n+ 1 RiderPatchEngineAutoPopupHost.kt\ncom/jetbrains/rider/completion/patchEngine/RiderPatchEngineAutoPopupHost\n*L\n39#1:138,4\n79#1:142,4\n84#1:146,4\n35#1:150\n*E\n"})
public class RiderPatchEngineAutoPopupHost
extends com.jetbrains.rdclient.completion.FrontendAutoPopupHost {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger logger;

    public void autoPopupRequested(@NotNull ComponentId componentId, @NotNull CompletionPopupRequestData data2) {
        boolean isNotExpired;
        Logger logger;
        Intrinsics.checkNotNullParameter((Object)componentId, (String)"componentId");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        Logger $this$trace$iv = RiderPatchEngineAutoPopupHost.logger;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("New auto popup request " + data2);
        }
        if (!data2.getShouldBeShown()) {
            return;
        }
        TextControlId editorId = ((EditorComponentId)componentId).getTextControlId();
        Editor editor = FrontendTextControlHostKt.toEditorOrNull((TextControlId)editorId);
        if (editor == null) {
            RiderPatchEngineAutoPopupHost.logger.info("Auto popup request can not be applied for editor id " + editorId + ": editor not found");
            return;
        }
        EditorSynchronizer editorSynchronizer = DocumentExKt.getEditorSynchronizer((Editor)editor);
        if (editorSynchronizer == null) {
            RiderPatchEngineAutoPopupHost.logger.info("Auto popup request can not be applied for editor id " + editorId + ": editor synchronizer not found");
            return;
        }
        LookupEx currentLookup = LookupManagerImpl.Companion.getActiveLookup(editor);
        Class[] classArray = new Class[]{CompletionPhase.BgCalculation.class, CompletionPhase.ItemsCalculated.class};
        boolean isActivePhase = CompletionServiceImpl.Companion.isPhase(classArray);
        CompletionPhase completionPhase = CompletionServiceImpl.Companion.getCompletionPhase();
        CompletionPhase.CommittingDocuments committingDocuments = completionPhase instanceof CompletionPhase.CommittingDocuments ? (CompletionPhase.CommittingDocuments)completionPhase : null;
        boolean bl = isNotExpired = !(committingDocuments != null ? committingDocuments.isExpired() : false);
        if ((currentLookup != null || isActivePhase) && isNotExpired) {
            return;
        }
        Boolean forceSoft = data2.getForceSoft();
        if (forceSoft != null) {
            FrontendAutoPopupHost.AutoPopupState autoPopupState = FrontendAutoPopupHost.Companion.getAutoPopupState(editor);
            if (autoPopupState != null) {
                autoPopupState.setNextLookupSoft(forceSoft);
            }
        }
        Project project = ProjectUtilKt.toProject((RdProjectId)data2.getProjectId());
        PsiUtilBase.assertEditorAndProjectConsistent((Project)project, (Editor)editor);
        CompletionType completionType = switch (WhenMappings.$EnumSwitchMapping$0[data2.getMode().ordinal()]) {
            case 1 -> CompletionType.CLASS_NAME;
            case 2 -> CompletionType.SMART;
            case 3 -> CompletionType.BASIC;
            default -> throw new NoWhenBranchMatchedException();
        };
        FrontendAutoPopupHost.AutoPopupState autoPopupState = FrontendAutoPopupHost.Companion.getAutoPopupState(editor);
        if (autoPopupState != null && (autoPopupState = autoPopupState.getScheduleAutoPopupSeq()) != null) {
            autoPopupState.defineNext((arg_0, arg_1) -> RiderPatchEngineAutoPopupHost.autoPopupRequested$lambda$1(this, project, editor, arg_0, arg_1));
        }
        Logger $this$trace$iv2 = RiderPatchEngineAutoPopupHost.logger;
        boolean $i$f$trace2 = false;
        if ($this$trace$iv2.isTraceEnabled()) {
            logger = $this$trace$iv2;
            boolean bl2 = false;
            logger.trace("Scheduling auto popup for " + editor + ", " + completionType);
        }
        AutoPopupController.getInstance((Project)project).scheduleAutoPopup(editor, completionType, arg_0 -> RiderPatchEngineAutoPopupHost.autoPopupRequested$lambda$5(arg_0 -> RiderPatchEngineAutoPopupHost.autoPopupRequested$lambda$4(editorSynchronizer, data2, arg_0), arg_0));
    }

    private final void registerStatisticsListener(Project project, Editor editor, Lifetime statisticLifetimeDefinition) {
        RiderPatchEngineAutoPopupStatisticsHolder statisticsHolder = RiderPatchEngineAutoPopupStatisticsHolder.Companion.getInstance();
        EditorSynchronizer editorSynchronizer = DocumentExKt.getEditorSynchronizer((Editor)editor);
        if (!statisticsHolder.isInCurrentEditorScope(DocumentExKt.getTextControlId((Editor)editor), (RdAbstractEditorVersion)(editorSynchronizer != null ? editorSynchronizer.getVersion() : null))) {
            return;
        }
        long triggerTime = statisticsHolder.getTypeTime();
        Language language = DocumentUtilKt.getLanguage((Editor)editor);
        if (language == null) {
            return;
        }
        Language language2 = language;
        MessageBus messageBus = project.getMessageBus();
        Intrinsics.checkNotNullExpressionValue((Object)messageBus, (String)"getMessageBus(...)");
        Topic topic = LookupManagerListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        ListenersKt.subscribe((MessageBus)messageBus, (Lifetime)statisticLifetimeDefinition, (Topic)topic, (arg_0, arg_1) -> RiderPatchEngineAutoPopupHost.registerStatisticsListener$lambda$6(editor, triggerTime, project, language2, arg_0, arg_1));
    }

    private static final Unit autoPopupRequested$lambda$1(RiderPatchEngineAutoPopupHost this$0, Project $project, Editor $editor, LifetimeDefinition lifetimeDefinition, Lifetime lifetime) {
        Intrinsics.checkNotNullParameter((Object)lifetimeDefinition, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        this$0.registerStatisticsListener($project, $editor, lifetime);
        return Unit.INSTANCE;
    }

    private static final boolean autoPopupRequested$lambda$4(EditorSynchronizer $editorSynchronizer, CompletionPopupRequestData $data, PsiFile psiFile2) {
        boolean areVersionsMatch = Intrinsics.areEqual((Object)$editorSynchronizer.getVersion(), (Object)$data.getEditorVersion());
        if (!areVersionsMatch) {
            Logger $this$trace$iv = logger;
            boolean $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                Logger logger = $this$trace$iv;
                boolean bl = false;
                logger.trace("Auto popup request can not be applied. Frontend and backend editor versions are different :: frontendVersion=" + $editorSynchronizer.getVersion() + ", backendVersion=" + $data.getEditorVersion());
            }
        }
        return areVersionsMatch;
    }

    private static final boolean autoPopupRequested$lambda$5(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final void registerStatisticsListener$lambda$6(Editor $editor, long $triggerTime, Project $project, Language $language, Lookup lookup, Lookup newLookup) {
        Lookup lookup2 = newLookup;
        if (!Intrinsics.areEqual((Object)$editor, (Object)(lookup2 != null ? lookup2.getEditor() : null))) {
            return;
        }
        LookupListener statisticalLookupListener2 = new LookupListener(newLookup, $triggerTime, $project, $language){
            private final registerStatisticsListener.1.statisticalLookupListener.onLateItemAddedUiListener.1 onLateItemAddedUiListener;
            final /* synthetic */ Lookup $newLookup;
            final /* synthetic */ long $triggerTime;
            final /* synthetic */ Project $project;
            final /* synthetic */ Language $language;
            {
                this.$newLookup = $newLookup;
                this.$triggerTime = $triggerTime;
                this.$project = $project;
                this.$language = $language;
                this.onLateItemAddedUiListener = new LookupListener($newLookup, $triggerTime, $project, $language){
                    final /* synthetic */ Lookup $newLookup;
                    final /* synthetic */ long $triggerTime;
                    final /* synthetic */ Project $project;
                    final /* synthetic */ Language $language;
                    {
                        this.$newLookup = $newLookup;
                        this.$triggerTime = $triggerTime;
                        this.$project = $project;
                        this.$language = $language;
                    }

                    public void uiRefreshed() {
                        boolean lookupHasItems;
                        List list = this.$newLookup.getItems();
                        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getItems(...)");
                        boolean bl = lookupHasItems = ((Collection)list).size() > 0;
                        if (lookupHasItems) {
                            long time = TimeoutUtil.getDurationMillis((long)this.$triggerTime);
                            RiderCompletionStatisticCollector.INSTANCE.logAutoPopupShown(this.$project, this.$language, time);
                            this.$newLookup.removeLookupListener((LookupListener)this);
                        }
                    }
                };
            }

            public final registerStatisticsListener.1.statisticalLookupListener.onLateItemAddedUiListener.1 getOnLateItemAddedUiListener() {
                return this.onLateItemAddedUiListener;
            }

            public void lookupShown(LookupEvent event) {
                boolean lookupHasItems;
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                List list = this.$newLookup.getItems();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getItems(...)");
                boolean bl = lookupHasItems = ((Collection)list).size() > 0;
                if (lookupHasItems) {
                    long time = TimeoutUtil.getDurationMillis((long)this.$triggerTime);
                    RiderCompletionStatisticCollector.INSTANCE.logAutoPopupShown(this.$project, this.$language, time);
                    this.$newLookup.removeLookupListener((LookupListener)this);
                } else {
                    this.$newLookup.addLookupListener((LookupListener)this.onLateItemAddedUiListener);
                }
            }
        };
        newLookup.addLookupListener(statisticalLookupListener2);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(RiderPatchEngineAutoPopupHost.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        RiderPatchEngineAutoPopupHost.logger = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/rider/completion/patchEngine/RiderPatchEngineAutoPopupHost$Companion;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.rider.rdclient.dotnet"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[CompletionMode.values().length];
            try {
                nArray[CompletionMode.Import.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CompletionMode.Smart.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CompletionMode.Basic.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

