/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.completion.patchEngine;

import com.intellij.codeInsight.lookup.Lookup;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupEx;
import com.intellij.codeInsight.lookup.LookupFocusDegree;
import com.intellij.codeInsight.lookup.LookupListener;
import com.intellij.codeInsight.lookup.LookupManagerListener;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.jetbrains.rd.ide.model.FocusBehaviour;
import com.jetbrains.rdclient.completion.ProtocolLookupItemBase;
import com.jetbrains.rdclient.completion.UtilsKt;
import com.jetbrains.rdclient.patches.PatchEngineRegistryKt;
import com.jetbrains.rdclient.services.IdeBackend;
import com.jetbrains.rider.completion.patchEngine.RiderPatchEngineItemPresenter;
import com.jetbrains.rider.completion.patchEngine.RiderPatchEngineLookupManagerListenerKt;
import com.jetbrains.rider.completion.patchEngine.RiderPatchEngineProtocolProvider;
import com.jetbrains.rider.completion.summaryInfo.SummaryInfoTracker;
import com.jetbrains.rider.editorActions.RiderPatchEngineProtocolItem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u0007H\u0016J\u0010\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\f\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0018\u0010\r\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/rider/completion/patchEngine/RiderPatchEngineLookupManagerListener;", "Lcom/intellij/codeInsight/lookup/LookupManagerListener;", "<init>", "()V", "activeLookupChanged", "", "oldLookup", "Lcom/intellij/codeInsight/lookup/Lookup;", "newLookup", "handleLookupShown", "lookup", "Lcom/intellij/codeInsight/lookup/impl/LookupImpl;", "updateLookupFocusDegree", "calculatePresentation", "lookupItemPresenter", "Lcom/jetbrains/rider/completion/patchEngine/RiderPatchEngineItemPresenter;", "intellij.rider.rdclient.dotnet"})
@SourceDebugExtension(value={"SMAP\nRiderPatchEngineLookupManagerListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RiderPatchEngineLookupManagerListener.kt\ncom/jetbrains/rider/completion/patchEngine/RiderPatchEngineLookupManagerListener\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 4 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 6 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,110:1\n68#2,4:111\n68#2,4:119\n68#2,4:123\n68#2,4:156\n68#2,4:160\n68#2,2:164\n71#2:170\n68#2,4:172\n68#2,4:177\n30#3,2:115\n1088#4,2:117\n1617#5,9:127\n1869#5:136\n1870#5:138\n1626#5:139\n1617#5,9:140\n1869#5:149\n1870#5:151\n1626#5:152\n774#5:153\n865#5,2:154\n1788#5,4:166\n1869#5:171\n1870#5:176\n1#6:137\n1#6:150\n*S KotlinDebug\n*F\n+ 1 RiderPatchEngineLookupManagerListener.kt\ncom/jetbrains/rider/completion/patchEngine/RiderPatchEngineLookupManagerListener\n*L\n42#1:111,4\n66#1:119,4\n69#1:123,4\n78#1:156,4\n84#1:160,4\n90#1:164,2\n90#1:170\n96#1:172,4\n100#1:177,4\n46#1:115,2\n58#1:117,2\n73#1:127,9\n73#1:136\n73#1:138\n73#1:139\n75#1:140,9\n75#1:149\n75#1:151\n75#1:152\n76#1:153\n76#1:154,2\n90#1:166,4\n91#1:171\n91#1:176\n73#1:137\n75#1:150\n*E\n"})
public final class RiderPatchEngineLookupManagerListener
implements LookupManagerListener {
    public void activeLookupChanged(@Nullable Lookup oldLookup, @Nullable Lookup newLookup) {
        if (PatchEngineRegistryKt.isTypingSessionEnabled()) {
            return;
        }
        LookupImpl lookupImpl = (LookupImpl)newLookup;
        if (lookupImpl == null) {
            return;
        }
        LookupImpl lookup = lookupImpl;
        if (lookup.getProject().isDefault()) {
            return;
        }
        RiderPatchEngineLookupManagerListenerKt.setCalculating(lookup, false);
        Editor editor = lookup.getEditor();
        Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"getEditor(...)");
        Editor editor2 = editor;
        Project project = lookup.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        IdeBackend backend = IdeBackend.Companion.getInstance(project);
        if (backend.isCompletionEnabled(editor2)) {
            this.handleLookupShown(lookup);
        }
    }

    private final void handleLookupShown(LookupImpl lookup) {
        Logger $this$trace$iv = RiderPatchEngineLookupManagerListenerKt.access$getLogger$p();
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("Active lookup changed");
        }
        SummaryInfoTracker.Companion.addSummaryInfoTracker((LookupEx)lookup);
        Project project = lookup.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        ComponentManager $this$service$iv = (ComponentManager)project;
        boolean $i$f$service = false;
        Class<RiderPatchEngineItemPresenter> serviceClass$iv = RiderPatchEngineItemPresenter.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        RiderPatchEngineItemPresenter lookupItemPresenter = (RiderPatchEngineItemPresenter)object;
        lookup.addLookupListener(new LookupListener(this, lookup, lookupItemPresenter){
            final /* synthetic */ RiderPatchEngineLookupManagerListener this$0;
            final /* synthetic */ LookupImpl $lookup;
            final /* synthetic */ RiderPatchEngineItemPresenter $lookupItemPresenter;
            {
                this.this$0 = $receiver;
                this.$lookup = $lookup;
                this.$lookupItemPresenter = $lookupItemPresenter;
            }

            public void uiRefreshed() {
                RiderPatchEngineLookupManagerListener.access$updateLookupFocusDegree(this.this$0, this.$lookup);
                RiderPatchEngineLookupManagerListener.access$calculatePresentation(this.this$0, this.$lookup, this.$lookupItemPresenter);
            }
        });
    }

    private final void updateLookupFocusDegree(LookupImpl lookup) {
        if (RiderPatchEngineLookupManagerListenerKt.getFocusBehaviour(lookup) == FocusBehaviour.SoftWhenEmpty) {
            String string = lookup.getAdditionalPrefix();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAdditionalPrefix(...)");
            if (((CharSequence)string).length() > 0) {
                boolean bl;
                block4: {
                    String string2 = lookup.getAdditionalPrefix();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getAdditionalPrefix(...)");
                    CharSequence $this$any$iv = string2;
                    boolean $i$f$any = false;
                    for (int i = 0; i < $this$any$iv.length(); ++i) {
                        char element$iv;
                        char it = element$iv = $this$any$iv.charAt(i);
                        boolean bl2 = false;
                        if (!(!Character.isDigit(it))) continue;
                        bl = true;
                        break block4;
                    }
                    bl = false;
                }
                if (bl) {
                    lookup.setLookupFocusDegree(LookupFocusDegree.FOCUSED);
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void calculatePresentation(LookupImpl lookup, RiderPatchEngineItemPresenter lookupItemPresenter) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv;
        Object it$iv$iv;
        boolean bl;
        Object element$iv$iv$iv2;
        void $this$mapNotNullTo$iv$iv2;
        Logger logger;
        Integer lookupSessionId = (Integer)lookup.getUserData(RiderPatchEngineProtocolProvider.Companion.getLookupSessionIdKey());
        Logger $this$trace$iv = RiderPatchEngineLookupManagerListenerKt.access$getLogger$p();
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            logger = $this$trace$iv;
            boolean bl2 = false;
            logger.trace("Starting presentations calculation :: lookupSessionId=" + lookupSessionId);
        }
        if (Intrinsics.areEqual((Object)RiderPatchEngineLookupManagerListenerKt.getCalculating(lookup), (Object)true)) {
            $this$trace$iv = RiderPatchEngineLookupManagerListenerKt.access$getLogger$p();
            $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                logger = $this$trace$iv;
                boolean bl3 = false;
                logger.trace("Cannot be calculated. Presentations already calculating :: lookupSessionId=" + lookupSessionId);
            }
            return;
        }
        List list = lookup.getItems();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getItems(...)");
        Iterable $this$mapNotNull$iv2 = list;
        boolean $i$f$mapNotNull22 = false;
        Iterable iterable = $this$mapNotNull$iv2;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv2;
        boolean $i$f$forEach = false;
        for (Object element$iv$iv$iv2 : $this$forEach$iv$iv$iv) {
            Object element$iv$iv = element$iv$iv$iv2;
            boolean bl4 = false;
            LookupElement it = (LookupElement)element$iv$iv;
            boolean bl5 = false;
            ProtocolLookupItemBase protocolLookupItemBase = UtilsKt.tryGetProtocolItem((LookupElement)it);
            if (TuplesKt.to((Object)it, (Object)((Object)(protocolLookupItemBase instanceof RiderPatchEngineProtocolItem ? (RiderPatchEngineProtocolItem)protocolLookupItemBase : null))) == null) continue;
            bl = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List backendLookupItems = (List)destination$iv$iv;
        Iterable $i$f$mapNotNull22 = backendLookupItems;
        boolean $i$f$mapNotNull = false;
        destination$iv$iv = $this$mapNotNull$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$mapNotNullTo2 = false;
        void $this$forEach$iv$iv$iv2 = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach2 = false;
        element$iv$iv$iv2 = $this$forEach$iv$iv$iv2.iterator();
        while (element$iv$iv$iv2.hasNext()) {
            Object element$iv$iv$iv3;
            Object element$iv$iv = element$iv$iv$iv3 = element$iv$iv$iv2.next();
            boolean bl6 = false;
            Pair it = (Pair)element$iv$iv;
            boolean bl7 = false;
            if ((RiderPatchEngineProtocolItem)((Object)it.getSecond()) == null) continue;
            bl = false;
            destination$iv$iv2.add(it$iv$iv);
        }
        $this$mapNotNull$iv = (List)destination$iv$iv2;
        boolean $i$f$filter = false;
        $this$mapNotNullTo$iv$iv = $this$filter$iv;
        destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            RiderPatchEngineProtocolItem it = (RiderPatchEngineProtocolItem)((Object)element$iv$iv);
            boolean bl8 = false;
            if (!(it.shouldRequestUpdate() && it.isBackendInvolved())) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List itemsToUpdate = (List)destination$iv$iv2;
        if (itemsToUpdate.isEmpty()) {
            Logger $this$trace$iv2 = RiderPatchEngineLookupManagerListenerKt.access$getLogger$p();
            boolean $i$f$trace2 = false;
            if ($this$trace$iv2.isTraceEnabled()) {
                logger = $this$trace$iv2;
                boolean bl9 = false;
                logger.trace("Cannot be calculated. Items to update are empty :: lookupSessionId=" + lookupSessionId);
            }
            return;
        }
        boolean shouldUpdatePresentation = lookupItemPresenter.updatePresentation(itemsToUpdate, lookup, (Function0<Unit>)((Function0)() -> RiderPatchEngineLookupManagerListener.calculatePresentation$lambda$14(lookup, backendLookupItems, this, lookupItemPresenter, lookupSessionId)));
        if (shouldUpdatePresentation) {
            RiderPatchEngineLookupManagerListenerKt.setCalculating(lookup, true);
        }
    }

    private static final Unit calculatePresentation$lambda$14(LookupImpl $lookup, List $backendLookupItems, RiderPatchEngineLookupManagerListener this$0, RiderPatchEngineItemPresenter $lookupItemPresenter, Integer $lookupSessionId) {
        Logger logger;
        if ($lookup.isLookupDisposed()) {
            Logger $this$trace$iv = RiderPatchEngineLookupManagerListenerKt.access$getLogger$p();
            boolean $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                Logger logger2 = $this$trace$iv;
                boolean bl = false;
                logger2.trace("Lookup disposed during presentations updating :: lookupSessionId=" + $lookupSessionId);
            }
            $lookup.setCalculating(false);
            return Unit.INSTANCE;
        }
        List list = $lookup.getItems();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getItems(...)");
        HashSet currentItems = CollectionsKt.toHashSet((Iterable)list);
        Logger $this$trace$iv = RiderPatchEngineLookupManagerListenerKt.access$getLogger$p();
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            int n;
            logger = $this$trace$iv;
            boolean bl = false;
            Iterable $this$count$iv = $backendLookupItems;
            boolean $i$f$count = false;
            if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                n = 0;
            } else {
                int count$iv = 0;
                for (Object element$iv : $this$count$iv) {
                    Pair it = (Pair)element$iv;
                    boolean bl2 = false;
                    if (!currentItems.contains(it.getFirst()) || ++count$iv >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                n = count$iv;
            }
            logger.trace("Items to schedule :: count=" + n);
        }
        Iterable $this$forEach$iv = $backendLookupItems;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Pair it = (Pair)element$iv;
            boolean bl = false;
            if (currentItems.contains(it.getFirst())) {
                $lookup.scheduleItemUpdate((LookupElement)it.getFirst());
                continue;
            }
            Logger $this$trace$iv2 = RiderPatchEngineLookupManagerListenerKt.access$getLogger$p();
            boolean $i$f$trace2 = false;
            if (!$this$trace$iv2.isTraceEnabled()) continue;
            Logger logger3 = $this$trace$iv2;
            boolean bl3 = false;
            RiderPatchEngineProtocolItem riderPatchEngineProtocolItem = (RiderPatchEngineProtocolItem)((Object)it.getSecond());
            logger3.trace("Skip updating item " + (riderPatchEngineProtocolItem != null && (riderPatchEngineProtocolItem = riderPatchEngineProtocolItem.getCompletionItem()) != null ? riderPatchEngineProtocolItem.getShortText() : null) + " because it doesn't shown in lookup anymore");
        }
        $this$trace$iv = RiderPatchEngineLookupManagerListenerKt.access$getLogger$p();
        $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("All items scheduled :: lookupSessionId=" + $lookupSessionId);
        }
        RiderPatchEngineLookupManagerListenerKt.setCalculating($lookup, false);
        this$0.calculatePresentation($lookup, $lookupItemPresenter);
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ void access$updateLookupFocusDegree(RiderPatchEngineLookupManagerListener $this, LookupImpl lookup) {
        $this.updateLookupFocusDegree(lookup);
    }

    public static final /* synthetic */ void access$calculatePresentation(RiderPatchEngineLookupManagerListener $this, LookupImpl lookup, RiderPatchEngineItemPresenter lookupItemPresenter) {
        $this.calculatePresentation(lookup, lookupItemPresenter);
    }
}

