/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.daemon;

import com.intellij.codeInsight.daemon.impl.EditorTracker;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInspection.LocalInspectionEP;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.ClassEventField;
import com.intellij.internal.statistic.eventLog.events.EnumEventField;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventPair;
import com.intellij.internal.statistic.eventLog.events.LongEventField;
import com.intellij.internal.statistic.eventLog.events.PrimitiveEventField;
import com.intellij.internal.statistic.eventLog.events.VarargEventId;
import com.intellij.internal.statistic.service.fus.collectors.CounterUsagesCollector;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.client.ClientAppSession;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.impl.DocumentMarkupModel;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.rd.ide.model.TextControlId;
import com.jetbrains.rd.ide.model.TextControlModel;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rdclient.daemon.FrontendMarkupAdapterListener;
import com.jetbrains.rdclient.daemon.FrontendMarkupContributor;
import com.jetbrains.rdclient.daemon.components.FrontendMarkupHost;
import com.jetbrains.rdclient.daemon.util.HighlightersUtilKt;
import com.jetbrains.rdclient.editors.FrontendTextControlHostListener;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u00012\u00020\u0002:\u0001,B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J0\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0012\u0010%\u001a\u00020\u00152\b\u0010&\u001a\u0004\u0018\u00010\"H\u0002J\b\u0010'\u001a\u00020\u0015H\u0002J\b\u0010(\u001a\u00020\u0006H\u0016J\b\u0010)\u001a\u00020\u0015H\u0002J\u000e\u0010*\u001a\u0004\u0018\u00010\u0011*\u00020+H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010 \u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\"0!X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020$X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lcom/jetbrains/rider/daemon/RiderVisibleHighlighterCollector;", "Lcom/intellij/internal/statistic/service/fus/collectors/CounterUsagesCollector;", "Lcom/jetbrains/rdclient/editors/FrontendTextControlHostListener;", "<init>", "()V", "GROUP", "Lcom/intellij/internal/statistic/eventLog/EventLogGroup;", "INSPECTION_CLASS", "Lcom/intellij/internal/statistic/eventLog/events/ClassEventField;", "HIGHLIGHTER_SIDE", "Lcom/intellij/internal/statistic/eventLog/events/EnumEventField;", "Lcom/jetbrains/rider/daemon/RiderVisibleHighlighterCollector$HighlighterSide;", "COUNT", "Lcom/intellij/internal/statistic/eventLog/events/LongEventField;", "CHARS", "PATH", "Lcom/intellij/internal/statistic/eventLog/events/PrimitiveEventField;", "", "EVENT", "Lcom/intellij/internal/statistic/eventLog/events/VarargEventId;", "editorBound", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "appSession", "Lcom/intellij/openapi/client/ClientAppSession;", "textControlId", "Lcom/jetbrains/rd/ide/model/TextControlId;", "editorModel", "Lcom/jetbrains/rd/ide/model/TextControlModel;", "editor", "Lcom/intellij/openapi/editor/Editor;", "lastReportTime", "Ljava/util/concurrent/atomic/AtomicReference;", "Ljava/time/LocalDateTime;", "numberOfReportsInCurrentSession", "", "tryReportStatistics", "cachedLastReportTime", "tryInitializeLastReportTime", "getGroup", "doReportVisibleHighlighters", "tryGetInspectionClassName", "Lcom/intellij/openapi/editor/markup/RangeHighlighter;", "HighlighterSide", "intellij.rider.rdclient.dotnet"})
@SourceDebugExtension(value={"SMAP\nRiderVisibleHighlighterCollector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RiderVisibleHighlighterCollector.kt\ncom/jetbrains/rider/daemon/RiderVisibleHighlighterCollector\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 6 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 7 EventFields.kt\ncom/intellij/internal/statistic/eventLog/events/EventFields\n*L\n1#1,150:1\n295#2,2:151\n1869#2:153\n1491#2:157\n1516#2,3:158\n1519#2,3:168\n774#2:173\n865#2,2:174\n774#2:176\n865#2,2:177\n1870#2:180\n3829#3:154\n4344#3,2:155\n382#4,7:161\n216#5:171\n217#5:179\n1#6:172\n244#7,4:181\n*S KotlinDebug\n*F\n+ 1 RiderVisibleHighlighterCollector.kt\ncom/jetbrains/rider/daemon/RiderVisibleHighlighterCollector\n*L\n147#1:151,2\n96#1:153\n102#1:157\n102#1:158,3\n102#1:168,3\n120#1:173\n120#1:174,2\n128#1:176\n128#1:177,2\n96#1:180\n101#1:154\n101#1:155,2\n102#1:161,7\n103#1:171\n103#1:179\n30#1:181,4\n*E\n"})
public final class RiderVisibleHighlighterCollector
extends CounterUsagesCollector
implements FrontendTextControlHostListener {
    @NotNull
    public static final RiderVisibleHighlighterCollector INSTANCE;
    @NotNull
    private static final EventLogGroup GROUP;
    @NotNull
    private static final ClassEventField INSPECTION_CLASS;
    @NotNull
    private static final EnumEventField<HighlighterSide> HIGHLIGHTER_SIDE;
    @NotNull
    private static final LongEventField COUNT;
    @NotNull
    private static final LongEventField CHARS;
    @NotNull
    private static final PrimitiveEventField<String> PATH;
    @NotNull
    private static final VarargEventId EVENT;
    @NotNull
    private static AtomicReference<LocalDateTime> lastReportTime;
    private static int numberOfReportsInCurrentSession;

    private RiderVisibleHighlighterCollector() {
    }

    public void editorBound(@NotNull Lifetime lifetime, @NotNull ClientAppSession appSession, @NotNull TextControlId textControlId, @NotNull TextControlModel editorModel, @NotNull Editor editor) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
            Intrinsics.checkNotNullParameter((Object)appSession, (String)"appSession");
            Intrinsics.checkNotNullParameter((Object)textControlId, (String)"textControlId");
            Intrinsics.checkNotNullParameter((Object)editorModel, (String)"editorModel");
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            FrontendMarkupContributor frontendMarkupContributor = FrontendMarkupHost.Companion.getMarkupContributor(editor);
            if (frontendMarkupContributor == null || (frontendMarkupContributor = frontendMarkupContributor.getMarkupAdapter()) == null) break block0;
            frontendMarkupContributor.addListener(lifetime, new FrontendMarkupAdapterListener(){

                public void afterAdded(RangeHighlighterEx highlighter) {
                    Intrinsics.checkNotNullParameter((Object)highlighter, (String)"highlighter");
                    LocalDateTime cachedLastReportTime = (LocalDateTime)RiderVisibleHighlighterCollector.access$getLastReportTime$p().getAcquire();
                    if (cachedLastReportTime == null) {
                        RiderVisibleHighlighterCollector.access$tryInitializeLastReportTime(RiderVisibleHighlighterCollector.INSTANCE);
                        return;
                    }
                    LocalDateTime currentTime = LocalDateTime.now();
                    Duration delay = Duration.ofHours(RiderVisibleHighlighterCollector.access$getNumberOfReportsInCurrentSession$p() == 0 ? 1L : 12L);
                    if (cachedLastReportTime.plus(delay).compareTo(currentTime) < 0) {
                        RiderVisibleHighlighterCollector.access$tryReportStatistics(RiderVisibleHighlighterCollector.INSTANCE, cachedLastReportTime);
                    }
                }
            });
        }
    }

    private final void tryReportStatistics(LocalDateTime cachedLastReportTime) {
        if (!Intrinsics.areEqual((Object)lastReportTime.compareAndExchange(cachedLastReportTime, LocalDateTime.now()), (Object)cachedLastReportTime)) {
            return;
        }
        ++numberOfReportsInCurrentSession;
        this.doReportVisibleHighlighters();
    }

    private final void tryInitializeLastReportTime() {
        lastReportTime.compareAndExchange(null, LocalDateTime.now());
    }

    @NotNull
    public EventLogGroup getGroup() {
        return GROUP;
    }

    private final void doReportVisibleHighlighters() {
        Application application = ApplicationManager.getApplication();
        Project[] projectArray = ProjectManager.getInstance().getOpenProjects();
        Intrinsics.checkNotNullExpressionValue((Object)projectArray, (String)"getOpenProjects(...)");
        Project project = (Project)ArraysKt.firstOrNull((Object[])projectArray);
        if (project == null) {
            return;
        }
        Project project2 = project;
        FileDocumentManager fileDocumentManager = FileDocumentManager.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)fileDocumentManager, (String)"getInstance(...)");
        FileDocumentManager fileDocumentManager2 = fileDocumentManager;
        application.invokeLater(() -> RiderVisibleHighlighterCollector.doReportVisibleHighlighters$lambda$9(project2, fileDocumentManager2));
    }

    /*
     * WARNING - void declaration
     */
    private final String tryGetInspectionClassName(RangeHighlighter $this$tryGetInspectionClassName) {
        Object v2;
        block2: {
            void $this$firstOrNull$iv;
            String toolId;
            Object object = $this$tryGetInspectionClassName.getErrorStripeTooltip();
            HighlightInfo highlightInfo = object instanceof HighlightInfo ? (HighlightInfo)object : null;
            String string = toolId = highlightInfo != null ? highlightInfo.getInspectionToolId() : null;
            if (toolId == null) {
                return null;
            }
            object = LocalInspectionEP.LOCAL_INSPECTION.getExtensionList();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                LocalInspectionEP it = (LocalInspectionEP)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.shortName, (Object)toolId)) continue;
                v2 = element$iv;
                break block2;
            }
            v2 = null;
        }
        LocalInspectionEP localInspectionEP = v2;
        return localInspectionEP != null ? localInspectionEP.implementationClass : null;
    }

    /*
     * WARNING - void declaration
     */
    private static final void doReportVisibleHighlighters$lambda$9(Project $project, FileDocumentManager $fileDocumentManager) {
        Iterable $this$forEach$iv = EditorTracker.Companion.getInstance($project).getActiveEditors();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Map grouped;
            void $this$groupByTo$iv$iv;
            void $this$filterTo$iv$iv;
            VirtualFile virtualFile;
            Editor editor = (Editor)element$iv;
            boolean bl = false;
            if (editor.isDisposed() || (virtualFile = editor.getVirtualFile()) == null && (virtualFile = $fileDocumentManager.getFile(editor.getDocument())) == null) continue;
            VirtualFile virtualFile2 = virtualFile;
            RangeHighlighter[] rangeHighlighterArray = DocumentMarkupModel.forDocument((Document)editor.getDocument(), (Project)$project, (boolean)false);
            if (rangeHighlighterArray == null || (rangeHighlighterArray = rangeHighlighterArray.getAllHighlighters()) == null) continue;
            RangeHighlighter[] documentHighlighters = rangeHighlighterArray;
            Intrinsics.checkNotNullExpressionValue((Object)editor.calculateVisibleRange(), (String)"calculateVisibleRange(...)");
            RangeHighlighter[] $this$filter$iv = documentHighlighters;
            boolean $i$f$filter = false;
            RangeHighlighter[] rangeHighlighterArray2 = $this$filter$iv;
            Iterable<void> destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                ProperTextRange visibleRange;
                void highlighter = element$iv$iv;
                boolean bl2 = false;
                if (!highlighter.getTextRange().intersects((TextRange)visibleRange)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List visibleHighlighters = (List)destination$iv$iv;
            Iterable $this$groupBy$iv = visibleHighlighters;
            boolean $i$f$groupBy = false;
            destination$iv$iv = $this$groupBy$iv;
            Map destination$iv$iv2 = new LinkedHashMap();
            boolean $i$f$groupByTo = false;
            for (Object element$iv$iv : $this$groupByTo$iv$iv) {
                Object object;
                RangeHighlighter it = (RangeHighlighter)element$iv$iv;
                boolean bl3 = false;
                Intrinsics.checkNotNull((Object)it);
                String key$iv$iv = INSTANCE.tryGetInspectionClassName(it);
                Map $this$getOrPut$iv$iv$iv = destination$iv$iv2;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl4 = false;
                    List answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                    object = answer$iv$iv$iv;
                } else {
                    object = value$iv$iv$iv;
                }
                List list$iv$iv = (List)object;
                list$iv$iv.add(element$iv$iv);
            }
            Map $this$forEach$iv2 = grouped = destination$iv$iv2;
            boolean $i$f$forEach2 = false;
            Iterator iterator = $this$forEach$iv2.entrySet().iterator();
            while (iterator.hasNext()) {
                void $this$filterTo$iv$iv2;
                void $this$filterTo$iv$iv32;
                int n;
                int n2;
                Object object;
                VarargEventId varargEventId;
                Object object2;
                int n3;
                LongEventField longEventField;
                Object clazz;
                Map.Entry element$iv2;
                Object element$iv$iv;
                Map.Entry group = element$iv2 = iterator.next();
                boolean bl5 = false;
                if (group.getKey() != null) {
                    try {
                        element$iv$iv = Class.forName((String)group.getKey());
                    }
                    catch (ClassNotFoundException e) {
                        element$iv$iv = null;
                    }
                    v3 = element$iv$iv;
                } else {
                    v3 = clazz = null;
                }
                if (clazz != null) {
                    element$iv$iv = new EventPair[5];
                    element$iv$iv[0] = INSPECTION_CLASS.with(clazz);
                    element$iv$iv[1] = HIGHLIGHTER_SIDE.with((Object)HighlighterSide.INTELLIJ);
                    element$iv$iv[2] = COUNT.with((Object)((Collection)group.getValue()).size());
                    Iterable e = (Iterable)group.getValue();
                    longEventField = CHARS;
                    n3 = 3;
                    object2 = element$iv$iv;
                    varargEventId = EVENT;
                    int answer$iv$iv$iv = 0;
                    for (Object e2 : e) {
                        void highlighter;
                        object = (RangeHighlighter)e2;
                        n2 = answer$iv$iv$iv;
                        boolean bl6 = false;
                        n = highlighter.getEndOffset() - highlighter.getStartOffset();
                        answer$iv$iv$iv = n2 + n;
                    }
                    n2 = answer$iv$iv$iv;
                    object2[n3] = longEventField.with((Object)n2);
                    element$iv$iv[4] = PATH.with((Object)virtualFile2.getPath());
                    varargEventId.log(element$iv$iv);
                    continue;
                }
                EventPair[] $this$filter$iv2 = (EventPair[])group.getValue();
                boolean $i$f$filter22 = false;
                Object object3 = $this$filter$iv2;
                Object destination$iv$iv3 = new ArrayList();
                boolean $i$f$filterTo22 = false;
                for (Object element$iv$iv2 : $this$filterTo$iv$iv32) {
                    RangeHighlighter it = (RangeHighlighter)element$iv$iv2;
                    boolean bl7 = false;
                    Intrinsics.checkNotNull((Object)it);
                    if (!(HighlightersUtilKt.getBackendAttributeId((RangeHighlighter)it) != null)) continue;
                    destination$iv$iv3.add(element$iv$iv2);
                }
                List resharperHighlighters = (List)destination$iv$iv3;
                $this$filter$iv2 = new EventPair[5];
                $this$filter$iv2[0] = INSPECTION_CLASS.with(null);
                $this$filter$iv2[1] = HIGHLIGHTER_SIDE.with((Object)HighlighterSide.RESHARPER);
                $this$filter$iv2[2] = COUNT.with((Object)((Collection)resharperHighlighters).size());
                Iterable $i$f$filter22 = resharperHighlighters;
                longEventField = CHARS;
                n3 = 3;
                object2 = $this$filter$iv2;
                varargEventId = EVENT;
                int $this$filterTo$iv$iv32 = 0;
                for (Object $i$f$filterTo22 : $i$f$filter22) {
                    void highlighter;
                    RangeHighlighter bl6 = (RangeHighlighter)$i$f$filterTo22;
                    n2 = $this$filterTo$iv$iv32;
                    boolean bl8 = false;
                    n = highlighter.getEndOffset() - highlighter.getStartOffset();
                    $this$filterTo$iv$iv32 = n2 + n;
                }
                n2 = $this$filterTo$iv$iv32;
                object2[n3] = longEventField.with((Object)n2);
                $this$filter$iv2[4] = PATH.with((Object)virtualFile2.getPath());
                varargEventId.log($this$filter$iv2);
                Iterable $this$filter$iv3 = (Iterable)group.getValue();
                boolean $i$f$filter3 = false;
                destination$iv$iv3 = $this$filter$iv3;
                Collection destination$iv$iv4 = new ArrayList();
                boolean $i$f$filterTo3 = false;
                for (Object element$iv$iv3 : $this$filterTo$iv$iv2) {
                    RangeHighlighter it = (RangeHighlighter)element$iv$iv3;
                    boolean bl9 = false;
                    Intrinsics.checkNotNull((Object)it);
                    if (!(HighlightersUtilKt.getBackendAttributeId((RangeHighlighter)it) == null)) continue;
                    destination$iv$iv4.add(element$iv$iv3);
                }
                List ideaHighlighters = (List)destination$iv$iv4;
                EventPair[] eventPairArray = new EventPair[5];
                eventPairArray[0] = INSPECTION_CLASS.with(null);
                eventPairArray[1] = HIGHLIGHTER_SIDE.with((Object)HighlighterSide.INTELLIJ);
                eventPairArray[2] = COUNT.with((Object)((Collection)ideaHighlighters).size());
                object3 = ideaHighlighters;
                longEventField = CHARS;
                n3 = 3;
                object2 = eventPairArray;
                varargEventId = EVENT;
                int n4 = 0;
                object = object3.iterator();
                while (object.hasNext()) {
                    void highlighter;
                    Object e = object.next();
                    RangeHighlighter bl8 = (RangeHighlighter)e;
                    n2 = n4;
                    boolean bl10 = false;
                    n = highlighter.getEndOffset() - highlighter.getStartOffset();
                    n4 = n2 + n;
                }
                n2 = n4;
                object2[n3] = longEventField.with((Object)n2);
                eventPairArray[4] = PATH.with((Object)virtualFile2.getPath());
                varargEventId.log(eventPairArray);
            }
        }
    }

    public static final /* synthetic */ AtomicReference access$getLastReportTime$p() {
        return lastReportTime;
    }

    public static final /* synthetic */ void access$tryInitializeLastReportTime(RiderVisibleHighlighterCollector $this) {
        $this.tryInitializeLastReportTime();
    }

    public static final /* synthetic */ int access$getNumberOfReportsInCurrentSession$p() {
        return numberOfReportsInCurrentSession;
    }

    public static final /* synthetic */ void access$tryReportStatistics(RiderVisibleHighlighterCollector $this, LocalDateTime cachedLastReportTime) {
        $this.tryReportStatistics(cachedLastReportTime);
    }

    /*
     * WARNING - void declaration
     */
    static {
        void name$iv;
        void $this$iv;
        INSTANCE = new RiderVisibleHighlighterCollector();
        GROUP = new EventLogGroup("rider.sampling", 1, null, 4, null);
        INSPECTION_CLASS = EventFields.Class((String)"inspection_class", (String)"The name of inspection that created these highlighters");
        EventField[] eventFieldArray = EventFields.INSTANCE;
        String string = "highlighter_side";
        String description$iv = "whether this highlighter comes from IntelliJ or ReSharper";
        Function1 transform$iv = $this$iv.getDefaultEnumTransform();
        boolean $i$f$Enum = false;
        HIGHLIGHTER_SIDE = new EnumEventField((String)name$iv, HighlighterSide.class, description$iv, transform$iv);
        COUNT = EventFields.Long((String)"count", (String)"The total amount of visible highlighters of this kind");
        CHARS = EventFields.Long((String)"chars", (String)"The sum of the editor characters count occupied by highlightings of this kind");
        PATH = EventFields.AnonymizedPath;
        eventFieldArray = new EventField[]{INSPECTION_CLASS, HIGHLIGHTER_SIDE, COUNT, CHARS, PATH};
        EVENT = GROUP.registerVarargEvent("viewport.highlighting.sample", eventFieldArray);
        lastReportTime = new AtomicReference<Object>(null);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/rider/daemon/RiderVisibleHighlighterCollector$HighlighterSide;", "", "<init>", "(Ljava/lang/String;I)V", "RESHARPER", "INTELLIJ", "intellij.rider.rdclient.dotnet"})
    public static final class HighlighterSide
    extends Enum<HighlighterSide> {
        public static final /* enum */ HighlighterSide RESHARPER = new HighlighterSide();
        public static final /* enum */ HighlighterSide INTELLIJ = new HighlighterSide();
        private static final /* synthetic */ HighlighterSide[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static HighlighterSide[] values() {
            return (HighlighterSide[])$VALUES.clone();
        }

        public static HighlighterSide valueOf(String value) {
            return Enum.valueOf(HighlighterSide.class, value);
        }

        @NotNull
        public static EnumEntries<HighlighterSide> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = highlighterSideArray = new HighlighterSide[]{HighlighterSide.RESHARPER, HighlighterSide.INTELLIJ};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

