/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.daemon.grave;

import com.intellij.codeInsight.daemon.impl.HighlightingNecromancer;
import com.intellij.openapi.client.ClientAppSession;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.FileIdAdapter;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ApplicationKt;
import com.jetbrains.rd.ide.document.DocumentSynchronizer;
import com.jetbrains.rd.ide.model.BackendDaemonStateEnum;
import com.jetbrains.rd.ide.model.RdDocumentModel;
import com.jetbrains.rd.ide.model.RdMarkupKey;
import com.jetbrains.rd.ide.model.RdMarkupModel;
import com.jetbrains.rd.ide.model.RdMarkupModelBase;
import com.jetbrains.rd.ide.model.RdProjectId;
import com.jetbrains.rd.ide.model.TextControlId;
import com.jetbrains.rd.ide.model.TextControlModel;
import com.jetbrains.rd.platform.ProjectUtilKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rdclient.daemon.FrontendMarkupContributor;
import com.jetbrains.rdclient.daemon.components.FrontendMarkupHost;
import com.jetbrains.rdclient.daemon.util.HighlightersUtilKt;
import com.jetbrains.rdclient.document.DocumentExKt;
import com.jetbrains.rdclient.editors.FrontendTextControlHostListener;
import com.jetbrains.rider.daemon.RiderCacheAwareMarkupAdapter;
import com.jetbrains.rider.daemon.grave.RiderHighlightingNecromancer;
import com.jetbrains.rider.daemon.grave.RiderHighlightingNecromancerKt;
import com.jetbrains.rider.daemon.grave.filter.RiderHighlightingGraveFilter;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\tH\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0014J\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0014J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u0011H\u0014\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/rider/daemon/grave/RiderHighlightingNecromancer;", "Lcom/intellij/codeInsight/daemon/impl/HighlightingNecromancer;", "project", "Lcom/intellij/openapi/project/Project;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;)V", "subscribeDaemonFinished", "", "subscribeOnBackendDocuments", "shouldPutDownActiveZombiesInFile", "", "textEditor", "Lcom/intellij/openapi/fileEditor/TextEditor;", "shouldBuryHighlighter", "highlighter", "Lcom/intellij/openapi/editor/ex/RangeHighlighterEx;", "getHighlighterLayer", "", "intellij.rider.rdclient.dotnet"})
final class RiderHighlightingNecromancer
extends HighlightingNecromancer {
    public RiderHighlightingNecromancer(@NotNull Project project, @NotNull CoroutineScope scope) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        super(project, scope);
    }

    public void subscribeDaemonFinished() {
        super.subscribeDaemonFinished();
        this.subscribeOnBackendDocuments();
    }

    private final void subscribeOnBackendDocuments() {
        ApplicationKt.getApplication().getMessageBus().connect(this.getCoroutineScope()).subscribe(FrontendTextControlHostListener.Companion.getTOPIC(), (Object)new FrontendTextControlHostListener(this){
            final /* synthetic */ RiderHighlightingNecromancer this$0;
            {
                this.this$0 = $receiver;
            }

            public void editorBound(Lifetime lifetime, ClientAppSession appSession, TextControlId textControlId, TextControlModel editorModel, Editor editor) {
                Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
                Intrinsics.checkNotNullParameter((Object)appSession, (String)"appSession");
                Intrinsics.checkNotNullParameter((Object)textControlId, (String)"textControlId");
                Intrinsics.checkNotNullParameter((Object)editorModel, (String)"editorModel");
                Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
                if (!Intrinsics.areEqual((Object)RiderHighlightingNecromancer.access$getProject(this.this$0), (Object)editor.getProject())) {
                    return;
                }
                VirtualFile virtualFile = FileDocumentManager.getInstance().getFile(editor.getDocument());
                if (virtualFile == null) {
                    return;
                }
                VirtualFile virtualFile2 = virtualFile;
                Integer n = FileIdAdapter.Companion.getInstance().getId(virtualFile2);
                if (n == null) {
                    return;
                }
                int fileId = n;
                Document document = editor.getDocument();
                Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
                DocumentSynchronizer documentSynchronizer = DocumentExKt.getDocumentSynchronizer((Document)document, (Project)RiderHighlightingNecromancer.access$getProject(this.this$0));
                if (documentSynchronizer == null) {
                    return;
                }
                DocumentSynchronizer documentSynchronizer2 = documentSynchronizer;
                Logger $this$trace$iv = RiderHighlightingNecromancerKt.access$getLogger$p();
                boolean $i$f$trace = false;
                if ($this$trace$iv.isTraceEnabled()) {
                    Logger logger = $this$trace$iv;
                    boolean bl = false;
                    logger.trace("Subscribing for document markups for " + editor.getDocument());
                }
                com.jetbrains.rd.ide.document.DocumentExKt.getMarkups((RdDocumentModel)documentSynchronizer2.getModelDocument()).view(lifetime, (arg_0, arg_1, arg_2) -> subscribeOnBackendDocuments.1.editorBound$lambda$6(this.this$0, editor, virtualFile2, fileId, arg_0, arg_1, arg_2));
            }

            private static final Unit editorBound$lambda$6$lambda$5(RiderHighlightingNecromancer this$0, VirtualFile $virtualFile, int $fileId, Editor $editor, BackendDaemonStateEnum daemonState) {
                Logger logger;
                Intrinsics.checkNotNullParameter((Object)daemonState, (String)"daemonState");
                Logger $this$trace$iv = RiderHighlightingNecromancerKt.access$getLogger$p();
                boolean $i$f$trace = false;
                if ($this$trace$iv.isTraceEnabled()) {
                    logger = $this$trace$iv;
                    boolean bl = false;
                    logger.trace("Received daemon state " + daemonState + " for " + $editor.getDocument());
                }
                switch (subscribeOnBackendDocuments.WhenMappings.$EnumSwitchMapping$0[daemonState.ordinal()]) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: {
                        Logger $this$trace$iv2 = RiderHighlightingNecromancerKt.access$getLogger$p();
                        boolean $i$f$trace2 = false;
                        if (!$this$trace$iv2.isTraceEnabled()) break;
                        logger = $this$trace$iv2;
                        boolean bl = false;
                        logger.trace("Got " + daemonState + ", so do nothing");
                        break;
                    }
                    case 6: 
                    case 7: 
                    case 8: {
                        Logger $this$trace$iv3 = RiderHighlightingNecromancerKt.access$getLogger$p();
                        boolean $i$f$trace3 = false;
                        if ($this$trace$iv3.isTraceEnabled()) {
                            logger = $this$trace$iv3;
                            boolean bl = false;
                            logger.trace("Got " + daemonState + ", putting down zombies");
                        }
                        Document document = $editor.getDocument();
                        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
                        RiderHighlightingNecromancer.access$putDownActiveZombiesInFile(this$0, $virtualFile, $fileId, document);
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                return Unit.INSTANCE;
            }

            private static final Unit editorBound$lambda$6(RiderHighlightingNecromancer this$0, Editor $editor, VirtualFile $virtualFile, int $fileId, Lifetime markupLifetime, RdMarkupKey key, RdMarkupModelBase markup) {
                Intrinsics.checkNotNullParameter((Object)markupLifetime, (String)"markupLifetime");
                Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                Intrinsics.checkNotNullParameter((Object)markup, (String)"markup");
                if (!(markup instanceof RdMarkupModel)) {
                    return Unit.INSTANCE;
                }
                RdProjectId rdProjectId = key.getProjectId();
                if (rdProjectId == null || (rdProjectId = ProjectUtilKt.toProject((RdProjectId)rdProjectId)) == null) {
                    return Unit.INSTANCE;
                }
                RdProjectId p = rdProjectId;
                if (!Intrinsics.areEqual((Object)p, (Object)RiderHighlightingNecromancer.access$getProject(this$0))) {
                    return Unit.INSTANCE;
                }
                Logger $this$trace$iv = RiderHighlightingNecromancerKt.access$getLogger$p();
                boolean $i$f$trace = false;
                if ($this$trace$iv.isTraceEnabled()) {
                    Logger logger = $this$trace$iv;
                    boolean bl = false;
                    logger.trace("Listening daemon states for " + $editor.getDocument());
                }
                ((RdMarkupModel)markup).getDaemon().getState().advise(markupLifetime, arg_0 -> subscribeOnBackendDocuments.1.editorBound$lambda$6$lambda$5(this$0, $virtualFile, $fileId, $editor, arg_0));
                return Unit.INSTANCE;
            }
        });
    }

    protected boolean shouldPutDownActiveZombiesInFile(@NotNull TextEditor textEditor) {
        Intrinsics.checkNotNullParameter((Object)textEditor, (String)"textEditor");
        Project project = this.getProject();
        Document document = textEditor.getEditor().getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        FrontendMarkupContributor markupContributor = FrontendMarkupHost.Companion.getMarkupContributor(project, document);
        return markupContributor != null && markupContributor.getMarkupAdapter() instanceof RiderCacheAwareMarkupAdapter ? false : super.shouldPutDownActiveZombiesInFile(textEditor);
    }

    protected boolean shouldBuryHighlighter(@NotNull RangeHighlighterEx highlighter) {
        Intrinsics.checkNotNullParameter((Object)highlighter, (String)"highlighter");
        return HighlightersUtilKt.isFromBackend((RangeHighlighter)((RangeHighlighter)highlighter)) ? RiderHighlightingGraveFilter.Companion.shouldPutInGrave((RangeHighlighter)highlighter) : super.shouldBuryHighlighter(highlighter);
    }

    protected int getHighlighterLayer(@NotNull RangeHighlighterEx highlighter) {
        Intrinsics.checkNotNullParameter((Object)highlighter, (String)"highlighter");
        return HighlightersUtilKt.isBackendHighlighter((RangeHighlighter)((RangeHighlighter)highlighter)) ? 400 : super.getHighlighterLayer(highlighter);
    }

    public static final /* synthetic */ Project access$getProject(RiderHighlightingNecromancer $this) {
        return $this.getProject();
    }

    public static final /* synthetic */ void access$putDownActiveZombiesInFile(RiderHighlightingNecromancer $this, VirtualFile file, int fileId, Document document) {
        $this.putDownActiveZombiesInFile(file, fileId, document);
    }
}

