/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.diagnostics;

import com.intellij.ide.GeneralLocalSettings;
import com.intellij.ide.browsers.BrowserSpecificSettings;
import com.intellij.ide.browsers.DefaultBrowserPolicy;
import com.intellij.ide.browsers.WebBrowser;
import com.intellij.ide.browsers.WebBrowserManager;
import com.intellij.ide.browsers.chrome.ChromeSettings;
import com.intellij.openapi.project.Project;
import com.intellij.troubleshooting.GeneralTroubleInfoCollector;
import java.util.List;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0010\u001a\u00020\u0011*\u00060\u0012j\u0002`\u00132\u0006\u0010\u0014\u001a\u00020\fH\u0002J&\u0010\u0015\u001a\u00020\u0011*\u00060\u0012j\u0002`\u00132\u0006\u0010\u0016\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00170\u0019H\u0002J&\u0010\u001a\u001a\u00020\u0011*\u00060\u0012j\u0002`\u00132\u0006\u0010\u0016\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00170\u0019H\u0002J\u001a\u0010\u001b\u001a\u00020\u0011*\u00060\u0012j\u0002`\u00132\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0002J\u001e\u0010\u001e\u001a\u00020\u0011*\u00060\u0012j\u0002`\u00132\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00170\u0019H\u0002R#\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u001f"}, d2={"Lcom/jetbrains/rider/diagnostics/RiderBrowserTroubleInfoCollector;", "Lcom/intellij/troubleshooting/GeneralTroubleInfoCollector;", "<init>", "()V", "browserManager", "Lcom/intellij/ide/browsers/WebBrowserManager;", "kotlin.jvm.PlatformType", "getBrowserManager", "()Lcom/intellij/ide/browsers/WebBrowserManager;", "browserManager$delegate", "Lkotlin/Lazy;", "getTitle", "", "collectInfo", "project", "Lcom/intellij/openapi/project/Project;", "secondLevelHeader", "", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "text", "dumpBrowser", "browser", "Lcom/intellij/ide/browsers/WebBrowser;", "activeBrowsers", "", "dumpBrowserCommonInfo", "dumpBrowserSpecificInfo", "settings", "Lcom/intellij/ide/browsers/BrowserSpecificSettings;", "dumpDefaultBrowserSettings", "intellij.rider.rdclient.dotnet"})
@SourceDebugExtension(value={"SMAP\nRiderBrowserTroubleInfoCollector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RiderBrowserTroubleInfoCollector.kt\ncom/jetbrains/rider/diagnostics/RiderBrowserTroubleInfoCollector\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,83:1\n1869#2,2:84\n*S KotlinDebug\n*F\n+ 1 RiderBrowserTroubleInfoCollector.kt\ncom/jetbrains/rider/diagnostics/RiderBrowserTroubleInfoCollector\n*L\n23#1:84,2\n*E\n"})
public final class RiderBrowserTroubleInfoCollector
implements GeneralTroubleInfoCollector {
    @NotNull
    private final Lazy browserManager$delegate = LazyKt.lazy(RiderBrowserTroubleInfoCollector::browserManager_delegate$lambda$0);

    private final WebBrowserManager getBrowserManager() {
        Lazy lazy = this.browserManager$delegate;
        return (WebBrowserManager)lazy.getValue();
    }

    @NotNull
    public String getTitle() {
        return "Web Browsers";
    }

    @NotNull
    public String collectInfo(@NotNull Project project) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        List list = this.getBrowserManager().getActiveBrowsers();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getActiveBrowsers(...)");
        Set activeBrowsers = CollectionsKt.toSet((Iterable)list);
        StringBuilder $this$collectInfo_u24lambda_u242 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$collectInfo_u24lambda_u242.append('\n');
        this.secondLevelHeader($this$collectInfo_u24lambda_u242, "Configured browsers");
        List list2 = this.getBrowserManager().getBrowsers();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getBrowsers(...)");
        Iterable $this$forEach$iv = list2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            WebBrowser browser = (WebBrowser)element$iv;
            boolean bl2 = false;
            Intrinsics.checkNotNull((Object)browser);
            this.dumpBrowser($this$collectInfo_u24lambda_u242, browser, activeBrowsers);
        }
        this.dumpDefaultBrowserSettings($this$collectInfo_u24lambda_u242, activeBrowsers);
        return stringBuilder.toString();
    }

    private final void secondLevelHeader(StringBuilder $this$secondLevelHeader, String text) {
        $this$secondLevelHeader.append('\n');
        $this$secondLevelHeader.append("==== " + text + " ====").append('\n');
    }

    private final void dumpBrowser(StringBuilder $this$dumpBrowser, WebBrowser browser, Set<? extends WebBrowser> activeBrowsers) {
        $this$dumpBrowser.append("- ");
        this.dumpBrowserCommonInfo($this$dumpBrowser, browser, activeBrowsers);
        this.dumpBrowserSpecificInfo($this$dumpBrowser, browser.getSpecificSettings());
    }

    private final void dumpBrowserCommonInfo(StringBuilder $this$dumpBrowserCommonInfo, WebBrowser browser, Set<? extends WebBrowser> activeBrowsers) {
        $this$dumpBrowserCommonInfo.append(browser.getName());
        $this$dumpBrowserCommonInfo.append(" (");
        $this$dumpBrowserCommonInfo.append("Family: " + browser.getFamily());
        $this$dumpBrowserCommonInfo.append(", IsActive: " + activeBrowsers.contains(browser));
        CharSequence charSequence = browser.getPath();
        if (!(charSequence == null || charSequence.length() == 0)) {
            $this$dumpBrowserCommonInfo.append(", Path: " + browser.getPath());
        }
        $this$dumpBrowserCommonInfo.append(")");
        $this$dumpBrowserCommonInfo.append('\n');
    }

    private final void dumpBrowserSpecificInfo(StringBuilder $this$dumpBrowserSpecificInfo, BrowserSpecificSettings settings) {
        if (settings instanceof ChromeSettings) {
            CharSequence charSequence;
            $this$dumpBrowserSpecificInfo.append("    Use custom profile folder: " + ((ChromeSettings)settings).isUseCustomProfile()).append('\n');
            if (((ChromeSettings)settings).isUseCustomProfile()) {
                $this$dumpBrowserSpecificInfo.append("    Custom profile folder: " + ((ChromeSettings)settings).getUserDataDirectoryPath()).append('\n');
            }
            if (!((charSequence = (CharSequence)((ChromeSettings)settings).getCommandLineOptions()) == null || charSequence.length() == 0)) {
                $this$dumpBrowserSpecificInfo.append("    Custom CLI options: " + ((ChromeSettings)settings).getCommandLineOptions()).append('\n');
            }
        }
    }

    private final void dumpDefaultBrowserSettings(StringBuilder $this$dumpDefaultBrowserSettings, Set<? extends WebBrowser> activeBrowsers) {
        DefaultBrowserPolicy defaultBrowserPolicy = this.getBrowserManager().getDefaultBrowserPolicy();
        Intrinsics.checkNotNullExpressionValue((Object)defaultBrowserPolicy, (String)"getDefaultBrowserPolicy(...)");
        DefaultBrowserPolicy policy = defaultBrowserPolicy;
        WebBrowser firstActive = this.getBrowserManager().getFirstActiveBrowser();
        this.secondLevelHeader($this$dumpDefaultBrowserSettings, "Default browser");
        $this$dumpDefaultBrowserSettings.append("Policy: " + policy).append('\n');
        if (policy == DefaultBrowserPolicy.ALTERNATIVE) {
            $this$dumpDefaultBrowserSettings.append("Custom path: " + GeneralLocalSettings.Companion.getInstance().getBrowserPath()).append('\n');
        } else if (policy == DefaultBrowserPolicy.FIRST && firstActive != null) {
            $this$dumpDefaultBrowserSettings.append("First active: ");
            this.dumpBrowserCommonInfo($this$dumpDefaultBrowserSettings, firstActive, activeBrowsers);
        }
    }

    private static final WebBrowserManager browserManager_delegate$lambda$0() {
        return WebBrowserManager.getInstance();
    }
}

